/*******************************************************************************
 * See COPYRIGHT.txt & LICENSE.txt for copyright and licensing details.
 *******************************************************************************/

#ifndef CNIC_DEFS_H
#define CNIC_DEFS_H

/* KWQ (kernel work queue) request op codes */
#define L2_KWQE_OPCODE_VALUE_FLUSH			(4)

#define L2_OOO_KWQE_OPCODE_VALUE_FLUSH                  (4)
#define L2_OOO_KWQE_OPCODE_VALUE_VM_FREE_RX_QUEUE       (8)

#define L4_KWQE_OPCODE_VALUE_CONNECT1               (50)
#define L4_KWQE_OPCODE_VALUE_CONNECT2               (51)
#define L4_KWQE_OPCODE_VALUE_CONNECT3               (52)
#define L4_KWQE_OPCODE_VALUE_RESET                  (53)
#define L4_KWQE_OPCODE_VALUE_CLOSE                  (54)
#define L4_KWQE_OPCODE_VALUE_UPDATE_SECRET          (60)
#define L4_KWQE_OPCODE_VALUE_INIT_ULP               (61)

#define L4_KWQE_OPCODE_VALUE_OFFLOAD_PG             (1)
#define L4_KWQE_OPCODE_VALUE_UPDATE_PG              (9)
#define L4_KWQE_OPCODE_VALUE_UPLOAD_PG              (14)

#define L5CM_RAMROD_CMD_ID_BASE			(0x80)
#define L5CM_RAMROD_CMD_ID_TCP_CONNECT		(L5CM_RAMROD_CMD_ID_BASE + 3)
/* Close TCP Connection (i.e. send FIN/RST, wait for peer response as
 * appropriate.
 */
#define L5CM_RAMROD_CMD_ID_CLOSE		(L5CM_RAMROD_CMD_ID_BASE + 12)
#define L5CM_RAMROD_CMD_ID_ABORT		(L5CM_RAMROD_CMD_ID_BASE + 13)
/* Remove the TCP/IP addresses from the database of offloaded connections in the
 * searcher.
 */
#define L5CM_RAMROD_CMD_ID_SEARCHER_DELETE	(L5CM_RAMROD_CMD_ID_BASE + 14)
/* Clean the device from the remains of the connection */
#define L5CM_RAMROD_CMD_ID_TERMINATE_OFFLOAD	(L5CM_RAMROD_CMD_ID_BASE + 15)

#define FCOE_KCQE_OPCODE_INIT_FUNC			(0x10)
#define FCOE_KCQE_OPCODE_DESTROY_FUNC			(0x11)
#define FCOE_KCQE_OPCODE_STAT_FUNC			(0x12)
#define FCOE_KCQE_OPCODE_OFFLOAD_CONN			(0x15)
#define FCOE_KCQE_OPCODE_ENABLE_CONN			(0x16)
#define FCOE_KCQE_OPCODE_DISABLE_CONN			(0x17)
#define FCOE_KCQE_OPCODE_DESTROY_CONN			(0x18)
#define FCOE_KCQE_OPCODE_CQ_EVENT_NOTIFICATION  (0x20)
#define FCOE_KCQE_OPCODE_FCOE_ERROR				(0x21)

#define FCOE_RAMROD_CMD_ID_INIT_FUNC		(FCOE_KCQE_OPCODE_INIT_FUNC)
#define FCOE_RAMROD_CMD_ID_DESTROY_FUNC		(FCOE_KCQE_OPCODE_DESTROY_FUNC)
#define FCOE_RAMROD_CMD_ID_STAT_FUNC		(FCOE_KCQE_OPCODE_STAT_FUNC)
#define FCOE_RAMROD_CMD_ID_OFFLOAD_CONN		(FCOE_KCQE_OPCODE_OFFLOAD_CONN)
#define FCOE_RAMROD_CMD_ID_ENABLE_CONN		(FCOE_KCQE_OPCODE_ENABLE_CONN)
#define FCOE_RAMROD_CMD_ID_DISABLE_CONN		(FCOE_KCQE_OPCODE_DISABLE_CONN)
#define FCOE_RAMROD_CMD_ID_DESTROY_CONN		(FCOE_KCQE_OPCODE_DESTROY_CONN)
#define FCOE_RAMROD_CMD_ID_TERMINATE_CONN	(0x81)

#define FCOE_KWQE_OPCODE_INIT1                  (0)
#define FCOE_KWQE_OPCODE_INIT2                  (1)
#define FCOE_KWQE_OPCODE_INIT3                  (2)
#define FCOE_KWQE_OPCODE_OFFLOAD_CONN1  (3)
#define FCOE_KWQE_OPCODE_OFFLOAD_CONN2  (4)
#define FCOE_KWQE_OPCODE_OFFLOAD_CONN3  (5)
#define FCOE_KWQE_OPCODE_OFFLOAD_CONN4  (6)
#define FCOE_KWQE_OPCODE_ENABLE_CONN	(7)
#define FCOE_KWQE_OPCODE_DISABLE_CONN	(8)
#define FCOE_KWQE_OPCODE_DESTROY_CONN	(9)
#define FCOE_KWQE_OPCODE_DESTROY		(10)
#define FCOE_KWQE_OPCODE_STAT			(11)

#define FCOE_KCQE_COMPLETION_STATUS_ERROR	(0x1)
#define FCOE_KCQE_COMPLETION_STATUS_CTX_ALLOC_FAILURE	(0x3)

/* KCQ (kernel completion queue) response op codes */

/* Asynchronous indication that the close TCP connection close has completed
 * successfully.
 */
#define L4_KCQE_OPCODE_VALUE_CLOSE_COMP             (53)
#define L4_KCQE_OPCODE_VALUE_RESET_COMP             (54)
#define L4_KCQE_OPCODE_VALUE_FW_TCP_UPDATE          (55)
#define L4_KCQE_OPCODE_VALUE_CONNECT_COMPLETE       (56)
#define L4_KCQE_OPCODE_VALUE_RESET_RECEIVED         (57)
#define L4_KCQE_OPCODE_VALUE_CLOSE_RECEIVED         (58)
#define L4_KCQE_OPCODE_VALUE_INIT_ULP               (61)

#define L4_KCQE_OPCODE_VALUE_OFFLOAD_PG             (1)
#define L4_KCQE_OPCODE_VALUE_UPDATE_PG              (9)
#define L4_KCQE_OPCODE_VALUE_UPLOAD_PG              (14)

/* KCQ (kernel completion queue) completion status */
#define L4_KCQE_COMPLETION_STATUS_SUCCESS           (0)
#define L4_KCQE_COMPLETION_STATUS_NIC_ERROR         (4)
#define L4_KCQE_COMPLETION_STATUS_PARITY_ERROR      (0x81)
#define L4_KCQE_COMPLETION_STATUS_TIMEOUT           (0x93)

#define L4_KCQE_COMPLETION_STATUS_CTX_ALLOC_FAIL    (0x83)
#define L4_KCQE_COMPLETION_STATUS_OFFLOADED_PG      (0x89)

#define L4_KCQE_OPCODE_VALUE_OOO_EVENT_NOTIFICATION (0xa0)
#define L4_KCQE_OPCODE_VALUE_OOO_FLUSH              (0xa1)

#define L4_LAYER_CODE (4)
#define L2_LAYER_CODE (2)

/*
 * L4 KCQ CQE
 */
struct l4_kcq {
	vmk_uint32 cid;
	vmk_uint32 pg_cid;
	vmk_uint32 conn_id;
	vmk_uint32 pg_host_opaque;
#if defined(__BIG_ENDIAN)
	vmk_uint16 status;
	vmk_uint16 reserved1;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 reserved1;
	vmk_uint16 status;
#endif
	vmk_uint32 reserved2[2];
#if defined(__BIG_ENDIAN)
	vmk_uint8 flags;
#define L4_KCQ_RESERVED3 (0x7<<0)
#define L4_KCQ_RESERVED3_SHIFT 0
#define L4_KCQ_RAMROD_COMPLETION (0x1<<3) /* Everest only */
#define L4_KCQ_RAMROD_COMPLETION_SHIFT 3
#define L4_KCQ_LAYER_CODE (0x7<<4)
#define L4_KCQ_LAYER_CODE_SHIFT 4
#define L4_KCQ_RESERVED4 (0x1<<7)
#define L4_KCQ_RESERVED4_SHIFT 7
	vmk_uint8 op_code;
	vmk_uint16 qe_self_seq;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 qe_self_seq;
	vmk_uint8 op_code;
	vmk_uint8 flags;
#define L4_KCQ_RESERVED3 (0xF<<0)
#define L4_KCQ_RESERVED3_SHIFT 0
#define L4_KCQ_RAMROD_COMPLETION (0x1<<3) /* Everest only */
#define L4_KCQ_RAMROD_COMPLETION_SHIFT 3
#define L4_KCQ_LAYER_CODE (0x7<<4)
#define L4_KCQ_LAYER_CODE_SHIFT 4
#define L4_KCQ_RESERVED4 (0x1<<7)
#define L4_KCQ_RESERVED4_SHIFT 7
#endif
};


/*
 * L4 KCQ CQE PG upload
 */
struct l4_kcq_upload_pg {
	vmk_uint32 pg_cid;
#if defined(__BIG_ENDIAN)
	vmk_uint16 pg_status;
	vmk_uint16 pg_ipid_count;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 pg_ipid_count;
	vmk_uint16 pg_status;
#endif
	vmk_uint32 reserved1[5];
#if defined(__BIG_ENDIAN)
	vmk_uint8 flags;
#define L4_KCQ_UPLOAD_PG_RESERVED3 (0xF<<0)
#define L4_KCQ_UPLOAD_PG_RESERVED3_SHIFT 0
#define L4_KCQ_UPLOAD_PG_LAYER_CODE (0x7<<4)
#define L4_KCQ_UPLOAD_PG_LAYER_CODE_SHIFT 4
#define L4_KCQ_UPLOAD_PG_RESERVED4 (0x1<<7)
#define L4_KCQ_UPLOAD_PG_RESERVED4_SHIFT 7
	vmk_uint8 op_code;
	vmk_uint16 qe_self_seq;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 qe_self_seq;
	vmk_uint8 op_code;
	vmk_uint8 flags;
#define L4_KCQ_UPLOAD_PG_RESERVED3 (0xF<<0)
#define L4_KCQ_UPLOAD_PG_RESERVED3_SHIFT 0
#define L4_KCQ_UPLOAD_PG_LAYER_CODE (0x7<<4)
#define L4_KCQ_UPLOAD_PG_LAYER_CODE_SHIFT 4
#define L4_KCQ_UPLOAD_PG_RESERVED4 (0x1<<7)
#define L4_KCQ_UPLOAD_PG_RESERVED4_SHIFT 7
#endif
};


/*
 * Gracefully close the connection request
 */
struct l4_kwq_close_req {
#if defined(__BIG_ENDIAN)
	vmk_uint8 flags;
#define L4_KWQ_CLOSE_REQ_RESERVED1 (0xF<<0)
#define L4_KWQ_CLOSE_REQ_RESERVED1_SHIFT 0
#define L4_KWQ_CLOSE_REQ_LAYER_CODE (0x7<<4)
#define L4_KWQ_CLOSE_REQ_LAYER_CODE_SHIFT 4
#define L4_KWQ_CLOSE_REQ_LINKED_WITH_NEXT (0x1<<7)
#define L4_KWQ_CLOSE_REQ_LINKED_WITH_NEXT_SHIFT 7
	vmk_uint8 op_code;
	vmk_uint16 reserved0;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 reserved0;
	vmk_uint8 op_code;
	vmk_uint8 flags;
#define L4_KWQ_CLOSE_REQ_RESERVED1 (0xF<<0)
#define L4_KWQ_CLOSE_REQ_RESERVED1_SHIFT 0
#define L4_KWQ_CLOSE_REQ_LAYER_CODE (0x7<<4)
#define L4_KWQ_CLOSE_REQ_LAYER_CODE_SHIFT 4
#define L4_KWQ_CLOSE_REQ_LINKED_WITH_NEXT (0x1<<7)
#define L4_KWQ_CLOSE_REQ_LINKED_WITH_NEXT_SHIFT 7
#endif
	vmk_uint32 cid;
	vmk_uint32 reserved2[6];
};


/*
 * The first request to be passed in order to establish connection in option2
 */
struct l4_kwq_connect_req1 {
#if defined(__BIG_ENDIAN)
	vmk_uint8 flags;
#define L4_KWQ_CONNECT_REQ1_RESERVED1 (0xF<<0)
#define L4_KWQ_CONNECT_REQ1_RESERVED1_SHIFT 0
#define L4_KWQ_CONNECT_REQ1_LAYER_CODE (0x7<<4)
#define L4_KWQ_CONNECT_REQ1_LAYER_CODE_SHIFT 4
#define L4_KWQ_CONNECT_REQ1_LINKED_WITH_NEXT (0x1<<7)
#define L4_KWQ_CONNECT_REQ1_LINKED_WITH_NEXT_SHIFT 7
	vmk_uint8 op_code;
	vmk_uint8 reserved0;
	vmk_uint8 conn_flags;
#define L4_KWQ_CONNECT_REQ1_IS_PG_HOST_OPAQUE (0x1<<0)
#define L4_KWQ_CONNECT_REQ1_IS_PG_HOST_OPAQUE_SHIFT 0
#define L4_KWQ_CONNECT_REQ1_IP_V6 (0x1<<1)
#define L4_KWQ_CONNECT_REQ1_IP_V6_SHIFT 1
#define L4_KWQ_CONNECT_REQ1_PASSIVE_FLAG (0x1<<2)
#define L4_KWQ_CONNECT_REQ1_PASSIVE_FLAG_SHIFT 2
#define L4_KWQ_CONNECT_REQ1_RSRV (0x1F<<3)
#define L4_KWQ_CONNECT_REQ1_RSRV_SHIFT 3
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 conn_flags;
#define L4_KWQ_CONNECT_REQ1_IS_PG_HOST_OPAQUE (0x1<<0)
#define L4_KWQ_CONNECT_REQ1_IS_PG_HOST_OPAQUE_SHIFT 0
#define L4_KWQ_CONNECT_REQ1_IP_V6 (0x1<<1)
#define L4_KWQ_CONNECT_REQ1_IP_V6_SHIFT 1
#define L4_KWQ_CONNECT_REQ1_PASSIVE_FLAG (0x1<<2)
#define L4_KWQ_CONNECT_REQ1_PASSIVE_FLAG_SHIFT 2
#define L4_KWQ_CONNECT_REQ1_RSRV (0x1F<<3)
#define L4_KWQ_CONNECT_REQ1_RSRV_SHIFT 3
	vmk_uint8 reserved0;
	vmk_uint8 op_code;
	vmk_uint8 flags;
#define L4_KWQ_CONNECT_REQ1_RESERVED1 (0xF<<0)
#define L4_KWQ_CONNECT_REQ1_RESERVED1_SHIFT 0
#define L4_KWQ_CONNECT_REQ1_LAYER_CODE (0x7<<4)
#define L4_KWQ_CONNECT_REQ1_LAYER_CODE_SHIFT 4
#define L4_KWQ_CONNECT_REQ1_LINKED_WITH_NEXT (0x1<<7)
#define L4_KWQ_CONNECT_REQ1_LINKED_WITH_NEXT_SHIFT 7
#endif
	vmk_uint32 cid;
	vmk_uint32 pg_cid;
	vmk_uint32 src_ip;
	vmk_uint32 dst_ip;
#if defined(__BIG_ENDIAN)
	vmk_uint16 dst_port;
	vmk_uint16 src_port;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 src_port;
	vmk_uint16 dst_port;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint8 rsrv1[3];
	vmk_uint8 tcp_flags;
#define L4_KWQ_CONNECT_REQ1_NO_DELAY_ACK (0x1<<0)
#define L4_KWQ_CONNECT_REQ1_NO_DELAY_ACK_SHIFT 0
#define L4_KWQ_CONNECT_REQ1_KEEP_ALIVE (0x1<<1)
#define L4_KWQ_CONNECT_REQ1_KEEP_ALIVE_SHIFT 1
#define L4_KWQ_CONNECT_REQ1_NAGLE_ENABLE (0x1<<2)
#define L4_KWQ_CONNECT_REQ1_NAGLE_ENABLE_SHIFT 2
#define L4_KWQ_CONNECT_REQ1_TIME_STAMP (0x1<<3)
#define L4_KWQ_CONNECT_REQ1_TIME_STAMP_SHIFT 3
#define L4_KWQ_CONNECT_REQ1_SACK (0x1<<4)
#define L4_KWQ_CONNECT_REQ1_SACK_SHIFT 4
#define L4_KWQ_CONNECT_REQ1_SEG_SCALING (0x1<<5)
#define L4_KWQ_CONNECT_REQ1_SEG_SCALING_SHIFT 5
#define L4_KWQ_CONNECT_REQ1_RESERVED2 (0x3<<6)
#define L4_KWQ_CONNECT_REQ1_RESERVED2_SHIFT 6
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 tcp_flags;
#define L4_KWQ_CONNECT_REQ1_NO_DELAY_ACK (0x1<<0)
#define L4_KWQ_CONNECT_REQ1_NO_DELAY_ACK_SHIFT 0
#define L4_KWQ_CONNECT_REQ1_KEEP_ALIVE (0x1<<1)
#define L4_KWQ_CONNECT_REQ1_KEEP_ALIVE_SHIFT 1
#define L4_KWQ_CONNECT_REQ1_NAGLE_ENABLE (0x1<<2)
#define L4_KWQ_CONNECT_REQ1_NAGLE_ENABLE_SHIFT 2
#define L4_KWQ_CONNECT_REQ1_TIME_STAMP (0x1<<3)
#define L4_KWQ_CONNECT_REQ1_TIME_STAMP_SHIFT 3
#define L4_KWQ_CONNECT_REQ1_SACK (0x1<<4)
#define L4_KWQ_CONNECT_REQ1_SACK_SHIFT 4
#define L4_KWQ_CONNECT_REQ1_SEG_SCALING (0x1<<5)
#define L4_KWQ_CONNECT_REQ1_SEG_SCALING_SHIFT 5
#define L4_KWQ_CONNECT_REQ1_RESERVED2 (0x3<<6)
#define L4_KWQ_CONNECT_REQ1_RESERVED2_SHIFT 6
	vmk_uint8 rsrv1[3];
#endif
	vmk_uint32 rsrv2;
};


/*
 * The second ( optional )request to be passed in order to establish
 * connection in option2 - for IPv6 only
 */
struct l4_kwq_connect_req2 {
#if defined(__BIG_ENDIAN)
	vmk_uint8 flags;
#define L4_KWQ_CONNECT_REQ2_RESERVED1 (0xF<<0)
#define L4_KWQ_CONNECT_REQ2_RESERVED1_SHIFT 0
#define L4_KWQ_CONNECT_REQ2_LAYER_CODE (0x7<<4)
#define L4_KWQ_CONNECT_REQ2_LAYER_CODE_SHIFT 4
#define L4_KWQ_CONNECT_REQ2_LINKED_WITH_NEXT (0x1<<7)
#define L4_KWQ_CONNECT_REQ2_LINKED_WITH_NEXT_SHIFT 7
	vmk_uint8 op_code;
	vmk_uint8 reserved0;
	vmk_uint8 rsrv;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 rsrv;
	vmk_uint8 reserved0;
	vmk_uint8 op_code;
	vmk_uint8 flags;
#define L4_KWQ_CONNECT_REQ2_RESERVED1 (0xF<<0)
#define L4_KWQ_CONNECT_REQ2_RESERVED1_SHIFT 0
#define L4_KWQ_CONNECT_REQ2_LAYER_CODE (0x7<<4)
#define L4_KWQ_CONNECT_REQ2_LAYER_CODE_SHIFT 4
#define L4_KWQ_CONNECT_REQ2_LINKED_WITH_NEXT (0x1<<7)
#define L4_KWQ_CONNECT_REQ2_LINKED_WITH_NEXT_SHIFT 7
#endif
	vmk_uint32 reserved2;
	vmk_uint32 src_ip_v6_2;
	vmk_uint32 src_ip_v6_3;
	vmk_uint32 src_ip_v6_4;
	vmk_uint32 dst_ip_v6_2;
	vmk_uint32 dst_ip_v6_3;
	vmk_uint32 dst_ip_v6_4;
};


/*
 * The third ( and last )request to be passed in order to establish
 * connection in option2
 */
struct l4_kwq_connect_req3 {
#if defined(__BIG_ENDIAN)
	vmk_uint8 flags;
#define L4_KWQ_CONNECT_REQ3_RESERVED1 (0xF<<0)
#define L4_KWQ_CONNECT_REQ3_RESERVED1_SHIFT 0
#define L4_KWQ_CONNECT_REQ3_LAYER_CODE (0x7<<4)
#define L4_KWQ_CONNECT_REQ3_LAYER_CODE_SHIFT 4
#define L4_KWQ_CONNECT_REQ3_LINKED_WITH_NEXT (0x1<<7)
#define L4_KWQ_CONNECT_REQ3_LINKED_WITH_NEXT_SHIFT 7
	vmk_uint8 op_code;
	vmk_uint16 reserved0;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 reserved0;
	vmk_uint8 op_code;
	vmk_uint8 flags;
#define L4_KWQ_CONNECT_REQ3_RESERVED1 (0xF<<0)
#define L4_KWQ_CONNECT_REQ3_RESERVED1_SHIFT 0
#define L4_KWQ_CONNECT_REQ3_LAYER_CODE (0x7<<4)
#define L4_KWQ_CONNECT_REQ3_LAYER_CODE_SHIFT 4
#define L4_KWQ_CONNECT_REQ3_LINKED_WITH_NEXT (0x1<<7)
#define L4_KWQ_CONNECT_REQ3_LINKED_WITH_NEXT_SHIFT 7
#endif
	vmk_uint32 ka_timeout;
	vmk_uint32 ka_interval ;
#if defined(__BIG_ENDIAN)
	vmk_uint8 snd_seq_scale;
	vmk_uint8 ttl;
	vmk_uint8 tos;
	vmk_uint8 ka_max_probe_count;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 ka_max_probe_count;
	vmk_uint8 tos;
	vmk_uint8 ttl;
	vmk_uint8 snd_seq_scale;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint16 pmtu;
	vmk_uint16 mss;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 mss;
	vmk_uint16 pmtu;
#endif
	vmk_uint32 rcv_buf;
	vmk_uint32 snd_buf;
	vmk_uint32 seed;
};


/*
 * a KWQE request to offload a PG connection
 */
struct l4_kwq_offload_pg {
#if defined(__BIG_ENDIAN)
	vmk_uint8 flags;
#define L4_KWQ_OFFLOAD_PG_RESERVED1 (0xF<<0)
#define L4_KWQ_OFFLOAD_PG_RESERVED1_SHIFT 0
#define L4_KWQ_OFFLOAD_PG_LAYER_CODE (0x7<<4)
#define L4_KWQ_OFFLOAD_PG_LAYER_CODE_SHIFT 4
#define L4_KWQ_OFFLOAD_PG_LINKED_WITH_NEXT (0x1<<7)
#define L4_KWQ_OFFLOAD_PG_LINKED_WITH_NEXT_SHIFT 7
	vmk_uint8 op_code;
	vmk_uint16 reserved0;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 reserved0;
	vmk_uint8 op_code;
	vmk_uint8 flags;
#define L4_KWQ_OFFLOAD_PG_RESERVED1 (0xF<<0)
#define L4_KWQ_OFFLOAD_PG_RESERVED1_SHIFT 0
#define L4_KWQ_OFFLOAD_PG_LAYER_CODE (0x7<<4)
#define L4_KWQ_OFFLOAD_PG_LAYER_CODE_SHIFT 4
#define L4_KWQ_OFFLOAD_PG_LINKED_WITH_NEXT (0x1<<7)
#define L4_KWQ_OFFLOAD_PG_LINKED_WITH_NEXT_SHIFT 7
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint8 l2hdr_nbytes;
	vmk_uint8 pg_flags;
#define L4_KWQ_OFFLOAD_PG_SNAP_ENCAP (0x1<<0)
#define L4_KWQ_OFFLOAD_PG_SNAP_ENCAP_SHIFT 0
#define L4_KWQ_OFFLOAD_PG_VLAN_TAGGING (0x1<<1)
#define L4_KWQ_OFFLOAD_PG_VLAN_TAGGING_SHIFT 1
#define L4_KWQ_OFFLOAD_PG_RESERVED2 (0x3F<<2)
#define L4_KWQ_OFFLOAD_PG_RESERVED2_SHIFT 2
	vmk_uint8 da0;
	vmk_uint8 da1;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 da1;
	vmk_uint8 da0;
	vmk_uint8 pg_flags;
#define L4_KWQ_OFFLOAD_PG_SNAP_ENCAP (0x1<<0)
#define L4_KWQ_OFFLOAD_PG_SNAP_ENCAP_SHIFT 0
#define L4_KWQ_OFFLOAD_PG_VLAN_TAGGING (0x1<<1)
#define L4_KWQ_OFFLOAD_PG_VLAN_TAGGING_SHIFT 1
#define L4_KWQ_OFFLOAD_PG_RESERVED2 (0x3F<<2)
#define L4_KWQ_OFFLOAD_PG_RESERVED2_SHIFT 2
	vmk_uint8 l2hdr_nbytes;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint8 da2;
	vmk_uint8 da3;
	vmk_uint8 da4;
	vmk_uint8 da5;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 da5;
	vmk_uint8 da4;
	vmk_uint8 da3;
	vmk_uint8 da2;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint8 sa0;
	vmk_uint8 sa1;
	vmk_uint8 sa2;
	vmk_uint8 sa3;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 sa3;
	vmk_uint8 sa2;
	vmk_uint8 sa1;
	vmk_uint8 sa0;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint8 sa4;
	vmk_uint8 sa5;
	vmk_uint16 etype;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 etype;
	vmk_uint8 sa5;
	vmk_uint8 sa4;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint16 vlan_tag;
	vmk_uint16 ipid_start;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 ipid_start;
	vmk_uint16 vlan_tag;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint16 ipid_count;
	vmk_uint16 reserved3;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 reserved3;
	vmk_uint16 ipid_count;
#endif
	vmk_uint32 host_opaque;
};


/*
 * Abortively close the connection request
 */
struct l4_kwq_reset_req {
#if defined(__BIG_ENDIAN)
	vmk_uint8 flags;
#define L4_KWQ_RESET_REQ_RESERVED1 (0xF<<0)
#define L4_KWQ_RESET_REQ_RESERVED1_SHIFT 0
#define L4_KWQ_RESET_REQ_LAYER_CODE (0x7<<4)
#define L4_KWQ_RESET_REQ_LAYER_CODE_SHIFT 4
#define L4_KWQ_RESET_REQ_LINKED_WITH_NEXT (0x1<<7)
#define L4_KWQ_RESET_REQ_LINKED_WITH_NEXT_SHIFT 7
	vmk_uint8 op_code;
	vmk_uint16 reserved0;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 reserved0;
	vmk_uint8 op_code;
	vmk_uint8 flags;
#define L4_KWQ_RESET_REQ_RESERVED1 (0xF<<0)
#define L4_KWQ_RESET_REQ_RESERVED1_SHIFT 0
#define L4_KWQ_RESET_REQ_LAYER_CODE (0x7<<4)
#define L4_KWQ_RESET_REQ_LAYER_CODE_SHIFT 4
#define L4_KWQ_RESET_REQ_LINKED_WITH_NEXT (0x1<<7)
#define L4_KWQ_RESET_REQ_LINKED_WITH_NEXT_SHIFT 7
#endif
	vmk_uint32 cid;
	vmk_uint32 reserved2[6];
};


/*
 * a KWQE request to update a PG connection
 */
struct l4_kwq_update_pg {
#if defined(__BIG_ENDIAN)
	vmk_uint8 flags;
#define L4_KWQ_UPDATE_PG_RESERVED1 (0xF<<0)
#define L4_KWQ_UPDATE_PG_RESERVED1_SHIFT 0
#define L4_KWQ_UPDATE_PG_LAYER_CODE (0x7<<4)
#define L4_KWQ_UPDATE_PG_LAYER_CODE_SHIFT 4
#define L4_KWQ_UPDATE_PG_LINKED_WITH_NEXT (0x1<<7)
#define L4_KWQ_UPDATE_PG_LINKED_WITH_NEXT_SHIFT 7
	vmk_uint8 opcode;
	vmk_uint16 oper16;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 oper16;
	vmk_uint8 opcode;
	vmk_uint8 flags;
#define L4_KWQ_UPDATE_PG_RESERVED1 (0xF<<0)
#define L4_KWQ_UPDATE_PG_RESERVED1_SHIFT 0
#define L4_KWQ_UPDATE_PG_LAYER_CODE (0x7<<4)
#define L4_KWQ_UPDATE_PG_LAYER_CODE_SHIFT 4
#define L4_KWQ_UPDATE_PG_LINKED_WITH_NEXT (0x1<<7)
#define L4_KWQ_UPDATE_PG_LINKED_WITH_NEXT_SHIFT 7
#endif
	vmk_uint32 pg_cid;
	vmk_uint32 pg_host_opaque;
#if defined(__BIG_ENDIAN)
	vmk_uint8 pg_valids;
#define L4_KWQ_UPDATE_PG_VALIDS_IPID_COUNT (0x1<<0)
#define L4_KWQ_UPDATE_PG_VALIDS_IPID_COUNT_SHIFT 0
#define L4_KWQ_UPDATE_PG_VALIDS_DA (0x1<<1)
#define L4_KWQ_UPDATE_PG_VALIDS_DA_SHIFT 1
#define L4_KWQ_UPDATE_PG_RESERVERD2 (0x3F<<2)
#define L4_KWQ_UPDATE_PG_RESERVERD2_SHIFT 2
	vmk_uint8 pg_unused_a;
	vmk_uint16 pg_ipid_count;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 pg_ipid_count;
	vmk_uint8 pg_unused_a;
	vmk_uint8 pg_valids;
#define L4_KWQ_UPDATE_PG_VALIDS_IPID_COUNT (0x1<<0)
#define L4_KWQ_UPDATE_PG_VALIDS_IPID_COUNT_SHIFT 0
#define L4_KWQ_UPDATE_PG_VALIDS_DA (0x1<<1)
#define L4_KWQ_UPDATE_PG_VALIDS_DA_SHIFT 1
#define L4_KWQ_UPDATE_PG_RESERVERD2 (0x3F<<2)
#define L4_KWQ_UPDATE_PG_RESERVERD2_SHIFT 2
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint16 reserverd3;
	vmk_uint8 da0;
	vmk_uint8 da1;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 da1;
	vmk_uint8 da0;
	vmk_uint16 reserverd3;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint8 da2;
	vmk_uint8 da3;
	vmk_uint8 da4;
	vmk_uint8 da5;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 da5;
	vmk_uint8 da4;
	vmk_uint8 da3;
	vmk_uint8 da2;
#endif
	vmk_uint32 reserved4;
	vmk_uint32 reserved5;
};


/*
 * a KWQE request to upload a PG or L4 context
 */
struct l4_kwq_upload {
#if defined(__BIG_ENDIAN)
	vmk_uint8 flags;
#define L4_KWQ_UPLOAD_RESERVED1 (0xF<<0)
#define L4_KWQ_UPLOAD_RESERVED1_SHIFT 0
#define L4_KWQ_UPLOAD_LAYER_CODE (0x7<<4)
#define L4_KWQ_UPLOAD_LAYER_CODE_SHIFT 4
#define L4_KWQ_UPLOAD_LINKED_WITH_NEXT (0x1<<7)
#define L4_KWQ_UPLOAD_LINKED_WITH_NEXT_SHIFT 7
	vmk_uint8 opcode;
	vmk_uint16 oper16;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 oper16;
	vmk_uint8 opcode;
	vmk_uint8 flags;
#define L4_KWQ_UPLOAD_RESERVED1 (0xF<<0)
#define L4_KWQ_UPLOAD_RESERVED1_SHIFT 0
#define L4_KWQ_UPLOAD_LAYER_CODE (0x7<<4)
#define L4_KWQ_UPLOAD_LAYER_CODE_SHIFT 4
#define L4_KWQ_UPLOAD_LINKED_WITH_NEXT (0x1<<7)
#define L4_KWQ_UPLOAD_LINKED_WITH_NEXT_SHIFT 7
#endif
	vmk_uint32 cid;
	vmk_uint32 reserved2[6];
};

/*
 * qfle3 structures
 */

/*
 * The iscsi aggregative context of Cstorm
 */
struct cstorm_iscsi_ag_context {
	vmk_uint32 agg_vars1;
#define CSTORM_ISCSI_AG_CONTEXT_STATE (0xFF<<0)
#define CSTORM_ISCSI_AG_CONTEXT_STATE_SHIFT 0
#define __CSTORM_ISCSI_AG_CONTEXT_EXISTS_IN_QM0 (0x1<<8)
#define __CSTORM_ISCSI_AG_CONTEXT_EXISTS_IN_QM0_SHIFT 8
#define __CSTORM_ISCSI_AG_CONTEXT_EXISTS_IN_QM1 (0x1<<9)
#define __CSTORM_ISCSI_AG_CONTEXT_EXISTS_IN_QM1_SHIFT 9
#define __CSTORM_ISCSI_AG_CONTEXT_EXISTS_IN_QM2 (0x1<<10)
#define __CSTORM_ISCSI_AG_CONTEXT_EXISTS_IN_QM2_SHIFT 10
#define __CSTORM_ISCSI_AG_CONTEXT_EXISTS_IN_QM3 (0x1<<11)
#define __CSTORM_ISCSI_AG_CONTEXT_EXISTS_IN_QM3_SHIFT 11
#define __CSTORM_ISCSI_AG_CONTEXT_RESERVED_ULP_RX_SE_CF_EN (0x1<<12)
#define __CSTORM_ISCSI_AG_CONTEXT_RESERVED_ULP_RX_SE_CF_EN_SHIFT 12
#define __CSTORM_ISCSI_AG_CONTEXT_RESERVED_ULP_RX_INV_CF_EN (0x1<<13)
#define __CSTORM_ISCSI_AG_CONTEXT_RESERVED_ULP_RX_INV_CF_EN_SHIFT 13
#define __CSTORM_ISCSI_AG_CONTEXT_AUX4_CF (0x3<<14)
#define __CSTORM_ISCSI_AG_CONTEXT_AUX4_CF_SHIFT 14
#define __CSTORM_ISCSI_AG_CONTEXT_RESERVED66 (0x3<<16)
#define __CSTORM_ISCSI_AG_CONTEXT_RESERVED66_SHIFT 16
#define __CSTORM_ISCSI_AG_CONTEXT_FIN_RECEIVED_CF_EN (0x1<<18)
#define __CSTORM_ISCSI_AG_CONTEXT_FIN_RECEIVED_CF_EN_SHIFT 18
#define __CSTORM_ISCSI_AG_CONTEXT_AUX1_CF_EN (0x1<<19)
#define __CSTORM_ISCSI_AG_CONTEXT_AUX1_CF_EN_SHIFT 19
#define __CSTORM_ISCSI_AG_CONTEXT_AUX2_CF_EN (0x1<<20)
#define __CSTORM_ISCSI_AG_CONTEXT_AUX2_CF_EN_SHIFT 20
#define __CSTORM_ISCSI_AG_CONTEXT_AUX3_CF_EN (0x1<<21)
#define __CSTORM_ISCSI_AG_CONTEXT_AUX3_CF_EN_SHIFT 21
#define __CSTORM_ISCSI_AG_CONTEXT_AUX4_CF_EN (0x1<<22)
#define __CSTORM_ISCSI_AG_CONTEXT_AUX4_CF_EN_SHIFT 22
#define __CSTORM_ISCSI_AG_CONTEXT_REL_SEQ_RULE (0x7<<23)
#define __CSTORM_ISCSI_AG_CONTEXT_REL_SEQ_RULE_SHIFT 23
#define CSTORM_ISCSI_AG_CONTEXT_HQ_PROD_RULE (0x3<<26)
#define CSTORM_ISCSI_AG_CONTEXT_HQ_PROD_RULE_SHIFT 26
#define __CSTORM_ISCSI_AG_CONTEXT_RESERVED52 (0x3<<28)
#define __CSTORM_ISCSI_AG_CONTEXT_RESERVED52_SHIFT 28
#define __CSTORM_ISCSI_AG_CONTEXT_RESERVED53 (0x3<<30)
#define __CSTORM_ISCSI_AG_CONTEXT_RESERVED53_SHIFT 30
#if defined(__BIG_ENDIAN)
	vmk_uint8 __aux1_th;
	vmk_uint8 __aux1_val;
	vmk_uint16 __agg_vars2;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 __agg_vars2;
	vmk_uint8 __aux1_val;
	vmk_uint8 __aux1_th;
#endif
	vmk_uint32 rel_seq;
	vmk_uint32 rel_seq_th;
#if defined(__BIG_ENDIAN)
	vmk_uint16 hq_cons;
	vmk_uint16 hq_prod;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 hq_prod;
	vmk_uint16 hq_cons;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint8 __reserved62;
	vmk_uint8 __reserved61;
	vmk_uint8 __reserved60;
	vmk_uint8 __reserved59;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 __reserved59;
	vmk_uint8 __reserved60;
	vmk_uint8 __reserved61;
	vmk_uint8 __reserved62;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint16 __reserved64;
	vmk_uint16 cq_u_prod;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 cq_u_prod;
	vmk_uint16 __reserved64;
#endif
	vmk_uint32 __cq_u_prod1;
#if defined(__BIG_ENDIAN)
	vmk_uint16 __agg_vars3;
	vmk_uint16 cq_u_pend;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 cq_u_pend;
	vmk_uint16 __agg_vars3;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint16 __aux2_th;
	vmk_uint16 aux2_val;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 aux2_val;
	vmk_uint16 __aux2_th;
#endif
};

/*
 * The fcoe extra aggregative context section of Tstorm
 */
struct tstorm_fcoe_extra_ag_context_section {
	vmk_uint32 __agg_val1;
#if defined(__BIG_ENDIAN)
	vmk_uint8 __tcp_agg_vars2;
	vmk_uint8 __agg_val3;
	vmk_uint16 __agg_val2;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 __agg_val2;
	vmk_uint8 __agg_val3;
	vmk_uint8 __tcp_agg_vars2;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint16 __agg_val5;
	vmk_uint8 __agg_val6;
	vmk_uint8 __tcp_agg_vars3;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 __tcp_agg_vars3;
	vmk_uint8 __agg_val6;
	vmk_uint16 __agg_val5;
#endif
	vmk_uint32 __lcq_prod;
	vmk_uint32 rtt_seq;
	vmk_uint32 rtt_time;
	vmk_uint32 __reserved66;
	vmk_uint32 wnd_right_edge;
	vmk_uint32 tcp_agg_vars1;
#define TSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_FIN_SENT_FLAG (0x1<<0)
#define TSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_FIN_SENT_FLAG_SHIFT 0
#define TSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_LAST_PACKET_FIN_FLAG (0x1<<1)
#define TSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_LAST_PACKET_FIN_FLAG_SHIFT 1
#define TSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_WND_UPD_CF (0x3<<2)
#define TSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_WND_UPD_CF_SHIFT 2
#define TSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_TIMEOUT_CF (0x3<<4)
#define TSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_TIMEOUT_CF_SHIFT 4
#define TSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_WND_UPD_CF_EN (0x1<<6)
#define TSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_WND_UPD_CF_EN_SHIFT 6
#define TSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_TIMEOUT_CF_EN (0x1<<7)
#define TSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_TIMEOUT_CF_EN_SHIFT 7
#define TSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_RETRANSMIT_SEQ_EN (0x1<<8)
#define TSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_RETRANSMIT_SEQ_EN_SHIFT 8
#define __TSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_LCQ_SND_EN (0x1<<9)
#define __TSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_LCQ_SND_EN_SHIFT 9
#define TSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_AUX1_FLAG (0x1<<10)
#define TSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_AUX1_FLAG_SHIFT 10
#define TSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_AUX2_FLAG (0x1<<11)
#define TSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_AUX2_FLAG_SHIFT 11
#define TSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_AUX1_CF_EN (0x1<<12)
#define TSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_AUX1_CF_EN_SHIFT 12
#define TSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_AUX2_CF_EN (0x1<<13)
#define TSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_AUX2_CF_EN_SHIFT 13
#define TSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_AUX1_CF (0x3<<14)
#define TSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_AUX1_CF_SHIFT 14
#define TSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_AUX2_CF (0x3<<16)
#define TSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_AUX2_CF_SHIFT 16
#define TSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_TX_BLOCKED (0x1<<18)
#define TSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_TX_BLOCKED_SHIFT 18
#define __TSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_AUX10_CF_EN (0x1<<19)
#define __TSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_AUX10_CF_EN_SHIFT 19
#define __TSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_AUX11_CF_EN (0x1<<20)
#define __TSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_AUX11_CF_EN_SHIFT 20
#define __TSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_AUX12_CF_EN (0x1<<21)
#define __TSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_AUX12_CF_EN_SHIFT 21
#define __TSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_RESERVED1 (0x3<<22)
#define __TSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_RESERVED1_SHIFT 22
#define TSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_RETRANSMIT_PEND_SEQ (0xF<<24)
#define TSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_RETRANSMIT_PEND_SEQ_SHIFT 24
#define TSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_RETRANSMIT_DONE_SEQ (0xF<<28)
#define TSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_RETRANSMIT_DONE_SEQ_SHIFT 28
	vmk_uint32 snd_max;
	vmk_uint32 __lcq_cons;
	vmk_uint32 __reserved2;
};

/*
 * The fcoe aggregative context of Tstorm
 */
struct tstorm_fcoe_ag_context {
#if defined(__BIG_ENDIAN)
	vmk_uint16 ulp_credit;
	vmk_uint8 agg_vars1;
#define TSTORM_FCOE_AG_CONTEXT_EXISTS_IN_QM0 (0x1<<0)
#define TSTORM_FCOE_AG_CONTEXT_EXISTS_IN_QM0_SHIFT 0
#define TSTORM_FCOE_AG_CONTEXT_EXISTS_IN_QM1 (0x1<<1)
#define TSTORM_FCOE_AG_CONTEXT_EXISTS_IN_QM1_SHIFT 1
#define TSTORM_FCOE_AG_CONTEXT_EXISTS_IN_QM2 (0x1<<2)
#define TSTORM_FCOE_AG_CONTEXT_EXISTS_IN_QM2_SHIFT 2
#define TSTORM_FCOE_AG_CONTEXT_EXISTS_IN_QM3 (0x1<<3)
#define TSTORM_FCOE_AG_CONTEXT_EXISTS_IN_QM3_SHIFT 3
#define __TSTORM_FCOE_AG_CONTEXT_QUEUE0_FLUSH_CF (0x3<<4)
#define __TSTORM_FCOE_AG_CONTEXT_QUEUE0_FLUSH_CF_SHIFT 4
#define __TSTORM_FCOE_AG_CONTEXT_AUX3_FLAG (0x1<<6)
#define __TSTORM_FCOE_AG_CONTEXT_AUX3_FLAG_SHIFT 6
#define __TSTORM_FCOE_AG_CONTEXT_AUX4_FLAG (0x1<<7)
#define __TSTORM_FCOE_AG_CONTEXT_AUX4_FLAG_SHIFT 7
	vmk_uint8 state;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 state;
	vmk_uint8 agg_vars1;
#define TSTORM_FCOE_AG_CONTEXT_EXISTS_IN_QM0 (0x1<<0)
#define TSTORM_FCOE_AG_CONTEXT_EXISTS_IN_QM0_SHIFT 0
#define TSTORM_FCOE_AG_CONTEXT_EXISTS_IN_QM1 (0x1<<1)
#define TSTORM_FCOE_AG_CONTEXT_EXISTS_IN_QM1_SHIFT 1
#define TSTORM_FCOE_AG_CONTEXT_EXISTS_IN_QM2 (0x1<<2)
#define TSTORM_FCOE_AG_CONTEXT_EXISTS_IN_QM2_SHIFT 2
#define TSTORM_FCOE_AG_CONTEXT_EXISTS_IN_QM3 (0x1<<3)
#define TSTORM_FCOE_AG_CONTEXT_EXISTS_IN_QM3_SHIFT 3
#define __TSTORM_FCOE_AG_CONTEXT_QUEUE0_FLUSH_CF (0x3<<4)
#define __TSTORM_FCOE_AG_CONTEXT_QUEUE0_FLUSH_CF_SHIFT 4
#define __TSTORM_FCOE_AG_CONTEXT_AUX3_FLAG (0x1<<6)
#define __TSTORM_FCOE_AG_CONTEXT_AUX3_FLAG_SHIFT 6
#define __TSTORM_FCOE_AG_CONTEXT_AUX4_FLAG (0x1<<7)
#define __TSTORM_FCOE_AG_CONTEXT_AUX4_FLAG_SHIFT 7
	vmk_uint16 ulp_credit;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint16 __agg_val4;
	vmk_uint16 agg_vars2;
#define __TSTORM_FCOE_AG_CONTEXT_AUX5_FLAG (0x1<<0)
#define __TSTORM_FCOE_AG_CONTEXT_AUX5_FLAG_SHIFT 0
#define __TSTORM_FCOE_AG_CONTEXT_AUX6_FLAG (0x1<<1)
#define __TSTORM_FCOE_AG_CONTEXT_AUX6_FLAG_SHIFT 1
#define __TSTORM_FCOE_AG_CONTEXT_AUX4_CF (0x3<<2)
#define __TSTORM_FCOE_AG_CONTEXT_AUX4_CF_SHIFT 2
#define __TSTORM_FCOE_AG_CONTEXT_AUX5_CF (0x3<<4)
#define __TSTORM_FCOE_AG_CONTEXT_AUX5_CF_SHIFT 4
#define __TSTORM_FCOE_AG_CONTEXT_AUX6_CF (0x3<<6)
#define __TSTORM_FCOE_AG_CONTEXT_AUX6_CF_SHIFT 6
#define __TSTORM_FCOE_AG_CONTEXT_AUX7_CF (0x3<<8)
#define __TSTORM_FCOE_AG_CONTEXT_AUX7_CF_SHIFT 8
#define __TSTORM_FCOE_AG_CONTEXT_AUX7_FLAG (0x1<<10)
#define __TSTORM_FCOE_AG_CONTEXT_AUX7_FLAG_SHIFT 10
#define __TSTORM_FCOE_AG_CONTEXT_QUEUE0_FLUSH_CF_EN (0x1<<11)
#define __TSTORM_FCOE_AG_CONTEXT_QUEUE0_FLUSH_CF_EN_SHIFT 11
#define TSTORM_FCOE_AG_CONTEXT_AUX4_CF_EN (0x1<<12)
#define TSTORM_FCOE_AG_CONTEXT_AUX4_CF_EN_SHIFT 12
#define TSTORM_FCOE_AG_CONTEXT_AUX5_CF_EN (0x1<<13)
#define TSTORM_FCOE_AG_CONTEXT_AUX5_CF_EN_SHIFT 13
#define TSTORM_FCOE_AG_CONTEXT_AUX6_CF_EN (0x1<<14)
#define TSTORM_FCOE_AG_CONTEXT_AUX6_CF_EN_SHIFT 14
#define TSTORM_FCOE_AG_CONTEXT_AUX7_CF_EN (0x1<<15)
#define TSTORM_FCOE_AG_CONTEXT_AUX7_CF_EN_SHIFT 15
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 agg_vars2;
#define __TSTORM_FCOE_AG_CONTEXT_AUX5_FLAG (0x1<<0)
#define __TSTORM_FCOE_AG_CONTEXT_AUX5_FLAG_SHIFT 0
#define __TSTORM_FCOE_AG_CONTEXT_AUX6_FLAG (0x1<<1)
#define __TSTORM_FCOE_AG_CONTEXT_AUX6_FLAG_SHIFT 1
#define __TSTORM_FCOE_AG_CONTEXT_AUX4_CF (0x3<<2)
#define __TSTORM_FCOE_AG_CONTEXT_AUX4_CF_SHIFT 2
#define __TSTORM_FCOE_AG_CONTEXT_AUX5_CF (0x3<<4)
#define __TSTORM_FCOE_AG_CONTEXT_AUX5_CF_SHIFT 4
#define __TSTORM_FCOE_AG_CONTEXT_AUX6_CF (0x3<<6)
#define __TSTORM_FCOE_AG_CONTEXT_AUX6_CF_SHIFT 6
#define __TSTORM_FCOE_AG_CONTEXT_AUX7_CF (0x3<<8)
#define __TSTORM_FCOE_AG_CONTEXT_AUX7_CF_SHIFT 8
#define __TSTORM_FCOE_AG_CONTEXT_AUX7_FLAG (0x1<<10)
#define __TSTORM_FCOE_AG_CONTEXT_AUX7_FLAG_SHIFT 10
#define __TSTORM_FCOE_AG_CONTEXT_QUEUE0_FLUSH_CF_EN (0x1<<11)
#define __TSTORM_FCOE_AG_CONTEXT_QUEUE0_FLUSH_CF_EN_SHIFT 11
#define TSTORM_FCOE_AG_CONTEXT_AUX4_CF_EN (0x1<<12)
#define TSTORM_FCOE_AG_CONTEXT_AUX4_CF_EN_SHIFT 12
#define TSTORM_FCOE_AG_CONTEXT_AUX5_CF_EN (0x1<<13)
#define TSTORM_FCOE_AG_CONTEXT_AUX5_CF_EN_SHIFT 13
#define TSTORM_FCOE_AG_CONTEXT_AUX6_CF_EN (0x1<<14)
#define TSTORM_FCOE_AG_CONTEXT_AUX6_CF_EN_SHIFT 14
#define TSTORM_FCOE_AG_CONTEXT_AUX7_CF_EN (0x1<<15)
#define TSTORM_FCOE_AG_CONTEXT_AUX7_CF_EN_SHIFT 15
	vmk_uint16 __agg_val4;
#endif
	struct tstorm_fcoe_extra_ag_context_section __extra_section;
};



/*
 * The tcp aggregative context section of Tstorm
 */
struct tstorm_tcp_tcp_ag_context_section {
	vmk_uint32 __agg_val1;
#if defined(__BIG_ENDIAN)
	vmk_uint8 __tcp_agg_vars2;
	vmk_uint8 __agg_val3;
	vmk_uint16 __agg_val2;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 __agg_val2;
	vmk_uint8 __agg_val3;
	vmk_uint8 __tcp_agg_vars2;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint16 __agg_val5;
	vmk_uint8 __agg_val6;
	vmk_uint8 __tcp_agg_vars3;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 __tcp_agg_vars3;
	vmk_uint8 __agg_val6;
	vmk_uint16 __agg_val5;
#endif
	vmk_uint32 snd_nxt;
	vmk_uint32 rtt_seq;
	vmk_uint32 rtt_time;
	vmk_uint32 __reserved66;
	vmk_uint32 wnd_right_edge;
	vmk_uint32 tcp_agg_vars1;
#define TSTORM_TCP_TCP_AG_CONTEXT_SECTION_FIN_SENT_FLAG (0x1<<0)
#define TSTORM_TCP_TCP_AG_CONTEXT_SECTION_FIN_SENT_FLAG_SHIFT 0
#define TSTORM_TCP_TCP_AG_CONTEXT_SECTION_LAST_PACKET_FIN_FLAG (0x1<<1)
#define TSTORM_TCP_TCP_AG_CONTEXT_SECTION_LAST_PACKET_FIN_FLAG_SHIFT 1
#define TSTORM_TCP_TCP_AG_CONTEXT_SECTION_WND_UPD_CF (0x3<<2)
#define TSTORM_TCP_TCP_AG_CONTEXT_SECTION_WND_UPD_CF_SHIFT 2
#define TSTORM_TCP_TCP_AG_CONTEXT_SECTION_TIMEOUT_CF (0x3<<4)
#define TSTORM_TCP_TCP_AG_CONTEXT_SECTION_TIMEOUT_CF_SHIFT 4
#define TSTORM_TCP_TCP_AG_CONTEXT_SECTION_WND_UPD_CF_EN (0x1<<6)
#define TSTORM_TCP_TCP_AG_CONTEXT_SECTION_WND_UPD_CF_EN_SHIFT 6
#define TSTORM_TCP_TCP_AG_CONTEXT_SECTION_TIMEOUT_CF_EN (0x1<<7)
#define TSTORM_TCP_TCP_AG_CONTEXT_SECTION_TIMEOUT_CF_EN_SHIFT 7
#define TSTORM_TCP_TCP_AG_CONTEXT_SECTION_RETRANSMIT_SEQ_EN (0x1<<8)
#define TSTORM_TCP_TCP_AG_CONTEXT_SECTION_RETRANSMIT_SEQ_EN_SHIFT 8
#define TSTORM_TCP_TCP_AG_CONTEXT_SECTION_SND_NXT_EN (0x1<<9)
#define TSTORM_TCP_TCP_AG_CONTEXT_SECTION_SND_NXT_EN_SHIFT 9
#define TSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX1_FLAG (0x1<<10)
#define TSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX1_FLAG_SHIFT 10
#define TSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX2_FLAG (0x1<<11)
#define TSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX2_FLAG_SHIFT 11
#define TSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX1_CF_EN (0x1<<12)
#define TSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX1_CF_EN_SHIFT 12
#define TSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX2_CF_EN (0x1<<13)
#define TSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX2_CF_EN_SHIFT 13
#define TSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX1_CF (0x3<<14)
#define TSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX1_CF_SHIFT 14
#define TSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX2_CF (0x3<<16)
#define TSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX2_CF_SHIFT 16
#define TSTORM_TCP_TCP_AG_CONTEXT_SECTION_TX_BLOCKED (0x1<<18)
#define TSTORM_TCP_TCP_AG_CONTEXT_SECTION_TX_BLOCKED_SHIFT 18
#define __TSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX10_CF_EN (0x1<<19)
#define __TSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX10_CF_EN_SHIFT 19
#define __TSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX11_CF_EN (0x1<<20)
#define __TSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX11_CF_EN_SHIFT 20
#define __TSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX12_CF_EN (0x1<<21)
#define __TSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX12_CF_EN_SHIFT 21
#define __TSTORM_TCP_TCP_AG_CONTEXT_SECTION_RESERVED1 (0x3<<22)
#define __TSTORM_TCP_TCP_AG_CONTEXT_SECTION_RESERVED1_SHIFT 22
#define TSTORM_TCP_TCP_AG_CONTEXT_SECTION_RETRANSMIT_PEND_SEQ (0xF<<24)
#define TSTORM_TCP_TCP_AG_CONTEXT_SECTION_RETRANSMIT_PEND_SEQ_SHIFT 24
#define TSTORM_TCP_TCP_AG_CONTEXT_SECTION_RETRANSMIT_DONE_SEQ (0xF<<28)
#define TSTORM_TCP_TCP_AG_CONTEXT_SECTION_RETRANSMIT_DONE_SEQ_SHIFT 28
	vmk_uint32 snd_max;
	vmk_uint32 snd_una;
	vmk_uint32 __reserved2;
};

/*
 * The iscsi aggregative context of Tstorm
 */
struct tstorm_iscsi_ag_context {
#if defined(__BIG_ENDIAN)
	vmk_uint16 ulp_credit;
	vmk_uint8 agg_vars1;
#define TSTORM_ISCSI_AG_CONTEXT_EXISTS_IN_QM0 (0x1<<0)
#define TSTORM_ISCSI_AG_CONTEXT_EXISTS_IN_QM0_SHIFT 0
#define TSTORM_ISCSI_AG_CONTEXT_EXISTS_IN_QM1 (0x1<<1)
#define TSTORM_ISCSI_AG_CONTEXT_EXISTS_IN_QM1_SHIFT 1
#define TSTORM_ISCSI_AG_CONTEXT_EXISTS_IN_QM2 (0x1<<2)
#define TSTORM_ISCSI_AG_CONTEXT_EXISTS_IN_QM2_SHIFT 2
#define TSTORM_ISCSI_AG_CONTEXT_EXISTS_IN_QM3 (0x1<<3)
#define TSTORM_ISCSI_AG_CONTEXT_EXISTS_IN_QM3_SHIFT 3
#define __TSTORM_ISCSI_AG_CONTEXT_QUEUES_FLUSH_Q0_CF (0x3<<4)
#define __TSTORM_ISCSI_AG_CONTEXT_QUEUES_FLUSH_Q0_CF_SHIFT 4
#define __TSTORM_ISCSI_AG_CONTEXT_AUX3_FLAG (0x1<<6)
#define __TSTORM_ISCSI_AG_CONTEXT_AUX3_FLAG_SHIFT 6
#define __TSTORM_ISCSI_AG_CONTEXT_ACK_ON_FIN_SENT_FLAG (0x1<<7)
#define __TSTORM_ISCSI_AG_CONTEXT_ACK_ON_FIN_SENT_FLAG_SHIFT 7
	vmk_uint8 state;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 state;
	vmk_uint8 agg_vars1;
#define TSTORM_ISCSI_AG_CONTEXT_EXISTS_IN_QM0 (0x1<<0)
#define TSTORM_ISCSI_AG_CONTEXT_EXISTS_IN_QM0_SHIFT 0
#define TSTORM_ISCSI_AG_CONTEXT_EXISTS_IN_QM1 (0x1<<1)
#define TSTORM_ISCSI_AG_CONTEXT_EXISTS_IN_QM1_SHIFT 1
#define TSTORM_ISCSI_AG_CONTEXT_EXISTS_IN_QM2 (0x1<<2)
#define TSTORM_ISCSI_AG_CONTEXT_EXISTS_IN_QM2_SHIFT 2
#define TSTORM_ISCSI_AG_CONTEXT_EXISTS_IN_QM3 (0x1<<3)
#define TSTORM_ISCSI_AG_CONTEXT_EXISTS_IN_QM3_SHIFT 3
#define __TSTORM_ISCSI_AG_CONTEXT_QUEUES_FLUSH_Q0_CF (0x3<<4)
#define __TSTORM_ISCSI_AG_CONTEXT_QUEUES_FLUSH_Q0_CF_SHIFT 4
#define __TSTORM_ISCSI_AG_CONTEXT_AUX3_FLAG (0x1<<6)
#define __TSTORM_ISCSI_AG_CONTEXT_AUX3_FLAG_SHIFT 6
#define __TSTORM_ISCSI_AG_CONTEXT_ACK_ON_FIN_SENT_FLAG (0x1<<7)
#define __TSTORM_ISCSI_AG_CONTEXT_ACK_ON_FIN_SENT_FLAG_SHIFT 7
	vmk_uint16 ulp_credit;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint16 __agg_val4;
	vmk_uint16 agg_vars2;
#define __TSTORM_ISCSI_AG_CONTEXT_MSL_TIMER_SET_FLAG (0x1<<0)
#define __TSTORM_ISCSI_AG_CONTEXT_MSL_TIMER_SET_FLAG_SHIFT 0
#define __TSTORM_ISCSI_AG_CONTEXT_FIN_SENT_FIRST_FLAG (0x1<<1)
#define __TSTORM_ISCSI_AG_CONTEXT_FIN_SENT_FIRST_FLAG_SHIFT 1
#define __TSTORM_ISCSI_AG_CONTEXT_RST_SENT_CF (0x3<<2)
#define __TSTORM_ISCSI_AG_CONTEXT_RST_SENT_CF_SHIFT 2
#define __TSTORM_ISCSI_AG_CONTEXT_WAKEUP_CALL_CF (0x3<<4)
#define __TSTORM_ISCSI_AG_CONTEXT_WAKEUP_CALL_CF_SHIFT 4
#define __TSTORM_ISCSI_AG_CONTEXT_AUX6_CF (0x3<<6)
#define __TSTORM_ISCSI_AG_CONTEXT_AUX6_CF_SHIFT 6
#define __TSTORM_ISCSI_AG_CONTEXT_AUX7_CF (0x3<<8)
#define __TSTORM_ISCSI_AG_CONTEXT_AUX7_CF_SHIFT 8
#define __TSTORM_ISCSI_AG_CONTEXT_AUX7_FLAG (0x1<<10)
#define __TSTORM_ISCSI_AG_CONTEXT_AUX7_FLAG_SHIFT 10
#define __TSTORM_ISCSI_AG_CONTEXT_QUEUES_FLUSH_Q0_CF_EN (0x1<<11)
#define __TSTORM_ISCSI_AG_CONTEXT_QUEUES_FLUSH_Q0_CF_EN_SHIFT 11
#define __TSTORM_ISCSI_AG_CONTEXT_RST_SENT_CF_EN (0x1<<12)
#define __TSTORM_ISCSI_AG_CONTEXT_RST_SENT_CF_EN_SHIFT 12
#define __TSTORM_ISCSI_AG_CONTEXT_WAKEUP_CALL_CF_EN (0x1<<13)
#define __TSTORM_ISCSI_AG_CONTEXT_WAKEUP_CALL_CF_EN_SHIFT 13
#define TSTORM_ISCSI_AG_CONTEXT_AUX6_CF_EN (0x1<<14)
#define TSTORM_ISCSI_AG_CONTEXT_AUX6_CF_EN_SHIFT 14
#define TSTORM_ISCSI_AG_CONTEXT_AUX7_CF_EN (0x1<<15)
#define TSTORM_ISCSI_AG_CONTEXT_AUX7_CF_EN_SHIFT 15
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 agg_vars2;
#define __TSTORM_ISCSI_AG_CONTEXT_MSL_TIMER_SET_FLAG (0x1<<0)
#define __TSTORM_ISCSI_AG_CONTEXT_MSL_TIMER_SET_FLAG_SHIFT 0
#define __TSTORM_ISCSI_AG_CONTEXT_FIN_SENT_FIRST_FLAG (0x1<<1)
#define __TSTORM_ISCSI_AG_CONTEXT_FIN_SENT_FIRST_FLAG_SHIFT 1
#define __TSTORM_ISCSI_AG_CONTEXT_RST_SENT_CF (0x3<<2)
#define __TSTORM_ISCSI_AG_CONTEXT_RST_SENT_CF_SHIFT 2
#define __TSTORM_ISCSI_AG_CONTEXT_WAKEUP_CALL_CF (0x3<<4)
#define __TSTORM_ISCSI_AG_CONTEXT_WAKEUP_CALL_CF_SHIFT 4
#define __TSTORM_ISCSI_AG_CONTEXT_AUX6_CF (0x3<<6)
#define __TSTORM_ISCSI_AG_CONTEXT_AUX6_CF_SHIFT 6
#define __TSTORM_ISCSI_AG_CONTEXT_AUX7_CF (0x3<<8)
#define __TSTORM_ISCSI_AG_CONTEXT_AUX7_CF_SHIFT 8
#define __TSTORM_ISCSI_AG_CONTEXT_AUX7_FLAG (0x1<<10)
#define __TSTORM_ISCSI_AG_CONTEXT_AUX7_FLAG_SHIFT 10
#define __TSTORM_ISCSI_AG_CONTEXT_QUEUES_FLUSH_Q0_CF_EN (0x1<<11)
#define __TSTORM_ISCSI_AG_CONTEXT_QUEUES_FLUSH_Q0_CF_EN_SHIFT 11
#define __TSTORM_ISCSI_AG_CONTEXT_RST_SENT_CF_EN (0x1<<12)
#define __TSTORM_ISCSI_AG_CONTEXT_RST_SENT_CF_EN_SHIFT 12
#define __TSTORM_ISCSI_AG_CONTEXT_WAKEUP_CALL_CF_EN (0x1<<13)
#define __TSTORM_ISCSI_AG_CONTEXT_WAKEUP_CALL_CF_EN_SHIFT 13
#define TSTORM_ISCSI_AG_CONTEXT_AUX6_CF_EN (0x1<<14)
#define TSTORM_ISCSI_AG_CONTEXT_AUX6_CF_EN_SHIFT 14
#define TSTORM_ISCSI_AG_CONTEXT_AUX7_CF_EN (0x1<<15)
#define TSTORM_ISCSI_AG_CONTEXT_AUX7_CF_EN_SHIFT 15
	vmk_uint16 __agg_val4;
#endif
	struct tstorm_tcp_tcp_ag_context_section tcp;
};



/*
 * The fcoe aggregative context of Ustorm
 */
struct ustorm_fcoe_ag_context {
#if defined(__BIG_ENDIAN)
	vmk_uint8 __aux_counter_flags;
	vmk_uint8 agg_vars2;
#define USTORM_FCOE_AG_CONTEXT_TX_CF (0x3<<0)
#define USTORM_FCOE_AG_CONTEXT_TX_CF_SHIFT 0
#define __USTORM_FCOE_AG_CONTEXT_TIMER_CF (0x3<<2)
#define __USTORM_FCOE_AG_CONTEXT_TIMER_CF_SHIFT 2
#define USTORM_FCOE_AG_CONTEXT_AGG_MISC4_RULE (0x7<<4)
#define USTORM_FCOE_AG_CONTEXT_AGG_MISC4_RULE_SHIFT 4
#define __USTORM_FCOE_AG_CONTEXT_AGG_VAL2_MASK (0x1<<7)
#define __USTORM_FCOE_AG_CONTEXT_AGG_VAL2_MASK_SHIFT 7
	vmk_uint8 agg_vars1;
#define __USTORM_FCOE_AG_CONTEXT_EXISTS_IN_QM0 (0x1<<0)
#define __USTORM_FCOE_AG_CONTEXT_EXISTS_IN_QM0_SHIFT 0
#define USTORM_FCOE_AG_CONTEXT_EXISTS_IN_QM1 (0x1<<1)
#define USTORM_FCOE_AG_CONTEXT_EXISTS_IN_QM1_SHIFT 1
#define USTORM_FCOE_AG_CONTEXT_EXISTS_IN_QM2 (0x1<<2)
#define USTORM_FCOE_AG_CONTEXT_EXISTS_IN_QM2_SHIFT 2
#define USTORM_FCOE_AG_CONTEXT_EXISTS_IN_QM3 (0x1<<3)
#define USTORM_FCOE_AG_CONTEXT_EXISTS_IN_QM3_SHIFT 3
#define USTORM_FCOE_AG_CONTEXT_INV_CF (0x3<<4)
#define USTORM_FCOE_AG_CONTEXT_INV_CF_SHIFT 4
#define USTORM_FCOE_AG_CONTEXT_COMPLETION_CF (0x3<<6)
#define USTORM_FCOE_AG_CONTEXT_COMPLETION_CF_SHIFT 6
	vmk_uint8 state;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 state;
	vmk_uint8 agg_vars1;
#define __USTORM_FCOE_AG_CONTEXT_EXISTS_IN_QM0 (0x1<<0)
#define __USTORM_FCOE_AG_CONTEXT_EXISTS_IN_QM0_SHIFT 0
#define USTORM_FCOE_AG_CONTEXT_EXISTS_IN_QM1 (0x1<<1)
#define USTORM_FCOE_AG_CONTEXT_EXISTS_IN_QM1_SHIFT 1
#define USTORM_FCOE_AG_CONTEXT_EXISTS_IN_QM2 (0x1<<2)
#define USTORM_FCOE_AG_CONTEXT_EXISTS_IN_QM2_SHIFT 2
#define USTORM_FCOE_AG_CONTEXT_EXISTS_IN_QM3 (0x1<<3)
#define USTORM_FCOE_AG_CONTEXT_EXISTS_IN_QM3_SHIFT 3
#define USTORM_FCOE_AG_CONTEXT_INV_CF (0x3<<4)
#define USTORM_FCOE_AG_CONTEXT_INV_CF_SHIFT 4
#define USTORM_FCOE_AG_CONTEXT_COMPLETION_CF (0x3<<6)
#define USTORM_FCOE_AG_CONTEXT_COMPLETION_CF_SHIFT 6
	vmk_uint8 agg_vars2;
#define USTORM_FCOE_AG_CONTEXT_TX_CF (0x3<<0)
#define USTORM_FCOE_AG_CONTEXT_TX_CF_SHIFT 0
#define __USTORM_FCOE_AG_CONTEXT_TIMER_CF (0x3<<2)
#define __USTORM_FCOE_AG_CONTEXT_TIMER_CF_SHIFT 2
#define USTORM_FCOE_AG_CONTEXT_AGG_MISC4_RULE (0x7<<4)
#define USTORM_FCOE_AG_CONTEXT_AGG_MISC4_RULE_SHIFT 4
#define __USTORM_FCOE_AG_CONTEXT_AGG_VAL2_MASK (0x1<<7)
#define __USTORM_FCOE_AG_CONTEXT_AGG_VAL2_MASK_SHIFT 7
	vmk_uint8 __aux_counter_flags;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint8 cdu_usage;
	vmk_uint8 agg_misc2;
	vmk_uint16 pbf_tx_seq_ack;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 pbf_tx_seq_ack;
	vmk_uint8 agg_misc2;
	vmk_uint8 cdu_usage;
#endif
	vmk_uint32 agg_misc4;
#if defined(__BIG_ENDIAN)
	vmk_uint8 agg_val3_th;
	vmk_uint8 agg_val3;
	vmk_uint16 agg_misc3;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 agg_misc3;
	vmk_uint8 agg_val3;
	vmk_uint8 agg_val3_th;
#endif
	vmk_uint32 expired_task_id;
	vmk_uint32 agg_misc4_th;
#if defined(__BIG_ENDIAN)
	vmk_uint16 cq_prod;
	vmk_uint16 cq_cons;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 cq_cons;
	vmk_uint16 cq_prod;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint16 __reserved2;
	vmk_uint8 decision_rules;
#define USTORM_FCOE_AG_CONTEXT_CQ_DEC_RULE (0x7<<0)
#define USTORM_FCOE_AG_CONTEXT_CQ_DEC_RULE_SHIFT 0
#define __USTORM_FCOE_AG_CONTEXT_AGG_VAL3_RULE (0x7<<3)
#define __USTORM_FCOE_AG_CONTEXT_AGG_VAL3_RULE_SHIFT 3
#define USTORM_FCOE_AG_CONTEXT_CQ_ARM_N_FLAG (0x1<<6)
#define USTORM_FCOE_AG_CONTEXT_CQ_ARM_N_FLAG_SHIFT 6
#define __USTORM_FCOE_AG_CONTEXT_RESERVED1 (0x1<<7)
#define __USTORM_FCOE_AG_CONTEXT_RESERVED1_SHIFT 7
	vmk_uint8 decision_rule_enable_bits;
#define __USTORM_FCOE_AG_CONTEXT_RESERVED_INV_CF_EN (0x1<<0)
#define __USTORM_FCOE_AG_CONTEXT_RESERVED_INV_CF_EN_SHIFT 0
#define USTORM_FCOE_AG_CONTEXT_COMPLETION_CF_EN (0x1<<1)
#define USTORM_FCOE_AG_CONTEXT_COMPLETION_CF_EN_SHIFT 1
#define USTORM_FCOE_AG_CONTEXT_TX_CF_EN (0x1<<2)
#define USTORM_FCOE_AG_CONTEXT_TX_CF_EN_SHIFT 2
#define __USTORM_FCOE_AG_CONTEXT_TIMER_CF_EN (0x1<<3)
#define __USTORM_FCOE_AG_CONTEXT_TIMER_CF_EN_SHIFT 3
#define __USTORM_FCOE_AG_CONTEXT_AUX1_CF_EN (0x1<<4)
#define __USTORM_FCOE_AG_CONTEXT_AUX1_CF_EN_SHIFT 4
#define __USTORM_FCOE_AG_CONTEXT_QUEUE0_CF_EN (0x1<<5)
#define __USTORM_FCOE_AG_CONTEXT_QUEUE0_CF_EN_SHIFT 5
#define __USTORM_FCOE_AG_CONTEXT_AUX3_CF_EN (0x1<<6)
#define __USTORM_FCOE_AG_CONTEXT_AUX3_CF_EN_SHIFT 6
#define __USTORM_FCOE_AG_CONTEXT_DQ_CF_EN (0x1<<7)
#define __USTORM_FCOE_AG_CONTEXT_DQ_CF_EN_SHIFT 7
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 decision_rule_enable_bits;
#define __USTORM_FCOE_AG_CONTEXT_RESERVED_INV_CF_EN (0x1<<0)
#define __USTORM_FCOE_AG_CONTEXT_RESERVED_INV_CF_EN_SHIFT 0
#define USTORM_FCOE_AG_CONTEXT_COMPLETION_CF_EN (0x1<<1)
#define USTORM_FCOE_AG_CONTEXT_COMPLETION_CF_EN_SHIFT 1
#define USTORM_FCOE_AG_CONTEXT_TX_CF_EN (0x1<<2)
#define USTORM_FCOE_AG_CONTEXT_TX_CF_EN_SHIFT 2
#define __USTORM_FCOE_AG_CONTEXT_TIMER_CF_EN (0x1<<3)
#define __USTORM_FCOE_AG_CONTEXT_TIMER_CF_EN_SHIFT 3
#define __USTORM_FCOE_AG_CONTEXT_AUX1_CF_EN (0x1<<4)
#define __USTORM_FCOE_AG_CONTEXT_AUX1_CF_EN_SHIFT 4
#define __USTORM_FCOE_AG_CONTEXT_QUEUE0_CF_EN (0x1<<5)
#define __USTORM_FCOE_AG_CONTEXT_QUEUE0_CF_EN_SHIFT 5
#define __USTORM_FCOE_AG_CONTEXT_AUX3_CF_EN (0x1<<6)
#define __USTORM_FCOE_AG_CONTEXT_AUX3_CF_EN_SHIFT 6
#define __USTORM_FCOE_AG_CONTEXT_DQ_CF_EN (0x1<<7)
#define __USTORM_FCOE_AG_CONTEXT_DQ_CF_EN_SHIFT 7
	vmk_uint8 decision_rules;
#define USTORM_FCOE_AG_CONTEXT_CQ_DEC_RULE (0x7<<0)
#define USTORM_FCOE_AG_CONTEXT_CQ_DEC_RULE_SHIFT 0
#define __USTORM_FCOE_AG_CONTEXT_AGG_VAL3_RULE (0x7<<3)
#define __USTORM_FCOE_AG_CONTEXT_AGG_VAL3_RULE_SHIFT 3
#define USTORM_FCOE_AG_CONTEXT_CQ_ARM_N_FLAG (0x1<<6)
#define USTORM_FCOE_AG_CONTEXT_CQ_ARM_N_FLAG_SHIFT 6
#define __USTORM_FCOE_AG_CONTEXT_RESERVED1 (0x1<<7)
#define __USTORM_FCOE_AG_CONTEXT_RESERVED1_SHIFT 7
	vmk_uint16 __reserved2;
#endif
};


/*
 * The iscsi aggregative context of Ustorm
 */
struct ustorm_iscsi_ag_context {
#if defined(__BIG_ENDIAN)
	vmk_uint8 __aux_counter_flags;
	vmk_uint8 agg_vars2;
#define USTORM_ISCSI_AG_CONTEXT_TX_CF (0x3<<0)
#define USTORM_ISCSI_AG_CONTEXT_TX_CF_SHIFT 0
#define __USTORM_ISCSI_AG_CONTEXT_TIMER_CF (0x3<<2)
#define __USTORM_ISCSI_AG_CONTEXT_TIMER_CF_SHIFT 2
#define USTORM_ISCSI_AG_CONTEXT_AGG_MISC4_RULE (0x7<<4)
#define USTORM_ISCSI_AG_CONTEXT_AGG_MISC4_RULE_SHIFT 4
#define __USTORM_ISCSI_AG_CONTEXT_AGG_VAL2_MASK (0x1<<7)
#define __USTORM_ISCSI_AG_CONTEXT_AGG_VAL2_MASK_SHIFT 7
	vmk_uint8 agg_vars1;
#define __USTORM_ISCSI_AG_CONTEXT_EXISTS_IN_QM0 (0x1<<0)
#define __USTORM_ISCSI_AG_CONTEXT_EXISTS_IN_QM0_SHIFT 0
#define USTORM_ISCSI_AG_CONTEXT_EXISTS_IN_QM1 (0x1<<1)
#define USTORM_ISCSI_AG_CONTEXT_EXISTS_IN_QM1_SHIFT 1
#define USTORM_ISCSI_AG_CONTEXT_EXISTS_IN_QM2 (0x1<<2)
#define USTORM_ISCSI_AG_CONTEXT_EXISTS_IN_QM2_SHIFT 2
#define USTORM_ISCSI_AG_CONTEXT_EXISTS_IN_QM3 (0x1<<3)
#define USTORM_ISCSI_AG_CONTEXT_EXISTS_IN_QM3_SHIFT 3
#define USTORM_ISCSI_AG_CONTEXT_INV_CF (0x3<<4)
#define USTORM_ISCSI_AG_CONTEXT_INV_CF_SHIFT 4
#define USTORM_ISCSI_AG_CONTEXT_COMPLETION_CF (0x3<<6)
#define USTORM_ISCSI_AG_CONTEXT_COMPLETION_CF_SHIFT 6
	vmk_uint8 state;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 state;
	vmk_uint8 agg_vars1;
#define __USTORM_ISCSI_AG_CONTEXT_EXISTS_IN_QM0 (0x1<<0)
#define __USTORM_ISCSI_AG_CONTEXT_EXISTS_IN_QM0_SHIFT 0
#define USTORM_ISCSI_AG_CONTEXT_EXISTS_IN_QM1 (0x1<<1)
#define USTORM_ISCSI_AG_CONTEXT_EXISTS_IN_QM1_SHIFT 1
#define USTORM_ISCSI_AG_CONTEXT_EXISTS_IN_QM2 (0x1<<2)
#define USTORM_ISCSI_AG_CONTEXT_EXISTS_IN_QM2_SHIFT 2
#define USTORM_ISCSI_AG_CONTEXT_EXISTS_IN_QM3 (0x1<<3)
#define USTORM_ISCSI_AG_CONTEXT_EXISTS_IN_QM3_SHIFT 3
#define USTORM_ISCSI_AG_CONTEXT_INV_CF (0x3<<4)
#define USTORM_ISCSI_AG_CONTEXT_INV_CF_SHIFT 4
#define USTORM_ISCSI_AG_CONTEXT_COMPLETION_CF (0x3<<6)
#define USTORM_ISCSI_AG_CONTEXT_COMPLETION_CF_SHIFT 6
	vmk_uint8 agg_vars2;
#define USTORM_ISCSI_AG_CONTEXT_TX_CF (0x3<<0)
#define USTORM_ISCSI_AG_CONTEXT_TX_CF_SHIFT 0
#define __USTORM_ISCSI_AG_CONTEXT_TIMER_CF (0x3<<2)
#define __USTORM_ISCSI_AG_CONTEXT_TIMER_CF_SHIFT 2
#define USTORM_ISCSI_AG_CONTEXT_AGG_MISC4_RULE (0x7<<4)
#define USTORM_ISCSI_AG_CONTEXT_AGG_MISC4_RULE_SHIFT 4
#define __USTORM_ISCSI_AG_CONTEXT_AGG_VAL2_MASK (0x1<<7)
#define __USTORM_ISCSI_AG_CONTEXT_AGG_VAL2_MASK_SHIFT 7
	vmk_uint8 __aux_counter_flags;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint8 cdu_usage;
	vmk_uint8 agg_misc2;
	vmk_uint16 __cq_local_comp_itt_val;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 __cq_local_comp_itt_val;
	vmk_uint8 agg_misc2;
	vmk_uint8 cdu_usage;
#endif
	vmk_uint32 agg_misc4;
#if defined(__BIG_ENDIAN)
	vmk_uint8 agg_val3_th;
	vmk_uint8 agg_val3;
	vmk_uint16 agg_misc3;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 agg_misc3;
	vmk_uint8 agg_val3;
	vmk_uint8 agg_val3_th;
#endif
	vmk_uint32 agg_val1;
	vmk_uint32 agg_misc4_th;
#if defined(__BIG_ENDIAN)
	vmk_uint16 agg_val2_th;
	vmk_uint16 agg_val2;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 agg_val2;
	vmk_uint16 agg_val2_th;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint16 __reserved2;
	vmk_uint8 decision_rules;
#define USTORM_ISCSI_AG_CONTEXT_AGG_VAL2_RULE (0x7<<0)
#define USTORM_ISCSI_AG_CONTEXT_AGG_VAL2_RULE_SHIFT 0
#define __USTORM_ISCSI_AG_CONTEXT_AGG_VAL3_RULE (0x7<<3)
#define __USTORM_ISCSI_AG_CONTEXT_AGG_VAL3_RULE_SHIFT 3
#define USTORM_ISCSI_AG_CONTEXT_AGG_VAL2_ARM_N_FLAG (0x1<<6)
#define USTORM_ISCSI_AG_CONTEXT_AGG_VAL2_ARM_N_FLAG_SHIFT 6
#define __USTORM_ISCSI_AG_CONTEXT_RESERVED1 (0x1<<7)
#define __USTORM_ISCSI_AG_CONTEXT_RESERVED1_SHIFT 7
	vmk_uint8 decision_rule_enable_bits;
#define USTORM_ISCSI_AG_CONTEXT_INV_CF_EN (0x1<<0)
#define USTORM_ISCSI_AG_CONTEXT_INV_CF_EN_SHIFT 0
#define USTORM_ISCSI_AG_CONTEXT_COMPLETION_CF_EN (0x1<<1)
#define USTORM_ISCSI_AG_CONTEXT_COMPLETION_CF_EN_SHIFT 1
#define USTORM_ISCSI_AG_CONTEXT_TX_CF_EN (0x1<<2)
#define USTORM_ISCSI_AG_CONTEXT_TX_CF_EN_SHIFT 2
#define __USTORM_ISCSI_AG_CONTEXT_TIMER_CF_EN (0x1<<3)
#define __USTORM_ISCSI_AG_CONTEXT_TIMER_CF_EN_SHIFT 3
#define __USTORM_ISCSI_AG_CONTEXT_CQ_LOCAL_COMP_CF_EN (0x1<<4)
#define __USTORM_ISCSI_AG_CONTEXT_CQ_LOCAL_COMP_CF_EN_SHIFT 4
#define __USTORM_ISCSI_AG_CONTEXT_QUEUES_FLUSH_Q0_CF_EN (0x1<<5)
#define __USTORM_ISCSI_AG_CONTEXT_QUEUES_FLUSH_Q0_CF_EN_SHIFT 5
#define __USTORM_ISCSI_AG_CONTEXT_AUX3_CF_EN (0x1<<6)
#define __USTORM_ISCSI_AG_CONTEXT_AUX3_CF_EN_SHIFT 6
#define __USTORM_ISCSI_AG_CONTEXT_DQ_CF_EN (0x1<<7)
#define __USTORM_ISCSI_AG_CONTEXT_DQ_CF_EN_SHIFT 7
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 decision_rule_enable_bits;
#define USTORM_ISCSI_AG_CONTEXT_INV_CF_EN (0x1<<0)
#define USTORM_ISCSI_AG_CONTEXT_INV_CF_EN_SHIFT 0
#define USTORM_ISCSI_AG_CONTEXT_COMPLETION_CF_EN (0x1<<1)
#define USTORM_ISCSI_AG_CONTEXT_COMPLETION_CF_EN_SHIFT 1
#define USTORM_ISCSI_AG_CONTEXT_TX_CF_EN (0x1<<2)
#define USTORM_ISCSI_AG_CONTEXT_TX_CF_EN_SHIFT 2
#define __USTORM_ISCSI_AG_CONTEXT_TIMER_CF_EN (0x1<<3)
#define __USTORM_ISCSI_AG_CONTEXT_TIMER_CF_EN_SHIFT 3
#define __USTORM_ISCSI_AG_CONTEXT_CQ_LOCAL_COMP_CF_EN (0x1<<4)
#define __USTORM_ISCSI_AG_CONTEXT_CQ_LOCAL_COMP_CF_EN_SHIFT 4
#define __USTORM_ISCSI_AG_CONTEXT_QUEUES_FLUSH_Q0_CF_EN (0x1<<5)
#define __USTORM_ISCSI_AG_CONTEXT_QUEUES_FLUSH_Q0_CF_EN_SHIFT 5
#define __USTORM_ISCSI_AG_CONTEXT_AUX3_CF_EN (0x1<<6)
#define __USTORM_ISCSI_AG_CONTEXT_AUX3_CF_EN_SHIFT 6
#define __USTORM_ISCSI_AG_CONTEXT_DQ_CF_EN (0x1<<7)
#define __USTORM_ISCSI_AG_CONTEXT_DQ_CF_EN_SHIFT 7
	vmk_uint8 decision_rules;
#define USTORM_ISCSI_AG_CONTEXT_AGG_VAL2_RULE (0x7<<0)
#define USTORM_ISCSI_AG_CONTEXT_AGG_VAL2_RULE_SHIFT 0
#define __USTORM_ISCSI_AG_CONTEXT_AGG_VAL3_RULE (0x7<<3)
#define __USTORM_ISCSI_AG_CONTEXT_AGG_VAL3_RULE_SHIFT 3
#define USTORM_ISCSI_AG_CONTEXT_AGG_VAL2_ARM_N_FLAG (0x1<<6)
#define USTORM_ISCSI_AG_CONTEXT_AGG_VAL2_ARM_N_FLAG_SHIFT 6
#define __USTORM_ISCSI_AG_CONTEXT_RESERVED1 (0x1<<7)
#define __USTORM_ISCSI_AG_CONTEXT_RESERVED1_SHIFT 7
	vmk_uint16 __reserved2;
#endif
};


/*
 * The fcoe aggregative context section of Xstorm
 */
struct xstorm_fcoe_extra_ag_context_section {
#if defined(__BIG_ENDIAN)
	vmk_uint8 tcp_agg_vars1;
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_RESERVED51 (0x3<<0)
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_RESERVED51_SHIFT 0
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_ACK_TO_FE_UPDATED (0x3<<2)
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_ACK_TO_FE_UPDATED_SHIFT 2
#define XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_SIDEBAND_SENT_CF (0x3<<4)
#define XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_SIDEBAND_SENT_CF_SHIFT 4
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_RESERVED_CLEAR_DA_TIMER_EN (0x1<<6)
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_RESERVED_CLEAR_DA_TIMER_EN_SHIFT 6
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_RESERVED_DA_EXPIRATION_FLAG (0x1<<7)
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_RESERVED_DA_EXPIRATION_FLAG_SHIFT 7
	vmk_uint8 __reserved_da_cnt;
	vmk_uint16 __mtu;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 __mtu;
	vmk_uint8 __reserved_da_cnt;
	vmk_uint8 tcp_agg_vars1;
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_RESERVED51 (0x3<<0)
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_RESERVED51_SHIFT 0
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_ACK_TO_FE_UPDATED (0x3<<2)
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_ACK_TO_FE_UPDATED_SHIFT 2
#define XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_SIDEBAND_SENT_CF (0x3<<4)
#define XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_SIDEBAND_SENT_CF_SHIFT 4
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_RESERVED_CLEAR_DA_TIMER_EN (0x1<<6)
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_RESERVED_CLEAR_DA_TIMER_EN_SHIFT 6
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_RESERVED_DA_EXPIRATION_FLAG (0x1<<7)
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_RESERVED_DA_EXPIRATION_FLAG_SHIFT 7
#endif
	vmk_uint32 snd_nxt;
	vmk_uint32 tx_wnd;
	vmk_uint32 __reserved55;
	vmk_uint32 local_adv_wnd;
#if defined(__BIG_ENDIAN)
	vmk_uint8 __agg_val8_th;
	vmk_uint8 __tx_dest;
	vmk_uint16 tcp_agg_vars2;
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_RESERVED57 (0x1<<0)
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_RESERVED57_SHIFT 0
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_RESERVED58 (0x1<<1)
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_RESERVED58_SHIFT 1
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_RESERVED59 (0x1<<2)
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_RESERVED59_SHIFT 2
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_AUX3_FLAG (0x1<<3)
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_AUX3_FLAG_SHIFT 3
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_AUX4_FLAG (0x1<<4)
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_AUX4_FLAG_SHIFT 4
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_RESERVED60 (0x1<<5)
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_RESERVED60_SHIFT 5
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_RESERVED_ACK_TO_FE_UPDATED_EN (0x1<<6)
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_RESERVED_ACK_TO_FE_UPDATED_EN_SHIFT 6
#define XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_SIDEBAND_SENT_CF_EN (0x1<<7)
#define XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_SIDEBAND_SENT_CF_EN_SHIFT 7
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_RESERVED_TX_FIN_FLAG_EN (0x1<<8)
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_RESERVED_TX_FIN_FLAG_EN_SHIFT 8
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_AUX1_FLAG (0x1<<9)
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_AUX1_FLAG_SHIFT 9
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_SET_RTO_CF (0x3<<10)
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_SET_RTO_CF_SHIFT 10
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_TS_TO_ECHO_UPDATED_CF (0x3<<12)
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_TS_TO_ECHO_UPDATED_CF_SHIFT 12
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_TX_DEST_UPDATED_CF (0x3<<14)
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_TX_DEST_UPDATED_CF_SHIFT 14
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 tcp_agg_vars2;
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_RESERVED57 (0x1<<0)
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_RESERVED57_SHIFT 0
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_RESERVED58 (0x1<<1)
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_RESERVED58_SHIFT 1
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_RESERVED59 (0x1<<2)
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_RESERVED59_SHIFT 2
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_AUX3_FLAG (0x1<<3)
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_AUX3_FLAG_SHIFT 3
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_AUX4_FLAG (0x1<<4)
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_AUX4_FLAG_SHIFT 4
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_RESERVED60 (0x1<<5)
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_RESERVED60_SHIFT 5
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_RESERVED_ACK_TO_FE_UPDATED_EN (0x1<<6)
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_RESERVED_ACK_TO_FE_UPDATED_EN_SHIFT 6
#define XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_SIDEBAND_SENT_CF_EN (0x1<<7)
#define XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_SIDEBAND_SENT_CF_EN_SHIFT 7
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_RESERVED_TX_FIN_FLAG_EN (0x1<<8)
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_RESERVED_TX_FIN_FLAG_EN_SHIFT 8
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_AUX1_FLAG (0x1<<9)
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_AUX1_FLAG_SHIFT 9
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_SET_RTO_CF (0x3<<10)
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_SET_RTO_CF_SHIFT 10
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_TS_TO_ECHO_UPDATED_CF (0x3<<12)
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_TS_TO_ECHO_UPDATED_CF_SHIFT 12
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_TX_DEST_UPDATED_CF (0x3<<14)
#define __XSTORM_FCOE_EXTRA_AG_CONTEXT_SECTION_TX_DEST_UPDATED_CF_SHIFT 14
	vmk_uint8 __tx_dest;
	vmk_uint8 __agg_val8_th;
#endif
	vmk_uint32 __sq_base_addr_lo;
	vmk_uint32 __sq_base_addr_hi;
	vmk_uint32 __xfrq_base_addr_lo;
	vmk_uint32 __xfrq_base_addr_hi;
#if defined(__BIG_ENDIAN)
	vmk_uint16 __xfrq_cons;
	vmk_uint16 __xfrq_prod;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 __xfrq_prod;
	vmk_uint16 __xfrq_cons;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint8 __tcp_agg_vars5;
	vmk_uint8 __tcp_agg_vars4;
	vmk_uint8 __tcp_agg_vars3;
	vmk_uint8 __reserved_force_pure_ack_cnt;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 __reserved_force_pure_ack_cnt;
	vmk_uint8 __tcp_agg_vars3;
	vmk_uint8 __tcp_agg_vars4;
	vmk_uint8 __tcp_agg_vars5;
#endif
	vmk_uint32 __tcp_agg_vars6;
#if defined(__BIG_ENDIAN)
	vmk_uint16 __agg_misc6;
	vmk_uint16 __tcp_agg_vars7;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 __tcp_agg_vars7;
	vmk_uint16 __agg_misc6;
#endif
	vmk_uint32 __agg_val10;
	vmk_uint32 __agg_val10_th;
#if defined(__BIG_ENDIAN)
	vmk_uint16 __reserved3;
	vmk_uint8 __reserved2;
	vmk_uint8 __da_only_cnt;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 __da_only_cnt;
	vmk_uint8 __reserved2;
	vmk_uint16 __reserved3;
#endif
};

/*
 * The fcoe aggregative context of Xstorm
 */
struct xstorm_fcoe_ag_context {
#if defined(__BIG_ENDIAN)
	vmk_uint16 agg_val1;
	vmk_uint8 agg_vars1;
#define __XSTORM_FCOE_AG_CONTEXT_EXISTS_IN_QM0 (0x1<<0)
#define __XSTORM_FCOE_AG_CONTEXT_EXISTS_IN_QM0_SHIFT 0
#define __XSTORM_FCOE_AG_CONTEXT_EXISTS_IN_QM1 (0x1<<1)
#define __XSTORM_FCOE_AG_CONTEXT_EXISTS_IN_QM1_SHIFT 1
#define __XSTORM_FCOE_AG_CONTEXT_RESERVED51 (0x1<<2)
#define __XSTORM_FCOE_AG_CONTEXT_RESERVED51_SHIFT 2
#define __XSTORM_FCOE_AG_CONTEXT_RESERVED52 (0x1<<3)
#define __XSTORM_FCOE_AG_CONTEXT_RESERVED52_SHIFT 3
#define __XSTORM_FCOE_AG_CONTEXT_MORE_TO_SEND_EN (0x1<<4)
#define __XSTORM_FCOE_AG_CONTEXT_MORE_TO_SEND_EN_SHIFT 4
#define XSTORM_FCOE_AG_CONTEXT_NAGLE_EN (0x1<<5)
#define XSTORM_FCOE_AG_CONTEXT_NAGLE_EN_SHIFT 5
#define __XSTORM_FCOE_AG_CONTEXT_DQ_SPARE_FLAG (0x1<<6)
#define __XSTORM_FCOE_AG_CONTEXT_DQ_SPARE_FLAG_SHIFT 6
#define __XSTORM_FCOE_AG_CONTEXT_RESERVED_UNA_GT_NXT_EN (0x1<<7)
#define __XSTORM_FCOE_AG_CONTEXT_RESERVED_UNA_GT_NXT_EN_SHIFT 7
	vmk_uint8 __state;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 __state;
	vmk_uint8 agg_vars1;
#define __XSTORM_FCOE_AG_CONTEXT_EXISTS_IN_QM0 (0x1<<0)
#define __XSTORM_FCOE_AG_CONTEXT_EXISTS_IN_QM0_SHIFT 0
#define __XSTORM_FCOE_AG_CONTEXT_EXISTS_IN_QM1 (0x1<<1)
#define __XSTORM_FCOE_AG_CONTEXT_EXISTS_IN_QM1_SHIFT 1
#define __XSTORM_FCOE_AG_CONTEXT_RESERVED51 (0x1<<2)
#define __XSTORM_FCOE_AG_CONTEXT_RESERVED51_SHIFT 2
#define __XSTORM_FCOE_AG_CONTEXT_RESERVED52 (0x1<<3)
#define __XSTORM_FCOE_AG_CONTEXT_RESERVED52_SHIFT 3
#define __XSTORM_FCOE_AG_CONTEXT_MORE_TO_SEND_EN (0x1<<4)
#define __XSTORM_FCOE_AG_CONTEXT_MORE_TO_SEND_EN_SHIFT 4
#define XSTORM_FCOE_AG_CONTEXT_NAGLE_EN (0x1<<5)
#define XSTORM_FCOE_AG_CONTEXT_NAGLE_EN_SHIFT 5
#define __XSTORM_FCOE_AG_CONTEXT_DQ_SPARE_FLAG (0x1<<6)
#define __XSTORM_FCOE_AG_CONTEXT_DQ_SPARE_FLAG_SHIFT 6
#define __XSTORM_FCOE_AG_CONTEXT_RESERVED_UNA_GT_NXT_EN (0x1<<7)
#define __XSTORM_FCOE_AG_CONTEXT_RESERVED_UNA_GT_NXT_EN_SHIFT 7
	vmk_uint16 agg_val1;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint8 cdu_reserved;
	vmk_uint8 __agg_vars4;
	vmk_uint8 agg_vars3;
#define XSTORM_FCOE_AG_CONTEXT_PHYSICAL_QUEUE_NUM2 (0x3F<<0)
#define XSTORM_FCOE_AG_CONTEXT_PHYSICAL_QUEUE_NUM2_SHIFT 0
#define __XSTORM_FCOE_AG_CONTEXT_AUX19_CF (0x3<<6)
#define __XSTORM_FCOE_AG_CONTEXT_AUX19_CF_SHIFT 6
	vmk_uint8 agg_vars2;
#define __XSTORM_FCOE_AG_CONTEXT_DQ_CF (0x3<<0)
#define __XSTORM_FCOE_AG_CONTEXT_DQ_CF_SHIFT 0
#define __XSTORM_FCOE_AG_CONTEXT_DQ_SPARE_FLAG_EN (0x1<<2)
#define __XSTORM_FCOE_AG_CONTEXT_DQ_SPARE_FLAG_EN_SHIFT 2
#define __XSTORM_FCOE_AG_CONTEXT_AUX8_FLAG (0x1<<3)
#define __XSTORM_FCOE_AG_CONTEXT_AUX8_FLAG_SHIFT 3
#define __XSTORM_FCOE_AG_CONTEXT_AUX9_FLAG (0x1<<4)
#define __XSTORM_FCOE_AG_CONTEXT_AUX9_FLAG_SHIFT 4
#define XSTORM_FCOE_AG_CONTEXT_DECISION_RULE1 (0x3<<5)
#define XSTORM_FCOE_AG_CONTEXT_DECISION_RULE1_SHIFT 5
#define __XSTORM_FCOE_AG_CONTEXT_DQ_CF_EN (0x1<<7)
#define __XSTORM_FCOE_AG_CONTEXT_DQ_CF_EN_SHIFT 7
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 agg_vars2;
#define __XSTORM_FCOE_AG_CONTEXT_DQ_CF (0x3<<0)
#define __XSTORM_FCOE_AG_CONTEXT_DQ_CF_SHIFT 0
#define __XSTORM_FCOE_AG_CONTEXT_DQ_SPARE_FLAG_EN (0x1<<2)
#define __XSTORM_FCOE_AG_CONTEXT_DQ_SPARE_FLAG_EN_SHIFT 2
#define __XSTORM_FCOE_AG_CONTEXT_AUX8_FLAG (0x1<<3)
#define __XSTORM_FCOE_AG_CONTEXT_AUX8_FLAG_SHIFT 3
#define __XSTORM_FCOE_AG_CONTEXT_AUX9_FLAG (0x1<<4)
#define __XSTORM_FCOE_AG_CONTEXT_AUX9_FLAG_SHIFT 4
#define XSTORM_FCOE_AG_CONTEXT_DECISION_RULE1 (0x3<<5)
#define XSTORM_FCOE_AG_CONTEXT_DECISION_RULE1_SHIFT 5
#define __XSTORM_FCOE_AG_CONTEXT_DQ_CF_EN (0x1<<7)
#define __XSTORM_FCOE_AG_CONTEXT_DQ_CF_EN_SHIFT 7
	vmk_uint8 agg_vars3;
#define XSTORM_FCOE_AG_CONTEXT_PHYSICAL_QUEUE_NUM2 (0x3F<<0)
#define XSTORM_FCOE_AG_CONTEXT_PHYSICAL_QUEUE_NUM2_SHIFT 0
#define __XSTORM_FCOE_AG_CONTEXT_AUX19_CF (0x3<<6)
#define __XSTORM_FCOE_AG_CONTEXT_AUX19_CF_SHIFT 6
	vmk_uint8 __agg_vars4;
	vmk_uint8 cdu_reserved;
#endif
	vmk_uint32 more_to_send;
#if defined(__BIG_ENDIAN)
	vmk_uint16 agg_vars5;
#define XSTORM_FCOE_AG_CONTEXT_DECISION_RULE5 (0x3<<0)
#define XSTORM_FCOE_AG_CONTEXT_DECISION_RULE5_SHIFT 0
#define XSTORM_FCOE_AG_CONTEXT_PHYSICAL_QUEUE_NUM0 (0x3F<<2)
#define XSTORM_FCOE_AG_CONTEXT_PHYSICAL_QUEUE_NUM0_SHIFT 2
#define XSTORM_FCOE_AG_CONTEXT_PHYSICAL_QUEUE_NUM1 (0x3F<<8)
#define XSTORM_FCOE_AG_CONTEXT_PHYSICAL_QUEUE_NUM1_SHIFT 8
#define __XSTORM_FCOE_AG_CONTEXT_CONFQ_DEC_RULE (0x3<<14)
#define __XSTORM_FCOE_AG_CONTEXT_CONFQ_DEC_RULE_SHIFT 14
	vmk_uint16 sq_cons;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 sq_cons;
	vmk_uint16 agg_vars5;
#define XSTORM_FCOE_AG_CONTEXT_DECISION_RULE5 (0x3<<0)
#define XSTORM_FCOE_AG_CONTEXT_DECISION_RULE5_SHIFT 0
#define XSTORM_FCOE_AG_CONTEXT_PHYSICAL_QUEUE_NUM0 (0x3F<<2)
#define XSTORM_FCOE_AG_CONTEXT_PHYSICAL_QUEUE_NUM0_SHIFT 2
#define XSTORM_FCOE_AG_CONTEXT_PHYSICAL_QUEUE_NUM1 (0x3F<<8)
#define XSTORM_FCOE_AG_CONTEXT_PHYSICAL_QUEUE_NUM1_SHIFT 8
#define __XSTORM_FCOE_AG_CONTEXT_CONFQ_DEC_RULE (0x3<<14)
#define __XSTORM_FCOE_AG_CONTEXT_CONFQ_DEC_RULE_SHIFT 14
#endif
	struct xstorm_fcoe_extra_ag_context_section __extra_section;
#if defined(__BIG_ENDIAN)
	vmk_uint16 agg_vars7;
#define __XSTORM_FCOE_AG_CONTEXT_AGG_VAL11_DECISION_RULE (0x7<<0)
#define __XSTORM_FCOE_AG_CONTEXT_AGG_VAL11_DECISION_RULE_SHIFT 0
#define __XSTORM_FCOE_AG_CONTEXT_AUX13_FLAG (0x1<<3)
#define __XSTORM_FCOE_AG_CONTEXT_AUX13_FLAG_SHIFT 3
#define __XSTORM_FCOE_AG_CONTEXT_QUEUE0_CF (0x3<<4)
#define __XSTORM_FCOE_AG_CONTEXT_QUEUE0_CF_SHIFT 4
#define XSTORM_FCOE_AG_CONTEXT_DECISION_RULE3 (0x3<<6)
#define XSTORM_FCOE_AG_CONTEXT_DECISION_RULE3_SHIFT 6
#define XSTORM_FCOE_AG_CONTEXT_AUX1_CF (0x3<<8)
#define XSTORM_FCOE_AG_CONTEXT_AUX1_CF_SHIFT 8
#define __XSTORM_FCOE_AG_CONTEXT_RESERVED62 (0x1<<10)
#define __XSTORM_FCOE_AG_CONTEXT_RESERVED62_SHIFT 10
#define __XSTORM_FCOE_AG_CONTEXT_AUX1_CF_EN (0x1<<11)
#define __XSTORM_FCOE_AG_CONTEXT_AUX1_CF_EN_SHIFT 11
#define __XSTORM_FCOE_AG_CONTEXT_AUX10_FLAG (0x1<<12)
#define __XSTORM_FCOE_AG_CONTEXT_AUX10_FLAG_SHIFT 12
#define __XSTORM_FCOE_AG_CONTEXT_AUX11_FLAG (0x1<<13)
#define __XSTORM_FCOE_AG_CONTEXT_AUX11_FLAG_SHIFT 13
#define __XSTORM_FCOE_AG_CONTEXT_AUX12_FLAG (0x1<<14)
#define __XSTORM_FCOE_AG_CONTEXT_AUX12_FLAG_SHIFT 14
#define __XSTORM_FCOE_AG_CONTEXT_AUX2_FLAG (0x1<<15)
#define __XSTORM_FCOE_AG_CONTEXT_AUX2_FLAG_SHIFT 15
	vmk_uint8 agg_val3_th;
	vmk_uint8 agg_vars6;
#define XSTORM_FCOE_AG_CONTEXT_DECISION_RULE6 (0x7<<0)
#define XSTORM_FCOE_AG_CONTEXT_DECISION_RULE6_SHIFT 0
#define __XSTORM_FCOE_AG_CONTEXT_XFRQ_DEC_RULE (0x7<<3)
#define __XSTORM_FCOE_AG_CONTEXT_XFRQ_DEC_RULE_SHIFT 3
#define __XSTORM_FCOE_AG_CONTEXT_SQ_DEC_RULE (0x3<<6)
#define __XSTORM_FCOE_AG_CONTEXT_SQ_DEC_RULE_SHIFT 6
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 agg_vars6;
#define XSTORM_FCOE_AG_CONTEXT_DECISION_RULE6 (0x7<<0)
#define XSTORM_FCOE_AG_CONTEXT_DECISION_RULE6_SHIFT 0
#define __XSTORM_FCOE_AG_CONTEXT_XFRQ_DEC_RULE (0x7<<3)
#define __XSTORM_FCOE_AG_CONTEXT_XFRQ_DEC_RULE_SHIFT 3
#define __XSTORM_FCOE_AG_CONTEXT_SQ_DEC_RULE (0x3<<6)
#define __XSTORM_FCOE_AG_CONTEXT_SQ_DEC_RULE_SHIFT 6
	vmk_uint8 agg_val3_th;
	vmk_uint16 agg_vars7;
#define __XSTORM_FCOE_AG_CONTEXT_AGG_VAL11_DECISION_RULE (0x7<<0)
#define __XSTORM_FCOE_AG_CONTEXT_AGG_VAL11_DECISION_RULE_SHIFT 0
#define __XSTORM_FCOE_AG_CONTEXT_AUX13_FLAG (0x1<<3)
#define __XSTORM_FCOE_AG_CONTEXT_AUX13_FLAG_SHIFT 3
#define __XSTORM_FCOE_AG_CONTEXT_QUEUE0_CF (0x3<<4)
#define __XSTORM_FCOE_AG_CONTEXT_QUEUE0_CF_SHIFT 4
#define XSTORM_FCOE_AG_CONTEXT_DECISION_RULE3 (0x3<<6)
#define XSTORM_FCOE_AG_CONTEXT_DECISION_RULE3_SHIFT 6
#define XSTORM_FCOE_AG_CONTEXT_AUX1_CF (0x3<<8)
#define XSTORM_FCOE_AG_CONTEXT_AUX1_CF_SHIFT 8
#define __XSTORM_FCOE_AG_CONTEXT_RESERVED62 (0x1<<10)
#define __XSTORM_FCOE_AG_CONTEXT_RESERVED62_SHIFT 10
#define __XSTORM_FCOE_AG_CONTEXT_AUX1_CF_EN (0x1<<11)
#define __XSTORM_FCOE_AG_CONTEXT_AUX1_CF_EN_SHIFT 11
#define __XSTORM_FCOE_AG_CONTEXT_AUX10_FLAG (0x1<<12)
#define __XSTORM_FCOE_AG_CONTEXT_AUX10_FLAG_SHIFT 12
#define __XSTORM_FCOE_AG_CONTEXT_AUX11_FLAG (0x1<<13)
#define __XSTORM_FCOE_AG_CONTEXT_AUX11_FLAG_SHIFT 13
#define __XSTORM_FCOE_AG_CONTEXT_AUX12_FLAG (0x1<<14)
#define __XSTORM_FCOE_AG_CONTEXT_AUX12_FLAG_SHIFT 14
#define __XSTORM_FCOE_AG_CONTEXT_AUX2_FLAG (0x1<<15)
#define __XSTORM_FCOE_AG_CONTEXT_AUX2_FLAG_SHIFT 15
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint16 __agg_val11_th;
	vmk_uint16 __agg_val11;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 __agg_val11;
	vmk_uint16 __agg_val11_th;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint8 __reserved1;
	vmk_uint8 __agg_val6_th;
	vmk_uint16 __agg_val9;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 __agg_val9;
	vmk_uint8 __agg_val6_th;
	vmk_uint8 __reserved1;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint16 confq_cons;
	vmk_uint16 confq_prod;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 confq_prod;
	vmk_uint16 confq_cons;
#endif
	vmk_uint32 agg_vars8;
#define XSTORM_FCOE_AG_CONTEXT_AGG_MISC2 (0xFFFFFF<<0)
#define XSTORM_FCOE_AG_CONTEXT_AGG_MISC2_SHIFT 0
#define XSTORM_FCOE_AG_CONTEXT_AGG_MISC3 (0xFF<<24)
#define XSTORM_FCOE_AG_CONTEXT_AGG_MISC3_SHIFT 24
#if defined(__BIG_ENDIAN)
	vmk_uint16 agg_misc0;
	vmk_uint16 sq_prod;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 sq_prod;
	vmk_uint16 agg_misc0;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint8 agg_val3;
	vmk_uint8 agg_val6;
	vmk_uint8 agg_val5_th;
	vmk_uint8 agg_val5;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 agg_val5;
	vmk_uint8 agg_val5_th;
	vmk_uint8 agg_val6;
	vmk_uint8 agg_val3;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint16 __agg_misc1;
	vmk_uint16 agg_limit1;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 agg_limit1;
	vmk_uint16 __agg_misc1;
#endif
	vmk_uint32 completion_seq;
	vmk_uint32 confq_pbl_base_lo;
	vmk_uint32 confq_pbl_base_hi;
};



/*
 * The tcp aggregative context section of Xstorm
 */
struct xstorm_tcp_tcp_ag_context_section {
#if defined(__BIG_ENDIAN)
	vmk_uint8 tcp_agg_vars1;
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_SET_DA_TIMER_CF (0x3<<0)
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_SET_DA_TIMER_CF_SHIFT 0
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_ACK_TO_FE_UPDATED (0x3<<2)
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_ACK_TO_FE_UPDATED_SHIFT 2
#define XSTORM_TCP_TCP_AG_CONTEXT_SECTION_SIDEBAND_SENT_CF (0x3<<4)
#define XSTORM_TCP_TCP_AG_CONTEXT_SECTION_SIDEBAND_SENT_CF_SHIFT 4
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_CLEAR_DA_TIMER_EN (0x1<<6)
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_CLEAR_DA_TIMER_EN_SHIFT 6
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_DA_EXPIRATION_FLAG (0x1<<7)
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_DA_EXPIRATION_FLAG_SHIFT 7
	vmk_uint8 __da_cnt;
	vmk_uint16 mss;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 mss;
	vmk_uint8 __da_cnt;
	vmk_uint8 tcp_agg_vars1;
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_SET_DA_TIMER_CF (0x3<<0)
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_SET_DA_TIMER_CF_SHIFT 0
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_ACK_TO_FE_UPDATED (0x3<<2)
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_ACK_TO_FE_UPDATED_SHIFT 2
#define XSTORM_TCP_TCP_AG_CONTEXT_SECTION_SIDEBAND_SENT_CF (0x3<<4)
#define XSTORM_TCP_TCP_AG_CONTEXT_SECTION_SIDEBAND_SENT_CF_SHIFT 4
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_CLEAR_DA_TIMER_EN (0x1<<6)
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_CLEAR_DA_TIMER_EN_SHIFT 6
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_DA_EXPIRATION_FLAG (0x1<<7)
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_DA_EXPIRATION_FLAG_SHIFT 7
#endif
	vmk_uint32 snd_nxt;
	vmk_uint32 tx_wnd;
	vmk_uint32 snd_una;
	vmk_uint32 local_adv_wnd;
#if defined(__BIG_ENDIAN)
	vmk_uint8 __agg_val8_th;
	vmk_uint8 __tx_dest;
	vmk_uint16 tcp_agg_vars2;
#define XSTORM_TCP_TCP_AG_CONTEXT_SECTION_TX_FIN_FLAG (0x1<<0)
#define XSTORM_TCP_TCP_AG_CONTEXT_SECTION_TX_FIN_FLAG_SHIFT 0
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_TX_UNBLOCKED (0x1<<1)
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_TX_UNBLOCKED_SHIFT 1
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_DA_TIMER_ACTIVE (0x1<<2)
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_DA_TIMER_ACTIVE_SHIFT 2
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX3_FLAG (0x1<<3)
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX3_FLAG_SHIFT 3
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX4_FLAG (0x1<<4)
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX4_FLAG_SHIFT 4
#define XSTORM_TCP_TCP_AG_CONTEXT_SECTION_DA_ENABLE (0x1<<5)
#define XSTORM_TCP_TCP_AG_CONTEXT_SECTION_DA_ENABLE_SHIFT 5
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_ACK_TO_FE_UPDATED_EN (0x1<<6)
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_ACK_TO_FE_UPDATED_EN_SHIFT 6
#define XSTORM_TCP_TCP_AG_CONTEXT_SECTION_SIDEBAND_SENT_CF_EN (0x1<<7)
#define XSTORM_TCP_TCP_AG_CONTEXT_SECTION_SIDEBAND_SENT_CF_EN_SHIFT 7
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_TX_FIN_FLAG_EN (0x1<<8)
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_TX_FIN_FLAG_EN_SHIFT 8
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX1_FLAG (0x1<<9)
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX1_FLAG_SHIFT 9
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_SET_RTO_CF (0x3<<10)
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_SET_RTO_CF_SHIFT 10
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_TS_TO_ECHO_UPDATED_CF (0x3<<12)
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_TS_TO_ECHO_UPDATED_CF_SHIFT 12
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_TX_DEST_UPDATED_CF (0x3<<14)
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_TX_DEST_UPDATED_CF_SHIFT 14
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 tcp_agg_vars2;
#define XSTORM_TCP_TCP_AG_CONTEXT_SECTION_TX_FIN_FLAG (0x1<<0)
#define XSTORM_TCP_TCP_AG_CONTEXT_SECTION_TX_FIN_FLAG_SHIFT 0
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_TX_UNBLOCKED (0x1<<1)
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_TX_UNBLOCKED_SHIFT 1
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_DA_TIMER_ACTIVE (0x1<<2)
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_DA_TIMER_ACTIVE_SHIFT 2
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX3_FLAG (0x1<<3)
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX3_FLAG_SHIFT 3
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX4_FLAG (0x1<<4)
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX4_FLAG_SHIFT 4
#define XSTORM_TCP_TCP_AG_CONTEXT_SECTION_DA_ENABLE (0x1<<5)
#define XSTORM_TCP_TCP_AG_CONTEXT_SECTION_DA_ENABLE_SHIFT 5
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_ACK_TO_FE_UPDATED_EN (0x1<<6)
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_ACK_TO_FE_UPDATED_EN_SHIFT 6
#define XSTORM_TCP_TCP_AG_CONTEXT_SECTION_SIDEBAND_SENT_CF_EN (0x1<<7)
#define XSTORM_TCP_TCP_AG_CONTEXT_SECTION_SIDEBAND_SENT_CF_EN_SHIFT 7
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_TX_FIN_FLAG_EN (0x1<<8)
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_TX_FIN_FLAG_EN_SHIFT 8
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX1_FLAG (0x1<<9)
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX1_FLAG_SHIFT 9
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_SET_RTO_CF (0x3<<10)
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_SET_RTO_CF_SHIFT 10
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_TS_TO_ECHO_UPDATED_CF (0x3<<12)
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_TS_TO_ECHO_UPDATED_CF_SHIFT 12
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_TX_DEST_UPDATED_CF (0x3<<14)
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_TX_DEST_UPDATED_CF_SHIFT 14
	vmk_uint8 __tx_dest;
	vmk_uint8 __agg_val8_th;
#endif
	vmk_uint32 ack_to_far_end;
	vmk_uint32 rto_timer;
	vmk_uint32 ka_timer;
	vmk_uint32 ts_to_echo;
#if defined(__BIG_ENDIAN)
	vmk_uint16 __agg_val7_th;
	vmk_uint16 __agg_val7;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 __agg_val7;
	vmk_uint16 __agg_val7_th;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint8 __tcp_agg_vars5;
	vmk_uint8 __tcp_agg_vars4;
	vmk_uint8 __tcp_agg_vars3;
	vmk_uint8 __force_pure_ack_cnt;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 __force_pure_ack_cnt;
	vmk_uint8 __tcp_agg_vars3;
	vmk_uint8 __tcp_agg_vars4;
	vmk_uint8 __tcp_agg_vars5;
#endif
	vmk_uint32 tcp_agg_vars6;
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_TS_TO_ECHO_CF_EN (0x1<<0)
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_TS_TO_ECHO_CF_EN_SHIFT 0
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_TX_DEST_UPDATED_CF_EN (0x1<<1)
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_TX_DEST_UPDATED_CF_EN_SHIFT 1
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX9_CF_EN (0x1<<2)
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX9_CF_EN_SHIFT 2
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX10_CF_EN (0x1<<3)
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX10_CF_EN_SHIFT 3
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX6_FLAG (0x1<<4)
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX6_FLAG_SHIFT 4
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX7_FLAG (0x1<<5)
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX7_FLAG_SHIFT 5
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX5_CF (0x3<<6)
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX5_CF_SHIFT 6
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX9_CF (0x3<<8)
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX9_CF_SHIFT 8
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX10_CF (0x3<<10)
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX10_CF_SHIFT 10
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX11_CF (0x3<<12)
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX11_CF_SHIFT 12
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX12_CF (0x3<<14)
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX12_CF_SHIFT 14
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX13_CF (0x3<<16)
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX13_CF_SHIFT 16
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX14_CF (0x3<<18)
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX14_CF_SHIFT 18
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX15_CF (0x3<<20)
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX15_CF_SHIFT 20
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX16_CF (0x3<<22)
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX16_CF_SHIFT 22
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX17_CF (0x3<<24)
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_AUX17_CF_SHIFT 24
#define XSTORM_TCP_TCP_AG_CONTEXT_SECTION_ECE_FLAG (0x1<<26)
#define XSTORM_TCP_TCP_AG_CONTEXT_SECTION_ECE_FLAG_SHIFT 26
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_RESERVED71 (0x1<<27)
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_RESERVED71_SHIFT 27
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_FORCE_PURE_ACK_CNT_DIRTY (0x1<<28)
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_FORCE_PURE_ACK_CNT_DIRTY_SHIFT 28
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_TCP_AUTO_STOP_FLAG (0x1<<29)
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_TCP_AUTO_STOP_FLAG_SHIFT 29
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_DO_TS_UPDATE_FLAG (0x1<<30)
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_DO_TS_UPDATE_FLAG_SHIFT 30
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_CANCEL_RETRANSMIT_FLAG (0x1<<31)
#define __XSTORM_TCP_TCP_AG_CONTEXT_SECTION_CANCEL_RETRANSMIT_FLAG_SHIFT 31
#if defined(__BIG_ENDIAN)
	vmk_uint16 __agg_misc6;
	vmk_uint16 __tcp_agg_vars7;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 __tcp_agg_vars7;
	vmk_uint16 __agg_misc6;
#endif
	vmk_uint32 __agg_val10;
	vmk_uint32 __agg_val10_th;
#if defined(__BIG_ENDIAN)
	vmk_uint16 __reserved3;
	vmk_uint8 __reserved2;
	vmk_uint8 __da_only_cnt;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 __da_only_cnt;
	vmk_uint8 __reserved2;
	vmk_uint16 __reserved3;
#endif
};

/*
 * The iscsi aggregative context of Xstorm
 */
struct xstorm_iscsi_ag_context {
#if defined(__BIG_ENDIAN)
	vmk_uint16 agg_val1;
	vmk_uint8 agg_vars1;
#define __XSTORM_ISCSI_AG_CONTEXT_EXISTS_IN_QM0 (0x1<<0)
#define __XSTORM_ISCSI_AG_CONTEXT_EXISTS_IN_QM0_SHIFT 0
#define XSTORM_ISCSI_AG_CONTEXT_EXISTS_IN_QM1 (0x1<<1)
#define XSTORM_ISCSI_AG_CONTEXT_EXISTS_IN_QM1_SHIFT 1
#define XSTORM_ISCSI_AG_CONTEXT_EXISTS_IN_QM2 (0x1<<2)
#define XSTORM_ISCSI_AG_CONTEXT_EXISTS_IN_QM2_SHIFT 2
#define XSTORM_ISCSI_AG_CONTEXT_EXISTS_IN_QM3 (0x1<<3)
#define XSTORM_ISCSI_AG_CONTEXT_EXISTS_IN_QM3_SHIFT 3
#define __XSTORM_ISCSI_AG_CONTEXT_MORE_TO_SEND_EN (0x1<<4)
#define __XSTORM_ISCSI_AG_CONTEXT_MORE_TO_SEND_EN_SHIFT 4
#define XSTORM_ISCSI_AG_CONTEXT_NAGLE_EN (0x1<<5)
#define XSTORM_ISCSI_AG_CONTEXT_NAGLE_EN_SHIFT 5
#define __XSTORM_ISCSI_AG_CONTEXT_DQ_SPARE_FLAG (0x1<<6)
#define __XSTORM_ISCSI_AG_CONTEXT_DQ_SPARE_FLAG_SHIFT 6
#define __XSTORM_ISCSI_AG_CONTEXT_UNA_GT_NXT_EN (0x1<<7)
#define __XSTORM_ISCSI_AG_CONTEXT_UNA_GT_NXT_EN_SHIFT 7
	vmk_uint8 state;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 state;
	vmk_uint8 agg_vars1;
#define __XSTORM_ISCSI_AG_CONTEXT_EXISTS_IN_QM0 (0x1<<0)
#define __XSTORM_ISCSI_AG_CONTEXT_EXISTS_IN_QM0_SHIFT 0
#define XSTORM_ISCSI_AG_CONTEXT_EXISTS_IN_QM1 (0x1<<1)
#define XSTORM_ISCSI_AG_CONTEXT_EXISTS_IN_QM1_SHIFT 1
#define XSTORM_ISCSI_AG_CONTEXT_EXISTS_IN_QM2 (0x1<<2)
#define XSTORM_ISCSI_AG_CONTEXT_EXISTS_IN_QM2_SHIFT 2
#define XSTORM_ISCSI_AG_CONTEXT_EXISTS_IN_QM3 (0x1<<3)
#define XSTORM_ISCSI_AG_CONTEXT_EXISTS_IN_QM3_SHIFT 3
#define __XSTORM_ISCSI_AG_CONTEXT_MORE_TO_SEND_EN (0x1<<4)
#define __XSTORM_ISCSI_AG_CONTEXT_MORE_TO_SEND_EN_SHIFT 4
#define XSTORM_ISCSI_AG_CONTEXT_NAGLE_EN (0x1<<5)
#define XSTORM_ISCSI_AG_CONTEXT_NAGLE_EN_SHIFT 5
#define __XSTORM_ISCSI_AG_CONTEXT_DQ_SPARE_FLAG (0x1<<6)
#define __XSTORM_ISCSI_AG_CONTEXT_DQ_SPARE_FLAG_SHIFT 6
#define __XSTORM_ISCSI_AG_CONTEXT_UNA_GT_NXT_EN (0x1<<7)
#define __XSTORM_ISCSI_AG_CONTEXT_UNA_GT_NXT_EN_SHIFT 7
	vmk_uint16 agg_val1;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint8 cdu_reserved;
	vmk_uint8 __agg_vars4;
	vmk_uint8 agg_vars3;
#define XSTORM_ISCSI_AG_CONTEXT_PHYSICAL_QUEUE_NUM2 (0x3F<<0)
#define XSTORM_ISCSI_AG_CONTEXT_PHYSICAL_QUEUE_NUM2_SHIFT 0
#define __XSTORM_ISCSI_AG_CONTEXT_RX_TS_EN_CF (0x3<<6)
#define __XSTORM_ISCSI_AG_CONTEXT_RX_TS_EN_CF_SHIFT 6
	vmk_uint8 agg_vars2;
#define __XSTORM_ISCSI_AG_CONTEXT_DQ_CF (0x3<<0)
#define __XSTORM_ISCSI_AG_CONTEXT_DQ_CF_SHIFT 0
#define __XSTORM_ISCSI_AG_CONTEXT_DQ_SPARE_FLAG_EN (0x1<<2)
#define __XSTORM_ISCSI_AG_CONTEXT_DQ_SPARE_FLAG_EN_SHIFT 2
#define __XSTORM_ISCSI_AG_CONTEXT_AUX8_FLAG (0x1<<3)
#define __XSTORM_ISCSI_AG_CONTEXT_AUX8_FLAG_SHIFT 3
#define __XSTORM_ISCSI_AG_CONTEXT_AUX9_FLAG (0x1<<4)
#define __XSTORM_ISCSI_AG_CONTEXT_AUX9_FLAG_SHIFT 4
#define XSTORM_ISCSI_AG_CONTEXT_DECISION_RULE1 (0x3<<5)
#define XSTORM_ISCSI_AG_CONTEXT_DECISION_RULE1_SHIFT 5
#define __XSTORM_ISCSI_AG_CONTEXT_DQ_CF_EN (0x1<<7)
#define __XSTORM_ISCSI_AG_CONTEXT_DQ_CF_EN_SHIFT 7
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 agg_vars2;
#define __XSTORM_ISCSI_AG_CONTEXT_DQ_CF (0x3<<0)
#define __XSTORM_ISCSI_AG_CONTEXT_DQ_CF_SHIFT 0
#define __XSTORM_ISCSI_AG_CONTEXT_DQ_SPARE_FLAG_EN (0x1<<2)
#define __XSTORM_ISCSI_AG_CONTEXT_DQ_SPARE_FLAG_EN_SHIFT 2
#define __XSTORM_ISCSI_AG_CONTEXT_AUX8_FLAG (0x1<<3)
#define __XSTORM_ISCSI_AG_CONTEXT_AUX8_FLAG_SHIFT 3
#define __XSTORM_ISCSI_AG_CONTEXT_AUX9_FLAG (0x1<<4)
#define __XSTORM_ISCSI_AG_CONTEXT_AUX9_FLAG_SHIFT 4
#define XSTORM_ISCSI_AG_CONTEXT_DECISION_RULE1 (0x3<<5)
#define XSTORM_ISCSI_AG_CONTEXT_DECISION_RULE1_SHIFT 5
#define __XSTORM_ISCSI_AG_CONTEXT_DQ_CF_EN (0x1<<7)
#define __XSTORM_ISCSI_AG_CONTEXT_DQ_CF_EN_SHIFT 7
	vmk_uint8 agg_vars3;
#define XSTORM_ISCSI_AG_CONTEXT_PHYSICAL_QUEUE_NUM2 (0x3F<<0)
#define XSTORM_ISCSI_AG_CONTEXT_PHYSICAL_QUEUE_NUM2_SHIFT 0
#define __XSTORM_ISCSI_AG_CONTEXT_RX_TS_EN_CF (0x3<<6)
#define __XSTORM_ISCSI_AG_CONTEXT_RX_TS_EN_CF_SHIFT 6
	vmk_uint8 __agg_vars4;
	vmk_uint8 cdu_reserved;
#endif
	vmk_uint32 more_to_send;
#if defined(__BIG_ENDIAN)
	vmk_uint16 agg_vars5;
#define XSTORM_ISCSI_AG_CONTEXT_DECISION_RULE5 (0x3<<0)
#define XSTORM_ISCSI_AG_CONTEXT_DECISION_RULE5_SHIFT 0
#define XSTORM_ISCSI_AG_CONTEXT_PHYSICAL_QUEUE_NUM0 (0x3F<<2)
#define XSTORM_ISCSI_AG_CONTEXT_PHYSICAL_QUEUE_NUM0_SHIFT 2
#define XSTORM_ISCSI_AG_CONTEXT_PHYSICAL_QUEUE_NUM1 (0x3F<<8)
#define XSTORM_ISCSI_AG_CONTEXT_PHYSICAL_QUEUE_NUM1_SHIFT 8
#define XSTORM_ISCSI_AG_CONTEXT_DECISION_RULE2 (0x3<<14)
#define XSTORM_ISCSI_AG_CONTEXT_DECISION_RULE2_SHIFT 14
	vmk_uint16 sq_cons;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 sq_cons;
	vmk_uint16 agg_vars5;
#define XSTORM_ISCSI_AG_CONTEXT_DECISION_RULE5 (0x3<<0)
#define XSTORM_ISCSI_AG_CONTEXT_DECISION_RULE5_SHIFT 0
#define XSTORM_ISCSI_AG_CONTEXT_PHYSICAL_QUEUE_NUM0 (0x3F<<2)
#define XSTORM_ISCSI_AG_CONTEXT_PHYSICAL_QUEUE_NUM0_SHIFT 2
#define XSTORM_ISCSI_AG_CONTEXT_PHYSICAL_QUEUE_NUM1 (0x3F<<8)
#define XSTORM_ISCSI_AG_CONTEXT_PHYSICAL_QUEUE_NUM1_SHIFT 8
#define XSTORM_ISCSI_AG_CONTEXT_DECISION_RULE2 (0x3<<14)
#define XSTORM_ISCSI_AG_CONTEXT_DECISION_RULE2_SHIFT 14
#endif
	struct xstorm_tcp_tcp_ag_context_section tcp;
#if defined(__BIG_ENDIAN)
	vmk_uint16 agg_vars7;
#define __XSTORM_ISCSI_AG_CONTEXT_AGG_VAL11_DECISION_RULE (0x7<<0)
#define __XSTORM_ISCSI_AG_CONTEXT_AGG_VAL11_DECISION_RULE_SHIFT 0
#define __XSTORM_ISCSI_AG_CONTEXT_AUX13_FLAG (0x1<<3)
#define __XSTORM_ISCSI_AG_CONTEXT_AUX13_FLAG_SHIFT 3
#define __XSTORM_ISCSI_AG_CONTEXT_STORMS_SYNC_CF (0x3<<4)
#define __XSTORM_ISCSI_AG_CONTEXT_STORMS_SYNC_CF_SHIFT 4
#define XSTORM_ISCSI_AG_CONTEXT_DECISION_RULE3 (0x3<<6)
#define XSTORM_ISCSI_AG_CONTEXT_DECISION_RULE3_SHIFT 6
#define XSTORM_ISCSI_AG_CONTEXT_AUX1_CF (0x3<<8)
#define XSTORM_ISCSI_AG_CONTEXT_AUX1_CF_SHIFT 8
#define __XSTORM_ISCSI_AG_CONTEXT_COMPLETION_SEQ_DECISION_MASK (0x1<<10)
#define __XSTORM_ISCSI_AG_CONTEXT_COMPLETION_SEQ_DECISION_MASK_SHIFT 10
#define __XSTORM_ISCSI_AG_CONTEXT_AUX1_CF_EN (0x1<<11)
#define __XSTORM_ISCSI_AG_CONTEXT_AUX1_CF_EN_SHIFT 11
#define __XSTORM_ISCSI_AG_CONTEXT_AUX10_FLAG (0x1<<12)
#define __XSTORM_ISCSI_AG_CONTEXT_AUX10_FLAG_SHIFT 12
#define __XSTORM_ISCSI_AG_CONTEXT_AUX11_FLAG (0x1<<13)
#define __XSTORM_ISCSI_AG_CONTEXT_AUX11_FLAG_SHIFT 13
#define __XSTORM_ISCSI_AG_CONTEXT_AUX12_FLAG (0x1<<14)
#define __XSTORM_ISCSI_AG_CONTEXT_AUX12_FLAG_SHIFT 14
#define __XSTORM_ISCSI_AG_CONTEXT_RX_WND_SCL_EN (0x1<<15)
#define __XSTORM_ISCSI_AG_CONTEXT_RX_WND_SCL_EN_SHIFT 15
	vmk_uint8 agg_val3_th;
	vmk_uint8 agg_vars6;
#define XSTORM_ISCSI_AG_CONTEXT_DECISION_RULE6 (0x7<<0)
#define XSTORM_ISCSI_AG_CONTEXT_DECISION_RULE6_SHIFT 0
#define XSTORM_ISCSI_AG_CONTEXT_DECISION_RULE7 (0x7<<3)
#define XSTORM_ISCSI_AG_CONTEXT_DECISION_RULE7_SHIFT 3
#define XSTORM_ISCSI_AG_CONTEXT_DECISION_RULE4 (0x3<<6)
#define XSTORM_ISCSI_AG_CONTEXT_DECISION_RULE4_SHIFT 6
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 agg_vars6;
#define XSTORM_ISCSI_AG_CONTEXT_DECISION_RULE6 (0x7<<0)
#define XSTORM_ISCSI_AG_CONTEXT_DECISION_RULE6_SHIFT 0
#define XSTORM_ISCSI_AG_CONTEXT_DECISION_RULE7 (0x7<<3)
#define XSTORM_ISCSI_AG_CONTEXT_DECISION_RULE7_SHIFT 3
#define XSTORM_ISCSI_AG_CONTEXT_DECISION_RULE4 (0x3<<6)
#define XSTORM_ISCSI_AG_CONTEXT_DECISION_RULE4_SHIFT 6
	vmk_uint8 agg_val3_th;
	vmk_uint16 agg_vars7;
#define __XSTORM_ISCSI_AG_CONTEXT_AGG_VAL11_DECISION_RULE (0x7<<0)
#define __XSTORM_ISCSI_AG_CONTEXT_AGG_VAL11_DECISION_RULE_SHIFT 0
#define __XSTORM_ISCSI_AG_CONTEXT_AUX13_FLAG (0x1<<3)
#define __XSTORM_ISCSI_AG_CONTEXT_AUX13_FLAG_SHIFT 3
#define __XSTORM_ISCSI_AG_CONTEXT_STORMS_SYNC_CF (0x3<<4)
#define __XSTORM_ISCSI_AG_CONTEXT_STORMS_SYNC_CF_SHIFT 4
#define XSTORM_ISCSI_AG_CONTEXT_DECISION_RULE3 (0x3<<6)
#define XSTORM_ISCSI_AG_CONTEXT_DECISION_RULE3_SHIFT 6
#define XSTORM_ISCSI_AG_CONTEXT_AUX1_CF (0x3<<8)
#define XSTORM_ISCSI_AG_CONTEXT_AUX1_CF_SHIFT 8
#define __XSTORM_ISCSI_AG_CONTEXT_COMPLETION_SEQ_DECISION_MASK (0x1<<10)
#define __XSTORM_ISCSI_AG_CONTEXT_COMPLETION_SEQ_DECISION_MASK_SHIFT 10
#define __XSTORM_ISCSI_AG_CONTEXT_AUX1_CF_EN (0x1<<11)
#define __XSTORM_ISCSI_AG_CONTEXT_AUX1_CF_EN_SHIFT 11
#define __XSTORM_ISCSI_AG_CONTEXT_AUX10_FLAG (0x1<<12)
#define __XSTORM_ISCSI_AG_CONTEXT_AUX10_FLAG_SHIFT 12
#define __XSTORM_ISCSI_AG_CONTEXT_AUX11_FLAG (0x1<<13)
#define __XSTORM_ISCSI_AG_CONTEXT_AUX11_FLAG_SHIFT 13
#define __XSTORM_ISCSI_AG_CONTEXT_AUX12_FLAG (0x1<<14)
#define __XSTORM_ISCSI_AG_CONTEXT_AUX12_FLAG_SHIFT 14
#define __XSTORM_ISCSI_AG_CONTEXT_RX_WND_SCL_EN (0x1<<15)
#define __XSTORM_ISCSI_AG_CONTEXT_RX_WND_SCL_EN_SHIFT 15
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint16 __agg_val11_th;
	vmk_uint16 __gen_data;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 __gen_data;
	vmk_uint16 __agg_val11_th;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint8 __reserved1;
	vmk_uint8 __agg_val6_th;
	vmk_uint16 __agg_val9;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 __agg_val9;
	vmk_uint8 __agg_val6_th;
	vmk_uint8 __reserved1;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint16 hq_prod;
	vmk_uint16 hq_cons;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 hq_cons;
	vmk_uint16 hq_prod;
#endif
	vmk_uint32 agg_vars8;
#define XSTORM_ISCSI_AG_CONTEXT_AGG_MISC2 (0xFFFFFF<<0)
#define XSTORM_ISCSI_AG_CONTEXT_AGG_MISC2_SHIFT 0
#define XSTORM_ISCSI_AG_CONTEXT_AGG_MISC3 (0xFF<<24)
#define XSTORM_ISCSI_AG_CONTEXT_AGG_MISC3_SHIFT 24
#if defined(__BIG_ENDIAN)
	vmk_uint16 r2tq_prod;
	vmk_uint16 sq_prod;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 sq_prod;
	vmk_uint16 r2tq_prod;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint8 agg_val3;
	vmk_uint8 agg_val6;
	vmk_uint8 agg_val5_th;
	vmk_uint8 agg_val5;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 agg_val5;
	vmk_uint8 agg_val5_th;
	vmk_uint8 agg_val6;
	vmk_uint8 agg_val3;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint16 __agg_misc1;
	vmk_uint16 agg_limit1;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 agg_limit1;
	vmk_uint16 __agg_misc1;
#endif
	vmk_uint32 hq_cons_tcp_seq;
	vmk_uint32 exp_stat_sn;
	vmk_uint32 rst_seq_num;
};


/*
 * The L5cm aggregative context of XStorm
 */
struct xstorm_l5cm_ag_context {
#if defined(__BIG_ENDIAN)
	vmk_uint16 agg_val1;
	vmk_uint8 agg_vars1;
#define __XSTORM_L5CM_AG_CONTEXT_EXISTS_IN_QM0 (0x1<<0)
#define __XSTORM_L5CM_AG_CONTEXT_EXISTS_IN_QM0_SHIFT 0
#define XSTORM_L5CM_AG_CONTEXT_EXISTS_IN_QM1 (0x1<<1)
#define XSTORM_L5CM_AG_CONTEXT_EXISTS_IN_QM1_SHIFT 1
#define XSTORM_L5CM_AG_CONTEXT_EXISTS_IN_QM2 (0x1<<2)
#define XSTORM_L5CM_AG_CONTEXT_EXISTS_IN_QM2_SHIFT 2
#define XSTORM_L5CM_AG_CONTEXT_EXISTS_IN_QM3 (0x1<<3)
#define XSTORM_L5CM_AG_CONTEXT_EXISTS_IN_QM3_SHIFT 3
#define __XSTORM_L5CM_AG_CONTEXT_MORE_TO_SEND_EN (0x1<<4)
#define __XSTORM_L5CM_AG_CONTEXT_MORE_TO_SEND_EN_SHIFT 4
#define XSTORM_L5CM_AG_CONTEXT_NAGLE_EN (0x1<<5)
#define XSTORM_L5CM_AG_CONTEXT_NAGLE_EN_SHIFT 5
#define __XSTORM_L5CM_AG_CONTEXT_DQ_SPARE_FLAG (0x1<<6)
#define __XSTORM_L5CM_AG_CONTEXT_DQ_SPARE_FLAG_SHIFT 6
#define __XSTORM_L5CM_AG_CONTEXT_UNA_GT_NXT_EN (0x1<<7)
#define __XSTORM_L5CM_AG_CONTEXT_UNA_GT_NXT_EN_SHIFT 7
	vmk_uint8 state;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 state;
	vmk_uint8 agg_vars1;
#define __XSTORM_L5CM_AG_CONTEXT_EXISTS_IN_QM0 (0x1<<0)
#define __XSTORM_L5CM_AG_CONTEXT_EXISTS_IN_QM0_SHIFT 0
#define XSTORM_L5CM_AG_CONTEXT_EXISTS_IN_QM1 (0x1<<1)
#define XSTORM_L5CM_AG_CONTEXT_EXISTS_IN_QM1_SHIFT 1
#define XSTORM_L5CM_AG_CONTEXT_EXISTS_IN_QM2 (0x1<<2)
#define XSTORM_L5CM_AG_CONTEXT_EXISTS_IN_QM2_SHIFT 2
#define XSTORM_L5CM_AG_CONTEXT_EXISTS_IN_QM3 (0x1<<3)
#define XSTORM_L5CM_AG_CONTEXT_EXISTS_IN_QM3_SHIFT 3
#define __XSTORM_L5CM_AG_CONTEXT_MORE_TO_SEND_EN (0x1<<4)
#define __XSTORM_L5CM_AG_CONTEXT_MORE_TO_SEND_EN_SHIFT 4
#define XSTORM_L5CM_AG_CONTEXT_NAGLE_EN (0x1<<5)
#define XSTORM_L5CM_AG_CONTEXT_NAGLE_EN_SHIFT 5
#define __XSTORM_L5CM_AG_CONTEXT_DQ_SPARE_FLAG (0x1<<6)
#define __XSTORM_L5CM_AG_CONTEXT_DQ_SPARE_FLAG_SHIFT 6
#define __XSTORM_L5CM_AG_CONTEXT_UNA_GT_NXT_EN (0x1<<7)
#define __XSTORM_L5CM_AG_CONTEXT_UNA_GT_NXT_EN_SHIFT 7
	vmk_uint16 agg_val1;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint8 cdu_reserved;
	vmk_uint8 __agg_vars4;
	vmk_uint8 agg_vars3;
#define XSTORM_L5CM_AG_CONTEXT_PHYSICAL_QUEUE_NUM2 (0x3F<<0)
#define XSTORM_L5CM_AG_CONTEXT_PHYSICAL_QUEUE_NUM2_SHIFT 0
#define __XSTORM_L5CM_AG_CONTEXT_RX_TS_EN_CF (0x3<<6)
#define __XSTORM_L5CM_AG_CONTEXT_RX_TS_EN_CF_SHIFT 6
	vmk_uint8 agg_vars2;
#define XSTORM_L5CM_AG_CONTEXT_AUX4_CF (0x3<<0)
#define XSTORM_L5CM_AG_CONTEXT_AUX4_CF_SHIFT 0
#define __XSTORM_L5CM_AG_CONTEXT_DQ_SPARE_FLAG_EN (0x1<<2)
#define __XSTORM_L5CM_AG_CONTEXT_DQ_SPARE_FLAG_EN_SHIFT 2
#define __XSTORM_L5CM_AG_CONTEXT_AUX8_FLAG (0x1<<3)
#define __XSTORM_L5CM_AG_CONTEXT_AUX8_FLAG_SHIFT 3
#define __XSTORM_L5CM_AG_CONTEXT_AUX9_FLAG (0x1<<4)
#define __XSTORM_L5CM_AG_CONTEXT_AUX9_FLAG_SHIFT 4
#define XSTORM_L5CM_AG_CONTEXT_DECISION_RULE1 (0x3<<5)
#define XSTORM_L5CM_AG_CONTEXT_DECISION_RULE1_SHIFT 5
#define XSTORM_L5CM_AG_CONTEXT_AUX4_CF_EN (0x1<<7)
#define XSTORM_L5CM_AG_CONTEXT_AUX4_CF_EN_SHIFT 7
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 agg_vars2;
#define XSTORM_L5CM_AG_CONTEXT_AUX4_CF (0x3<<0)
#define XSTORM_L5CM_AG_CONTEXT_AUX4_CF_SHIFT 0
#define __XSTORM_L5CM_AG_CONTEXT_DQ_SPARE_FLAG_EN (0x1<<2)
#define __XSTORM_L5CM_AG_CONTEXT_DQ_SPARE_FLAG_EN_SHIFT 2
#define __XSTORM_L5CM_AG_CONTEXT_AUX8_FLAG (0x1<<3)
#define __XSTORM_L5CM_AG_CONTEXT_AUX8_FLAG_SHIFT 3
#define __XSTORM_L5CM_AG_CONTEXT_AUX9_FLAG (0x1<<4)
#define __XSTORM_L5CM_AG_CONTEXT_AUX9_FLAG_SHIFT 4
#define XSTORM_L5CM_AG_CONTEXT_DECISION_RULE1 (0x3<<5)
#define XSTORM_L5CM_AG_CONTEXT_DECISION_RULE1_SHIFT 5
#define XSTORM_L5CM_AG_CONTEXT_AUX4_CF_EN (0x1<<7)
#define XSTORM_L5CM_AG_CONTEXT_AUX4_CF_EN_SHIFT 7
	vmk_uint8 agg_vars3;
#define XSTORM_L5CM_AG_CONTEXT_PHYSICAL_QUEUE_NUM2 (0x3F<<0)
#define XSTORM_L5CM_AG_CONTEXT_PHYSICAL_QUEUE_NUM2_SHIFT 0
#define __XSTORM_L5CM_AG_CONTEXT_RX_TS_EN_CF (0x3<<6)
#define __XSTORM_L5CM_AG_CONTEXT_RX_TS_EN_CF_SHIFT 6
	vmk_uint8 __agg_vars4;
	vmk_uint8 cdu_reserved;
#endif
	vmk_uint32 more_to_send;
#if defined(__BIG_ENDIAN)
	vmk_uint16 agg_vars5;
#define XSTORM_L5CM_AG_CONTEXT_DECISION_RULE5 (0x3<<0)
#define XSTORM_L5CM_AG_CONTEXT_DECISION_RULE5_SHIFT 0
#define XSTORM_L5CM_AG_CONTEXT_PHYSICAL_QUEUE_NUM0 (0x3F<<2)
#define XSTORM_L5CM_AG_CONTEXT_PHYSICAL_QUEUE_NUM0_SHIFT 2
#define XSTORM_L5CM_AG_CONTEXT_PHYSICAL_QUEUE_NUM1 (0x3F<<8)
#define XSTORM_L5CM_AG_CONTEXT_PHYSICAL_QUEUE_NUM1_SHIFT 8
#define XSTORM_L5CM_AG_CONTEXT_DECISION_RULE2 (0x3<<14)
#define XSTORM_L5CM_AG_CONTEXT_DECISION_RULE2_SHIFT 14
	vmk_uint16 agg_val4_th;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 agg_val4_th;
	vmk_uint16 agg_vars5;
#define XSTORM_L5CM_AG_CONTEXT_DECISION_RULE5 (0x3<<0)
#define XSTORM_L5CM_AG_CONTEXT_DECISION_RULE5_SHIFT 0
#define XSTORM_L5CM_AG_CONTEXT_PHYSICAL_QUEUE_NUM0 (0x3F<<2)
#define XSTORM_L5CM_AG_CONTEXT_PHYSICAL_QUEUE_NUM0_SHIFT 2
#define XSTORM_L5CM_AG_CONTEXT_PHYSICAL_QUEUE_NUM1 (0x3F<<8)
#define XSTORM_L5CM_AG_CONTEXT_PHYSICAL_QUEUE_NUM1_SHIFT 8
#define XSTORM_L5CM_AG_CONTEXT_DECISION_RULE2 (0x3<<14)
#define XSTORM_L5CM_AG_CONTEXT_DECISION_RULE2_SHIFT 14
#endif
	struct xstorm_tcp_tcp_ag_context_section tcp;
#if defined(__BIG_ENDIAN)
	vmk_uint16 agg_vars7;
#define __XSTORM_L5CM_AG_CONTEXT_AGG_VAL11_DECISION_RULE (0x7<<0)
#define __XSTORM_L5CM_AG_CONTEXT_AGG_VAL11_DECISION_RULE_SHIFT 0
#define __XSTORM_L5CM_AG_CONTEXT_AUX13_FLAG (0x1<<3)
#define __XSTORM_L5CM_AG_CONTEXT_AUX13_FLAG_SHIFT 3
#define __XSTORM_L5CM_AG_CONTEXT_STORMS_SYNC_CF (0x3<<4)
#define __XSTORM_L5CM_AG_CONTEXT_STORMS_SYNC_CF_SHIFT 4
#define XSTORM_L5CM_AG_CONTEXT_DECISION_RULE3 (0x3<<6)
#define XSTORM_L5CM_AG_CONTEXT_DECISION_RULE3_SHIFT 6
#define XSTORM_L5CM_AG_CONTEXT_AUX1_CF (0x3<<8)
#define XSTORM_L5CM_AG_CONTEXT_AUX1_CF_SHIFT 8
#define __XSTORM_L5CM_AG_CONTEXT_COMPLETION_SEQ_DECISION_MASK (0x1<<10)
#define __XSTORM_L5CM_AG_CONTEXT_COMPLETION_SEQ_DECISION_MASK_SHIFT 10
#define __XSTORM_L5CM_AG_CONTEXT_AUX1_CF_EN (0x1<<11)
#define __XSTORM_L5CM_AG_CONTEXT_AUX1_CF_EN_SHIFT 11
#define __XSTORM_L5CM_AG_CONTEXT_AUX10_FLAG (0x1<<12)
#define __XSTORM_L5CM_AG_CONTEXT_AUX10_FLAG_SHIFT 12
#define __XSTORM_L5CM_AG_CONTEXT_AUX11_FLAG (0x1<<13)
#define __XSTORM_L5CM_AG_CONTEXT_AUX11_FLAG_SHIFT 13
#define __XSTORM_L5CM_AG_CONTEXT_AUX12_FLAG (0x1<<14)
#define __XSTORM_L5CM_AG_CONTEXT_AUX12_FLAG_SHIFT 14
#define __XSTORM_L5CM_AG_CONTEXT_RX_WND_SCL_EN (0x1<<15)
#define __XSTORM_L5CM_AG_CONTEXT_RX_WND_SCL_EN_SHIFT 15
	vmk_uint8 agg_val3_th;
	vmk_uint8 agg_vars6;
#define XSTORM_L5CM_AG_CONTEXT_DECISION_RULE6 (0x7<<0)
#define XSTORM_L5CM_AG_CONTEXT_DECISION_RULE6_SHIFT 0
#define XSTORM_L5CM_AG_CONTEXT_DECISION_RULE7 (0x7<<3)
#define XSTORM_L5CM_AG_CONTEXT_DECISION_RULE7_SHIFT 3
#define XSTORM_L5CM_AG_CONTEXT_DECISION_RULE4 (0x3<<6)
#define XSTORM_L5CM_AG_CONTEXT_DECISION_RULE4_SHIFT 6
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 agg_vars6;
#define XSTORM_L5CM_AG_CONTEXT_DECISION_RULE6 (0x7<<0)
#define XSTORM_L5CM_AG_CONTEXT_DECISION_RULE6_SHIFT 0
#define XSTORM_L5CM_AG_CONTEXT_DECISION_RULE7 (0x7<<3)
#define XSTORM_L5CM_AG_CONTEXT_DECISION_RULE7_SHIFT 3
#define XSTORM_L5CM_AG_CONTEXT_DECISION_RULE4 (0x3<<6)
#define XSTORM_L5CM_AG_CONTEXT_DECISION_RULE4_SHIFT 6
	vmk_uint8 agg_val3_th;
	vmk_uint16 agg_vars7;
#define __XSTORM_L5CM_AG_CONTEXT_AGG_VAL11_DECISION_RULE (0x7<<0)
#define __XSTORM_L5CM_AG_CONTEXT_AGG_VAL11_DECISION_RULE_SHIFT 0
#define __XSTORM_L5CM_AG_CONTEXT_AUX13_FLAG (0x1<<3)
#define __XSTORM_L5CM_AG_CONTEXT_AUX13_FLAG_SHIFT 3
#define __XSTORM_L5CM_AG_CONTEXT_STORMS_SYNC_CF (0x3<<4)
#define __XSTORM_L5CM_AG_CONTEXT_STORMS_SYNC_CF_SHIFT 4
#define XSTORM_L5CM_AG_CONTEXT_DECISION_RULE3 (0x3<<6)
#define XSTORM_L5CM_AG_CONTEXT_DECISION_RULE3_SHIFT 6
#define XSTORM_L5CM_AG_CONTEXT_AUX1_CF (0x3<<8)
#define XSTORM_L5CM_AG_CONTEXT_AUX1_CF_SHIFT 8
#define __XSTORM_L5CM_AG_CONTEXT_COMPLETION_SEQ_DECISION_MASK (0x1<<10)
#define __XSTORM_L5CM_AG_CONTEXT_COMPLETION_SEQ_DECISION_MASK_SHIFT 10
#define __XSTORM_L5CM_AG_CONTEXT_AUX1_CF_EN (0x1<<11)
#define __XSTORM_L5CM_AG_CONTEXT_AUX1_CF_EN_SHIFT 11
#define __XSTORM_L5CM_AG_CONTEXT_AUX10_FLAG (0x1<<12)
#define __XSTORM_L5CM_AG_CONTEXT_AUX10_FLAG_SHIFT 12
#define __XSTORM_L5CM_AG_CONTEXT_AUX11_FLAG (0x1<<13)
#define __XSTORM_L5CM_AG_CONTEXT_AUX11_FLAG_SHIFT 13
#define __XSTORM_L5CM_AG_CONTEXT_AUX12_FLAG (0x1<<14)
#define __XSTORM_L5CM_AG_CONTEXT_AUX12_FLAG_SHIFT 14
#define __XSTORM_L5CM_AG_CONTEXT_RX_WND_SCL_EN (0x1<<15)
#define __XSTORM_L5CM_AG_CONTEXT_RX_WND_SCL_EN_SHIFT 15
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint16 __agg_val11_th;
	vmk_uint16 __gen_data;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 __gen_data;
	vmk_uint16 __agg_val11_th;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint8 __reserved1;
	vmk_uint8 __agg_val6_th;
	vmk_uint16 __agg_val9;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 __agg_val9;
	vmk_uint8 __agg_val6_th;
	vmk_uint8 __reserved1;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint16 agg_val2_th;
	vmk_uint16 agg_val2;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 agg_val2;
	vmk_uint16 agg_val2_th;
#endif
	vmk_uint32 agg_vars8;
#define XSTORM_L5CM_AG_CONTEXT_AGG_MISC2 (0xFFFFFF<<0)
#define XSTORM_L5CM_AG_CONTEXT_AGG_MISC2_SHIFT 0
#define XSTORM_L5CM_AG_CONTEXT_AGG_MISC3 (0xFF<<24)
#define XSTORM_L5CM_AG_CONTEXT_AGG_MISC3_SHIFT 24
#if defined(__BIG_ENDIAN)
	vmk_uint16 agg_misc0;
	vmk_uint16 agg_val4;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 agg_val4;
	vmk_uint16 agg_misc0;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint8 agg_val3;
	vmk_uint8 agg_val6;
	vmk_uint8 agg_val5_th;
	vmk_uint8 agg_val5;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 agg_val5;
	vmk_uint8 agg_val5_th;
	vmk_uint8 agg_val6;
	vmk_uint8 agg_val3;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint16 __agg_misc1;
	vmk_uint16 agg_limit1;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 agg_limit1;
	vmk_uint16 __agg_misc1;
#endif
	vmk_uint32 completion_seq;
	vmk_uint32 agg_misc4;
	vmk_uint32 rst_seq_num;
};

/*
 * ABTS info $$KEEP_ENDIANNESS$$
 */
struct fcoe_abts_info {
	vmk_uint16 aborted_task_id;
	vmk_uint16 reserved0;
	vmk_uint32 reserved1;
};


/*
 * Fixed size structure in order to plant it in Union structure $$KEEP_ENDIANNESS$$
 */
struct fcoe_abts_rsp_union {
	vmk_uint8 r_ctl;
	vmk_uint8 rsrv[3];
	vmk_uint32 abts_rsp_payload[7];
};


/*
 * 4 regs size $$KEEP_ENDIANNESS$$
 */
struct fcoe_bd_ctx {
	vmk_uint32 buf_addr_hi;
	vmk_uint32 buf_addr_lo;
	vmk_uint16 buf_len;
	vmk_uint16 rsrv0;
	vmk_uint16 flags;
	vmk_uint16 rsrv1;
};


/*
 * FCoE cached sges context $$KEEP_ENDIANNESS$$
 */
struct fcoe_cached_sge_ctx {
	struct regpair cur_buf_addr;
	vmk_uint16 cur_buf_rem;
	vmk_uint16 second_buf_rem;
	struct regpair second_buf_addr;
};


/*
 * Cleanup info $$KEEP_ENDIANNESS$$
 */
struct fcoe_cleanup_info {
	vmk_uint16 cleaned_task_id;
	vmk_uint16 rolled_tx_seq_cnt;
	vmk_uint32 rolled_tx_data_offset;
};


/*
 * Fcp RSP flags $$KEEP_ENDIANNESS$$
 */
struct fcoe_fcp_rsp_flags {
	vmk_uint8 flags;
#define FCOE_FCP_RSP_FLAGS_FCP_RSP_LEN_VALID (0x1<<0)
#define FCOE_FCP_RSP_FLAGS_FCP_RSP_LEN_VALID_SHIFT 0
#define FCOE_FCP_RSP_FLAGS_FCP_SNS_LEN_VALID (0x1<<1)
#define FCOE_FCP_RSP_FLAGS_FCP_SNS_LEN_VALID_SHIFT 1
#define FCOE_FCP_RSP_FLAGS_FCP_RESID_OVER (0x1<<2)
#define FCOE_FCP_RSP_FLAGS_FCP_RESID_OVER_SHIFT 2
#define FCOE_FCP_RSP_FLAGS_FCP_RESID_UNDER (0x1<<3)
#define FCOE_FCP_RSP_FLAGS_FCP_RESID_UNDER_SHIFT 3
#define FCOE_FCP_RSP_FLAGS_FCP_CONF_REQ (0x1<<4)
#define FCOE_FCP_RSP_FLAGS_FCP_CONF_REQ_SHIFT 4
#define FCOE_FCP_RSP_FLAGS_FCP_BIDI_FLAGS (0x7<<5)
#define FCOE_FCP_RSP_FLAGS_FCP_BIDI_FLAGS_SHIFT 5
};

/*
 * Fcp RSP payload $$KEEP_ENDIANNESS$$
 */
struct fcoe_fcp_rsp_payload {
	struct regpair reserved0;
	vmk_uint32 fcp_resid;
	vmk_uint8 scsi_status_code;
	struct fcoe_fcp_rsp_flags fcp_flags;
	vmk_uint16 retry_delay_timer;
	vmk_uint32 fcp_rsp_len;
	vmk_uint32 fcp_sns_len;
};

/*
 * Fixed size structure in order to plant it in Union structure $$KEEP_ENDIANNESS$$
 */
struct fcoe_fcp_rsp_union {
	struct fcoe_fcp_rsp_payload payload;
	struct regpair reserved0;
};

/*
 * FC header $$KEEP_ENDIANNESS$$
 */
struct fcoe_fc_hdr {
	vmk_uint8 s_id[3];
	vmk_uint8 cs_ctl;
	vmk_uint8 d_id[3];
	vmk_uint8 r_ctl;
	vmk_uint16 seq_cnt;
	vmk_uint8 df_ctl;
	vmk_uint8 seq_id;
	vmk_uint8 f_ctl[3];
	vmk_uint8 type;
	vmk_uint32 parameters;
	vmk_uint16 rx_id;
	vmk_uint16 ox_id;
};

/*
 * FC header union $$KEEP_ENDIANNESS$$
 */
struct fcoe_mp_rsp_union {
	struct fcoe_fc_hdr fc_hdr;
	vmk_uint32 mp_payload_len;
	vmk_uint32 rsrv;
};

/*
 * Completion information $$KEEP_ENDIANNESS$$
 */
union fcoe_comp_flow_info {
	struct fcoe_fcp_rsp_union fcp_rsp;
	struct fcoe_abts_rsp_union abts_rsp;
	struct fcoe_mp_rsp_union mp_rsp;
	vmk_uint32 opaque[8];
};


/*
 * External ABTS info $$KEEP_ENDIANNESS$$
 */
struct fcoe_ext_abts_info {
	vmk_uint32 rsrv0[6];
	struct fcoe_abts_info ctx;
};


/*
 * External cleanup info $$KEEP_ENDIANNESS$$
 */
struct fcoe_ext_cleanup_info {
	vmk_uint32 rsrv0[6];
	struct fcoe_cleanup_info ctx;
};


/*
 * Fcoe FW Tx sequence context $$KEEP_ENDIANNESS$$
 */
struct fcoe_fw_tx_seq_ctx {
	vmk_uint32 data_offset;
	vmk_uint16 seq_cnt;
	vmk_uint16 rsrv0;
};

/*
 * Fcoe external FW Tx sequence context $$KEEP_ENDIANNESS$$
 */
struct fcoe_ext_fw_tx_seq_ctx {
	vmk_uint32 rsrv0[6];
	struct fcoe_fw_tx_seq_ctx ctx;
};


/*
 * FCoE multiple sges context $$KEEP_ENDIANNESS$$
 */
struct fcoe_mul_sges_ctx {
	struct regpair cur_sge_addr;
	vmk_uint16 cur_sge_off;
	vmk_uint8 cur_sge_idx;
	vmk_uint8 sgl_size;
};

/*
 * FCoE external multiple sges context $$KEEP_ENDIANNESS$$
 */
struct fcoe_ext_mul_sges_ctx {
	struct fcoe_mul_sges_ctx mul_sgl;
	struct regpair rsrv0;
};


/*
 * FCP CMD payload $$KEEP_ENDIANNESS$$
 */
struct fcoe_fcp_cmd_payload {
	vmk_uint32 opaque[8];
};


/*
 * Fcp xfr rdy payload $$KEEP_ENDIANNESS$$
 */
struct fcoe_fcp_xfr_rdy_payload {
	vmk_uint32 burst_len;
	vmk_uint32 data_ro;
};


/*
 * FC frame $$KEEP_ENDIANNESS$$
 */
struct fcoe_fc_frame {
	struct fcoe_fc_hdr fc_hdr;
	vmk_uint32 reserved0[2];
};




/*
 * FCoE KCQ CQE parameters $$KEEP_ENDIANNESS$$
 */
union fcoe_kcqe_params {
	vmk_uint32 reserved0[4];
};

/*
 * FCoE KCQ CQE $$KEEP_ENDIANNESS$$
 */
struct fcoe_kcqe {
	vmk_uint32 fcoe_conn_id;
	vmk_uint32 completion_status;
	vmk_uint32 fcoe_conn_context_id;
	union fcoe_kcqe_params params;
	vmk_uint16 qe_self_seq;
	vmk_uint8 op_code;
	vmk_uint8 flags;
#define FCOE_KCQE_RESERVED0 (0x7<<0)
#define FCOE_KCQE_RESERVED0_SHIFT 0
#define FCOE_KCQE_RAMROD_COMPLETION (0x1<<3)
#define FCOE_KCQE_RAMROD_COMPLETION_SHIFT 3
#define FCOE_KCQE_LAYER_CODE (0x7<<4)
#define FCOE_KCQE_LAYER_CODE_SHIFT 4
#define FCOE_KCQE_LINKED_WITH_NEXT (0x1<<7)
#define FCOE_KCQE_LINKED_WITH_NEXT_SHIFT 7
};



/*
 * FCoE KWQE header $$KEEP_ENDIANNESS$$
 */
struct fcoe_kwqe_header {
	vmk_uint8 op_code;
	vmk_uint8 flags;
#define FCOE_KWQE_HEADER_RESERVED0 (0xF<<0)
#define FCOE_KWQE_HEADER_RESERVED0_SHIFT 0
#define FCOE_KWQE_HEADER_LAYER_CODE (0x7<<4)
#define FCOE_KWQE_HEADER_LAYER_CODE_SHIFT 4
#define FCOE_KWQE_HEADER_RESERVED1 (0x1<<7)
#define FCOE_KWQE_HEADER_RESERVED1_SHIFT 7
};

/*
 * FCoE firmware init request 1 $$KEEP_ENDIANNESS$$
 */
struct fcoe_kwqe_init1 {
	vmk_uint16 num_tasks;
	struct fcoe_kwqe_header hdr;
	vmk_uint32 task_list_pbl_addr_lo;
	vmk_uint32 task_list_pbl_addr_hi;
	vmk_uint32 dummy_buffer_addr_lo;
	vmk_uint32 dummy_buffer_addr_hi;
	vmk_uint16 sq_num_wqes;
	vmk_uint16 rq_num_wqes;
	vmk_uint16 rq_buffer_log_size;
	vmk_uint16 cq_num_wqes;
	vmk_uint16 mtu;
	vmk_uint8 num_sessions_log;
	vmk_uint8 flags;
#define FCOE_KWQE_INIT1_LOG_PAGE_SIZE (0xF<<0)
#define FCOE_KWQE_INIT1_LOG_PAGE_SIZE_SHIFT 0
#define FCOE_KWQE_INIT1_LOG_CACHED_PBES_PER_FUNC (0x7<<4)
#define FCOE_KWQE_INIT1_LOG_CACHED_PBES_PER_FUNC_SHIFT 4
#define FCOE_KWQE_INIT1_CLASSIFY_FAILED_ALLOWED (0x1<<7)
#define FCOE_KWQE_INIT1_CLASSIFY_FAILED_ALLOWED_SHIFT 7
};

/*
 * FCoE firmware init request 2 $$KEEP_ENDIANNESS$$
 */
struct fcoe_kwqe_init2 {
	vmk_uint8 hsi_major_version;
	vmk_uint8 hsi_minor_version;
	struct fcoe_kwqe_header hdr;
	vmk_uint32 hash_tbl_pbl_addr_lo;
	vmk_uint32 hash_tbl_pbl_addr_hi;
	vmk_uint32 t2_hash_tbl_addr_lo;
	vmk_uint32 t2_hash_tbl_addr_hi;
	vmk_uint32 t2_ptr_hash_tbl_addr_lo;
	vmk_uint32 t2_ptr_hash_tbl_addr_hi;
	vmk_uint32 free_list_count;
};

/*
 * FCoE firmware init request 3 $$KEEP_ENDIANNESS$$
 */
struct fcoe_kwqe_init3 {
	vmk_uint16 reserved0;
	struct fcoe_kwqe_header hdr;
	vmk_uint32 error_bit_map_lo;
	vmk_uint32 error_bit_map_hi;
	vmk_uint16 dst_mac_addr_hi;
	vmk_uint16 dst_mac_addr_mid;
	vmk_uint16 dst_mac_addr_lo;
	vmk_uint8 perf_config;
	vmk_uint8 reserved2[13];
};

/*
 * FCoE connection offload request 1 $$KEEP_ENDIANNESS$$
 */
struct fcoe_kwqe_conn_offload1 {
	vmk_uint16 fcoe_conn_id;
	struct fcoe_kwqe_header hdr;
	vmk_uint32 sq_addr_lo;
	vmk_uint32 sq_addr_hi;
	vmk_uint32 rq_pbl_addr_lo;
	vmk_uint32 rq_pbl_addr_hi;
	vmk_uint32 rq_first_pbe_addr_lo;
	vmk_uint32 rq_first_pbe_addr_hi;
	vmk_uint16 rq_prod;
	vmk_uint16 reserved0;
};

/*
 * FCoE connection offload request 2 $$KEEP_ENDIANNESS$$
 */
struct fcoe_kwqe_conn_offload2 {
	vmk_uint16 tx_max_fc_pay_len;
	struct fcoe_kwqe_header hdr;
	vmk_uint32 cq_addr_lo;
	vmk_uint32 cq_addr_hi;
	vmk_uint32 xferq_addr_lo;
	vmk_uint32 xferq_addr_hi;
	vmk_uint32 conn_db_addr_lo;
	vmk_uint32 conn_db_addr_hi;
	vmk_uint32 reserved1;
};

/*
 * FCoE connection offload request 3 $$KEEP_ENDIANNESS$$
 */
struct fcoe_kwqe_conn_offload3 {
	vmk_uint16 vlan_tag;
#define FCOE_KWQE_CONN_OFFLOAD3_VLAN_ID (0xFFF<<0)
#define FCOE_KWQE_CONN_OFFLOAD3_VLAN_ID_SHIFT 0
#define FCOE_KWQE_CONN_OFFLOAD3_CFI (0x1<<12)
#define FCOE_KWQE_CONN_OFFLOAD3_CFI_SHIFT 12
#define FCOE_KWQE_CONN_OFFLOAD3_PRIORITY (0x7<<13)
#define FCOE_KWQE_CONN_OFFLOAD3_PRIORITY_SHIFT 13
	struct fcoe_kwqe_header hdr;
	vmk_uint8 s_id[3];
	vmk_uint8 tx_max_conc_seqs_c3;
	vmk_uint8 d_id[3];
	vmk_uint8 flags;
#define FCOE_KWQE_CONN_OFFLOAD3_B_MUL_N_PORT_IDS (0x1<<0)
#define FCOE_KWQE_CONN_OFFLOAD3_B_MUL_N_PORT_IDS_SHIFT 0
#define FCOE_KWQE_CONN_OFFLOAD3_B_E_D_TOV_RES (0x1<<1)
#define FCOE_KWQE_CONN_OFFLOAD3_B_E_D_TOV_RES_SHIFT 1
#define FCOE_KWQE_CONN_OFFLOAD3_B_CONT_INCR_SEQ_CNT (0x1<<2)
#define FCOE_KWQE_CONN_OFFLOAD3_B_CONT_INCR_SEQ_CNT_SHIFT 2
#define FCOE_KWQE_CONN_OFFLOAD3_B_CONF_REQ (0x1<<3)
#define FCOE_KWQE_CONN_OFFLOAD3_B_CONF_REQ_SHIFT 3
#define FCOE_KWQE_CONN_OFFLOAD3_B_REC_VALID (0x1<<4)
#define FCOE_KWQE_CONN_OFFLOAD3_B_REC_VALID_SHIFT 4
#define FCOE_KWQE_CONN_OFFLOAD3_B_C2_VALID (0x1<<5)
#define FCOE_KWQE_CONN_OFFLOAD3_B_C2_VALID_SHIFT 5
#define FCOE_KWQE_CONN_OFFLOAD3_B_ACK_0 (0x1<<6)
#define FCOE_KWQE_CONN_OFFLOAD3_B_ACK_0_SHIFT 6
#define FCOE_KWQE_CONN_OFFLOAD3_B_VLAN_FLAG (0x1<<7)
#define FCOE_KWQE_CONN_OFFLOAD3_B_VLAN_FLAG_SHIFT 7
	vmk_uint32 reserved;
	vmk_uint32 confq_first_pbe_addr_lo;
	vmk_uint32 confq_first_pbe_addr_hi;
	vmk_uint16 tx_total_conc_seqs;
	vmk_uint16 rx_max_fc_pay_len;
	vmk_uint16 rx_total_conc_seqs;
	vmk_uint8 rx_max_conc_seqs_c3;
	vmk_uint8 rx_open_seqs_exch_c3;
};

/*
 * FCoE connection offload request 4 $$KEEP_ENDIANNESS$$
 */
struct fcoe_kwqe_conn_offload4 {
	vmk_uint8 e_d_tov_timer_val;
	vmk_uint8 reserved2;
	struct fcoe_kwqe_header hdr;
	vmk_uint8 src_mac_addr_lo[2];
	vmk_uint8 src_mac_addr_mid[2];
	vmk_uint8 src_mac_addr_hi[2];
	vmk_uint8 dst_mac_addr_hi[2];
	vmk_uint8 dst_mac_addr_lo[2];
	vmk_uint8 dst_mac_addr_mid[2];
	vmk_uint32 lcq_addr_lo;
	vmk_uint32 lcq_addr_hi;
	vmk_uint32 confq_pbl_base_addr_lo;
	vmk_uint32 confq_pbl_base_addr_hi;
};

/*
 * FCoE connection enable request $$KEEP_ENDIANNESS$$
 */
struct fcoe_kwqe_conn_enable_disable {
	vmk_uint16 reserved0;
	struct fcoe_kwqe_header hdr;
	vmk_uint8 src_mac_addr_lo[2];
	vmk_uint8 src_mac_addr_mid[2];
	vmk_uint8 src_mac_addr_hi[2];
	vmk_uint16 vlan_tag;
#define FCOE_KWQE_CONN_ENABLE_DISABLE_VLAN_ID (0xFFF<<0)
#define FCOE_KWQE_CONN_ENABLE_DISABLE_VLAN_ID_SHIFT 0
#define FCOE_KWQE_CONN_ENABLE_DISABLE_CFI (0x1<<12)
#define FCOE_KWQE_CONN_ENABLE_DISABLE_CFI_SHIFT 12
#define FCOE_KWQE_CONN_ENABLE_DISABLE_PRIORITY (0x7<<13)
#define FCOE_KWQE_CONN_ENABLE_DISABLE_PRIORITY_SHIFT 13
	vmk_uint8 dst_mac_addr_lo[2];
	vmk_uint8 dst_mac_addr_mid[2];
	vmk_uint8 dst_mac_addr_hi[2];
	vmk_uint16 reserved1;
	vmk_uint8 s_id[3];
	vmk_uint8 vlan_flag;
	vmk_uint8 d_id[3];
	vmk_uint8 reserved3;
	vmk_uint32 context_id;
	vmk_uint32 conn_id;
	vmk_uint32 reserved4;
};

/*
 * FCoE connection destroy request $$KEEP_ENDIANNESS$$
 */
struct fcoe_kwqe_conn_destroy {
	vmk_uint16 reserved0;
	struct fcoe_kwqe_header hdr;
	vmk_uint32 context_id;
	vmk_uint32 conn_id;
	vmk_uint32 reserved1[5];
};

/*
 * FCoe destroy request $$KEEP_ENDIANNESS$$
 */
struct fcoe_kwqe_destroy {
	vmk_uint16 reserved0;
	struct fcoe_kwqe_header hdr;
	vmk_uint32 reserved1[7];
};

/*
 * FCoe statistics request $$KEEP_ENDIANNESS$$
 */
struct fcoe_kwqe_stat {
	vmk_uint16 reserved0;
	struct fcoe_kwqe_header hdr;
	vmk_uint32 stat_params_addr_lo;
	vmk_uint32 stat_params_addr_hi;
	vmk_uint32 reserved1[5];
};

/*
 * FCoE KWQ WQE $$KEEP_ENDIANNESS$$
 */
union fcoe_kwqe {
	struct fcoe_kwqe_init1 init1;
	struct fcoe_kwqe_init2 init2;
	struct fcoe_kwqe_init3 init3;
	struct fcoe_kwqe_conn_offload1 conn_offload1;
	struct fcoe_kwqe_conn_offload2 conn_offload2;
	struct fcoe_kwqe_conn_offload3 conn_offload3;
	struct fcoe_kwqe_conn_offload4 conn_offload4;
	struct fcoe_kwqe_conn_enable_disable conn_enable_disable;
	struct fcoe_kwqe_conn_destroy conn_destroy;
	struct fcoe_kwqe_destroy destroy;
	struct fcoe_kwqe_stat statistics;
};




/*
 * TX SGL context $$KEEP_ENDIANNESS$$
 */
union fcoe_sgl_union_ctx {
	struct fcoe_cached_sge_ctx cached_sge;
	struct fcoe_ext_mul_sges_ctx sgl;
	vmk_uint32 opaque[5];
};

/*
 * Data-In/ELS/BLS information $$KEEP_ENDIANNESS$$
 */
struct fcoe_read_flow_info {
	union fcoe_sgl_union_ctx sgl_ctx;
	vmk_uint32 rsrv0[3];
};


/*
 * Fcoe stat context $$KEEP_ENDIANNESS$$
 */
struct fcoe_s_stat_ctx {
	vmk_uint8 flags;
#define FCOE_S_STAT_CTX_ACTIVE (0x1<<0)
#define FCOE_S_STAT_CTX_ACTIVE_SHIFT 0
#define FCOE_S_STAT_CTX_ACK_ABORT_SEQ_COND (0x1<<1)
#define FCOE_S_STAT_CTX_ACK_ABORT_SEQ_COND_SHIFT 1
#define FCOE_S_STAT_CTX_ABTS_PERFORMED (0x1<<2)
#define FCOE_S_STAT_CTX_ABTS_PERFORMED_SHIFT 2
#define FCOE_S_STAT_CTX_SEQ_TIMEOUT (0x1<<3)
#define FCOE_S_STAT_CTX_SEQ_TIMEOUT_SHIFT 3
#define FCOE_S_STAT_CTX_P_RJT (0x1<<4)
#define FCOE_S_STAT_CTX_P_RJT_SHIFT 4
#define FCOE_S_STAT_CTX_ACK_EOFT (0x1<<5)
#define FCOE_S_STAT_CTX_ACK_EOFT_SHIFT 5
#define FCOE_S_STAT_CTX_RSRV1 (0x3<<6)
#define FCOE_S_STAT_CTX_RSRV1_SHIFT 6
};

/*
 * Fcoe rx seq context $$KEEP_ENDIANNESS$$
 */
struct fcoe_rx_seq_ctx {
	vmk_uint8 seq_id;
	struct fcoe_s_stat_ctx s_stat;
	vmk_uint16 seq_cnt;
	vmk_uint32 low_exp_ro;
	vmk_uint32 high_exp_ro;
};


/*
 * Fcoe rx_wr union context $$KEEP_ENDIANNESS$$
 */
union fcoe_rx_wr_union_ctx {
	struct fcoe_read_flow_info read_info;
	union fcoe_comp_flow_info comp_info;
	vmk_uint32 opaque[8];
};



/*
 * FCoE SQ element $$KEEP_ENDIANNESS$$
 */
struct fcoe_sqe {
	vmk_uint16 wqe;
#define FCOE_SQE_TASK_ID (0x7FFF<<0)
#define FCOE_SQE_TASK_ID_SHIFT 0
#define FCOE_SQE_TOGGLE_BIT (0x1<<15)
#define FCOE_SQE_TOGGLE_BIT_SHIFT 15
};



/*
 * 14 regs $$KEEP_ENDIANNESS$$
 */
struct fcoe_tce_tx_only {
	union fcoe_sgl_union_ctx sgl_ctx;
	vmk_uint32 rsrv0;
};

/*
 * 32 bytes (8 regs) used for TX only purposes $$KEEP_ENDIANNESS$$
 */
union fcoe_tx_wr_rx_rd_union_ctx {
	struct fcoe_fc_frame tx_frame;
	struct fcoe_fcp_cmd_payload fcp_cmd;
	struct fcoe_ext_cleanup_info cleanup;
	struct fcoe_ext_abts_info abts;
	struct fcoe_ext_fw_tx_seq_ctx tx_seq;
	vmk_uint32 opaque[8];
};

/*
 * tce_tx_wr_rx_rd_const $$KEEP_ENDIANNESS$$
 */
struct fcoe_tce_tx_wr_rx_rd_const {
	vmk_uint8 init_flags;
#define FCOE_TCE_TX_WR_RX_RD_CONST_TASK_TYPE (0x7<<0)
#define FCOE_TCE_TX_WR_RX_RD_CONST_TASK_TYPE_SHIFT 0
#define FCOE_TCE_TX_WR_RX_RD_CONST_DEV_TYPE (0x1<<3)
#define FCOE_TCE_TX_WR_RX_RD_CONST_DEV_TYPE_SHIFT 3
#define FCOE_TCE_TX_WR_RX_RD_CONST_CLASS_TYPE (0x1<<4)
#define FCOE_TCE_TX_WR_RX_RD_CONST_CLASS_TYPE_SHIFT 4
#define FCOE_TCE_TX_WR_RX_RD_CONST_CACHED_SGE (0x3<<5)
#define FCOE_TCE_TX_WR_RX_RD_CONST_CACHED_SGE_SHIFT 5
#define FCOE_TCE_TX_WR_RX_RD_CONST_SUPPORT_REC_TOV (0x1<<7)
#define FCOE_TCE_TX_WR_RX_RD_CONST_SUPPORT_REC_TOV_SHIFT 7
	vmk_uint8 tx_flags;
#define FCOE_TCE_TX_WR_RX_RD_CONST_TX_VALID (0x1<<0)
#define FCOE_TCE_TX_WR_RX_RD_CONST_TX_VALID_SHIFT 0
#define FCOE_TCE_TX_WR_RX_RD_CONST_TX_STATE (0xF<<1)
#define FCOE_TCE_TX_WR_RX_RD_CONST_TX_STATE_SHIFT 1
#define FCOE_TCE_TX_WR_RX_RD_CONST_RSRV1 (0x1<<5)
#define FCOE_TCE_TX_WR_RX_RD_CONST_RSRV1_SHIFT 5
#define FCOE_TCE_TX_WR_RX_RD_CONST_TX_SEQ_INIT (0x1<<6)
#define FCOE_TCE_TX_WR_RX_RD_CONST_TX_SEQ_INIT_SHIFT 6
#define FCOE_TCE_TX_WR_RX_RD_CONST_RSRV2 (0x1<<7)
#define FCOE_TCE_TX_WR_RX_RD_CONST_RSRV2_SHIFT 7
	vmk_uint16 rsrv3;
	vmk_uint32 verify_tx_seq;
};

/*
 * tce_tx_wr_rx_rd $$KEEP_ENDIANNESS$$
 */
struct fcoe_tce_tx_wr_rx_rd {
	union fcoe_tx_wr_rx_rd_union_ctx union_ctx;
	struct fcoe_tce_tx_wr_rx_rd_const const_ctx;
};

/*
 * tce_rx_wr_tx_rd_const $$KEEP_ENDIANNESS$$
 */
struct fcoe_tce_rx_wr_tx_rd_const {
	vmk_uint32 data_2_trns;
	vmk_uint32 init_flags;
#define FCOE_TCE_RX_WR_TX_RD_CONST_CID (0xFFFFFF<<0)
#define FCOE_TCE_RX_WR_TX_RD_CONST_CID_SHIFT 0
#define FCOE_TCE_RX_WR_TX_RD_CONST_RSRV0 (0xFF<<24)
#define FCOE_TCE_RX_WR_TX_RD_CONST_RSRV0_SHIFT 24
};

/*
 * tce_rx_wr_tx_rd_var $$KEEP_ENDIANNESS$$
 */
struct fcoe_tce_rx_wr_tx_rd_var {
	vmk_uint16 rx_flags;
#define FCOE_TCE_RX_WR_TX_RD_VAR_RSRV1 (0xF<<0)
#define FCOE_TCE_RX_WR_TX_RD_VAR_RSRV1_SHIFT 0
#define FCOE_TCE_RX_WR_TX_RD_VAR_NUM_RQ_WQE (0x7<<4)
#define FCOE_TCE_RX_WR_TX_RD_VAR_NUM_RQ_WQE_SHIFT 4
#define FCOE_TCE_RX_WR_TX_RD_VAR_CONF_REQ (0x1<<7)
#define FCOE_TCE_RX_WR_TX_RD_VAR_CONF_REQ_SHIFT 7
#define FCOE_TCE_RX_WR_TX_RD_VAR_RX_STATE (0xF<<8)
#define FCOE_TCE_RX_WR_TX_RD_VAR_RX_STATE_SHIFT 8
#define FCOE_TCE_RX_WR_TX_RD_VAR_EXP_FIRST_FRAME (0x1<<12)
#define FCOE_TCE_RX_WR_TX_RD_VAR_EXP_FIRST_FRAME_SHIFT 12
#define FCOE_TCE_RX_WR_TX_RD_VAR_RX_SEQ_INIT (0x1<<13)
#define FCOE_TCE_RX_WR_TX_RD_VAR_RX_SEQ_INIT_SHIFT 13
#define FCOE_TCE_RX_WR_TX_RD_VAR_RSRV2 (0x1<<14)
#define FCOE_TCE_RX_WR_TX_RD_VAR_RSRV2_SHIFT 14
#define FCOE_TCE_RX_WR_TX_RD_VAR_RX_VALID (0x1<<15)
#define FCOE_TCE_RX_WR_TX_RD_VAR_RX_VALID_SHIFT 15
	vmk_uint16 rx_id;
	struct fcoe_fcp_xfr_rdy_payload fcp_xfr_rdy;
};

/*
 * tce_rx_wr_tx_rd $$KEEP_ENDIANNESS$$
 */
struct fcoe_tce_rx_wr_tx_rd {
	struct fcoe_tce_rx_wr_tx_rd_const const_ctx;
	struct fcoe_tce_rx_wr_tx_rd_var var_ctx;
};

/*
 * tce_rx_only $$KEEP_ENDIANNESS$$
 */
struct fcoe_tce_rx_only {
	struct fcoe_rx_seq_ctx rx_seq_ctx;
	union fcoe_rx_wr_union_ctx union_ctx;
};

/*
 * task_ctx_entry $$KEEP_ENDIANNESS$$
 */
struct fcoe_task_ctx_entry {
	struct fcoe_tce_tx_only txwr_only;
	struct fcoe_tce_tx_wr_rx_rd txwr_rxrd;
	struct fcoe_tce_rx_wr_tx_rd rxwr_txrd;
	struct fcoe_tce_rx_only rxwr_only;
};



/*
 * FCoE XFRQ element $$KEEP_ENDIANNESS$$
 */
struct fcoe_xfrqe {
	vmk_uint16 wqe;
#define FCOE_XFRQE_TASK_ID (0x7FFF<<0)
#define FCOE_XFRQE_TASK_ID_SHIFT 0
#define FCOE_XFRQE_TOGGLE_BIT (0x1<<15)
#define FCOE_XFRQE_TOGGLE_BIT_SHIFT 15
};


/*
 * Cached SGEs $$KEEP_ENDIANNESS$$
 */
struct common_fcoe_sgl {
	struct fcoe_bd_ctx sge[3];
};


/*
 * FCoE SQ\XFRQ element
 */
struct fcoe_cached_wqe {
	struct fcoe_sqe sqe;
	struct fcoe_xfrqe xfrqe;
};


/*
 * FCoE connection enable\disable params passed by driver to FW in FCoE enable ramrod $$KEEP_ENDIANNESS$$
 */
struct fcoe_conn_enable_disable_ramrod_params {
	struct fcoe_kwqe_conn_enable_disable enable_disable_kwqe;
};


/*
 * FCoE connection offload params passed by driver to FW in FCoE offload ramrod $$KEEP_ENDIANNESS$$
 */
struct fcoe_conn_offload_ramrod_params {
	struct fcoe_kwqe_conn_offload1 offload_kwqe1;
	struct fcoe_kwqe_conn_offload2 offload_kwqe2;
	struct fcoe_kwqe_conn_offload3 offload_kwqe3;
	struct fcoe_kwqe_conn_offload4 offload_kwqe4;
};


struct ustorm_fcoe_mng_ctx {
#if defined(__BIG_ENDIAN)
	vmk_uint8 mid_seq_proc_flag;
	vmk_uint8 tce_in_cam_flag;
	vmk_uint8 tce_on_ior_flag;
	vmk_uint8 en_cached_tce_flag;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 en_cached_tce_flag;
	vmk_uint8 tce_on_ior_flag;
	vmk_uint8 tce_in_cam_flag;
	vmk_uint8 mid_seq_proc_flag;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint8 tce_cam_addr;
	vmk_uint8 cached_conn_flag;
	vmk_uint16 rsrv0;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 rsrv0;
	vmk_uint8 cached_conn_flag;
	vmk_uint8 tce_cam_addr;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint16 dma_tce_ram_addr;
	vmk_uint16 tce_ram_addr;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 tce_ram_addr;
	vmk_uint16 dma_tce_ram_addr;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint16 ox_id;
	vmk_uint16 wr_done_seq;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 wr_done_seq;
	vmk_uint16 ox_id;
#endif
	struct regpair task_addr;
};

/*
 * Parameters initialized during offloaded according to FLOGI/PLOGI/PRLI and used in FCoE context section
 */
struct ustorm_fcoe_params {
#if defined(__BIG_ENDIAN)
	vmk_uint16 fcoe_conn_id;
	vmk_uint16 flags;
#define USTORM_FCOE_PARAMS_B_MUL_N_PORT_IDS (0x1<<0)
#define USTORM_FCOE_PARAMS_B_MUL_N_PORT_IDS_SHIFT 0
#define USTORM_FCOE_PARAMS_B_E_D_TOV_RES (0x1<<1)
#define USTORM_FCOE_PARAMS_B_E_D_TOV_RES_SHIFT 1
#define USTORM_FCOE_PARAMS_B_CONT_INCR_SEQ_CNT (0x1<<2)
#define USTORM_FCOE_PARAMS_B_CONT_INCR_SEQ_CNT_SHIFT 2
#define USTORM_FCOE_PARAMS_B_CONF_REQ (0x1<<3)
#define USTORM_FCOE_PARAMS_B_CONF_REQ_SHIFT 3
#define USTORM_FCOE_PARAMS_B_REC_VALID (0x1<<4)
#define USTORM_FCOE_PARAMS_B_REC_VALID_SHIFT 4
#define USTORM_FCOE_PARAMS_B_CQ_TOGGLE_BIT (0x1<<5)
#define USTORM_FCOE_PARAMS_B_CQ_TOGGLE_BIT_SHIFT 5
#define USTORM_FCOE_PARAMS_B_XFRQ_TOGGLE_BIT (0x1<<6)
#define USTORM_FCOE_PARAMS_B_XFRQ_TOGGLE_BIT_SHIFT 6
#define USTORM_FCOE_PARAMS_RSRV0 (0x1FF<<7)
#define USTORM_FCOE_PARAMS_RSRV0_SHIFT 7
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 flags;
#define USTORM_FCOE_PARAMS_B_MUL_N_PORT_IDS (0x1<<0)
#define USTORM_FCOE_PARAMS_B_MUL_N_PORT_IDS_SHIFT 0
#define USTORM_FCOE_PARAMS_B_E_D_TOV_RES (0x1<<1)
#define USTORM_FCOE_PARAMS_B_E_D_TOV_RES_SHIFT 1
#define USTORM_FCOE_PARAMS_B_CONT_INCR_SEQ_CNT (0x1<<2)
#define USTORM_FCOE_PARAMS_B_CONT_INCR_SEQ_CNT_SHIFT 2
#define USTORM_FCOE_PARAMS_B_CONF_REQ (0x1<<3)
#define USTORM_FCOE_PARAMS_B_CONF_REQ_SHIFT 3
#define USTORM_FCOE_PARAMS_B_REC_VALID (0x1<<4)
#define USTORM_FCOE_PARAMS_B_REC_VALID_SHIFT 4
#define USTORM_FCOE_PARAMS_B_CQ_TOGGLE_BIT (0x1<<5)
#define USTORM_FCOE_PARAMS_B_CQ_TOGGLE_BIT_SHIFT 5
#define USTORM_FCOE_PARAMS_B_XFRQ_TOGGLE_BIT (0x1<<6)
#define USTORM_FCOE_PARAMS_B_XFRQ_TOGGLE_BIT_SHIFT 6
#define USTORM_FCOE_PARAMS_RSRV0 (0x1FF<<7)
#define USTORM_FCOE_PARAMS_RSRV0_SHIFT 7
	vmk_uint16 fcoe_conn_id;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint8 hc_csdm_byte_en;
	vmk_uint8 func_id;
	vmk_uint8 port_id;
	vmk_uint8 vnic_id;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 vnic_id;
	vmk_uint8 port_id;
	vmk_uint8 func_id;
	vmk_uint8 hc_csdm_byte_en;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint16 rx_total_conc_seqs;
	vmk_uint16 rx_max_fc_pay_len;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 rx_max_fc_pay_len;
	vmk_uint16 rx_total_conc_seqs;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint8 task_pbe_idx_off;
	vmk_uint8 task_in_page_log_size;
	vmk_uint16 rx_max_conc_seqs;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 rx_max_conc_seqs;
	vmk_uint8 task_in_page_log_size;
	vmk_uint8 task_pbe_idx_off;
#endif
};

/*
 * FCoE 16-bits index structure
 */
struct fcoe_idx16_fields {
	vmk_uint16 fields;
#define FCOE_IDX16_FIELDS_IDX (0x7FFF<<0)
#define FCOE_IDX16_FIELDS_IDX_SHIFT 0
#define FCOE_IDX16_FIELDS_MSB (0x1<<15)
#define FCOE_IDX16_FIELDS_MSB_SHIFT 15
};

/*
 * FCoE 16-bits index union
 */
union fcoe_idx16_field_union {
	struct fcoe_idx16_fields fields;
	vmk_uint16 val;
};

/*
 * Parameters required for placement according to SGL
 */
struct ustorm_fcoe_data_place_mng {
#if defined(__BIG_ENDIAN)
	vmk_uint16 sge_off;
	vmk_uint8 num_sges;
	vmk_uint8 sge_idx;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 sge_idx;
	vmk_uint8 num_sges;
	vmk_uint16 sge_off;
#endif
};

/*
 * Parameters required for placement according to SGL
 */
struct ustorm_fcoe_data_place {
	struct ustorm_fcoe_data_place_mng cached_mng;
	struct fcoe_bd_ctx cached_sge[2];
};

/*
 * TX processing shall write and RX processing shall read from this section
 */
union fcoe_u_tce_tx_wr_rx_rd_union {
	struct fcoe_abts_info abts;
	struct fcoe_cleanup_info cleanup;
	struct fcoe_fw_tx_seq_ctx tx_seq_ctx;
	vmk_uint32 opaque[2];
};

/*
 * TX processing shall write and RX processing shall read from this section
 */
struct fcoe_u_tce_tx_wr_rx_rd {
	union fcoe_u_tce_tx_wr_rx_rd_union union_ctx;
	struct fcoe_tce_tx_wr_rx_rd_const const_ctx;
};

struct ustorm_fcoe_tce {
	struct fcoe_u_tce_tx_wr_rx_rd txwr_rxrd;
	struct fcoe_tce_rx_wr_tx_rd rxwr_txrd;
	struct fcoe_tce_rx_only rxwr;
};

struct ustorm_fcoe_cache_ctx {
	vmk_uint32 rsrv0;
	struct ustorm_fcoe_data_place data_place;
	struct ustorm_fcoe_tce tce;
};

/*
 * Ustorm FCoE Storm Context
 */
struct ustorm_fcoe_st_context {
	struct ustorm_fcoe_mng_ctx mng_ctx;
	struct ustorm_fcoe_params fcoe_params;
	struct regpair cq_base_addr;
	struct regpair rq_pbl_base;
	struct regpair rq_cur_page_addr;
	struct regpair confq_pbl_base_addr;
	struct regpair conn_db_base;
	struct regpair xfrq_base_addr;
	struct regpair lcq_base_addr;
#if defined(__BIG_ENDIAN)
	union fcoe_idx16_field_union rq_cons;
	union fcoe_idx16_field_union rq_prod;
#elif defined(__LITTLE_ENDIAN)
	union fcoe_idx16_field_union rq_prod;
	union fcoe_idx16_field_union rq_cons;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint16 xfrq_prod;
	vmk_uint16 cq_cons;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 cq_cons;
	vmk_uint16 xfrq_prod;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint16 lcq_cons;
	vmk_uint16 hc_cram_address;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 hc_cram_address;
	vmk_uint16 lcq_cons;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint16 sq_xfrq_lcq_confq_size;
	vmk_uint16 confq_prod;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 confq_prod;
	vmk_uint16 sq_xfrq_lcq_confq_size;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint8 hc_csdm_agg_int;
	vmk_uint8 rsrv2;
	vmk_uint8 available_rqes;
	vmk_uint8 sp_q_flush_cnt;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 sp_q_flush_cnt;
	vmk_uint8 available_rqes;
	vmk_uint8 rsrv2;
	vmk_uint8 hc_csdm_agg_int;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint16 num_pend_tasks;
	vmk_uint16 pbf_ack_ram_addr;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 pbf_ack_ram_addr;
	vmk_uint16 num_pend_tasks;
#endif
	struct ustorm_fcoe_cache_ctx cache_ctx;
};

/*
 * The FCoE non-aggregative context of Tstorm
 */
struct tstorm_fcoe_st_context {
	struct regpair reserved0;
	struct regpair reserved1;
};

/*
 * Ethernet context section
 */
struct xstorm_fcoe_eth_context_section {
#if defined(__BIG_ENDIAN)
	vmk_uint8 remote_addr_4;
	vmk_uint8 remote_addr_5;
	vmk_uint8 local_addr_0;
	vmk_uint8 local_addr_1;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 local_addr_1;
	vmk_uint8 local_addr_0;
	vmk_uint8 remote_addr_5;
	vmk_uint8 remote_addr_4;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint8 remote_addr_0;
	vmk_uint8 remote_addr_1;
	vmk_uint8 remote_addr_2;
	vmk_uint8 remote_addr_3;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 remote_addr_3;
	vmk_uint8 remote_addr_2;
	vmk_uint8 remote_addr_1;
	vmk_uint8 remote_addr_0;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint16 reserved_vlan_type;
	vmk_uint16 params;
#define XSTORM_FCOE_ETH_CONTEXT_SECTION_VLAN_ID (0xFFF<<0)
#define XSTORM_FCOE_ETH_CONTEXT_SECTION_VLAN_ID_SHIFT 0
#define XSTORM_FCOE_ETH_CONTEXT_SECTION_CFI (0x1<<12)
#define XSTORM_FCOE_ETH_CONTEXT_SECTION_CFI_SHIFT 12
#define XSTORM_FCOE_ETH_CONTEXT_SECTION_PRIORITY (0x7<<13)
#define XSTORM_FCOE_ETH_CONTEXT_SECTION_PRIORITY_SHIFT 13
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 params;
#define XSTORM_FCOE_ETH_CONTEXT_SECTION_VLAN_ID (0xFFF<<0)
#define XSTORM_FCOE_ETH_CONTEXT_SECTION_VLAN_ID_SHIFT 0
#define XSTORM_FCOE_ETH_CONTEXT_SECTION_CFI (0x1<<12)
#define XSTORM_FCOE_ETH_CONTEXT_SECTION_CFI_SHIFT 12
#define XSTORM_FCOE_ETH_CONTEXT_SECTION_PRIORITY (0x7<<13)
#define XSTORM_FCOE_ETH_CONTEXT_SECTION_PRIORITY_SHIFT 13
	vmk_uint16 reserved_vlan_type;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint8 local_addr_2;
	vmk_uint8 local_addr_3;
	vmk_uint8 local_addr_4;
	vmk_uint8 local_addr_5;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 local_addr_5;
	vmk_uint8 local_addr_4;
	vmk_uint8 local_addr_3;
	vmk_uint8 local_addr_2;
#endif
};

/*
 * Flags used in FCoE context section - 1 byte
 */
struct xstorm_fcoe_context_flags {
	vmk_uint8 flags;
#define XSTORM_FCOE_CONTEXT_FLAGS_B_PROC_Q (0x3<<0)
#define XSTORM_FCOE_CONTEXT_FLAGS_B_PROC_Q_SHIFT 0
#define XSTORM_FCOE_CONTEXT_FLAGS_B_MID_SEQ (0x1<<2)
#define XSTORM_FCOE_CONTEXT_FLAGS_B_MID_SEQ_SHIFT 2
#define XSTORM_FCOE_CONTEXT_FLAGS_B_BLOCK_SQ (0x1<<3)
#define XSTORM_FCOE_CONTEXT_FLAGS_B_BLOCK_SQ_SHIFT 3
#define XSTORM_FCOE_CONTEXT_FLAGS_B_REC_SUPPORT (0x1<<4)
#define XSTORM_FCOE_CONTEXT_FLAGS_B_REC_SUPPORT_SHIFT 4
#define XSTORM_FCOE_CONTEXT_FLAGS_B_SQ_TOGGLE (0x1<<5)
#define XSTORM_FCOE_CONTEXT_FLAGS_B_SQ_TOGGLE_SHIFT 5
#define XSTORM_FCOE_CONTEXT_FLAGS_B_XFRQ_TOGGLE (0x1<<6)
#define XSTORM_FCOE_CONTEXT_FLAGS_B_XFRQ_TOGGLE_SHIFT 6
#define XSTORM_FCOE_CONTEXT_FLAGS_RESERVED0 (0x1<<7)
#define XSTORM_FCOE_CONTEXT_FLAGS_RESERVED0_SHIFT 7
};

struct xstorm_fcoe_tce {
	struct fcoe_tce_tx_only txwr;
	struct fcoe_tce_tx_wr_rx_rd txwr_rxrd;
};

/*
 * FCP_DATA parameters required for transmission
 */
struct xstorm_fcoe_fcp_data {
	vmk_uint32 io_rem;
#if defined(__BIG_ENDIAN)
	vmk_uint16 cached_sge_off;
	vmk_uint8 cached_num_sges;
	vmk_uint8 cached_sge_idx;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 cached_sge_idx;
	vmk_uint8 cached_num_sges;
	vmk_uint16 cached_sge_off;
#endif
	vmk_uint32 buf_addr_hi_0;
	vmk_uint32 buf_addr_lo_0;
#if defined(__BIG_ENDIAN)
	vmk_uint16 num_of_pending_tasks;
	vmk_uint16 buf_len_0;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 buf_len_0;
	vmk_uint16 num_of_pending_tasks;
#endif
	vmk_uint32 buf_addr_hi_1;
	vmk_uint32 buf_addr_lo_1;
#if defined(__BIG_ENDIAN)
	vmk_uint16 task_pbe_idx_off;
	vmk_uint16 buf_len_1;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 buf_len_1;
	vmk_uint16 task_pbe_idx_off;
#endif
	vmk_uint32 buf_addr_hi_2;
	vmk_uint32 buf_addr_lo_2;
#if defined(__BIG_ENDIAN)
	vmk_uint16 ox_id;
	vmk_uint16 buf_len_2;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 buf_len_2;
	vmk_uint16 ox_id;
#endif
};

/*
 * FCoE 16-bits vlan structure
 */
struct fcoe_vlan_fields {
	vmk_uint16 fields;
#define FCOE_VLAN_FIELDS_VID (0xFFF<<0)
#define FCOE_VLAN_FIELDS_VID_SHIFT 0
#define FCOE_VLAN_FIELDS_CLI (0x1<<12)
#define FCOE_VLAN_FIELDS_CLI_SHIFT 12
#define FCOE_VLAN_FIELDS_PRI (0x7<<13)
#define FCOE_VLAN_FIELDS_PRI_SHIFT 13
};

/*
 * FCoE 16-bits vlan union
 */
union fcoe_vlan_field_union {
	struct fcoe_vlan_fields fields;
	vmk_uint16 val;
};

/*
 * FCoE 16-bits vlan, vif union
 */
union fcoe_vlan_vif_field_union {
	union fcoe_vlan_field_union vlan;
	vmk_uint16 vif;
};

/*
 * FCoE context section
 */
struct xstorm_fcoe_context_section {
#if defined(__BIG_ENDIAN)
	vmk_uint8 cs_ctl;
	vmk_uint8 s_id[3];
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 s_id[3];
	vmk_uint8 cs_ctl;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint8 rctl;
	vmk_uint8 d_id[3];
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 d_id[3];
	vmk_uint8 rctl;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint16 sq_xfrq_lcq_confq_size;
	vmk_uint16 tx_max_fc_pay_len;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 tx_max_fc_pay_len;
	vmk_uint16 sq_xfrq_lcq_confq_size;
#endif
	vmk_uint32 lcq_prod;
#if defined(__BIG_ENDIAN)
	vmk_uint8 port_id;
	vmk_uint8 func_id;
	vmk_uint8 seq_id;
	struct xstorm_fcoe_context_flags tx_flags;
#elif defined(__LITTLE_ENDIAN)
	struct xstorm_fcoe_context_flags tx_flags;
	vmk_uint8 seq_id;
	vmk_uint8 func_id;
	vmk_uint8 port_id;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint16 mtu;
	vmk_uint8 func_mode;
	vmk_uint8 vnic_id;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 vnic_id;
	vmk_uint8 func_mode;
	vmk_uint16 mtu;
#endif
	struct regpair confq_curr_page_addr;
	struct fcoe_cached_wqe cached_wqe[8];
	struct regpair lcq_base_addr;
	struct xstorm_fcoe_tce tce;
	struct xstorm_fcoe_fcp_data fcp_data;
#if defined(__BIG_ENDIAN)
	vmk_uint8 tx_max_conc_seqs_c3;
	vmk_uint8 vlan_flag;
	vmk_uint8 vntag_vlan;
	vmk_uint8 data_pb_cmd_size;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 data_pb_cmd_size;
	vmk_uint8 vntag_vlan;
	vmk_uint8 vlan_flag;
	vmk_uint8 tx_max_conc_seqs_c3;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint16 fcoe_tx_stat_params_ram_addr;
	vmk_uint16 fcoe_tx_fc_seq_ram_addr;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 fcoe_tx_fc_seq_ram_addr;
	vmk_uint16 fcoe_tx_stat_params_ram_addr;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint8 fcp_cmd_line_credit;
	vmk_uint8 eth_hdr_size;
	vmk_uint16 pbf_addr;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 pbf_addr;
	vmk_uint8 eth_hdr_size;
	vmk_uint8 fcp_cmd_line_credit;
#endif
#if defined(__BIG_ENDIAN)
	union fcoe_vlan_vif_field_union multi_func_val;
	vmk_uint8 page_log_size;
	vmk_uint8 all_conf_version;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 all_conf_version;
	vmk_uint8 page_log_size;
	union fcoe_vlan_vif_field_union multi_func_val;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint16 fcp_cmd_frame_size;
	vmk_uint16 pbf_addr_ff;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 pbf_addr_ff;
	vmk_uint16 fcp_cmd_frame_size;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint8 vlan_num;
	vmk_uint8 cos;
	vmk_uint8 cache_xfrq_cons;
	vmk_uint8 cache_sq_cons;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 cache_sq_cons;
	vmk_uint8 cache_xfrq_cons;
	vmk_uint8 cos;
	vmk_uint8 vlan_num;
#endif
	vmk_uint32 verify_tx_seq;
};

/*
 * Xstorm FCoE Storm Context
 */
struct xstorm_fcoe_st_context {
	struct xstorm_fcoe_eth_context_section eth;
	struct xstorm_fcoe_context_section fcoe;
};

/*
 * Fcoe connection context
 */
struct fcoe_context {
	struct ustorm_fcoe_st_context ustorm_st_context;
	struct tstorm_fcoe_st_context tstorm_st_context;
	struct xstorm_fcoe_ag_context xstorm_ag_context;
	struct tstorm_fcoe_ag_context tstorm_ag_context;
	struct ustorm_fcoe_ag_context ustorm_ag_context;
	struct timers_block_context timers_context;
	struct xstorm_fcoe_st_context xstorm_st_context;
};




/*
 * FCoE init params passed by driver to FW in FCoE init ramrod $$KEEP_ENDIANNESS$$
 */
struct fcoe_init_ramrod_params {
	struct fcoe_kwqe_init1 init_kwqe1;
	struct fcoe_kwqe_init2 init_kwqe2;
	struct fcoe_kwqe_init3 init_kwqe3;
	struct regpair eq_pbl_base;
	vmk_uint32 eq_pbl_size;
	vmk_uint32 reserved2;
	vmk_uint16 eq_prod;
	vmk_uint16 sb_num;
	vmk_uint8 sb_id;
	vmk_uint8 reserved0;
	vmk_uint16 reserved1;
};


/*
 * FCoE statistics params buffer passed by driver to FW in FCoE statistics ramrod $$KEEP_ENDIANNESS$$
 */
struct fcoe_stat_ramrod_params {
	struct fcoe_kwqe_stat stat_kwqe;
};

/*
 * CQ DB CQ producer and pending completion counter
 */
struct iscsi_cq_db_prod_pnd_cmpltn_cnt {
#if defined(__BIG_ENDIAN)
	vmk_uint16 cntr;
	vmk_uint16 prod;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 prod;
	vmk_uint16 cntr;
#endif
};

/*
 * CQ DB pending completion ITT array
 */
struct iscsi_cq_db_prod_pnd_cmpltn_cnt_arr {
	struct iscsi_cq_db_prod_pnd_cmpltn_cnt prod_pend_comp[8];
};

/*
 * Cstorm CQ sequence to notify array, updated by driver
 */
struct iscsi_cq_db_sqn_2_notify_arr {
	vmk_uint16 sqn[8];
};

/*
 * Cstorm iSCSI Storm Context
 */
struct cstorm_iscsi_st_context {
	struct iscsi_cq_db_prod_pnd_cmpltn_cnt_arr cq_c_prod_pend_comp_ctr_arr;
	struct iscsi_cq_db_sqn_2_notify_arr cq_c_prod_sqn_arr;
	struct iscsi_cq_db_sqn_2_notify_arr cq_c_sqn_2_notify_arr;
	struct regpair hq_pbl_base;
	struct regpair hq_curr_pbe;
	struct regpair task_pbl_base;
	struct regpair cq_db_base;
#if defined(__BIG_ENDIAN)
	vmk_uint16 hq_bd_itt;
	vmk_uint16 iscsi_conn_id;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 iscsi_conn_id;
	vmk_uint16 hq_bd_itt;
#endif
	vmk_uint32 hq_bd_data_segment_len;
	vmk_uint32 hq_bd_buffer_offset;
#if defined(__BIG_ENDIAN)
	vmk_uint8 rsrv;
	vmk_uint8 cq_proc_en_bit_map;
	vmk_uint8 cq_pend_comp_itt_valid_bit_map;
	vmk_uint8 hq_bd_opcode;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 hq_bd_opcode;
	vmk_uint8 cq_pend_comp_itt_valid_bit_map;
	vmk_uint8 cq_proc_en_bit_map;
	vmk_uint8 rsrv;
#endif
	vmk_uint32 hq_tcp_seq;
#if defined(__BIG_ENDIAN)
	vmk_uint16 flags;
#define CSTORM_ISCSI_ST_CONTEXT_DATA_DIGEST_EN (0x1<<0)
#define CSTORM_ISCSI_ST_CONTEXT_DATA_DIGEST_EN_SHIFT 0
#define CSTORM_ISCSI_ST_CONTEXT_HDR_DIGEST_EN (0x1<<1)
#define CSTORM_ISCSI_ST_CONTEXT_HDR_DIGEST_EN_SHIFT 1
#define CSTORM_ISCSI_ST_CONTEXT_HQ_BD_CTXT_VALID (0x1<<2)
#define CSTORM_ISCSI_ST_CONTEXT_HQ_BD_CTXT_VALID_SHIFT 2
#define CSTORM_ISCSI_ST_CONTEXT_HQ_BD_LCL_CMPLN_FLG (0x1<<3)
#define CSTORM_ISCSI_ST_CONTEXT_HQ_BD_LCL_CMPLN_FLG_SHIFT 3
#define CSTORM_ISCSI_ST_CONTEXT_HQ_BD_WRITE_TASK (0x1<<4)
#define CSTORM_ISCSI_ST_CONTEXT_HQ_BD_WRITE_TASK_SHIFT 4
#define CSTORM_ISCSI_ST_CONTEXT_CTRL_FLAGS_RSRV (0x7FF<<5)
#define CSTORM_ISCSI_ST_CONTEXT_CTRL_FLAGS_RSRV_SHIFT 5
	vmk_uint16 hq_cons;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 hq_cons;
	vmk_uint16 flags;
#define CSTORM_ISCSI_ST_CONTEXT_DATA_DIGEST_EN (0x1<<0)
#define CSTORM_ISCSI_ST_CONTEXT_DATA_DIGEST_EN_SHIFT 0
#define CSTORM_ISCSI_ST_CONTEXT_HDR_DIGEST_EN (0x1<<1)
#define CSTORM_ISCSI_ST_CONTEXT_HDR_DIGEST_EN_SHIFT 1
#define CSTORM_ISCSI_ST_CONTEXT_HQ_BD_CTXT_VALID (0x1<<2)
#define CSTORM_ISCSI_ST_CONTEXT_HQ_BD_CTXT_VALID_SHIFT 2
#define CSTORM_ISCSI_ST_CONTEXT_HQ_BD_LCL_CMPLN_FLG (0x1<<3)
#define CSTORM_ISCSI_ST_CONTEXT_HQ_BD_LCL_CMPLN_FLG_SHIFT 3
#define CSTORM_ISCSI_ST_CONTEXT_HQ_BD_WRITE_TASK (0x1<<4)
#define CSTORM_ISCSI_ST_CONTEXT_HQ_BD_WRITE_TASK_SHIFT 4
#define CSTORM_ISCSI_ST_CONTEXT_CTRL_FLAGS_RSRV (0x7FF<<5)
#define CSTORM_ISCSI_ST_CONTEXT_CTRL_FLAGS_RSRV_SHIFT 5
#endif
	struct regpair rsrv1;
};


/*
 * SCSI read/write SQ WQE
 */
struct iscsi_cmd_pdu_hdr_little_endian {
#if defined(__BIG_ENDIAN)
	vmk_uint8 opcode;
	vmk_uint8 op_attr;
#define ISCSI_CMD_PDU_HDR_LITTLE_ENDIAN_ATTRIBUTES (0x7<<0)
#define ISCSI_CMD_PDU_HDR_LITTLE_ENDIAN_ATTRIBUTES_SHIFT 0
#define ISCSI_CMD_PDU_HDR_LITTLE_ENDIAN_RSRV1 (0x3<<3)
#define ISCSI_CMD_PDU_HDR_LITTLE_ENDIAN_RSRV1_SHIFT 3
#define ISCSI_CMD_PDU_HDR_LITTLE_ENDIAN_WRITE_FLAG (0x1<<5)
#define ISCSI_CMD_PDU_HDR_LITTLE_ENDIAN_WRITE_FLAG_SHIFT 5
#define ISCSI_CMD_PDU_HDR_LITTLE_ENDIAN_READ_FLAG (0x1<<6)
#define ISCSI_CMD_PDU_HDR_LITTLE_ENDIAN_READ_FLAG_SHIFT 6
#define ISCSI_CMD_PDU_HDR_LITTLE_ENDIAN_FINAL_FLAG (0x1<<7)
#define ISCSI_CMD_PDU_HDR_LITTLE_ENDIAN_FINAL_FLAG_SHIFT 7
	vmk_uint16 rsrv0;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 rsrv0;
	vmk_uint8 op_attr;
#define ISCSI_CMD_PDU_HDR_LITTLE_ENDIAN_ATTRIBUTES (0x7<<0)
#define ISCSI_CMD_PDU_HDR_LITTLE_ENDIAN_ATTRIBUTES_SHIFT 0
#define ISCSI_CMD_PDU_HDR_LITTLE_ENDIAN_RSRV1 (0x3<<3)
#define ISCSI_CMD_PDU_HDR_LITTLE_ENDIAN_RSRV1_SHIFT 3
#define ISCSI_CMD_PDU_HDR_LITTLE_ENDIAN_WRITE_FLAG (0x1<<5)
#define ISCSI_CMD_PDU_HDR_LITTLE_ENDIAN_WRITE_FLAG_SHIFT 5
#define ISCSI_CMD_PDU_HDR_LITTLE_ENDIAN_READ_FLAG (0x1<<6)
#define ISCSI_CMD_PDU_HDR_LITTLE_ENDIAN_READ_FLAG_SHIFT 6
#define ISCSI_CMD_PDU_HDR_LITTLE_ENDIAN_FINAL_FLAG (0x1<<7)
#define ISCSI_CMD_PDU_HDR_LITTLE_ENDIAN_FINAL_FLAG_SHIFT 7
	vmk_uint8 opcode;
#endif
	vmk_uint32 data_fields;
#define ISCSI_CMD_PDU_HDR_LITTLE_ENDIAN_DATA_SEGMENT_LENGTH (0xFFFFFF<<0)
#define ISCSI_CMD_PDU_HDR_LITTLE_ENDIAN_DATA_SEGMENT_LENGTH_SHIFT 0
#define ISCSI_CMD_PDU_HDR_LITTLE_ENDIAN_TOTAL_AHS_LENGTH (0xFF<<24)
#define ISCSI_CMD_PDU_HDR_LITTLE_ENDIAN_TOTAL_AHS_LENGTH_SHIFT 24
	struct regpair lun;
	vmk_uint32 itt;
	vmk_uint32 expected_data_transfer_length;
	vmk_uint32 cmd_sn;
	vmk_uint32 exp_stat_sn;
	vmk_uint32 scsi_command_block[4];
};


/*
 * Buffer per connection, used in Tstorm
 */
struct iscsi_conn_buf {
	struct regpair reserved[8];
};


/*
 * iSCSI context region, used only in iSCSI
 */
struct ustorm_iscsi_rq_db {
	struct regpair pbl_base;
	struct regpair curr_pbe;
};

/*
 * iSCSI context region, used only in iSCSI
 */
struct ustorm_iscsi_r2tq_db {
	struct regpair pbl_base;
	struct regpair curr_pbe;
};

/*
 * iSCSI context region, used only in iSCSI
 */
struct ustorm_iscsi_cq_db {
#if defined(__BIG_ENDIAN)
	vmk_uint16 cq_sn;
	vmk_uint16 prod;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 prod;
	vmk_uint16 cq_sn;
#endif
	struct regpair curr_pbe;
};

/*
 * iSCSI context region, used only in iSCSI
 */
struct rings_db {
	struct ustorm_iscsi_rq_db rq;
	struct ustorm_iscsi_r2tq_db r2tq;
	struct ustorm_iscsi_cq_db cq[8];
#if defined(__BIG_ENDIAN)
	vmk_uint16 rq_prod;
	vmk_uint16 r2tq_prod;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 r2tq_prod;
	vmk_uint16 rq_prod;
#endif
	struct regpair cq_pbl_base;
};

/*
 * iSCSI context region, used only in iSCSI
 */
struct ustorm_iscsi_placement_db {
	vmk_uint32 sgl_base_lo;
	vmk_uint32 sgl_base_hi;
	vmk_uint32 local_sge_0_address_hi;
	vmk_uint32 local_sge_0_address_lo;
#if defined(__BIG_ENDIAN)
	vmk_uint16 curr_sge_offset;
	vmk_uint16 local_sge_0_size;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 local_sge_0_size;
	vmk_uint16 curr_sge_offset;
#endif
	vmk_uint32 local_sge_1_address_hi;
	vmk_uint32 local_sge_1_address_lo;
#if defined(__BIG_ENDIAN)
	vmk_uint8 exp_padding_2b;
	vmk_uint8 nal_len_3b;
	vmk_uint16 local_sge_1_size;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 local_sge_1_size;
	vmk_uint8 nal_len_3b;
	vmk_uint8 exp_padding_2b;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint8 sgl_size;
	vmk_uint8 local_sge_index_2b;
	vmk_uint16 reserved7;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 reserved7;
	vmk_uint8 local_sge_index_2b;
	vmk_uint8 sgl_size;
#endif
	vmk_uint32 rem_pdu;
	vmk_uint32 place_db_bitfield_1;
#define USTORM_ISCSI_PLACEMENT_DB_REM_PDU_PAYLOAD (0xFFFFFF<<0)
#define USTORM_ISCSI_PLACEMENT_DB_REM_PDU_PAYLOAD_SHIFT 0
#define USTORM_ISCSI_PLACEMENT_DB_CQ_ID (0xFF<<24)
#define USTORM_ISCSI_PLACEMENT_DB_CQ_ID_SHIFT 24
	vmk_uint32 place_db_bitfield_2;
#define USTORM_ISCSI_PLACEMENT_DB_BYTES_2_TRUNCATE (0xFFFFFF<<0)
#define USTORM_ISCSI_PLACEMENT_DB_BYTES_2_TRUNCATE_SHIFT 0
#define USTORM_ISCSI_PLACEMENT_DB_HOST_SGE_INDEX (0xFF<<24)
#define USTORM_ISCSI_PLACEMENT_DB_HOST_SGE_INDEX_SHIFT 24
	vmk_uint32 nal;
#define USTORM_ISCSI_PLACEMENT_DB_REM_SGE_SIZE (0xFFFFFF<<0)
#define USTORM_ISCSI_PLACEMENT_DB_REM_SGE_SIZE_SHIFT 0
#define USTORM_ISCSI_PLACEMENT_DB_EXP_DIGEST_3B (0xFF<<24)
#define USTORM_ISCSI_PLACEMENT_DB_EXP_DIGEST_3B_SHIFT 24
};

/*
 * Ustorm iSCSI Storm Context
 */
struct ustorm_iscsi_st_context {
	vmk_uint32 exp_stat_sn;
	vmk_uint32 exp_data_sn;
	struct rings_db ring;
	struct regpair task_pbl_base;
	struct regpair tce_phy_addr;
	struct ustorm_iscsi_placement_db place_db;
	vmk_uint32 reserved8;
	vmk_uint32 rem_rcv_len;
#if defined(__BIG_ENDIAN)
	vmk_uint16 hdr_itt;
	vmk_uint16 iscsi_conn_id;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 iscsi_conn_id;
	vmk_uint16 hdr_itt;
#endif
	vmk_uint32 nal_bytes;
#if defined(__BIG_ENDIAN)
	vmk_uint8 hdr_second_byte_union;
	vmk_uint8 bitfield_0;
#define USTORM_ISCSI_ST_CONTEXT_BMIDDLEOFPDU (0x1<<0)
#define USTORM_ISCSI_ST_CONTEXT_BMIDDLEOFPDU_SHIFT 0
#define USTORM_ISCSI_ST_CONTEXT_BFENCECQE (0x1<<1)
#define USTORM_ISCSI_ST_CONTEXT_BFENCECQE_SHIFT 1
#define USTORM_ISCSI_ST_CONTEXT_BRESETCRC (0x1<<2)
#define USTORM_ISCSI_ST_CONTEXT_BRESETCRC_SHIFT 2
#define USTORM_ISCSI_ST_CONTEXT_RESERVED1 (0x1F<<3)
#define USTORM_ISCSI_ST_CONTEXT_RESERVED1_SHIFT 3
	vmk_uint8 task_pdu_cache_index;
	vmk_uint8 task_pbe_cache_index;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 task_pbe_cache_index;
	vmk_uint8 task_pdu_cache_index;
	vmk_uint8 bitfield_0;
#define USTORM_ISCSI_ST_CONTEXT_BMIDDLEOFPDU (0x1<<0)
#define USTORM_ISCSI_ST_CONTEXT_BMIDDLEOFPDU_SHIFT 0
#define USTORM_ISCSI_ST_CONTEXT_BFENCECQE (0x1<<1)
#define USTORM_ISCSI_ST_CONTEXT_BFENCECQE_SHIFT 1
#define USTORM_ISCSI_ST_CONTEXT_BRESETCRC (0x1<<2)
#define USTORM_ISCSI_ST_CONTEXT_BRESETCRC_SHIFT 2
#define USTORM_ISCSI_ST_CONTEXT_RESERVED1 (0x1F<<3)
#define USTORM_ISCSI_ST_CONTEXT_RESERVED1_SHIFT 3
	vmk_uint8 hdr_second_byte_union;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint16 reserved3;
	vmk_uint8 reserved2;
	vmk_uint8 acDecrement;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 acDecrement;
	vmk_uint8 reserved2;
	vmk_uint16 reserved3;
#endif
	vmk_uint32 task_stat;
#if defined(__BIG_ENDIAN)
	vmk_uint8 hdr_opcode;
	vmk_uint8 num_cqs;
	vmk_uint16 reserved5;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 reserved5;
	vmk_uint8 num_cqs;
	vmk_uint8 hdr_opcode;
#endif
	vmk_uint32 negotiated_rx;
#define USTORM_ISCSI_ST_CONTEXT_MAX_RECV_PDU_LENGTH (0xFFFFFF<<0)
#define USTORM_ISCSI_ST_CONTEXT_MAX_RECV_PDU_LENGTH_SHIFT 0
#define USTORM_ISCSI_ST_CONTEXT_MAX_OUTSTANDING_R2TS (0xFF<<24)
#define USTORM_ISCSI_ST_CONTEXT_MAX_OUTSTANDING_R2TS_SHIFT 24
	vmk_uint32 negotiated_rx_and_flags;
#define USTORM_ISCSI_ST_CONTEXT_MAX_BURST_LENGTH (0xFFFFFF<<0)
#define USTORM_ISCSI_ST_CONTEXT_MAX_BURST_LENGTH_SHIFT 0
#define USTORM_ISCSI_ST_CONTEXT_B_CQE_POSTED_OR_HEADER_CACHED (0x1<<24)
#define USTORM_ISCSI_ST_CONTEXT_B_CQE_POSTED_OR_HEADER_CACHED_SHIFT 24
#define USTORM_ISCSI_ST_CONTEXT_B_HDR_DIGEST_EN (0x1<<25)
#define USTORM_ISCSI_ST_CONTEXT_B_HDR_DIGEST_EN_SHIFT 25
#define USTORM_ISCSI_ST_CONTEXT_B_DATA_DIGEST_EN (0x1<<26)
#define USTORM_ISCSI_ST_CONTEXT_B_DATA_DIGEST_EN_SHIFT 26
#define USTORM_ISCSI_ST_CONTEXT_B_PROTOCOL_ERROR (0x1<<27)
#define USTORM_ISCSI_ST_CONTEXT_B_PROTOCOL_ERROR_SHIFT 27
#define USTORM_ISCSI_ST_CONTEXT_B_TASK_VALID (0x1<<28)
#define USTORM_ISCSI_ST_CONTEXT_B_TASK_VALID_SHIFT 28
#define USTORM_ISCSI_ST_CONTEXT_TASK_TYPE (0x3<<29)
#define USTORM_ISCSI_ST_CONTEXT_TASK_TYPE_SHIFT 29
#define USTORM_ISCSI_ST_CONTEXT_B_ALL_DATA_ACKED (0x1<<31)
#define USTORM_ISCSI_ST_CONTEXT_B_ALL_DATA_ACKED_SHIFT 31
};

/*
 * TCP context region, shared in TOE, RDMA and ISCSI
 */
struct tstorm_tcp_st_context_section {
	vmk_uint32 flags1;
#define TSTORM_TCP_ST_CONTEXT_SECTION_RTT_SRTT (0xFFFFFF<<0)
#define TSTORM_TCP_ST_CONTEXT_SECTION_RTT_SRTT_SHIFT 0
#define TSTORM_TCP_ST_CONTEXT_SECTION_PAWS_INVALID (0x1<<24)
#define TSTORM_TCP_ST_CONTEXT_SECTION_PAWS_INVALID_SHIFT 24
#define TSTORM_TCP_ST_CONTEXT_SECTION_TIMESTAMP_EXISTS (0x1<<25)
#define TSTORM_TCP_ST_CONTEXT_SECTION_TIMESTAMP_EXISTS_SHIFT 25
#define TSTORM_TCP_ST_CONTEXT_SECTION_RESERVED0 (0x1<<26)
#define TSTORM_TCP_ST_CONTEXT_SECTION_RESERVED0_SHIFT 26
#define TSTORM_TCP_ST_CONTEXT_SECTION_STOP_RX_PAYLOAD (0x1<<27)
#define TSTORM_TCP_ST_CONTEXT_SECTION_STOP_RX_PAYLOAD_SHIFT 27
#define TSTORM_TCP_ST_CONTEXT_SECTION_KA_ENABLED (0x1<<28)
#define TSTORM_TCP_ST_CONTEXT_SECTION_KA_ENABLED_SHIFT 28
#define TSTORM_TCP_ST_CONTEXT_SECTION_FIRST_RTO_ESTIMATE (0x1<<29)
#define TSTORM_TCP_ST_CONTEXT_SECTION_FIRST_RTO_ESTIMATE_SHIFT 29
#define TSTORM_TCP_ST_CONTEXT_SECTION_MAX_SEG_RETRANSMIT_EN (0x1<<30)
#define TSTORM_TCP_ST_CONTEXT_SECTION_MAX_SEG_RETRANSMIT_EN_SHIFT 30
#define TSTORM_TCP_ST_CONTEXT_SECTION_LAST_ISLE_HAS_FIN (0x1<<31)
#define TSTORM_TCP_ST_CONTEXT_SECTION_LAST_ISLE_HAS_FIN_SHIFT 31
	vmk_uint32 flags2;
#define TSTORM_TCP_ST_CONTEXT_SECTION_RTT_VARIATION (0xFFFFFF<<0)
#define TSTORM_TCP_ST_CONTEXT_SECTION_RTT_VARIATION_SHIFT 0
#define TSTORM_TCP_ST_CONTEXT_SECTION_DA_EN (0x1<<24)
#define TSTORM_TCP_ST_CONTEXT_SECTION_DA_EN_SHIFT 24
#define TSTORM_TCP_ST_CONTEXT_SECTION_DA_COUNTER_EN (0x1<<25)
#define TSTORM_TCP_ST_CONTEXT_SECTION_DA_COUNTER_EN_SHIFT 25
#define __TSTORM_TCP_ST_CONTEXT_SECTION_KA_PROBE_SENT (0x1<<26)
#define __TSTORM_TCP_ST_CONTEXT_SECTION_KA_PROBE_SENT_SHIFT 26
#define __TSTORM_TCP_ST_CONTEXT_SECTION_PERSIST_PROBE_SENT (0x1<<27)
#define __TSTORM_TCP_ST_CONTEXT_SECTION_PERSIST_PROBE_SENT_SHIFT 27
#define TSTORM_TCP_ST_CONTEXT_SECTION_UPDATE_L2_STATSTICS (0x1<<28)
#define TSTORM_TCP_ST_CONTEXT_SECTION_UPDATE_L2_STATSTICS_SHIFT 28
#define TSTORM_TCP_ST_CONTEXT_SECTION_UPDATE_L4_STATSTICS (0x1<<29)
#define TSTORM_TCP_ST_CONTEXT_SECTION_UPDATE_L4_STATSTICS_SHIFT 29
#define __TSTORM_TCP_ST_CONTEXT_SECTION_IN_WINDOW_RST_ATTACK (0x1<<30)
#define __TSTORM_TCP_ST_CONTEXT_SECTION_IN_WINDOW_RST_ATTACK_SHIFT 30
#define __TSTORM_TCP_ST_CONTEXT_SECTION_IN_WINDOW_SYN_ATTACK (0x1<<31)
#define __TSTORM_TCP_ST_CONTEXT_SECTION_IN_WINDOW_SYN_ATTACK_SHIFT 31
#if defined(__BIG_ENDIAN)
	vmk_uint16 mss;
	vmk_uint8 tcp_sm_state;
	vmk_uint8 rto_exp;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 rto_exp;
	vmk_uint8 tcp_sm_state;
	vmk_uint16 mss;
#endif
	vmk_uint32 rcv_nxt;
	vmk_uint32 timestamp_recent;
	vmk_uint32 timestamp_recent_time;
	vmk_uint32 cwnd;
	vmk_uint32 ss_thresh;
	vmk_uint32 cwnd_accum;
	vmk_uint32 prev_seg_seq;
	vmk_uint32 expected_rel_seq;
	vmk_uint32 recover;
#if defined(__BIG_ENDIAN)
	vmk_uint8 retransmit_count;
	vmk_uint8 ka_max_probe_count;
	vmk_uint8 persist_probe_count;
	vmk_uint8 ka_probe_count;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 ka_probe_count;
	vmk_uint8 persist_probe_count;
	vmk_uint8 ka_max_probe_count;
	vmk_uint8 retransmit_count;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint8 statistics_counter_id;
	vmk_uint8 ooo_support_mode;
	vmk_uint8 snd_wnd_scale;
	vmk_uint8 dup_ack_count;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 dup_ack_count;
	vmk_uint8 snd_wnd_scale;
	vmk_uint8 ooo_support_mode;
	vmk_uint8 statistics_counter_id;
#endif
	vmk_uint32 retransmit_start_time;
	vmk_uint32 ka_timeout;
	vmk_uint32 ka_interval;
	vmk_uint32 isle_start_seq;
	vmk_uint32 isle_end_seq;
#if defined(__BIG_ENDIAN)
	vmk_uint16 second_isle_address;
	vmk_uint16 recent_seg_wnd;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 recent_seg_wnd;
	vmk_uint16 second_isle_address;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint8 max_isles_ever_happened;
	vmk_uint8 isles_number;
	vmk_uint16 last_isle_address;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 last_isle_address;
	vmk_uint8 isles_number;
	vmk_uint8 max_isles_ever_happened;
#endif
	vmk_uint32 max_rt_time;
#if defined(__BIG_ENDIAN)
	vmk_uint16 lsb_mac_address;
	vmk_uint16 vlan_id;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 vlan_id;
	vmk_uint16 lsb_mac_address;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint16 msb_mac_address;
	vmk_uint16 mid_mac_address;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 mid_mac_address;
	vmk_uint16 msb_mac_address;
#endif
	vmk_uint32 rightmost_received_seq;
};

/*
 * Termination variables
 */
struct iscsi_term_vars {
	vmk_uint8 BitMap;
#define ISCSI_TERM_VARS_TCP_STATE (0xF<<0)
#define ISCSI_TERM_VARS_TCP_STATE_SHIFT 0
#define ISCSI_TERM_VARS_FIN_RECEIVED_SBIT (0x1<<4)
#define ISCSI_TERM_VARS_FIN_RECEIVED_SBIT_SHIFT 4
#define ISCSI_TERM_VARS_ACK_ON_FIN_RECEIVED_SBIT (0x1<<5)
#define ISCSI_TERM_VARS_ACK_ON_FIN_RECEIVED_SBIT_SHIFT 5
#define ISCSI_TERM_VARS_TERM_ON_CHIP (0x1<<6)
#define ISCSI_TERM_VARS_TERM_ON_CHIP_SHIFT 6
#define ISCSI_TERM_VARS_RSRV (0x1<<7)
#define ISCSI_TERM_VARS_RSRV_SHIFT 7
};

/*
 * iSCSI context region, used only in iSCSI
 */
struct tstorm_iscsi_st_context_section {
	vmk_uint32 nalPayload;
	vmk_uint32 b2nh;
#if defined(__BIG_ENDIAN)
	vmk_uint16 rq_cons;
	vmk_uint8 flags;
#define TSTORM_ISCSI_ST_CONTEXT_SECTION_B_HDR_DIGEST_EN (0x1<<0)
#define TSTORM_ISCSI_ST_CONTEXT_SECTION_B_HDR_DIGEST_EN_SHIFT 0
#define TSTORM_ISCSI_ST_CONTEXT_SECTION_B_DATA_DIGEST_EN (0x1<<1)
#define TSTORM_ISCSI_ST_CONTEXT_SECTION_B_DATA_DIGEST_EN_SHIFT 1
#define TSTORM_ISCSI_ST_CONTEXT_SECTION_B_PARTIAL_HEADER (0x1<<2)
#define TSTORM_ISCSI_ST_CONTEXT_SECTION_B_PARTIAL_HEADER_SHIFT 2
#define TSTORM_ISCSI_ST_CONTEXT_SECTION_B_FULL_FEATURE (0x1<<3)
#define TSTORM_ISCSI_ST_CONTEXT_SECTION_B_FULL_FEATURE_SHIFT 3
#define TSTORM_ISCSI_ST_CONTEXT_SECTION_B_DROP_ALL_PDUS (0x1<<4)
#define TSTORM_ISCSI_ST_CONTEXT_SECTION_B_DROP_ALL_PDUS_SHIFT 4
#define TSTORM_ISCSI_ST_CONTEXT_SECTION_NALLEN (0x3<<5)
#define TSTORM_ISCSI_ST_CONTEXT_SECTION_NALLEN_SHIFT 5
#define TSTORM_ISCSI_ST_CONTEXT_SECTION_RSRV0 (0x1<<7)
#define TSTORM_ISCSI_ST_CONTEXT_SECTION_RSRV0_SHIFT 7
	vmk_uint8 hdr_bytes_2_fetch;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 hdr_bytes_2_fetch;
	vmk_uint8 flags;
#define TSTORM_ISCSI_ST_CONTEXT_SECTION_B_HDR_DIGEST_EN (0x1<<0)
#define TSTORM_ISCSI_ST_CONTEXT_SECTION_B_HDR_DIGEST_EN_SHIFT 0
#define TSTORM_ISCSI_ST_CONTEXT_SECTION_B_DATA_DIGEST_EN (0x1<<1)
#define TSTORM_ISCSI_ST_CONTEXT_SECTION_B_DATA_DIGEST_EN_SHIFT 1
#define TSTORM_ISCSI_ST_CONTEXT_SECTION_B_PARTIAL_HEADER (0x1<<2)
#define TSTORM_ISCSI_ST_CONTEXT_SECTION_B_PARTIAL_HEADER_SHIFT 2
#define TSTORM_ISCSI_ST_CONTEXT_SECTION_B_FULL_FEATURE (0x1<<3)
#define TSTORM_ISCSI_ST_CONTEXT_SECTION_B_FULL_FEATURE_SHIFT 3
#define TSTORM_ISCSI_ST_CONTEXT_SECTION_B_DROP_ALL_PDUS (0x1<<4)
#define TSTORM_ISCSI_ST_CONTEXT_SECTION_B_DROP_ALL_PDUS_SHIFT 4
#define TSTORM_ISCSI_ST_CONTEXT_SECTION_NALLEN (0x3<<5)
#define TSTORM_ISCSI_ST_CONTEXT_SECTION_NALLEN_SHIFT 5
#define TSTORM_ISCSI_ST_CONTEXT_SECTION_RSRV0 (0x1<<7)
#define TSTORM_ISCSI_ST_CONTEXT_SECTION_RSRV0_SHIFT 7
	vmk_uint16 rq_cons;
#endif
	struct regpair rq_db_phy_addr;
#if defined(__BIG_ENDIAN)
	struct iscsi_term_vars term_vars;
	vmk_uint8 rsrv1;
	vmk_uint16 iscsi_conn_id;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 iscsi_conn_id;
	vmk_uint8 rsrv1;
	struct iscsi_term_vars term_vars;
#endif
	vmk_uint32 process_nxt;
};

/*
 * The iSCSI non-aggregative context of Tstorm
 */
struct tstorm_iscsi_st_context {
	struct tstorm_tcp_st_context_section tcp;
	struct tstorm_iscsi_st_context_section iscsi;
};

/*
 * Ethernet context section, shared in TOE, RDMA and ISCSI
 */
struct xstorm_eth_context_section {
#if defined(__BIG_ENDIAN)
	vmk_uint8 remote_addr_4;
	vmk_uint8 remote_addr_5;
	vmk_uint8 local_addr_0;
	vmk_uint8 local_addr_1;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 local_addr_1;
	vmk_uint8 local_addr_0;
	vmk_uint8 remote_addr_5;
	vmk_uint8 remote_addr_4;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint8 remote_addr_0;
	vmk_uint8 remote_addr_1;
	vmk_uint8 remote_addr_2;
	vmk_uint8 remote_addr_3;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 remote_addr_3;
	vmk_uint8 remote_addr_2;
	vmk_uint8 remote_addr_1;
	vmk_uint8 remote_addr_0;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint16 reserved_vlan_type;
	vmk_uint16 params;
#define XSTORM_ETH_CONTEXT_SECTION_VLAN_ID (0xFFF<<0)
#define XSTORM_ETH_CONTEXT_SECTION_VLAN_ID_SHIFT 0
#define XSTORM_ETH_CONTEXT_SECTION_CFI (0x1<<12)
#define XSTORM_ETH_CONTEXT_SECTION_CFI_SHIFT 12
#define XSTORM_ETH_CONTEXT_SECTION_PRIORITY (0x7<<13)
#define XSTORM_ETH_CONTEXT_SECTION_PRIORITY_SHIFT 13
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 params;
#define XSTORM_ETH_CONTEXT_SECTION_VLAN_ID (0xFFF<<0)
#define XSTORM_ETH_CONTEXT_SECTION_VLAN_ID_SHIFT 0
#define XSTORM_ETH_CONTEXT_SECTION_CFI (0x1<<12)
#define XSTORM_ETH_CONTEXT_SECTION_CFI_SHIFT 12
#define XSTORM_ETH_CONTEXT_SECTION_PRIORITY (0x7<<13)
#define XSTORM_ETH_CONTEXT_SECTION_PRIORITY_SHIFT 13
	vmk_uint16 reserved_vlan_type;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint8 local_addr_2;
	vmk_uint8 local_addr_3;
	vmk_uint8 local_addr_4;
	vmk_uint8 local_addr_5;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 local_addr_5;
	vmk_uint8 local_addr_4;
	vmk_uint8 local_addr_3;
	vmk_uint8 local_addr_2;
#endif
};

/*
 * IpV4 context section, shared in TOE, RDMA and ISCSI
 */
struct xstorm_ip_v4_context_section {
#if defined(__BIG_ENDIAN)
	vmk_uint16 __pbf_hdr_cmd_rsvd_id;
	vmk_uint16 __pbf_hdr_cmd_rsvd_flags_offset;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 __pbf_hdr_cmd_rsvd_flags_offset;
	vmk_uint16 __pbf_hdr_cmd_rsvd_id;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint8 __pbf_hdr_cmd_rsvd_ver_ihl;
	vmk_uint8 tos;
	vmk_uint16 __pbf_hdr_cmd_rsvd_length;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 __pbf_hdr_cmd_rsvd_length;
	vmk_uint8 tos;
	vmk_uint8 __pbf_hdr_cmd_rsvd_ver_ihl;
#endif
	vmk_uint32 ip_local_addr;
#if defined(__BIG_ENDIAN)
	vmk_uint8 ttl;
	vmk_uint8 __pbf_hdr_cmd_rsvd_protocol;
	vmk_uint16 __pbf_hdr_cmd_rsvd_csum;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 __pbf_hdr_cmd_rsvd_csum;
	vmk_uint8 __pbf_hdr_cmd_rsvd_protocol;
	vmk_uint8 ttl;
#endif
	vmk_uint32 __pbf_hdr_cmd_rsvd_1;
	vmk_uint32 ip_remote_addr;
};

/*
 * context section, shared in TOE, RDMA and ISCSI
 */
struct xstorm_padded_ip_v4_context_section {
	struct xstorm_ip_v4_context_section ip_v4;
	vmk_uint32 reserved1[4];
};

/*
 * IpV6 context section, shared in TOE, RDMA and ISCSI
 */
struct xstorm_ip_v6_context_section {
#if defined(__BIG_ENDIAN)
	vmk_uint16 pbf_hdr_cmd_rsvd_payload_len;
	vmk_uint8 pbf_hdr_cmd_rsvd_nxt_hdr;
	vmk_uint8 hop_limit;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 hop_limit;
	vmk_uint8 pbf_hdr_cmd_rsvd_nxt_hdr;
	vmk_uint16 pbf_hdr_cmd_rsvd_payload_len;
#endif
	vmk_uint32 priority_flow_label;
#define XSTORM_IP_V6_CONTEXT_SECTION_FLOW_LABEL (0xFFFFF<<0)
#define XSTORM_IP_V6_CONTEXT_SECTION_FLOW_LABEL_SHIFT 0
#define XSTORM_IP_V6_CONTEXT_SECTION_TRAFFIC_CLASS (0xFF<<20)
#define XSTORM_IP_V6_CONTEXT_SECTION_TRAFFIC_CLASS_SHIFT 20
#define XSTORM_IP_V6_CONTEXT_SECTION_PBF_HDR_CMD_RSVD_VER (0xF<<28)
#define XSTORM_IP_V6_CONTEXT_SECTION_PBF_HDR_CMD_RSVD_VER_SHIFT 28
	vmk_uint32 ip_local_addr_lo_hi;
	vmk_uint32 ip_local_addr_lo_lo;
	vmk_uint32 ip_local_addr_hi_hi;
	vmk_uint32 ip_local_addr_hi_lo;
	vmk_uint32 ip_remote_addr_lo_hi;
	vmk_uint32 ip_remote_addr_lo_lo;
	vmk_uint32 ip_remote_addr_hi_hi;
	vmk_uint32 ip_remote_addr_hi_lo;
};

union xstorm_ip_context_section_types {
	struct xstorm_padded_ip_v4_context_section padded_ip_v4;
	struct xstorm_ip_v6_context_section ip_v6;
};

/*
 * TCP context section, shared in TOE, RDMA and ISCSI
 */
struct xstorm_tcp_context_section {
	vmk_uint32 snd_max;
#if defined(__BIG_ENDIAN)
	vmk_uint16 remote_port;
	vmk_uint16 local_port;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 local_port;
	vmk_uint16 remote_port;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint8 original_nagle_1b;
	vmk_uint8 ts_enabled;
	vmk_uint16 tcp_params;
#define XSTORM_TCP_CONTEXT_SECTION_TOTAL_HEADER_SIZE (0xFF<<0)
#define XSTORM_TCP_CONTEXT_SECTION_TOTAL_HEADER_SIZE_SHIFT 0
#define __XSTORM_TCP_CONTEXT_SECTION_ECT_BIT (0x1<<8)
#define __XSTORM_TCP_CONTEXT_SECTION_ECT_BIT_SHIFT 8
#define __XSTORM_TCP_CONTEXT_SECTION_ECN_ENABLED (0x1<<9)
#define __XSTORM_TCP_CONTEXT_SECTION_ECN_ENABLED_SHIFT 9
#define XSTORM_TCP_CONTEXT_SECTION_SACK_ENABLED (0x1<<10)
#define XSTORM_TCP_CONTEXT_SECTION_SACK_ENABLED_SHIFT 10
#define XSTORM_TCP_CONTEXT_SECTION_SMALL_WIN_ADV (0x1<<11)
#define XSTORM_TCP_CONTEXT_SECTION_SMALL_WIN_ADV_SHIFT 11
#define XSTORM_TCP_CONTEXT_SECTION_FIN_SENT_FLAG (0x1<<12)
#define XSTORM_TCP_CONTEXT_SECTION_FIN_SENT_FLAG_SHIFT 12
#define XSTORM_TCP_CONTEXT_SECTION_WINDOW_SATURATED (0x1<<13)
#define XSTORM_TCP_CONTEXT_SECTION_WINDOW_SATURATED_SHIFT 13
#define XSTORM_TCP_CONTEXT_SECTION_SLOWPATH_QUEUES_FLUSH_COUNTER (0x3<<14)
#define XSTORM_TCP_CONTEXT_SECTION_SLOWPATH_QUEUES_FLUSH_COUNTER_SHIFT 14
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 tcp_params;
#define XSTORM_TCP_CONTEXT_SECTION_TOTAL_HEADER_SIZE (0xFF<<0)
#define XSTORM_TCP_CONTEXT_SECTION_TOTAL_HEADER_SIZE_SHIFT 0
#define __XSTORM_TCP_CONTEXT_SECTION_ECT_BIT (0x1<<8)
#define __XSTORM_TCP_CONTEXT_SECTION_ECT_BIT_SHIFT 8
#define __XSTORM_TCP_CONTEXT_SECTION_ECN_ENABLED (0x1<<9)
#define __XSTORM_TCP_CONTEXT_SECTION_ECN_ENABLED_SHIFT 9
#define XSTORM_TCP_CONTEXT_SECTION_SACK_ENABLED (0x1<<10)
#define XSTORM_TCP_CONTEXT_SECTION_SACK_ENABLED_SHIFT 10
#define XSTORM_TCP_CONTEXT_SECTION_SMALL_WIN_ADV (0x1<<11)
#define XSTORM_TCP_CONTEXT_SECTION_SMALL_WIN_ADV_SHIFT 11
#define XSTORM_TCP_CONTEXT_SECTION_FIN_SENT_FLAG (0x1<<12)
#define XSTORM_TCP_CONTEXT_SECTION_FIN_SENT_FLAG_SHIFT 12
#define XSTORM_TCP_CONTEXT_SECTION_WINDOW_SATURATED (0x1<<13)
#define XSTORM_TCP_CONTEXT_SECTION_WINDOW_SATURATED_SHIFT 13
#define XSTORM_TCP_CONTEXT_SECTION_SLOWPATH_QUEUES_FLUSH_COUNTER (0x3<<14)
#define XSTORM_TCP_CONTEXT_SECTION_SLOWPATH_QUEUES_FLUSH_COUNTER_SHIFT 14
	vmk_uint8 ts_enabled;
	vmk_uint8 original_nagle_1b;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint16 pseudo_csum;
	vmk_uint16 window_scaling_factor;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 window_scaling_factor;
	vmk_uint16 pseudo_csum;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint16 reserved2;
	vmk_uint8 statistics_counter_id;
	vmk_uint8 statistics_params;
#define XSTORM_TCP_CONTEXT_SECTION_UPDATE_L2_STATSTICS (0x1<<0)
#define XSTORM_TCP_CONTEXT_SECTION_UPDATE_L2_STATSTICS_SHIFT 0
#define XSTORM_TCP_CONTEXT_SECTION_UPDATE_L4_STATSTICS (0x1<<1)
#define XSTORM_TCP_CONTEXT_SECTION_UPDATE_L4_STATSTICS_SHIFT 1
#define XSTORM_TCP_CONTEXT_SECTION_RESERVED (0x3F<<2)
#define XSTORM_TCP_CONTEXT_SECTION_RESERVED_SHIFT 2
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 statistics_params;
#define XSTORM_TCP_CONTEXT_SECTION_UPDATE_L2_STATSTICS (0x1<<0)
#define XSTORM_TCP_CONTEXT_SECTION_UPDATE_L2_STATSTICS_SHIFT 0
#define XSTORM_TCP_CONTEXT_SECTION_UPDATE_L4_STATSTICS (0x1<<1)
#define XSTORM_TCP_CONTEXT_SECTION_UPDATE_L4_STATSTICS_SHIFT 1
#define XSTORM_TCP_CONTEXT_SECTION_RESERVED (0x3F<<2)
#define XSTORM_TCP_CONTEXT_SECTION_RESERVED_SHIFT 2
	vmk_uint8 statistics_counter_id;
	vmk_uint16 reserved2;
#endif
	vmk_uint32 ts_time_diff;
	vmk_uint32 __next_timer_expir;
};

/*
 * Common context section, shared in TOE, RDMA and ISCSI
 */
struct xstorm_common_context_section {
	struct xstorm_eth_context_section ethernet;
	union xstorm_ip_context_section_types ip_union;
	struct xstorm_tcp_context_section tcp;
#if defined(__BIG_ENDIAN)
	vmk_uint16 flags;
#define XSTORM_COMMON_CONTEXT_SECTION_PHYSQ_INITIALIZED (0x1<<0)
#define XSTORM_COMMON_CONTEXT_SECTION_PHYSQ_INITIALIZED_SHIFT 0
#define XSTORM_COMMON_CONTEXT_SECTION_PBF_PORT (0x7<<1)
#define XSTORM_COMMON_CONTEXT_SECTION_PBF_PORT_SHIFT 1
#define XSTORM_COMMON_CONTEXT_SECTION_COS (0x7<<4)
#define XSTORM_COMMON_CONTEXT_SECTION_COS_SHIFT 4
#define XSTORM_COMMON_CONTEXT_SECTION_DCB_EXISTS (0x1<<7)
#define XSTORM_COMMON_CONTEXT_SECTION_DCB_EXISTS_SHIFT 7
#define XSTORM_COMMON_CONTEXT_SECTION_DCB_PRIORITY (0x7<<8)
#define XSTORM_COMMON_CONTEXT_SECTION_DCB_PRIORITY_SHIFT 8
#define XSTORM_COMMON_CONTEXT_SECTION_RESERVED (0x1F<<11)
#define XSTORM_COMMON_CONTEXT_SECTION_RESERVED_SHIFT 11
	vmk_uint8 conf_version;
	vmk_uint8 ip_version_1b;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 ip_version_1b;
	vmk_uint8 conf_version;
	vmk_uint16 flags;
#define XSTORM_COMMON_CONTEXT_SECTION_PHYSQ_INITIALIZED (0x1<<0)
#define XSTORM_COMMON_CONTEXT_SECTION_PHYSQ_INITIALIZED_SHIFT 0
#define XSTORM_COMMON_CONTEXT_SECTION_PBF_PORT (0x7<<1)
#define XSTORM_COMMON_CONTEXT_SECTION_PBF_PORT_SHIFT 1
#define XSTORM_COMMON_CONTEXT_SECTION_COS (0x7<<4)
#define XSTORM_COMMON_CONTEXT_SECTION_COS_SHIFT 4
#define XSTORM_COMMON_CONTEXT_SECTION_DCB_EXISTS (0x1<<7)
#define XSTORM_COMMON_CONTEXT_SECTION_DCB_EXISTS_SHIFT 7
#define XSTORM_COMMON_CONTEXT_SECTION_DCB_PRIORITY (0x7<<8)
#define XSTORM_COMMON_CONTEXT_SECTION_DCB_PRIORITY_SHIFT 8
#define XSTORM_COMMON_CONTEXT_SECTION_RESERVED (0x1F<<11)
#define XSTORM_COMMON_CONTEXT_SECTION_RESERVED_SHIFT 11
#endif
};

/*
 * Flags used in ISCSI context section
 */
struct xstorm_iscsi_context_flags {
	vmk_uint8 flags;
#define XSTORM_ISCSI_CONTEXT_FLAGS_B_IMMEDIATE_DATA (0x1<<0)
#define XSTORM_ISCSI_CONTEXT_FLAGS_B_IMMEDIATE_DATA_SHIFT 0
#define XSTORM_ISCSI_CONTEXT_FLAGS_B_INITIAL_R2T (0x1<<1)
#define XSTORM_ISCSI_CONTEXT_FLAGS_B_INITIAL_R2T_SHIFT 1
#define XSTORM_ISCSI_CONTEXT_FLAGS_B_EN_HEADER_DIGEST (0x1<<2)
#define XSTORM_ISCSI_CONTEXT_FLAGS_B_EN_HEADER_DIGEST_SHIFT 2
#define XSTORM_ISCSI_CONTEXT_FLAGS_B_EN_DATA_DIGEST (0x1<<3)
#define XSTORM_ISCSI_CONTEXT_FLAGS_B_EN_DATA_DIGEST_SHIFT 3
#define XSTORM_ISCSI_CONTEXT_FLAGS_B_HQ_BD_WRITTEN (0x1<<4)
#define XSTORM_ISCSI_CONTEXT_FLAGS_B_HQ_BD_WRITTEN_SHIFT 4
#define XSTORM_ISCSI_CONTEXT_FLAGS_B_LAST_OP_SQ (0x1<<5)
#define XSTORM_ISCSI_CONTEXT_FLAGS_B_LAST_OP_SQ_SHIFT 5
#define XSTORM_ISCSI_CONTEXT_FLAGS_B_UPDATE_SND_NXT (0x1<<6)
#define XSTORM_ISCSI_CONTEXT_FLAGS_B_UPDATE_SND_NXT_SHIFT 6
#define XSTORM_ISCSI_CONTEXT_FLAGS_RESERVED4 (0x1<<7)
#define XSTORM_ISCSI_CONTEXT_FLAGS_RESERVED4_SHIFT 7
};

struct iscsi_task_context_entry_x {
	vmk_uint32 data_out_buffer_offset;
	vmk_uint32 itt;
	vmk_uint32 data_sn;
};

struct iscsi_task_context_entry_xuc_x_write_only {
	vmk_uint32 tx_r2t_sn;
};

struct iscsi_task_context_entry_xuc_xu_write_both {
	vmk_uint32 sgl_base_lo;
	vmk_uint32 sgl_base_hi;
#if defined(__BIG_ENDIAN)
	vmk_uint8 sgl_size;
	vmk_uint8 sge_index;
	vmk_uint16 sge_offset;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 sge_offset;
	vmk_uint8 sge_index;
	vmk_uint8 sgl_size;
#endif
};

/*
 * iSCSI context section
 */
struct xstorm_iscsi_context_section {
	vmk_uint32 first_burst_length;
	vmk_uint32 max_send_pdu_length;
	struct regpair sq_pbl_base;
	struct regpair sq_curr_pbe;
	struct regpair hq_pbl_base;
	struct regpair hq_curr_pbe_base;
	struct regpair r2tq_pbl_base;
	struct regpair r2tq_curr_pbe_base;
	struct regpair task_pbl_base;
#if defined(__BIG_ENDIAN)
	vmk_uint16 data_out_count;
	struct xstorm_iscsi_context_flags flags;
	vmk_uint8 task_pbl_cache_idx;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 task_pbl_cache_idx;
	struct xstorm_iscsi_context_flags flags;
	vmk_uint16 data_out_count;
#endif
	vmk_uint32 seq_more_2_send;
	vmk_uint32 pdu_more_2_send;
	struct iscsi_task_context_entry_x temp_tce_x;
	struct iscsi_task_context_entry_xuc_x_write_only temp_tce_x_wr;
	struct iscsi_task_context_entry_xuc_xu_write_both temp_tce_xu_wr;
	struct regpair lun;
	vmk_uint32 exp_data_transfer_len_ttt;
	vmk_uint32 pdu_data_2_rxmit;
	vmk_uint32 rxmit_bytes_2_dr;
#if defined(__BIG_ENDIAN)
	vmk_uint16 rxmit_sge_offset;
	vmk_uint16 hq_rxmit_cons;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 hq_rxmit_cons;
	vmk_uint16 rxmit_sge_offset;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint16 r2tq_cons;
	vmk_uint8 rxmit_flags;
#define XSTORM_ISCSI_CONTEXT_SECTION_B_NEW_HQ_BD (0x1<<0)
#define XSTORM_ISCSI_CONTEXT_SECTION_B_NEW_HQ_BD_SHIFT 0
#define XSTORM_ISCSI_CONTEXT_SECTION_B_RXMIT_PDU_HDR (0x1<<1)
#define XSTORM_ISCSI_CONTEXT_SECTION_B_RXMIT_PDU_HDR_SHIFT 1
#define XSTORM_ISCSI_CONTEXT_SECTION_B_RXMIT_END_PDU (0x1<<2)
#define XSTORM_ISCSI_CONTEXT_SECTION_B_RXMIT_END_PDU_SHIFT 2
#define XSTORM_ISCSI_CONTEXT_SECTION_B_RXMIT_DR (0x1<<3)
#define XSTORM_ISCSI_CONTEXT_SECTION_B_RXMIT_DR_SHIFT 3
#define XSTORM_ISCSI_CONTEXT_SECTION_B_RXMIT_START_DR (0x1<<4)
#define XSTORM_ISCSI_CONTEXT_SECTION_B_RXMIT_START_DR_SHIFT 4
#define XSTORM_ISCSI_CONTEXT_SECTION_B_RXMIT_PADDING (0x3<<5)
#define XSTORM_ISCSI_CONTEXT_SECTION_B_RXMIT_PADDING_SHIFT 5
#define XSTORM_ISCSI_CONTEXT_SECTION_B_ISCSI_CONT_FAST_RXMIT (0x1<<7)
#define XSTORM_ISCSI_CONTEXT_SECTION_B_ISCSI_CONT_FAST_RXMIT_SHIFT 7
	vmk_uint8 rxmit_sge_idx;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 rxmit_sge_idx;
	vmk_uint8 rxmit_flags;
#define XSTORM_ISCSI_CONTEXT_SECTION_B_NEW_HQ_BD (0x1<<0)
#define XSTORM_ISCSI_CONTEXT_SECTION_B_NEW_HQ_BD_SHIFT 0
#define XSTORM_ISCSI_CONTEXT_SECTION_B_RXMIT_PDU_HDR (0x1<<1)
#define XSTORM_ISCSI_CONTEXT_SECTION_B_RXMIT_PDU_HDR_SHIFT 1
#define XSTORM_ISCSI_CONTEXT_SECTION_B_RXMIT_END_PDU (0x1<<2)
#define XSTORM_ISCSI_CONTEXT_SECTION_B_RXMIT_END_PDU_SHIFT 2
#define XSTORM_ISCSI_CONTEXT_SECTION_B_RXMIT_DR (0x1<<3)
#define XSTORM_ISCSI_CONTEXT_SECTION_B_RXMIT_DR_SHIFT 3
#define XSTORM_ISCSI_CONTEXT_SECTION_B_RXMIT_START_DR (0x1<<4)
#define XSTORM_ISCSI_CONTEXT_SECTION_B_RXMIT_START_DR_SHIFT 4
#define XSTORM_ISCSI_CONTEXT_SECTION_B_RXMIT_PADDING (0x3<<5)
#define XSTORM_ISCSI_CONTEXT_SECTION_B_RXMIT_PADDING_SHIFT 5
#define XSTORM_ISCSI_CONTEXT_SECTION_B_ISCSI_CONT_FAST_RXMIT (0x1<<7)
#define XSTORM_ISCSI_CONTEXT_SECTION_B_ISCSI_CONT_FAST_RXMIT_SHIFT 7
	vmk_uint16 r2tq_cons;
#endif
	vmk_uint32 hq_rxmit_tcp_seq;
};

/*
 * Xstorm iSCSI Storm Context
 */
struct xstorm_iscsi_st_context {
	struct xstorm_common_context_section common;
	struct xstorm_iscsi_context_section iscsi;
};

/*
 * Iscsi connection context
 */
struct iscsi_context {
	struct ustorm_iscsi_st_context ustorm_st_context;
	struct tstorm_iscsi_st_context tstorm_st_context;
	struct xstorm_iscsi_ag_context xstorm_ag_context;
	struct tstorm_iscsi_ag_context tstorm_ag_context;
	struct cstorm_iscsi_ag_context cstorm_ag_context;
	struct ustorm_iscsi_ag_context ustorm_ag_context;
	struct timers_block_context timers_context;
	struct regpair upb_context;
	struct xstorm_iscsi_st_context xstorm_st_context;
	struct regpair xpb_context;
	struct cstorm_iscsi_st_context cstorm_st_context;
};


/*
 * PDU header of an iSCSI DATA-OUT
 */
struct iscsi_data_pdu_hdr_little_endian {
#if defined(__BIG_ENDIAN)
	vmk_uint8 opcode;
	vmk_uint8 op_attr;
#define ISCSI_DATA_PDU_HDR_LITTLE_ENDIAN_RSRV1 (0x7F<<0)
#define ISCSI_DATA_PDU_HDR_LITTLE_ENDIAN_RSRV1_SHIFT 0
#define ISCSI_DATA_PDU_HDR_LITTLE_ENDIAN_FINAL_FLAG (0x1<<7)
#define ISCSI_DATA_PDU_HDR_LITTLE_ENDIAN_FINAL_FLAG_SHIFT 7
	vmk_uint16 rsrv0;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 rsrv0;
	vmk_uint8 op_attr;
#define ISCSI_DATA_PDU_HDR_LITTLE_ENDIAN_RSRV1 (0x7F<<0)
#define ISCSI_DATA_PDU_HDR_LITTLE_ENDIAN_RSRV1_SHIFT 0
#define ISCSI_DATA_PDU_HDR_LITTLE_ENDIAN_FINAL_FLAG (0x1<<7)
#define ISCSI_DATA_PDU_HDR_LITTLE_ENDIAN_FINAL_FLAG_SHIFT 7
	vmk_uint8 opcode;
#endif
	vmk_uint32 data_fields;
#define ISCSI_DATA_PDU_HDR_LITTLE_ENDIAN_DATA_SEGMENT_LENGTH (0xFFFFFF<<0)
#define ISCSI_DATA_PDU_HDR_LITTLE_ENDIAN_DATA_SEGMENT_LENGTH_SHIFT 0
#define ISCSI_DATA_PDU_HDR_LITTLE_ENDIAN_TOTAL_AHS_LENGTH (0xFF<<24)
#define ISCSI_DATA_PDU_HDR_LITTLE_ENDIAN_TOTAL_AHS_LENGTH_SHIFT 24
	struct regpair lun;
	vmk_uint32 itt;
	vmk_uint32 ttt;
	vmk_uint32 rsrv2;
	vmk_uint32 exp_stat_sn;
	vmk_uint32 rsrv3;
	vmk_uint32 data_sn;
	vmk_uint32 buffer_offset;
	vmk_uint32 rsrv4;
};


/*
 * PDU header of an iSCSI login request
 */
struct iscsi_login_req_hdr_little_endian {
#if defined(__BIG_ENDIAN)
	vmk_uint8 opcode;
	vmk_uint8 op_attr;
#define ISCSI_LOGIN_REQ_HDR_LITTLE_ENDIAN_NSG (0x3<<0)
#define ISCSI_LOGIN_REQ_HDR_LITTLE_ENDIAN_NSG_SHIFT 0
#define ISCSI_LOGIN_REQ_HDR_LITTLE_ENDIAN_CSG (0x3<<2)
#define ISCSI_LOGIN_REQ_HDR_LITTLE_ENDIAN_CSG_SHIFT 2
#define ISCSI_LOGIN_REQ_HDR_LITTLE_ENDIAN_RSRV0 (0x3<<4)
#define ISCSI_LOGIN_REQ_HDR_LITTLE_ENDIAN_RSRV0_SHIFT 4
#define ISCSI_LOGIN_REQ_HDR_LITTLE_ENDIAN_CONTINUE_FLG (0x1<<6)
#define ISCSI_LOGIN_REQ_HDR_LITTLE_ENDIAN_CONTINUE_FLG_SHIFT 6
#define ISCSI_LOGIN_REQ_HDR_LITTLE_ENDIAN_TRANSIT (0x1<<7)
#define ISCSI_LOGIN_REQ_HDR_LITTLE_ENDIAN_TRANSIT_SHIFT 7
	vmk_uint8 version_max;
	vmk_uint8 version_min;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 version_min;
	vmk_uint8 version_max;
	vmk_uint8 op_attr;
#define ISCSI_LOGIN_REQ_HDR_LITTLE_ENDIAN_NSG (0x3<<0)
#define ISCSI_LOGIN_REQ_HDR_LITTLE_ENDIAN_NSG_SHIFT 0
#define ISCSI_LOGIN_REQ_HDR_LITTLE_ENDIAN_CSG (0x3<<2)
#define ISCSI_LOGIN_REQ_HDR_LITTLE_ENDIAN_CSG_SHIFT 2
#define ISCSI_LOGIN_REQ_HDR_LITTLE_ENDIAN_RSRV0 (0x3<<4)
#define ISCSI_LOGIN_REQ_HDR_LITTLE_ENDIAN_RSRV0_SHIFT 4
#define ISCSI_LOGIN_REQ_HDR_LITTLE_ENDIAN_CONTINUE_FLG (0x1<<6)
#define ISCSI_LOGIN_REQ_HDR_LITTLE_ENDIAN_CONTINUE_FLG_SHIFT 6
#define ISCSI_LOGIN_REQ_HDR_LITTLE_ENDIAN_TRANSIT (0x1<<7)
#define ISCSI_LOGIN_REQ_HDR_LITTLE_ENDIAN_TRANSIT_SHIFT 7
	vmk_uint8 opcode;
#endif
	vmk_uint32 data_fields;
#define ISCSI_LOGIN_REQ_HDR_LITTLE_ENDIAN_DATA_SEGMENT_LENGTH (0xFFFFFF<<0)
#define ISCSI_LOGIN_REQ_HDR_LITTLE_ENDIAN_DATA_SEGMENT_LENGTH_SHIFT 0
#define ISCSI_LOGIN_REQ_HDR_LITTLE_ENDIAN_TOTAL_AHS_LENGTH (0xFF<<24)
#define ISCSI_LOGIN_REQ_HDR_LITTLE_ENDIAN_TOTAL_AHS_LENGTH_SHIFT 24
	vmk_uint32 isid_lo;
#if defined(__BIG_ENDIAN)
	vmk_uint16 isid_hi;
	vmk_uint16 tsih;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 tsih;
	vmk_uint16 isid_hi;
#endif
	vmk_uint32 itt;
#if defined(__BIG_ENDIAN)
	vmk_uint16 cid;
	vmk_uint16 rsrv1;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 rsrv1;
	vmk_uint16 cid;
#endif
	vmk_uint32 cmd_sn;
	vmk_uint32 exp_stat_sn;
	vmk_uint32 rsrv2[4];
};

/*
 * PDU header of an iSCSI logout request
 */
struct iscsi_logout_req_hdr_little_endian {
#if defined(__BIG_ENDIAN)
	vmk_uint8 opcode;
	vmk_uint8 op_attr;
#define ISCSI_LOGOUT_REQ_HDR_LITTLE_ENDIAN_REASON_CODE (0x7F<<0)
#define ISCSI_LOGOUT_REQ_HDR_LITTLE_ENDIAN_REASON_CODE_SHIFT 0
#define ISCSI_LOGOUT_REQ_HDR_LITTLE_ENDIAN_RSRV1_1 (0x1<<7)
#define ISCSI_LOGOUT_REQ_HDR_LITTLE_ENDIAN_RSRV1_1_SHIFT 7
	vmk_uint16 rsrv0;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 rsrv0;
	vmk_uint8 op_attr;
#define ISCSI_LOGOUT_REQ_HDR_LITTLE_ENDIAN_REASON_CODE (0x7F<<0)
#define ISCSI_LOGOUT_REQ_HDR_LITTLE_ENDIAN_REASON_CODE_SHIFT 0
#define ISCSI_LOGOUT_REQ_HDR_LITTLE_ENDIAN_RSRV1_1 (0x1<<7)
#define ISCSI_LOGOUT_REQ_HDR_LITTLE_ENDIAN_RSRV1_1_SHIFT 7
	vmk_uint8 opcode;
#endif
	vmk_uint32 data_fields;
#define ISCSI_LOGOUT_REQ_HDR_LITTLE_ENDIAN_DATA_SEGMENT_LENGTH (0xFFFFFF<<0)
#define ISCSI_LOGOUT_REQ_HDR_LITTLE_ENDIAN_DATA_SEGMENT_LENGTH_SHIFT 0
#define ISCSI_LOGOUT_REQ_HDR_LITTLE_ENDIAN_TOTAL_AHS_LENGTH (0xFF<<24)
#define ISCSI_LOGOUT_REQ_HDR_LITTLE_ENDIAN_TOTAL_AHS_LENGTH_SHIFT 24
	vmk_uint32 rsrv2[2];
	vmk_uint32 itt;
#if defined(__BIG_ENDIAN)
	vmk_uint16 cid;
	vmk_uint16 rsrv1;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 rsrv1;
	vmk_uint16 cid;
#endif
	vmk_uint32 cmd_sn;
	vmk_uint32 exp_stat_sn;
	vmk_uint32 rsrv3[4];
};

/*
 * PDU header of an iSCSI TMF request
 */
struct iscsi_tmf_req_hdr_little_endian {
#if defined(__BIG_ENDIAN)
	vmk_uint8 opcode;
	vmk_uint8 op_attr;
#define ISCSI_TMF_REQ_HDR_LITTLE_ENDIAN_FUNCTION (0x7F<<0)
#define ISCSI_TMF_REQ_HDR_LITTLE_ENDIAN_FUNCTION_SHIFT 0
#define ISCSI_TMF_REQ_HDR_LITTLE_ENDIAN_RSRV1_1 (0x1<<7)
#define ISCSI_TMF_REQ_HDR_LITTLE_ENDIAN_RSRV1_1_SHIFT 7
	vmk_uint16 rsrv0;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 rsrv0;
	vmk_uint8 op_attr;
#define ISCSI_TMF_REQ_HDR_LITTLE_ENDIAN_FUNCTION (0x7F<<0)
#define ISCSI_TMF_REQ_HDR_LITTLE_ENDIAN_FUNCTION_SHIFT 0
#define ISCSI_TMF_REQ_HDR_LITTLE_ENDIAN_RSRV1_1 (0x1<<7)
#define ISCSI_TMF_REQ_HDR_LITTLE_ENDIAN_RSRV1_1_SHIFT 7
	vmk_uint8 opcode;
#endif
	vmk_uint32 data_fields;
#define ISCSI_TMF_REQ_HDR_LITTLE_ENDIAN_DATA_SEGMENT_LENGTH (0xFFFFFF<<0)
#define ISCSI_TMF_REQ_HDR_LITTLE_ENDIAN_DATA_SEGMENT_LENGTH_SHIFT 0
#define ISCSI_TMF_REQ_HDR_LITTLE_ENDIAN_TOTAL_AHS_LENGTH (0xFF<<24)
#define ISCSI_TMF_REQ_HDR_LITTLE_ENDIAN_TOTAL_AHS_LENGTH_SHIFT 24
	struct regpair lun;
	vmk_uint32 itt;
	vmk_uint32 referenced_task_tag;
	vmk_uint32 cmd_sn;
	vmk_uint32 exp_stat_sn;
	vmk_uint32 ref_cmd_sn;
	vmk_uint32 exp_data_sn;
	vmk_uint32 rsrv2[2];
};

/*
 * PDU header of an iSCSI Text request
 */
struct iscsi_text_req_hdr_little_endian {
#if defined(__BIG_ENDIAN)
	vmk_uint8 opcode;
	vmk_uint8 op_attr;
#define ISCSI_TEXT_REQ_HDR_LITTLE_ENDIAN_RSRV1 (0x3F<<0)
#define ISCSI_TEXT_REQ_HDR_LITTLE_ENDIAN_RSRV1_SHIFT 0
#define ISCSI_TEXT_REQ_HDR_LITTLE_ENDIAN_CONTINUE_FLG (0x1<<6)
#define ISCSI_TEXT_REQ_HDR_LITTLE_ENDIAN_CONTINUE_FLG_SHIFT 6
#define ISCSI_TEXT_REQ_HDR_LITTLE_ENDIAN_FINAL (0x1<<7)
#define ISCSI_TEXT_REQ_HDR_LITTLE_ENDIAN_FINAL_SHIFT 7
	vmk_uint16 rsrv0;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 rsrv0;
	vmk_uint8 op_attr;
#define ISCSI_TEXT_REQ_HDR_LITTLE_ENDIAN_RSRV1 (0x3F<<0)
#define ISCSI_TEXT_REQ_HDR_LITTLE_ENDIAN_RSRV1_SHIFT 0
#define ISCSI_TEXT_REQ_HDR_LITTLE_ENDIAN_CONTINUE_FLG (0x1<<6)
#define ISCSI_TEXT_REQ_HDR_LITTLE_ENDIAN_CONTINUE_FLG_SHIFT 6
#define ISCSI_TEXT_REQ_HDR_LITTLE_ENDIAN_FINAL (0x1<<7)
#define ISCSI_TEXT_REQ_HDR_LITTLE_ENDIAN_FINAL_SHIFT 7
	vmk_uint8 opcode;
#endif
	vmk_uint32 data_fields;
#define ISCSI_TEXT_REQ_HDR_LITTLE_ENDIAN_DATA_SEGMENT_LENGTH (0xFFFFFF<<0)
#define ISCSI_TEXT_REQ_HDR_LITTLE_ENDIAN_DATA_SEGMENT_LENGTH_SHIFT 0
#define ISCSI_TEXT_REQ_HDR_LITTLE_ENDIAN_TOTAL_AHS_LENGTH (0xFF<<24)
#define ISCSI_TEXT_REQ_HDR_LITTLE_ENDIAN_TOTAL_AHS_LENGTH_SHIFT 24
	struct regpair lun;
	vmk_uint32 itt;
	vmk_uint32 ttt;
	vmk_uint32 cmd_sn;
	vmk_uint32 exp_stat_sn;
	vmk_uint32 rsrv3[4];
};

/*
 * PDU header of an iSCSI Nop-Out
 */
struct iscsi_nop_out_hdr_little_endian {
#if defined(__BIG_ENDIAN)
	vmk_uint8 opcode;
	vmk_uint8 op_attr;
#define ISCSI_NOP_OUT_HDR_LITTLE_ENDIAN_RSRV1 (0x7F<<0)
#define ISCSI_NOP_OUT_HDR_LITTLE_ENDIAN_RSRV1_SHIFT 0
#define ISCSI_NOP_OUT_HDR_LITTLE_ENDIAN_RSRV2_1 (0x1<<7)
#define ISCSI_NOP_OUT_HDR_LITTLE_ENDIAN_RSRV2_1_SHIFT 7
	vmk_uint16 rsrv0;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 rsrv0;
	vmk_uint8 op_attr;
#define ISCSI_NOP_OUT_HDR_LITTLE_ENDIAN_RSRV1 (0x7F<<0)
#define ISCSI_NOP_OUT_HDR_LITTLE_ENDIAN_RSRV1_SHIFT 0
#define ISCSI_NOP_OUT_HDR_LITTLE_ENDIAN_RSRV2_1 (0x1<<7)
#define ISCSI_NOP_OUT_HDR_LITTLE_ENDIAN_RSRV2_1_SHIFT 7
	vmk_uint8 opcode;
#endif
	vmk_uint32 data_fields;
#define ISCSI_NOP_OUT_HDR_LITTLE_ENDIAN_DATA_SEGMENT_LENGTH (0xFFFFFF<<0)
#define ISCSI_NOP_OUT_HDR_LITTLE_ENDIAN_DATA_SEGMENT_LENGTH_SHIFT 0
#define ISCSI_NOP_OUT_HDR_LITTLE_ENDIAN_TOTAL_AHS_LENGTH (0xFF<<24)
#define ISCSI_NOP_OUT_HDR_LITTLE_ENDIAN_TOTAL_AHS_LENGTH_SHIFT 24
	struct regpair lun;
	vmk_uint32 itt;
	vmk_uint32 ttt;
	vmk_uint32 cmd_sn;
	vmk_uint32 exp_stat_sn;
	vmk_uint32 rsrv3[4];
};

/*
 * iscsi pdu headers in little endian form.
 */
union iscsi_pdu_headers_little_endian {
	vmk_uint32 fullHeaderSize[12];
	struct iscsi_cmd_pdu_hdr_little_endian command_pdu_hdr;
	struct iscsi_data_pdu_hdr_little_endian data_out_pdu_hdr;
	struct iscsi_login_req_hdr_little_endian login_req_pdu_hdr;
	struct iscsi_logout_req_hdr_little_endian logout_req_pdu_hdr;
	struct iscsi_tmf_req_hdr_little_endian tmf_req_pdu_hdr;
	struct iscsi_text_req_hdr_little_endian text_req_pdu_hdr;
	struct iscsi_nop_out_hdr_little_endian nop_out_pdu_hdr;
};

struct iscsi_hq_bd {
	union iscsi_pdu_headers_little_endian pdu_header;
#if defined(__BIG_ENDIAN)
	vmk_uint16 reserved1;
	vmk_uint16 lcl_cmp_flg;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 lcl_cmp_flg;
	vmk_uint16 reserved1;
#endif
	vmk_uint32 sgl_base_lo;
	vmk_uint32 sgl_base_hi;
#if defined(__BIG_ENDIAN)
	vmk_uint8 sgl_size;
	vmk_uint8 sge_index;
	vmk_uint16 sge_offset;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 sge_offset;
	vmk_uint8 sge_index;
	vmk_uint8 sgl_size;
#endif
};


/*
 * CQE data for L2 OOO connection $$KEEP_ENDIANNESS$$
 */
struct iscsi_l2_ooo_data {
	vmk_uint32 iscsi_cid;
	vmk_uint8 drop_isle;
	vmk_uint8 drop_size;
	vmk_uint8 ooo_opcode;
	vmk_uint8 ooo_isle;
	vmk_uint8 reserved[8];
};






struct iscsi_task_context_entry_xuc_c_write_only {
	vmk_uint32 total_data_acked;
};

struct iscsi_task_context_r2t_table_entry {
	vmk_uint32 ttt;
	vmk_uint32 desired_data_len;
};

struct iscsi_task_context_entry_xuc_u_write_only {
	vmk_uint32 exp_r2t_sn;
	struct iscsi_task_context_r2t_table_entry r2t_table[4];
#if defined(__BIG_ENDIAN)
	vmk_uint16 data_in_count;
	vmk_uint8 cq_id;
	vmk_uint8 valid_1b;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 valid_1b;
	vmk_uint8 cq_id;
	vmk_uint16 data_in_count;
#endif
};

struct iscsi_task_context_entry_xuc {
	struct iscsi_task_context_entry_xuc_c_write_only write_c;
	vmk_uint32 exp_data_transfer_len;
	struct iscsi_task_context_entry_xuc_x_write_only write_x;
	vmk_uint32 lun_lo;
	struct iscsi_task_context_entry_xuc_xu_write_both write_xu;
	vmk_uint32 lun_hi;
	struct iscsi_task_context_entry_xuc_u_write_only write_u;
};

struct iscsi_task_context_entry_u {
	vmk_uint32 exp_r2t_buff_offset;
	vmk_uint32 rem_rcv_len;
	vmk_uint32 exp_data_sn;
};

struct iscsi_task_context_entry {
	struct iscsi_task_context_entry_x tce_x;
#if defined(__BIG_ENDIAN)
	vmk_uint16 data_out_count;
	vmk_uint16 rsrv0;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 rsrv0;
	vmk_uint16 data_out_count;
#endif
	struct iscsi_task_context_entry_xuc tce_xuc;
	struct iscsi_task_context_entry_u tce_u;
	vmk_uint32 rsrv1[7];
};


struct iscsi_task_context_entry_xuc_x_init_only {
	struct regpair lun;
	vmk_uint32 exp_data_transfer_len;
};


/*
 * ipv6 structure
 */
struct ip_v6_addr {
	vmk_uint32 ip_addr_lo_lo;
	vmk_uint32 ip_addr_lo_hi;
	vmk_uint32 ip_addr_hi_lo;
	vmk_uint32 ip_addr_hi_hi;
};



/*
 * l5cm- connection identification params
 */
struct l5cm_conn_addr_params {
	vmk_uint32 pmtu;
#if defined(__BIG_ENDIAN)
	vmk_uint8 remote_addr_3;
	vmk_uint8 remote_addr_2;
	vmk_uint8 remote_addr_1;
	vmk_uint8 remote_addr_0;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 remote_addr_0;
	vmk_uint8 remote_addr_1;
	vmk_uint8 remote_addr_2;
	vmk_uint8 remote_addr_3;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint16 params;
#define L5CM_CONN_ADDR_PARAMS_IP_VERSION (0x1<<0)
#define L5CM_CONN_ADDR_PARAMS_IP_VERSION_SHIFT 0
#define L5CM_CONN_ADDR_PARAMS_RSRV (0x7FFF<<1)
#define L5CM_CONN_ADDR_PARAMS_RSRV_SHIFT 1
	vmk_uint8 remote_addr_5;
	vmk_uint8 remote_addr_4;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 remote_addr_4;
	vmk_uint8 remote_addr_5;
	vmk_uint16 params;
#define L5CM_CONN_ADDR_PARAMS_IP_VERSION (0x1<<0)
#define L5CM_CONN_ADDR_PARAMS_IP_VERSION_SHIFT 0
#define L5CM_CONN_ADDR_PARAMS_RSRV (0x7FFF<<1)
#define L5CM_CONN_ADDR_PARAMS_RSRV_SHIFT 1
#endif
	struct ip_v6_addr local_ip_addr;
	struct ip_v6_addr remote_ip_addr;
	vmk_uint32 ipv6_flow_label_20b;
	vmk_uint32 reserved1;
#if defined(__BIG_ENDIAN)
	vmk_uint16 remote_tcp_port;
	vmk_uint16 local_tcp_port;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 local_tcp_port;
	vmk_uint16 remote_tcp_port;
#endif
};

/*
 * l5cm-xstorm connection buffer
 */
struct l5cm_xstorm_conn_buffer {
#if defined(__BIG_ENDIAN)
	vmk_uint16 rsrv1;
	vmk_uint16 params;
#define L5CM_XSTORM_CONN_BUFFER_NAGLE_ENABLE (0x1<<0)
#define L5CM_XSTORM_CONN_BUFFER_NAGLE_ENABLE_SHIFT 0
#define L5CM_XSTORM_CONN_BUFFER_RSRV (0x7FFF<<1)
#define L5CM_XSTORM_CONN_BUFFER_RSRV_SHIFT 1
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 params;
#define L5CM_XSTORM_CONN_BUFFER_NAGLE_ENABLE (0x1<<0)
#define L5CM_XSTORM_CONN_BUFFER_NAGLE_ENABLE_SHIFT 0
#define L5CM_XSTORM_CONN_BUFFER_RSRV (0x7FFF<<1)
#define L5CM_XSTORM_CONN_BUFFER_RSRV_SHIFT 1
	vmk_uint16 rsrv1;
#endif
#if defined(__BIG_ENDIAN)
	vmk_uint16 mss;
	vmk_uint16 pseudo_header_checksum;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 pseudo_header_checksum;
	vmk_uint16 mss;
#endif
	vmk_uint32 rcv_buf;
	vmk_uint32 rsrv2;
	struct regpair context_addr;
};

/*
 * l5cm-tstorm connection buffer
 */
struct l5cm_tstorm_conn_buffer {
	vmk_uint32 rsrv1[2];
#if defined(__BIG_ENDIAN)
	vmk_uint16 params;
#define L5CM_TSTORM_CONN_BUFFER_DELAYED_ACK_ENABLE (0x1<<0)
#define L5CM_TSTORM_CONN_BUFFER_DELAYED_ACK_ENABLE_SHIFT 0
#define L5CM_TSTORM_CONN_BUFFER_RSRV (0x7FFF<<1)
#define L5CM_TSTORM_CONN_BUFFER_RSRV_SHIFT 1
	vmk_uint8 ka_max_probe_count;
	vmk_uint8 ka_enable;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 ka_enable;
	vmk_uint8 ka_max_probe_count;
	vmk_uint16 params;
#define L5CM_TSTORM_CONN_BUFFER_DELAYED_ACK_ENABLE (0x1<<0)
#define L5CM_TSTORM_CONN_BUFFER_DELAYED_ACK_ENABLE_SHIFT 0
#define L5CM_TSTORM_CONN_BUFFER_RSRV (0x7FFF<<1)
#define L5CM_TSTORM_CONN_BUFFER_RSRV_SHIFT 1
#endif
	vmk_uint32 ka_timeout;
	vmk_uint32 ka_interval;
	vmk_uint32 max_rt_time;
};

/*
 * l5cm connection buffer for active side
 */
struct l5cm_active_conn_buffer {
	struct l5cm_conn_addr_params conn_addr_buf;
	struct l5cm_xstorm_conn_buffer xstorm_conn_buffer;
	struct l5cm_tstorm_conn_buffer tstorm_conn_buffer;
};



/*
 * The l5cm opaque buffer passed in add new connection ramrod passive side
 */
struct l5cm_hash_input_string {
	vmk_uint32 __opaque1;
#if defined(__BIG_ENDIAN)
	vmk_uint16 __opaque3;
	vmk_uint16 __opaque2;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 __opaque2;
	vmk_uint16 __opaque3;
#endif
	struct ip_v6_addr __opaque4;
	struct ip_v6_addr __opaque5;
	vmk_uint32 __opaque6;
	vmk_uint32 __opaque7[5];
};


/*
 * syn cookie component
 */
struct l5cm_syn_cookie_comp {
	vmk_uint32 __opaque;
};

/*
 * data related to listeners of a TCP port
 */
struct l5cm_port_listener_data {
	vmk_uint8 params;
#define L5CM_PORT_LISTENER_DATA_ENABLE (0x1<<0)
#define L5CM_PORT_LISTENER_DATA_ENABLE_SHIFT 0
#define L5CM_PORT_LISTENER_DATA_IP_INDEX (0xF<<1)
#define L5CM_PORT_LISTENER_DATA_IP_INDEX_SHIFT 1
#define L5CM_PORT_LISTENER_DATA_NET_FILTER (0x1<<5)
#define L5CM_PORT_LISTENER_DATA_NET_FILTER_SHIFT 5
#define L5CM_PORT_LISTENER_DATA_DEFFERED_MODE (0x1<<6)
#define L5CM_PORT_LISTENER_DATA_DEFFERED_MODE_SHIFT 6
#define L5CM_PORT_LISTENER_DATA_MPA_MODE (0x1<<7)
#define L5CM_PORT_LISTENER_DATA_MPA_MODE_SHIFT 7
};

/*
 * Opaque structure passed from U to X when final ack arrives
 */
struct l5cm_opaque_buf {
	vmk_uint32 __opaque1;
	vmk_uint32 __opaque2;
	vmk_uint32 __opaque3;
	vmk_uint32 __opaque4;
	struct l5cm_syn_cookie_comp __opaque5;
#if defined(__BIG_ENDIAN)
	vmk_uint16 rsrv2;
	vmk_uint8 rsrv;
	struct l5cm_port_listener_data __opaque6;
#elif defined(__LITTLE_ENDIAN)
	struct l5cm_port_listener_data __opaque6;
	vmk_uint8 rsrv;
	vmk_uint16 rsrv2;
#endif
};


/*
 * l5cm slow path element
 */
struct l5cm_packet_size {
	vmk_uint32 size;
	vmk_uint32 rsrv;
};


/*
 * The final-ack union structure in PCS entry after final ack arrived
 */
struct l5cm_pcse_ack {
	struct l5cm_xstorm_conn_buffer tx_socket_params;
	struct l5cm_opaque_buf opaque_buf;
	struct l5cm_tstorm_conn_buffer rx_socket_params;
};


/*
 * The syn union structure in PCS entry after syn arrived
 */
struct l5cm_pcse_syn {
	struct l5cm_opaque_buf opaque_buf;
	vmk_uint32 rsrv[12];
};


/*
 * pcs entry data for passive connections
 */
struct l5cm_pcs_attributes {
#if defined(__BIG_ENDIAN)
	vmk_uint16 pcs_id;
	vmk_uint8 status;
	vmk_uint8 flags;
#define L5CM_PCS_ATTRIBUTES_NET_FILTER (0x1<<0)
#define L5CM_PCS_ATTRIBUTES_NET_FILTER_SHIFT 0
#define L5CM_PCS_ATTRIBUTES_CALCULATE_HASH (0x1<<1)
#define L5CM_PCS_ATTRIBUTES_CALCULATE_HASH_SHIFT 1
#define L5CM_PCS_ATTRIBUTES_COMPARE_HASH_RESULT (0x1<<2)
#define L5CM_PCS_ATTRIBUTES_COMPARE_HASH_RESULT_SHIFT 2
#define L5CM_PCS_ATTRIBUTES_QUERY_ULP_ACCEPT (0x1<<3)
#define L5CM_PCS_ATTRIBUTES_QUERY_ULP_ACCEPT_SHIFT 3
#define L5CM_PCS_ATTRIBUTES_FIND_DEST_MAC (0x1<<4)
#define L5CM_PCS_ATTRIBUTES_FIND_DEST_MAC_SHIFT 4
#define L5CM_PCS_ATTRIBUTES_L4_OFFLOAD (0x1<<5)
#define L5CM_PCS_ATTRIBUTES_L4_OFFLOAD_SHIFT 5
#define L5CM_PCS_ATTRIBUTES_FORWARD_PACKET (0x1<<6)
#define L5CM_PCS_ATTRIBUTES_FORWARD_PACKET_SHIFT 6
#define L5CM_PCS_ATTRIBUTES_RSRV (0x1<<7)
#define L5CM_PCS_ATTRIBUTES_RSRV_SHIFT 7
#elif defined(__LITTLE_ENDIAN)
	vmk_uint8 flags;
#define L5CM_PCS_ATTRIBUTES_NET_FILTER (0x1<<0)
#define L5CM_PCS_ATTRIBUTES_NET_FILTER_SHIFT 0
#define L5CM_PCS_ATTRIBUTES_CALCULATE_HASH (0x1<<1)
#define L5CM_PCS_ATTRIBUTES_CALCULATE_HASH_SHIFT 1
#define L5CM_PCS_ATTRIBUTES_COMPARE_HASH_RESULT (0x1<<2)
#define L5CM_PCS_ATTRIBUTES_COMPARE_HASH_RESULT_SHIFT 2
#define L5CM_PCS_ATTRIBUTES_QUERY_ULP_ACCEPT (0x1<<3)
#define L5CM_PCS_ATTRIBUTES_QUERY_ULP_ACCEPT_SHIFT 3
#define L5CM_PCS_ATTRIBUTES_FIND_DEST_MAC (0x1<<4)
#define L5CM_PCS_ATTRIBUTES_FIND_DEST_MAC_SHIFT 4
#define L5CM_PCS_ATTRIBUTES_L4_OFFLOAD (0x1<<5)
#define L5CM_PCS_ATTRIBUTES_L4_OFFLOAD_SHIFT 5
#define L5CM_PCS_ATTRIBUTES_FORWARD_PACKET (0x1<<6)
#define L5CM_PCS_ATTRIBUTES_FORWARD_PACKET_SHIFT 6
#define L5CM_PCS_ATTRIBUTES_RSRV (0x1<<7)
#define L5CM_PCS_ATTRIBUTES_RSRV_SHIFT 7
	vmk_uint8 status;
	vmk_uint16 pcs_id;
#endif
};


union l5cm_seg_params {
	struct l5cm_pcse_syn syn_seg_params;
	struct l5cm_pcse_ack ack_seg_params;
};

/*
 * pcs entry data for passive connections
 */
struct l5cm_pcs_hdr {
	struct l5cm_hash_input_string hash_input_string;
	struct l5cm_conn_addr_params conn_addr_buf;
	vmk_uint32 cid;
	vmk_uint32 hash_result;
	union l5cm_seg_params seg_params;
	struct l5cm_pcs_attributes att;
#if defined(__BIG_ENDIAN)
	vmk_uint16 rsrv;
	vmk_uint16 rx_seg_size;
#elif defined(__LITTLE_ENDIAN)
	vmk_uint16 rx_seg_size;
	vmk_uint16 rsrv;
#endif
};

/*
 * pcs entry for passive connections
 */
struct l5cm_pcs_entry {
	struct l5cm_pcs_hdr hdr;
	vmk_uint8 rx_segment[1516];
};




/*
 * l5cm connection parameters
 */
union l5cm_reduce_param_union {
	vmk_uint32 opaque1;
	vmk_uint32 opaque2;
};

/*
 * l5cm connection parameters
 */
struct l5cm_reduce_conn {
	union l5cm_reduce_param_union opaque1;
	vmk_uint32 opaque2;
};

/*
 * l5cm slow path element
 */
union l5cm_specific_data {
	vmk_uint8 protocol_data[8];
	struct regpair phy_address;
	struct l5cm_packet_size packet_size;
	struct l5cm_reduce_conn reduced_conn;
};

/*
 * l5 slow path element
 */
struct l5cm_spe {
	struct spe_hdr hdr;
	union l5cm_specific_data data;
};




/*
 * Termination variables
 */
struct l5cm_term_vars {
	vmk_uint8 BitMap;
#define L5CM_TERM_VARS_TCP_STATE (0xF<<0)
#define L5CM_TERM_VARS_TCP_STATE_SHIFT 0
#define L5CM_TERM_VARS_FIN_RECEIVED_SBIT (0x1<<4)
#define L5CM_TERM_VARS_FIN_RECEIVED_SBIT_SHIFT 4
#define L5CM_TERM_VARS_ACK_ON_FIN_RECEIVED_SBIT (0x1<<5)
#define L5CM_TERM_VARS_ACK_ON_FIN_RECEIVED_SBIT_SHIFT 5
#define L5CM_TERM_VARS_TERM_ON_CHIP (0x1<<6)
#define L5CM_TERM_VARS_TERM_ON_CHIP_SHIFT 6
#define L5CM_TERM_VARS_RSRV (0x1<<7)
#define L5CM_TERM_VARS_RSRV_SHIFT 7
};




/*
 * Tstorm Tcp flags
 */
struct tstorm_l5cm_tcp_flags {
	vmk_uint16 flags;
#define TSTORM_L5CM_TCP_FLAGS_VLAN_ID (0xFFF<<0)
#define TSTORM_L5CM_TCP_FLAGS_VLAN_ID_SHIFT 0
#define TSTORM_L5CM_TCP_FLAGS_DELAYED_ACK_EN (0x1<<12)
#define TSTORM_L5CM_TCP_FLAGS_DELAYED_ACK_SHIFT 12
#define TSTORM_L5CM_TCP_FLAGS_TS_ENABLED (0x1<<13)
#define TSTORM_L5CM_TCP_FLAGS_TS_ENABLED_SHIFT 13
#define TSTORM_L5CM_TCP_FLAGS_RSRV1 (0x3<<14)
#define TSTORM_L5CM_TCP_FLAGS_RSRV1_SHIFT 14
};


/*
 * Xstorm Tcp flags
 */
struct xstorm_l5cm_tcp_flags {
	vmk_uint8 flags;
#define XSTORM_L5CM_TCP_FLAGS_ENC_ENABLED (0x1<<0)
#define XSTORM_L5CM_TCP_FLAGS_ENC_ENABLED_SHIFT 0
#define XSTORM_L5CM_TCP_FLAGS_TS_ENABLED (0x1<<1)
#define XSTORM_L5CM_TCP_FLAGS_TS_ENABLED_SHIFT 1
#define XSTORM_L5CM_TCP_FLAGS_WND_SCL_EN (0x1<<2)
#define XSTORM_L5CM_TCP_FLAGS_WND_SCL_EN_SHIFT 2
#define XSTORM_L5CM_TCP_FLAGS_RSRV (0x1F<<3)
#define XSTORM_L5CM_TCP_FLAGS_RSRV_SHIFT 3
};



/*
 * Out-of-order states
 */
enum tcp_ooo_event {
	TCP_EVENT_ADD_PEN=0,
	TCP_EVENT_ADD_NEW_ISLE=1,
	TCP_EVENT_ADD_ISLE_RIGHT=2,
	TCP_EVENT_ADD_ISLE_LEFT=3,
	TCP_EVENT_JOIN=4,
	TCP_EVENT_NOP=5,
	MAX_TCP_OOO_EVENT
};


/*
 * OOO support modes
 */
enum tcp_tstorm_ooo {
	TCP_TSTORM_OOO_DROP_AND_PROC_ACK=0,
	TCP_TSTORM_OOO_SEND_PURE_ACK=1,
	TCP_TSTORM_OOO_SUPPORTED=2,
	MAX_TCP_TSTORM_OOO
};









#endif /* __5710_HSI_CNIC_LE__ */
