
#ifndef __QFLE3_COMPAT_H__
#define __QFLE3_COMPAT_H__

#if 1
#if (__BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__)
#undef  __BIG_ENDIAN
#define __LITTLE_ENDIAN	1
#elif (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
#define __BIG_ENDIAN	1
#undef  __LITTLE_ENDIAN
#else
#error "Unsupported endian mode"
#endif
#else
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
#define __BIG_ENDIAN	1
#undef  __LITTLE_ENDIAN
#error "Is big endian"
#elif (__BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__)
#undef  __BIG_ENDIAN
#define __LITTLE_ENDIAN	1
#error "Is little endian"
#else
#error "Unsupported endian mode"
#endif
#endif

#define bswap16(x)   vmk_CPUToBE16(x)
#define bswap32(x)   vmk_CPUToBE32(x)
#define bswap64(x)   vmk_CPUToBE64(x)

#ifdef __BIG_ENDIAN
#define htole64(x)   bswap64((x))
#define le64toh(x)   bswap64((x))
#define htole32(x)   bswap32((x))
#define le32toh(x)   bswap32((x))
#define htole16(x)   bswap16((x))
#define le16toh(x)   bswap16((x))
#else
#define htole64(x) ((vmk_uint64)(x))
#define le64toh(x) ((vmk_uint64)(x))
#define htole32(x) ((vmk_uint32)(x))
#define le32toh(x) ((vmk_uint32)(x))
#define htole16(x) ((vmk_uint16)(x))
#define le16toh(x) ((vmk_uint16)(x))
#endif

typedef vmk_uint16 __le16;
typedef vmk_uint32 __le32;
typedef vmk_uint64 __le64;

typedef vmk_uint16 __be16;
typedef vmk_uint32 __be32;
typedef vmk_uint64 __be64;

typedef vmk_IOA ecore_dma_addr_t;
typedef vmk_ListLinks    ecore_list_entry_t;
typedef vmk_ListLinks    ecore_list_t;
typedef vmk_Semaphore	ECORE_MUTEX;
typedef vmk_Lock ECORE_MUTEX_SPIN;
typedef vmk_atomic64 ecore_atomic_t;

#define ETH_ALEN	VMK_ETH_ADDR_LENGTH

#define PCI_COMMAND             0x04    /* 16 bits */
#define  PCI_COMMAND_INTX_DISABLE 0x400 /* INTx Emulation Disable */

#define	PCI_CAP_ID_EXP 		0x10
#define	PCI_CAP_ID_MSIX		0x11

#define	PCI_EXP_DEVSTA         10
#define	PCI_EXP_DEVSTA_TRPND   0x0020
#define	PCI_EXP_DEVCTL          8
#define	PCI_EXP_DEVCTL_PAYLOAD 0x00e0
#define	PCI_EXP_DEVCTL_READRQ  0x7000

#define PCI_MSIX_FLAGS          2
#define	PCI_MSIX_FLAGS_QSIZE   0x07FF

/* Bit Vector 64 bit ops*/	
#define BIT_VEC64_ELEM_SZ     64
#define BIT_VEC64_ELEM_SHIFT  6
#define BIT_VEC64_ELEM_MASK   ((vmk_uint64)BIT_VEC64_ELEM_SZ - 1)

#define __BIT_VEC64_SET_BIT(el, bit)            \
    do {                                        \
        el = ((el) | ((vmk_uint64)0x1 << (bit))); \
    } while (0)

#define __BIT_VEC64_CLEAR_BIT(el, bit)             \
    do {                                           \
        el = ((el) & (~((vmk_uint64)0x1 << (bit)))); \
    } while (0)

#define BIT_VEC64_SET_BIT(vec64, idx)                           \
    __BIT_VEC64_SET_BIT((vec64)[(idx) >> BIT_VEC64_ELEM_SHIFT], \
                        (idx) & BIT_VEC64_ELEM_MASK)

#define BIT_VEC64_CLEAR_BIT(vec64, idx)                           \
    __BIT_VEC64_CLEAR_BIT((vec64)[(idx) >> BIT_VEC64_ELEM_SHIFT], \
                          (idx) & BIT_VEC64_ELEM_MASK)

#define BIT_VEC64_TEST_BIT(vec64, idx)          \
    (((vec64)[(idx) >> BIT_VEC64_ELEM_SHIFT] >> \
      ((idx) & BIT_VEC64_ELEM_MASK)) & 0x1)

#define ECORE_BITS_PER_BYTE      (8)
#define ECORE_BITS_PER_UL        (sizeof(unsigned long) * ECORE_BITS_PER_BYTE)
#define ECORE_BITS_PER_UL_MASK   (ECORE_BITS_PER_UL - 1)

/*Bit ops. Non-atomic*/
static inline void ECORE_SET_BIT(vmk_uint32 nr, unsigned long *addr)
{
        addr[nr/ECORE_BITS_PER_UL] |= 1UL << (nr & ECORE_BITS_PER_UL_MASK);
}

static inline void ECORE_CLEAR_BIT(vmk_uint32 nr, unsigned long *addr)
{
        addr[nr/ECORE_BITS_PER_UL] &= ~(1UL << (nr & ECORE_BITS_PER_UL_MASK));
}

static inline vmk_Bool ECORE_TEST_BIT(vmk_uint32 nr, unsigned long *addr)
{
        return !!(addr[nr/ECORE_BITS_PER_UL] & (1UL << (nr & ECORE_BITS_PER_UL_MASK)));
}

static inline vmk_Bool ECORE_TEST_AND_CLEAR_BIT(vmk_uint32 nr, unsigned long *addr)
{
		vmk_Bool ret;
        ret = !!(addr[nr/ECORE_BITS_PER_UL] & (1UL << (nr & ECORE_BITS_PER_UL_MASK)));
		
        addr[nr/ECORE_BITS_PER_UL] &= ~(1UL << (nr & ECORE_BITS_PER_UL_MASK));
		return ret;
}

#define ECORE_RET_PENDING(pending_bit, pending) \
    (ECORE_TEST_BIT(pending_bit, pending) ? ECORE_PENDING : ECORE_SUCCESS)

#define ECORE_SET_BIT_NA	ECORE_SET_BIT
#define ECORE_CLEAR_BIT_NA	ECORE_CLEAR_BIT

#define ECORE_SET_FLAG(value, mask, flag) \
        do {\
                (value) &= ~(mask);\
                (value) |= ((flag) << (mask##_SHIFT));\
        } while (0)

#define ECORE_GET_FLAG(value, mask) \
        (((value) & (mask)) >> (mask##_SHIFT))

#define SET_BIT	ECORE_SET_BIT

/*Atomic Operations*/
#define ECORE_ATOMIC_SET		vmk_AtomicWrite64
#define ECORE_ATOMIC_READ		vmk_AtomicRead64
#define ECORE_ATOMIC_CMPXCHG	vmk_AtomicReadIfEqualWrite64

#define GET_FLAGS(flags, bits)   ((flags) & (bits))
#define SET_FLAGS(flag, val)	((flag) |= (val))
#define RESET_FLAGS(flags, bits)        ((flags) &= ~(bits))

static inline vmk_int32 qfle3_ilog2(vmk_int32 x)
{
	vmk_int32 log = 0;
	while (x >>= 1) log++;
	return (log);
}

static inline vmk_int32
qfle3_pcie_cap_read_word(vmk_PCIDevice pdev,
		vmk_int32 pos, vmk_uint32 *val)
{
	VMK_ReturnStatus status;
	vmk_uint16 pcie_cap_offset;

	status = vmk_PCIFindCapability(pdev,
			PCI_CAP_ID_EXP, &pcie_cap_offset);

	if (status != VMK_OK) {
		return -1;
	}

	return vmk_PCIReadConfig(vmk_ModuleCurrentID, pdev,
			VMK_PCI_CONFIG_ACCESS_16,
			pcie_cap_offset + pos, val);
}

#endif
