/*******************************************************************************
 * See COPYRIGHT.txt & LICENSE.txt for copyright and licensing details.
 *******************************************************************************/

#ifndef QFLE3F_VMK_H
#define QFLE3F_VMK_H

#include <vmkapi.h>
//#include <qfle3f.h>

#define U64_HI(val) ((vmk_uint32)(((vmk_uint64)(val)) >> 32))
#define U64_LO(val) ((vmk_uint32)(((vmk_uint64)(val)) & 0xffffffff))

#define GET_DMA_ADDR(x) ((vmk_uint64)(x).MachSg->elem[0].ioAddr)

struct qfle3fHBA;

typedef enum {
    LOCK_RANK_LOWEST = 1,
    LOCK_RANK_MEDIUM,
    LOCK_RANK_HIGHEST,
    LOCK_RANK_HIGHEST_MORE,
} ql_vmk_lock_rank;

struct qla_dmamem {
    vmk_SgOpsHandle SgOps_handle;
    vmk_SgOpsHandle SgOps_handle_out;
    vmk_SgArray *MachSg;
    vmk_uint32 dma_size;
    void *virtaddr;
};


void *qfle3f_alloc(vmk_uint32 size);
void *qfle3fFwDumpAlloc(vmk_uint32 size);
inline void qfle3f_free(void *buffer);

int qfle3f_dma_map(struct qfle3fHBA *hba, void *mem, struct qla_dmamem *buffer, vmk_uint32 size);
void qfle3f_dma_unmap(struct qfle3fHBA *hba, struct qla_dmamem *buffer);

void *qfle3f_dma_alloc(struct qfle3fHBA *hba, struct qla_dmamem *buffer, vmk_uint32 size);
void qfle3f_dma_free(struct qfle3fHBA *hba, struct qla_dmamem *buffer);


void * qfle3f_dma_slab_alloc(struct qfle3fHBA *hba, vmk_SlabID slab_id,
                struct qla_dmamem *buffer, vmk_uint32 size);
void qfle3f_dma_slab_free(struct qfle3fHBA *hba, vmk_SlabID slab_id, struct qla_dmamem *buffer);

VMK_ReturnStatus qfle3f_vmk_spin_lock_init(vmk_Lock *lock, ql_vmk_lock_rank lock_rank,
	const char *name);

void ql_vmk_ref_init(vmk_atomic64 *refcount);
vmk_uint16 ql_vmk_ref_get(vmk_atomic64 *refcount);
vmk_uint16 ql_vmk_ref_put(vmk_atomic64 *refcount,
    void (*release)(void *arg), void* arg);

typedef void (*ql_vmk_singlethread_workhandler_t) (void *);

typedef struct singlethread_workitem {
	vmk_ListLinks links;
	ql_vmk_singlethread_workhandler_t handler;
	vmk_uint64 event;
	void *data1;
	void *data2;
#define INACTIVE 0
#define ACTIVE	1
#define DELAY_ACTIVE 2
	int workitem_state;
} ql_vmk_singlethread_workitem_t;

typedef struct ql_vmk_singlethread_workqueue {
	vmk_WorldID world_id;
	void *data;
	vmk_Lock lock;
	vmk_ListLinks work_items;
	ql_vmk_singlethread_workitem_t tasklet_item;
	char name[40];
} ql_vmk_singlethread_workqueue_t;

VMK_ReturnStatus ql_vmk_do_singlethread_work(void *data);
void ql_vmk_init_singlethread_workitem(ql_vmk_singlethread_workitem_t *item,
							ql_vmk_singlethread_workhandler_t handler,
							void *data1, void *data2);
void ql_vmk_singlethread_queue_work(ql_vmk_singlethread_workqueue_t *wq,
							ql_vmk_singlethread_workitem_t *item);
ql_vmk_singlethread_workqueue_t *ql_vmk_create_singlethread_workqueue(
							const char *name, vmk_WorldSchedClass prio);
void ql_vmk_destroy_singlethread_workqueue(ql_vmk_singlethread_workqueue_t *wq);

typedef struct ql_vmk_singlethread_delayed_workitem {
	ql_vmk_singlethread_workitem_t work;
	vmk_Timer timer;
	ql_vmk_singlethread_workqueue_t *wq;
} ql_vmk_singlethread_delayed_workitem_t;

void ql_vmk_init_singlethread_delayed_workitem(
	ql_vmk_singlethread_delayed_workitem_t *);

VMK_ReturnStatus ql_vmk_queue_delayed_work(vmk_TimerQueue tq,
							ql_vmk_singlethread_workqueue_t *wq,
							ql_vmk_singlethread_delayed_workitem_t *,
							void *handler,
							void *data1, void *data2, unsigned long);
void ql_vmk_handle_tmo(ql_vmk_singlethread_delayed_workitem_t *);
VMK_ReturnStatus
ql_vmk_cancel_delayed_work(ql_vmk_singlethread_delayed_workitem_t *);
VMK_ReturnStatus
ql_vmk_cancel_delayed_work_sync(ql_vmk_singlethread_delayed_workitem_t *);

inline void qfle3f_charArrayToVmku64(vmk_uint8 *input,
		int inputSize, vmk_uint64* output);
void qfle3f_u64ToCharArray_BE(vmk_uint64 input,
		int inputSize, vmk_uint8 *output);
void qfle3f_u64ToCharArray(vmk_uint64 input,
		int inputSize, vmk_uint8 *output);
inline void qfle3f_int_to_scsilun_with_sec_lun_id(vmk_uint16 lun,
		vmk_uint8 *scsi_lun,
		vmk_uint64 sllid);

/* Borrowed from cnic_vmk.c file for cnic_if.h file */
typedef struct ql_vmk_tasklet {
    vmk_WorldID world_id;
    void (*func)(void *);
    void *data;
    char name[40];
} ql_vmk_tasklet_t;

#define container_of(ptr, type, member) ({                      \
    const typeof(((type *)0)->member) *__mptr = (ptr);    \
    (type *)((char *)__mptr - vmk_offsetof(type,member));})

VMK_ReturnStatus qfle3f_sleepWithCondition(struct qfle3fHBA *hba, void *data,
                        vmk_WorldEventID event, vmk_Lock lockHeld, vmk_uint32 timeout,
                        char *desciption,
                        vmk_Bool (*checkCondition)(void *data1));

#endif  /* QFLE3F_VMK_H */
