# Driver definition for qfle3i driver.
#
# When developing a driver for release through the async program:
#  * set "vendor" to the name of your company
#  * set "license" to one of the VMK_MODULE_LICENSE_* strings if applicable;
#    otherwise, set it to a 1-word identification of your module's license
#  * set "vendor_code" to your company's VMware-assigned Vendor Code
#  * set "vendor_email" to the contact e-mail provided by your company
#  * increment the version number if the source has come from VMware
#  * remove "version_bump" if present
#
# When bringing an async driver inbox at VMware:
#  * leave "version" as is from the async release
#  * set "license" to VMK_MODULE_LICENSE_BSD (unquoted)
#  * set "version_bump" to 1
#  * set "vendor" to "VMware, Inc."
#  * set "vendor_code" to "VMW"
#  * set "vendor_email" to the VMware contact e-mail address
#
# If updating the driver at VMware:
#  * increment "version bump" or contact the IHV for a new version number
#
# If updating the driver at an async vendor:
#  * increment the version number (do not touch version bump)

#
# identification section
#
qfle3i_identification = {
   "name"            : "qfle3i",
   "module type"     : "device driver",
   "binary compat"   : "yes",
   "summary"         : "Native E3 iSCSI Driver",
   "description"     : "Qlogic E3 iSCSI Native Driver",
   "version"         : "1.0.23.0",
   "license"         : "QLogic_Proprietary",
   "vendor"          : "QLogic",
   "vendor_code"     : "QLC",
   "vendor_email"    : "support@qlogic.com",
}

#
# Build the Driver Module
#
module_def = {
   "identification"  : qfle3i_identification,
   "source files"    : [
				"qfle3i_drv.c",
				"qfle3i_vmk.c",
				"qfle3i_main.c",
				"qfle3i_scsi.c",
				"qfle3i_iscsi.c",
				"qfle3i_hwi.c",
				"qfle3i_vmkmgmt.c",
                       ],
   "cc flags"	     : [
			 "-Wno-unused-variable",
			 "-Wno-unused-function",
			 "-DCNIC_STORAGE_IF",
		       ],
   "cc defs"         : [
			 # For vmk_ScsiSchedCommandCompletion.
			 # Remove when PR 956728 is fixed.
			 # "VMK_DEVKIT_HAS_API_VMKAPI_MPP",
			 # Macro for ESX DDK version
			 "VMWARE_ESX_DDK_VERSION=67000",
			 "Wall"
		       ],
}
qfle3i_module = defineKernelModule(module_def)

#
# Build the Driver's Device Definition
#
pci_device_def = {
   "identification"  : qfle3i_identification,
   "device spec"     : "qfle3i_devices.py",
}
qfle3i_pci_device_def = defineDeviceSpec(pci_device_def)

#
# Build the VIB
#
qfle3i_vib_def = {
   "identification"  : qfle3i_identification,
   "payload"         : [ qfle3i_module,
                         qfle3i_pci_device_def,
                       ],
   "vib properties"  : {
      "urls":                [],
      "provides":            [],
      "depends":             [],
      "maintenance-mode":    True,
      "hwplatform":          [],

      # Can use strings to define Boolean values  - see below
      "acceptance-level": 'certified',
      "live-install-allowed": False,
      "live-remove-allowed": 'false',
      "cimom-restart": False,
      "stateless-ready": 'True',
      "overlay": False,
   }
}
qfle3i_vib =  defineModuleVib(qfle3i_vib_def)

#
# Build the Offline Bundle
#
qfle3i_bulletin_def = {
   "identification"  : qfle3i_identification,
   "vib"             : qfle3i_vib,

   "bulletin"        : {
      # These elements show the default values for the corresponding items in bulletin.xml file
      # Uncomment a line if you need to use a different value
      #'severity'    : 'general',
      #'category'    : 'Enhancement',
      #'releaseType' : 'extension',
      #'urgency'     : 'Important',

      'kbUrl'       : 'http://kb.vmware.com/kb/example.html',

      # 1. At least one target platform needs to be specified with 'productLineID'
      # 2. The product version number may be specified explicitly, like 7.8.9,
      # or, when it's None or skipped, be a default one for the devkit
      # 3. 'locale' element is optional
      'platforms'   : [
                        {'productLineID':'ESXi'},
      #                 {'productLineID':'ESX',  'version':None, 'locale':''},
      #                 {'productLineID':'ESXi', 'version':"7.8.9", 'locale':''}
                      ],
   },
}
qfle3i_bundle =  defineOfflineBundle(qfle3i_bulletin_def)
