/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.SupertypeLoopChecker;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationSplitter;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.annotations.CompositeAnnotations;
import org.jetbrains.kotlin.descriptors.impl.ClassConstructorDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.FieldDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.PropertyDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.PropertyGetterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.PropertySetterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtContextReceiver;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProjectionKind;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtPureClassOrObject;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeConstraint;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.AdditionalClassPartsProvider;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DeclarationReturnTypeSanitizer;
import org.jetbrains.kotlin.resolve.DeclarationSignatureAnonymousTypeTransformer;
import org.jetbrains.kotlin.resolve.DefinitelyNonNullableTypesKt;
import org.jetbrains.kotlin.resolve.DescriptorFactory;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ModifiersChecker;
import org.jetbrains.kotlin.resolve.OverloadChecker;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.VariableAsPropertyInfo;
import org.jetbrains.kotlin.resolve.VariableTypeAndInitializerResolver;
import org.jetbrains.kotlin.resolve.calls.components.InferenceSession;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfoFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.util.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.UnderscoreUtilKt;
import org.jetbrains.kotlin.resolve.extensions.SyntheticResolveExtension;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyTypeAliasDescriptor;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.resolve.scopes.LocalRedeclarationChecker;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.ScopeUtils;
import org.jetbrains.kotlin.resolve.scopes.SubstitutingScope;
import org.jetbrains.kotlin.resolve.scopes.TraceBasedLocalRedeclarationChecker;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.SpecialTypesKt;
import org.jetbrains.kotlin.types.TypeApproximator;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.WrappedTypeFactory;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.error.ErrorTypeKind;
import org.jetbrains.kotlin.types.error.ErrorUtils;
import org.jetbrains.kotlin.types.expressions.DestructuringDeclarationResolver;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.FunctionsTypingVisitor;
import org.jetbrains.kotlin.types.expressions.PreliminaryDeclarationVisitor;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

public class DescriptorResolver {
    private final TypeResolver typeResolver;
    private final AnnotationResolver annotationResolver;
    private final StorageManager storageManager;
    private final KotlinBuiltIns builtIns;
    private final SupertypeLoopChecker supertypeLoopsResolver;
    private final VariableTypeAndInitializerResolver variableTypeAndInitializerResolver;
    private final ExpressionTypingServices expressionTypingServices;
    private final OverloadChecker overloadChecker;
    private final LanguageVersionSettings languageVersionSettings;
    private final FunctionsTypingVisitor functionsTypingVisitor;
    private final DestructuringDeclarationResolver destructuringDeclarationResolver;
    private final ModifiersChecker modifiersChecker;
    private final WrappedTypeFactory wrappedTypeFactory;
    private final SyntheticResolveExtension syntheticResolveExtension;
    private final TypeApproximator typeApproximator;
    private final DeclarationReturnTypeSanitizer declarationReturnTypeSanitizer;
    private final DataFlowValueFactory dataFlowValueFactory;
    private final Iterable<DeclarationSignatureAnonymousTypeTransformer> anonymousTypeTransformers;
    private final AdditionalClassPartsProvider additionalClassPartsProvider;

    public DescriptorResolver(@NotNull AnnotationResolver annotationResolver, @NotNull KotlinBuiltIns builtIns2, @NotNull StorageManager storageManager, @NotNull TypeResolver typeResolver, @NotNull SupertypeLoopChecker supertypeLoopsResolver, @NotNull VariableTypeAndInitializerResolver variableTypeAndInitializerResolver, @NotNull ExpressionTypingServices expressionTypingServices, @NotNull OverloadChecker overloadChecker, @NotNull LanguageVersionSettings languageVersionSettings2, @NotNull FunctionsTypingVisitor functionsTypingVisitor, @NotNull DestructuringDeclarationResolver destructuringDeclarationResolver, @NotNull ModifiersChecker modifiersChecker, @NotNull WrappedTypeFactory wrappedTypeFactory, @NotNull Project project, @NotNull TypeApproximator approximator, @NotNull DeclarationReturnTypeSanitizer declarationReturnTypeSanitizer, @NotNull DataFlowValueFactory dataFlowValueFactory, @NotNull Iterable<DeclarationSignatureAnonymousTypeTransformer> anonymousTypeTransformers, @NotNull AdditionalClassPartsProvider additionalClassPartsProvider) {
        if (annotationResolver == null) {
            DescriptorResolver.$$$reportNull$$$0(0);
        }
        if (builtIns2 == null) {
            DescriptorResolver.$$$reportNull$$$0(1);
        }
        if (storageManager == null) {
            DescriptorResolver.$$$reportNull$$$0(2);
        }
        if (typeResolver == null) {
            DescriptorResolver.$$$reportNull$$$0(3);
        }
        if (supertypeLoopsResolver == null) {
            DescriptorResolver.$$$reportNull$$$0(4);
        }
        if (variableTypeAndInitializerResolver == null) {
            DescriptorResolver.$$$reportNull$$$0(5);
        }
        if (expressionTypingServices == null) {
            DescriptorResolver.$$$reportNull$$$0(6);
        }
        if (overloadChecker == null) {
            DescriptorResolver.$$$reportNull$$$0(7);
        }
        if (languageVersionSettings2 == null) {
            DescriptorResolver.$$$reportNull$$$0(8);
        }
        if (functionsTypingVisitor == null) {
            DescriptorResolver.$$$reportNull$$$0(9);
        }
        if (destructuringDeclarationResolver == null) {
            DescriptorResolver.$$$reportNull$$$0(10);
        }
        if (modifiersChecker == null) {
            DescriptorResolver.$$$reportNull$$$0(11);
        }
        if (wrappedTypeFactory == null) {
            DescriptorResolver.$$$reportNull$$$0(12);
        }
        if (project == null) {
            DescriptorResolver.$$$reportNull$$$0(13);
        }
        if (approximator == null) {
            DescriptorResolver.$$$reportNull$$$0(14);
        }
        if (declarationReturnTypeSanitizer == null) {
            DescriptorResolver.$$$reportNull$$$0(15);
        }
        if (dataFlowValueFactory == null) {
            DescriptorResolver.$$$reportNull$$$0(16);
        }
        if (anonymousTypeTransformers == null) {
            DescriptorResolver.$$$reportNull$$$0(17);
        }
        if (additionalClassPartsProvider == null) {
            DescriptorResolver.$$$reportNull$$$0(18);
        }
        this.annotationResolver = annotationResolver;
        this.builtIns = builtIns2;
        this.storageManager = storageManager;
        this.typeResolver = typeResolver;
        this.supertypeLoopsResolver = supertypeLoopsResolver;
        this.variableTypeAndInitializerResolver = variableTypeAndInitializerResolver;
        this.expressionTypingServices = expressionTypingServices;
        this.overloadChecker = overloadChecker;
        this.languageVersionSettings = languageVersionSettings2;
        this.functionsTypingVisitor = functionsTypingVisitor;
        this.destructuringDeclarationResolver = destructuringDeclarationResolver;
        this.modifiersChecker = modifiersChecker;
        this.wrappedTypeFactory = wrappedTypeFactory;
        this.syntheticResolveExtension = SyntheticResolveExtension.Companion.getInstance(project);
        this.typeApproximator = approximator;
        this.declarationReturnTypeSanitizer = declarationReturnTypeSanitizer;
        this.dataFlowValueFactory = dataFlowValueFactory;
        this.anonymousTypeTransformers = anonymousTypeTransformers;
        this.additionalClassPartsProvider = additionalClassPartsProvider;
    }

    public List<KotlinType> resolveSupertypes(@NotNull LexicalScope scope2, @NotNull ClassDescriptor classDescriptor2, @Nullable KtPureClassOrObject correspondingClassOrObject, BindingTrace trace) {
        if (scope2 == null) {
            DescriptorResolver.$$$reportNull$$$0(19);
        }
        if (classDescriptor2 == null) {
            DescriptorResolver.$$$reportNull$$$0(20);
        }
        ArrayList<KotlinType> supertypes2 = Lists.newArrayList();
        List<KtSuperTypeListEntry> delegationSpecifiers = correspondingClassOrObject == null ? Collections.emptyList() : correspondingClassOrObject.getSuperTypeListEntries();
        Collection<KotlinType> declaredSupertypes = DescriptorResolver.resolveSuperTypeListEntries(scope2, delegationSpecifiers, this.typeResolver, trace, false);
        for (KotlinType declaredSupertype : declaredSupertypes) {
            DescriptorResolver.addValidSupertype(supertypes2, declaredSupertype);
        }
        if (classDescriptor2.getKind() == ClassKind.ENUM_CLASS && !DescriptorResolver.containsClass(supertypes2)) {
            supertypes2.add(0, this.builtIns.getEnumType(classDescriptor2.getDefaultType()));
        }
        this.syntheticResolveExtension.addSyntheticSupertypes(classDescriptor2, supertypes2);
        supertypes2.addAll(this.additionalClassPartsProvider.getAdditionalSupertypes(classDescriptor2, supertypes2));
        if (supertypes2.isEmpty()) {
            DescriptorResolver.addValidSupertype(supertypes2, this.getDefaultSupertype(classDescriptor2));
        }
        return supertypes2;
    }

    private static void addValidSupertype(List<KotlinType> supertypes2, KotlinType declaredSupertype) {
        if (!KotlinTypeKt.isError(declaredSupertype)) {
            supertypes2.add(declaredSupertype);
        }
    }

    private static boolean containsClass(Collection<KotlinType> result2) {
        for (KotlinType type2 : result2) {
            ClassifierDescriptor descriptor2 = type2.getConstructor().getDeclarationDescriptor();
            if (!(descriptor2 instanceof ClassDescriptor) || ((ClassDescriptor)descriptor2).getKind() == ClassKind.INTERFACE) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private KotlinType getDefaultSupertype(@NotNull ClassDescriptor classDescriptor2) {
        if (classDescriptor2 == null) {
            DescriptorResolver.$$$reportNull$$$0(21);
        }
        if (classDescriptor2.getKind() == ClassKind.ENUM_ENTRY) {
            SimpleType simpleType2 = ((ClassDescriptor)classDescriptor2.getContainingDeclaration()).getDefaultType();
            if (simpleType2 == null) {
                DescriptorResolver.$$$reportNull$$$0(22);
            }
            return simpleType2;
        }
        if (classDescriptor2.getKind() == ClassKind.ANNOTATION_CLASS) {
            SimpleType simpleType3 = this.builtIns.getAnnotationType();
            if (simpleType3 == null) {
                DescriptorResolver.$$$reportNull$$$0(23);
            }
            return simpleType3;
        }
        SimpleType simpleType4 = this.builtIns.getAnyType();
        if (simpleType4 == null) {
            DescriptorResolver.$$$reportNull$$$0(24);
        }
        return simpleType4;
    }

    private static Collection<KotlinType> resolveSuperTypeListEntries(LexicalScope extensibleScope, List<KtSuperTypeListEntry> delegationSpecifiers, @NotNull TypeResolver resolver, BindingTrace trace, boolean checkBounds) {
        if (resolver == null) {
            DescriptorResolver.$$$reportNull$$$0(25);
        }
        if (delegationSpecifiers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<KotlinType> result2 = Lists.newArrayList();
        for (KtSuperTypeListEntry delegationSpecifier : delegationSpecifiers) {
            KtTypeReference typeReference = delegationSpecifier.getTypeReference();
            if (typeReference != null) {
                KotlinType supertype2 = resolver.resolveType(extensibleScope, typeReference, trace, checkBounds);
                if (DynamicTypesKt.isDynamic(supertype2)) {
                    trace.report(Errors.DYNAMIC_SUPERTYPE.on(typeReference));
                    continue;
                }
                result2.add(supertype2);
                KtTypeElement bareSuperType = DescriptorResolver.checkNullableSupertypeAndStripQuestionMarks(trace, typeReference.getTypeElement());
                DescriptorResolver.checkProjectionsInImmediateArguments(trace, bareSuperType, supertype2);
                continue;
            }
            result2.add(ErrorUtils.createErrorType(ErrorTypeKind.UNRESOLVED_TYPE, delegationSpecifier.getText()));
        }
        return result2;
    }

    @Nullable
    private static KtTypeElement checkNullableSupertypeAndStripQuestionMarks(@NotNull BindingTrace trace, @Nullable KtTypeElement typeElement) {
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(26);
        }
        while (typeElement instanceof KtNullableType) {
            KtNullableType nullableType = (KtNullableType)typeElement;
            if ((typeElement = nullableType.getInnerType()) instanceof KtNullableType || typeElement == null) continue;
            trace.report(Errors.NULLABLE_SUPERTYPE.on(nullableType));
        }
        return typeElement;
    }

    private static void checkProjectionsInImmediateArguments(@NotNull BindingTrace trace, @Nullable KtTypeElement typeElement, @NotNull KotlinType type2) {
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(27);
        }
        if (type2 == null) {
            DescriptorResolver.$$$reportNull$$$0(28);
        }
        if (typeElement == null) {
            return;
        }
        boolean hasProjectionsInWrittenArguments = false;
        if (typeElement instanceof KtUserType) {
            KtUserType userType = (KtUserType)typeElement;
            List<KtTypeProjection> typeArguments = userType.getTypeArguments();
            for (KtTypeProjection typeArgument : typeArguments) {
                if (typeArgument.getProjectionKind() == KtProjectionKind.NONE) continue;
                trace.report(Errors.PROJECTION_IN_IMMEDIATE_ARGUMENT_TO_SUPERTYPE.on(typeArgument));
                hasProjectionsInWrittenArguments = true;
            }
        }
        if (!KotlinTypeKt.isError(type2) && SpecialTypesKt.getAbbreviatedType(type2) != null && !hasProjectionsInWrittenArguments && TypeUtilsKt.isInterface(type2) && TypeUtilsKt.containsTypeProjectionsInTopLevelArguments(type2)) {
            trace.report(Errors.EXPANDED_TYPE_CANNOT_BE_INHERITED.on(typeElement, type2));
        }
    }

    public static DescriptorVisibility getDefaultVisibility(KtModifierListOwner modifierListOwner, DeclarationDescriptor containingDescriptor) {
        KtModifierList modifierList2;
        DescriptorVisibility defaultVisibility = containingDescriptor instanceof ClassDescriptor ? ((modifierList2 = modifierListOwner.getModifierList()) != null && modifierList2.hasModifier(KtTokens.OVERRIDE_KEYWORD) ? DescriptorVisibilities.INHERITED : DescriptorVisibilities.DEFAULT_VISIBILITY) : (containingDescriptor instanceof FunctionDescriptor || containingDescriptor instanceof PropertyDescriptor ? DescriptorVisibilities.LOCAL : DescriptorVisibilities.DEFAULT_VISIBILITY);
        return defaultVisibility;
    }

    public static Modality getDefaultModality(DeclarationDescriptor containingDescriptor, DescriptorVisibility visibility2, boolean isBodyPresent) {
        Modality defaultModality;
        if (containingDescriptor instanceof ClassDescriptor) {
            boolean isTrait = ((ClassDescriptor)containingDescriptor).getKind() == ClassKind.INTERFACE;
            boolean isDefinitelyAbstract = isTrait && !isBodyPresent;
            Modality basicModality = isTrait && !DescriptorVisibilities.isPrivate(visibility2) ? Modality.OPEN : Modality.FINAL;
            defaultModality = isDefinitelyAbstract ? Modality.ABSTRACT : basicModality;
        } else {
            defaultModality = Modality.FINAL;
        }
        return defaultModality;
    }

    @NotNull
    public ValueParameterDescriptorImpl resolveValueParameterDescriptor(@NotNull LexicalScope scope2, @NotNull FunctionDescriptor owner, @NotNull KtParameter valueParameter2, int index2, @NotNull KotlinType type2, @NotNull BindingTrace trace, @NotNull Annotations additionalAnnotations, @Nullable InferenceSession inferenceSession) {
        Function0 destructuringVariables;
        if (scope2 == null) {
            DescriptorResolver.$$$reportNull$$$0(29);
        }
        if (owner == null) {
            DescriptorResolver.$$$reportNull$$$0(30);
        }
        if (valueParameter2 == null) {
            DescriptorResolver.$$$reportNull$$$0(31);
        }
        if (type2 == null) {
            DescriptorResolver.$$$reportNull$$$0(32);
        }
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(33);
        }
        if (additionalAnnotations == null) {
            DescriptorResolver.$$$reportNull$$$0(34);
        }
        KotlinType varargElementType2 = null;
        KotlinType variableType = type2;
        if (valueParameter2.hasModifier(KtTokens.VARARG_KEYWORD)) {
            varargElementType2 = type2;
            variableType = this.getVarargParameterType(type2);
        }
        Annotations valueParameterAnnotations = this.resolveValueParameterAnnotations(scope2, valueParameter2, trace, additionalAnnotations);
        KtDestructuringDeclaration destructuringDeclaration = valueParameter2.getDestructuringDeclaration();
        if (destructuringDeclaration != null) {
            if (!this.languageVersionSettings.supportsFeature(LanguageFeature.DestructuringLambdaParameters)) {
                trace.report(Errors.UNSUPPORTED_FEATURE.on(valueParameter2, (Pair<LanguageFeature, LanguageVersionSettings>)TuplesKt.to((Object)((Object)LanguageFeature.DestructuringLambdaParameters), (Object)this.languageVersionSettings)));
            }
            destructuringVariables = () -> {
                ReceiverParameterDescriptor dispatchReceiver = owner.getDispatchReceiverParameter();
                assert (dispatchReceiver == null || dispatchReceiver.getContainingDeclaration() instanceof ScriptDescriptor) : "Destructuring declarations are only be parsed for lambdas, and they must not have a dispatch receiver";
                LexicalScope scopeForDestructuring = ScopeUtilsKt.createScopeForDestructuring(scope2, owner.getExtensionReceiverParameter());
                List<VariableDescriptor> result2 = this.destructuringDeclarationResolver.resolveLocalVariablesFromDestructuringDeclaration(scope2, destructuringDeclaration, new TransientReceiver(type2), null, ExpressionTypingContext.newContext(trace, scopeForDestructuring, DataFlowInfoFactory.EMPTY, TypeUtils.NO_EXPECTED_TYPE, this.languageVersionSettings, this.dataFlowValueFactory, inferenceSession));
                this.modifiersChecker.withTrace(trace).checkModifiersForDestructuringDeclaration(destructuringDeclaration);
                return result2;
            };
        } else {
            destructuringVariables = null;
        }
        Name parameterName = destructuringDeclaration == null ? (!valueParameter2.hasValOrVar() && UnderscoreUtilKt.isSingleUnderscore(valueParameter2) ? Name.special("<anonymous parameter " + index2 + ">") : KtPsiUtil.safeName(valueParameter2.getName())) : Name.special("<name for destructuring parameter " + index2 + ">");
        ValueParameterDescriptorImpl valueParameterDescriptor = ValueParameterDescriptorImpl.createWithDestructuringDeclarations(owner, null, index2, valueParameterAnnotations, parameterName, variableType, valueParameter2.hasDefaultValue(), valueParameter2.hasModifier(KtTokens.CROSSINLINE_KEYWORD), valueParameter2.hasModifier(KtTokens.NOINLINE_KEYWORD), varargElementType2, KotlinSourceElementKt.toSourceElement(valueParameter2), (Function0<? extends List<? extends VariableDescriptor>>)destructuringVariables);
        trace.record(BindingContext.VALUE_PARAMETER, valueParameter2, valueParameterDescriptor);
        ValueParameterDescriptorImpl valueParameterDescriptorImpl = valueParameterDescriptor;
        if (valueParameterDescriptorImpl == null) {
            DescriptorResolver.$$$reportNull$$$0(35);
        }
        return valueParameterDescriptorImpl;
    }

    @NotNull
    private Annotations resolveValueParameterAnnotations(@NotNull LexicalScope scope2, @NotNull KtParameter parameter2, @NotNull BindingTrace trace, @NotNull Annotations additionalAnnotations) {
        KtModifierList modifierList2;
        if (scope2 == null) {
            DescriptorResolver.$$$reportNull$$$0(36);
        }
        if (parameter2 == null) {
            DescriptorResolver.$$$reportNull$$$0(37);
        }
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(38);
        }
        if (additionalAnnotations == null) {
            DescriptorResolver.$$$reportNull$$$0(39);
        }
        if ((modifierList2 = parameter2.getModifierList()) == null) {
            Annotations annotations2 = additionalAnnotations;
            if (annotations2 == null) {
                DescriptorResolver.$$$reportNull$$$0(40);
            }
            return annotations2;
        }
        Annotations allAnnotations = this.annotationResolver.resolveAnnotationsWithoutArguments(scope2, modifierList2, trace);
        if (!parameter2.hasValOrVar()) {
            return new CompositeAnnotations(allAnnotations, additionalAnnotations);
        }
        AnnotationSplitter splitter = new AnnotationSplitter(this.storageManager, allAnnotations, SetsKt.setOf((Object)((Object)AnnotationUseSiteTarget.CONSTRUCTOR_PARAMETER)));
        return new CompositeAnnotations(splitter.getAnnotationsForTarget(AnnotationUseSiteTarget.CONSTRUCTOR_PARAMETER), additionalAnnotations);
    }

    @NotNull
    private KotlinType getVarargParameterType(@NotNull KotlinType elementType) {
        SimpleType primitiveArrayType;
        if (elementType == null) {
            DescriptorResolver.$$$reportNull$$$0(41);
        }
        if ((primitiveArrayType = this.builtIns.getPrimitiveArrayKotlinTypeByPrimitiveKotlinType(elementType)) != null) {
            SimpleType simpleType2 = primitiveArrayType;
            if (simpleType2 == null) {
                DescriptorResolver.$$$reportNull$$$0(42);
            }
            return simpleType2;
        }
        SimpleType simpleType3 = this.builtIns.getArrayType(Variance.OUT_VARIANCE, elementType);
        if (simpleType3 == null) {
            DescriptorResolver.$$$reportNull$$$0(43);
        }
        return simpleType3;
    }

    public List<TypeParameterDescriptorImpl> resolveTypeParametersForDescriptor(DeclarationDescriptor containingDescriptor, LexicalWritableScope extensibleScope, LexicalScope scopeForAnnotationsResolve, List<KtTypeParameter> typeParameters2, BindingTrace trace) {
        List<TypeParameterDescriptorImpl> descriptors = this.resolveTypeParametersForDescriptor(containingDescriptor, scopeForAnnotationsResolve, typeParameters2, trace);
        for (TypeParameterDescriptorImpl descriptor2 : descriptors) {
            extensibleScope.addClassifierDescriptor(descriptor2);
        }
        return descriptors;
    }

    private List<TypeParameterDescriptorImpl> resolveTypeParametersForDescriptor(DeclarationDescriptor containingDescriptor, LexicalScope scopeForAnnotationsResolve, List<KtTypeParameter> typeParameters2, BindingTrace trace) {
        assert (containingDescriptor instanceof FunctionDescriptor || containingDescriptor instanceof PropertyDescriptor || containingDescriptor instanceof TypeAliasDescriptor) : "This method should be called for functions, properties, or type aliases, got " + containingDescriptor;
        ArrayList<TypeParameterDescriptorImpl> result2 = new ArrayList<TypeParameterDescriptorImpl>();
        int typeParametersSize = typeParameters2.size();
        for (int i = 0; i < typeParametersSize; ++i) {
            KtTypeParameter typeParameter2 = typeParameters2.get(i);
            result2.add(this.resolveTypeParameterForDescriptor(containingDescriptor, scopeForAnnotationsResolve, typeParameter2, i, trace));
        }
        return result2;
    }

    private TypeParameterDescriptorImpl resolveTypeParameterForDescriptor(DeclarationDescriptor containingDescriptor, LexicalScope scopeForAnnotationsResolve, KtTypeParameter typeParameter2, int index2, BindingTrace trace) {
        if (typeParameter2.getVariance() != Variance.INVARIANT) {
            trace.report(Errors.VARIANCE_ON_TYPE_PARAMETER_NOT_ALLOWED.on(typeParameter2));
        }
        Annotations annotations2 = this.annotationResolver.resolveAnnotationsWithArguments(scopeForAnnotationsResolve, typeParameter2.getModifierList(), trace);
        TypeParameterDescriptorImpl typeParameterDescriptor = TypeParameterDescriptorImpl.createForFurtherModification(containingDescriptor, annotations2, typeParameter2.hasModifier(KtTokens.REIFIED_KEYWORD), typeParameter2.getVariance(), KtPsiUtil.safeName(typeParameter2.getName()), index2, KotlinSourceElementKt.toSourceElement(typeParameter2), (Function1<KotlinType, Void>)((Function1)type2 -> {
            if (!(containingDescriptor instanceof TypeAliasDescriptor)) {
                trace.report(Errors.CYCLIC_GENERIC_UPPER_BOUND.on(typeParameter2));
            }
            return null;
        }), this.supertypeLoopsResolver, this.storageManager);
        trace.record(BindingContext.TYPE_PARAMETER, typeParameter2, typeParameterDescriptor);
        return typeParameterDescriptor;
    }

    @NotNull
    public static ClassConstructorDescriptorImpl createAndRecordPrimaryConstructorForObject(@Nullable KtPureClassOrObject object, @NotNull ClassDescriptor classDescriptor2, @NotNull BindingTrace trace) {
        if (classDescriptor2 == null) {
            DescriptorResolver.$$$reportNull$$$0(44);
        }
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(45);
        }
        ClassConstructorDescriptorImpl constructorDescriptor = DescriptorFactory.createPrimaryConstructorForObject(classDescriptor2, KotlinSourceElementKt.toSourceElement(object));
        if (object instanceof PsiElement) {
            KtPrimaryConstructor primaryConstructor2 = object.getPrimaryConstructor();
            trace.record(BindingContext.CONSTRUCTOR, primaryConstructor2 != null ? primaryConstructor2 : (PsiElement)((Object)object), constructorDescriptor);
        }
        ClassConstructorDescriptorImpl classConstructorDescriptorImpl = constructorDescriptor;
        if (classConstructorDescriptorImpl == null) {
            DescriptorResolver.$$$reportNull$$$0(46);
        }
        return classConstructorDescriptorImpl;
    }

    public void resolveGenericBounds(@NotNull KtTypeParameterListOwner declaration, @NotNull DeclarationDescriptor descriptor2, LexicalScope scope2, List<TypeParameterDescriptorImpl> parameters2, BindingTrace trace) {
        if (declaration == null) {
            DescriptorResolver.$$$reportNull$$$0(47);
        }
        if (descriptor2 == null) {
            DescriptorResolver.$$$reportNull$$$0(48);
        }
        ArrayList<UpperBoundCheckRequest> upperBoundCheckRequests = Lists.newArrayList();
        List<KtTypeParameter> typeParameters2 = declaration.getTypeParameters();
        HashMap<Name, TypeParameterDescriptorImpl> parameterByName2 = new HashMap<Name, TypeParameterDescriptorImpl>();
        for (int i = 0; i < typeParameters2.size(); ++i) {
            KtTypeParameter ktTypeParameter = typeParameters2.get(i);
            TypeParameterDescriptorImpl typeParameterDescriptor = parameters2.get(i);
            parameterByName2.put(typeParameterDescriptor.getName(), typeParameterDescriptor);
            KtTypeReference extendsBound = ktTypeParameter.getExtendsBound();
            if (extendsBound == null) continue;
            KotlinType type2 = this.typeResolver.resolveType(scope2, extendsBound, trace, false);
            typeParameterDescriptor.addUpperBound(type2);
            upperBoundCheckRequests.add(new UpperBoundCheckRequest(ktTypeParameter.getNameAsName(), extendsBound, type2));
        }
        for (KtTypeConstraint constraint2 : declaration.getTypeConstraints()) {
            KtSimpleNameExpression subjectTypeParameterName = constraint2.getSubjectTypeParameterName();
            if (subjectTypeParameterName == null) continue;
            Name referencedName = subjectTypeParameterName.getReferencedNameAsName();
            TypeParameterDescriptorImpl typeParameterDescriptor = (TypeParameterDescriptorImpl)parameterByName2.get(referencedName);
            KtTypeReference boundTypeReference = constraint2.getBoundTypeReference();
            KotlinType bound2 = null;
            if (boundTypeReference != null) {
                bound2 = this.typeResolver.resolveType(scope2, boundTypeReference, trace, false);
                upperBoundCheckRequests.add(new UpperBoundCheckRequest(referencedName, boundTypeReference, bound2));
            }
            if (typeParameterDescriptor == null) continue;
            trace.record(BindingContext.REFERENCE_TARGET, subjectTypeParameterName, typeParameterDescriptor);
            if (bound2 == null) continue;
            typeParameterDescriptor.addUpperBound(bound2);
        }
        for (TypeParameterDescriptorImpl parameter2 : parameters2) {
            parameter2.addDefaultUpperBound();
            parameter2.setInitialized();
        }
        for (TypeParameterDescriptorImpl parameter2 : parameters2) {
            DescriptorResolver.checkConflictingUpperBounds(trace, parameter2, typeParameters2.get(parameter2.getIndex()));
        }
        if (!(declaration instanceof KtClass)) {
            DescriptorResolver.checkUpperBoundTypes(trace, upperBoundCheckRequests, declaration.hasModifier(KtTokens.OVERRIDE_KEYWORD));
            this.checkNamesInConstraints(declaration, descriptor2, scope2, trace);
        }
    }

    public static void checkUpperBoundTypes(@NotNull BindingTrace trace, @NotNull List<UpperBoundCheckRequest> requests, boolean hasOverrideModifier) {
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(49);
        }
        if (requests == null) {
            DescriptorResolver.$$$reportNull$$$0(50);
        }
        if (requests.isEmpty()) {
            return;
        }
        HashSet<Name> classBoundEncountered = new HashSet<Name>();
        HashSet<Pair> allBounds = new HashSet<Pair>();
        for (UpperBoundCheckRequest request : requests) {
            Name typeParameterName = request.typeParameterName;
            KotlinType upperBound = request.upperBoundType;
            KtTypeReference upperBoundElement = request.upperBound;
            if (!KotlinTypeKt.isError(upperBound)) {
                if (!allBounds.add(new Pair((Object)typeParameterName, (Object)upperBound.getConstructor()))) {
                    trace.report(Errors.REPEATED_BOUND.on(upperBoundElement));
                } else {
                    ClassKind kind;
                    ClassDescriptor classDescriptor2 = TypeUtils.getClassDescriptor(upperBound);
                    if (!(classDescriptor2 == null || (kind = classDescriptor2.getKind()) != ClassKind.CLASS && kind != ClassKind.ENUM_CLASS && kind != ClassKind.OBJECT || classBoundEncountered.add(typeParameterName))) {
                        trace.report(Errors.ONLY_ONE_CLASS_BOUND_ALLOWED.on(upperBoundElement));
                    }
                }
            }
            DescriptorResolver.checkUpperBoundType(upperBoundElement, upperBound, trace, hasOverrideModifier);
        }
    }

    public static void checkConflictingUpperBounds(@NotNull BindingTrace trace, @NotNull TypeParameterDescriptor parameter2, @NotNull KtTypeParameter typeParameter2) {
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(51);
        }
        if (parameter2 == null) {
            DescriptorResolver.$$$reportNull$$$0(52);
        }
        if (typeParameter2 == null) {
            DescriptorResolver.$$$reportNull$$$0(53);
        }
        if (KotlinBuiltIns.isNothing(TypeIntersector.getUpperBoundsAsType(parameter2))) {
            trace.report(Errors.CONFLICTING_UPPER_BOUNDS.on(typeParameter2, parameter2));
        }
    }

    public void checkNamesInConstraints(@NotNull KtTypeParameterListOwner declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull LexicalScope scope2, @NotNull BindingTrace trace) {
        if (declaration == null) {
            DescriptorResolver.$$$reportNull$$$0(54);
        }
        if (descriptor2 == null) {
            DescriptorResolver.$$$reportNull$$$0(55);
        }
        if (scope2 == null) {
            DescriptorResolver.$$$reportNull$$$0(56);
        }
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(57);
        }
        for (KtTypeConstraint constraint2 : declaration.getTypeConstraints()) {
            KtTypeReference boundTypeReference;
            Name name2;
            ClassifierDescriptor classifier2;
            KtSimpleNameExpression nameExpression = constraint2.getSubjectTypeParameterName();
            if (nameExpression == null || (classifier2 = ScopeUtilsKt.findClassifier(scope2, name2 = nameExpression.getReferencedNameAsName(), NoLookupLocation.FOR_NON_TRACKED_SCOPE)) instanceof TypeParameterDescriptor && classifier2.getContainingDeclaration() == descriptor2) continue;
            if (classifier2 != null) {
                trace.report(Errors.NAME_IN_CONSTRAINT_IS_NOT_A_TYPE_PARAMETER.on(nameExpression, constraint2, declaration));
                trace.record(BindingContext.REFERENCE_TARGET, nameExpression, classifier2);
            } else {
                trace.report(Errors.UNRESOLVED_REFERENCE.on(nameExpression, nameExpression));
            }
            if ((boundTypeReference = constraint2.getBoundTypeReference()) == null) continue;
            this.typeResolver.resolveType(scope2, boundTypeReference, trace, true);
        }
    }

    public static void checkUpperBoundType(KtTypeReference upperBound, @NotNull KotlinType upperBoundType, BindingTrace trace, boolean hasOverrideModifier) {
        if (upperBoundType == null) {
            DescriptorResolver.$$$reportNull$$$0(58);
        }
        if (!hasOverrideModifier && !TypeUtils.canHaveSubtypes(KotlinTypeChecker.DEFAULT, upperBoundType)) {
            trace.report(Errors.FINAL_UPPER_BOUND.on(upperBound, upperBoundType));
        }
        if (DynamicTypesKt.isDynamic(upperBoundType)) {
            trace.report(Errors.DYNAMIC_UPPER_BOUND.on(upperBound));
        }
        if (FunctionTypesKt.isExtensionFunctionType(upperBoundType)) {
            trace.report(Errors.UPPER_BOUND_IS_EXTENSION_FUNCTION_TYPE.on(upperBound));
        }
        if (DefinitelyNonNullableTypesKt.containsIncorrectExplicitDefinitelyNonNullableType(upperBoundType)) {
            trace.report(Errors.INCORRECT_LEFT_COMPONENT_OF_INTERSECTION.on(upperBound));
        }
    }

    @NotNull
    public VariableDescriptor resolveLocalVariableDescriptor(@NotNull LexicalScope scope2, @NotNull KtParameter parameter2, BindingTrace trace) {
        if (scope2 == null) {
            DescriptorResolver.$$$reportNull$$$0(59);
        }
        if (parameter2 == null) {
            DescriptorResolver.$$$reportNull$$$0(60);
        }
        KotlinType type2 = this.resolveParameterType(scope2, parameter2, trace);
        VariableDescriptor variableDescriptor = this.resolveLocalVariableDescriptor(parameter2, type2, trace, scope2);
        if (variableDescriptor == null) {
            DescriptorResolver.$$$reportNull$$$0(61);
        }
        return variableDescriptor;
    }

    private KotlinType resolveParameterType(LexicalScope scope2, KtParameter parameter2, BindingTrace trace) {
        KtTypeReference typeReference = parameter2.getTypeReference();
        KotlinType type2 = typeReference != null ? this.typeResolver.resolveType(scope2, typeReference, trace, true) : ErrorUtils.createErrorType(ErrorTypeKind.NO_TYPE_SPECIFIED, parameter2.getText());
        if (parameter2.hasModifier(KtTokens.VARARG_KEYWORD)) {
            return this.getVarargParameterType(type2);
        }
        return type2;
    }

    public VariableDescriptor resolveLocalVariableDescriptor(@NotNull KtParameter parameter2, @NotNull KotlinType type2, BindingTrace trace, @NotNull LexicalScope scope2) {
        if (parameter2 == null) {
            DescriptorResolver.$$$reportNull$$$0(62);
        }
        if (type2 == null) {
            DescriptorResolver.$$$reportNull$$$0(63);
        }
        if (scope2 == null) {
            DescriptorResolver.$$$reportNull$$$0(64);
        }
        UnwrappedType approximatedType = this.typeApproximator.approximateDeclarationType(type2, true);
        LocalVariableDescriptor variableDescriptor = new LocalVariableDescriptor(scope2.getOwnerDescriptor(), this.annotationResolver.resolveAnnotationsWithArguments(scope2, parameter2.getModifierList(), trace), KtPsiUtil.safeName(parameter2.getName()), approximatedType, KotlinSourceElementKt.toSourceElement(parameter2));
        trace.record(BindingContext.VALUE_PARAMETER, parameter2, variableDescriptor);
        ForceResolveUtil.forceResolveAllContents(type2.getAnnotations());
        return variableDescriptor;
    }

    @NotNull
    public TypeAliasDescriptor resolveTypeAliasDescriptor(@NotNull DeclarationDescriptor containingDeclaration, @NotNull LexicalScope scope2, @NotNull KtTypeAlias typeAlias, @NotNull BindingTrace trace) {
        List<TypeParameterDescriptorImpl> typeParameterDescriptors;
        LexicalScope scopeWithTypeParameters;
        if (containingDeclaration == null) {
            DescriptorResolver.$$$reportNull$$$0(65);
        }
        if (scope2 == null) {
            DescriptorResolver.$$$reportNull$$$0(66);
        }
        if (typeAlias == null) {
            DescriptorResolver.$$$reportNull$$$0(67);
        }
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(68);
        }
        if (!(containingDeclaration instanceof PackageFragmentDescriptor) && !(containingDeclaration instanceof ScriptDescriptor)) {
            trace.report(Errors.TOPLEVEL_TYPEALIASES_ONLY.on(typeAlias));
        }
        KtModifierList modifierList2 = typeAlias.getModifierList();
        DescriptorVisibility visibility2 = ModifiersChecker.resolveVisibilityFromModifiers(typeAlias, DescriptorResolver.getDefaultVisibility(typeAlias, containingDeclaration));
        Annotations allAnnotations = this.annotationResolver.resolveAnnotationsWithArguments(scope2, modifierList2, trace);
        Name name2 = KtPsiUtil.safeName(typeAlias.getName());
        SourceElement sourceElement = KotlinSourceElementKt.toSourceElement(typeAlias);
        LazyTypeAliasDescriptor typeAliasDescriptor = LazyTypeAliasDescriptor.create(this.storageManager, trace, containingDeclaration, allAnnotations, name2, sourceElement, visibility2);
        List<KtTypeParameter> typeParameters2 = typeAlias.getTypeParameters();
        if (typeParameters2.isEmpty()) {
            scopeWithTypeParameters = scope2;
            typeParameterDescriptors = Collections.emptyList();
        } else {
            LexicalWritableScope writableScope = new LexicalWritableScope(scope2, containingDeclaration, false, new TraceBasedLocalRedeclarationChecker(trace, this.overloadChecker), LexicalScopeKind.TYPE_ALIAS_HEADER);
            typeParameterDescriptors = this.resolveTypeParametersForDescriptor(typeAliasDescriptor, writableScope, scope2, typeParameters2, trace);
            writableScope.freeze();
            DescriptorResolver.checkNoGenericBoundsOnTypeAliasParameters(typeAlias, trace);
            this.resolveGenericBounds(typeAlias, typeAliasDescriptor, writableScope, typeParameterDescriptors, trace);
            scopeWithTypeParameters = writableScope;
        }
        KtTypeReference typeReference = typeAlias.getTypeReference();
        if (typeReference == null) {
            typeAliasDescriptor.initialize(typeParameterDescriptors, ErrorUtils.createErrorType(ErrorTypeKind.UNRESOLVED_TYPE_ALIAS, name2.asString()), ErrorUtils.createErrorType(ErrorTypeKind.UNRESOLVED_TYPE_ALIAS, name2.asString()));
        } else if (!this.languageVersionSettings.supportsFeature(LanguageFeature.TypeAliases)) {
            this.typeResolver.resolveAbbreviatedType(scopeWithTypeParameters, typeReference, trace);
            PsiElement typeAliasKeyword = typeAlias.getTypeAliasKeyword();
            trace.report(Errors.UNSUPPORTED_FEATURE.on(typeAliasKeyword != null ? typeAliasKeyword : typeAlias, (Pair<LanguageFeature, LanguageVersionSettings>)TuplesKt.to((Object)((Object)LanguageFeature.TypeAliases), (Object)this.languageVersionSettings)));
            typeAliasDescriptor.initialize(typeParameterDescriptors, ErrorUtils.createErrorType(ErrorTypeKind.UNRESOLVED_TYPE_ALIAS, name2.asString()), ErrorUtils.createErrorType(ErrorTypeKind.UNRESOLVED_TYPE_ALIAS, name2.asString()));
        } else {
            typeAliasDescriptor.initialize(typeParameterDescriptors, this.storageManager.createRecursionTolerantLazyValue(() -> this.typeResolver.resolveAbbreviatedType(scopeWithTypeParameters, typeReference, trace), ErrorUtils.createErrorType(ErrorTypeKind.RECURSIVE_TYPE_ALIAS, typeAliasDescriptor.getName().asString())), this.storageManager.createRecursionTolerantLazyValue(() -> this.typeResolver.resolveExpandedTypeForTypeAlias(typeAliasDescriptor), ErrorUtils.createErrorType(ErrorTypeKind.RECURSIVE_TYPE_ALIAS, typeAliasDescriptor.getName().asString())));
        }
        trace.record(BindingContext.TYPE_ALIAS, typeAlias, typeAliasDescriptor);
        LazyTypeAliasDescriptor lazyTypeAliasDescriptor = typeAliasDescriptor;
        if (lazyTypeAliasDescriptor == null) {
            DescriptorResolver.$$$reportNull$$$0(69);
        }
        return lazyTypeAliasDescriptor;
    }

    private static void checkNoGenericBoundsOnTypeAliasParameters(@NotNull KtTypeAlias typeAlias, @NotNull BindingTrace trace) {
        if (typeAlias == null) {
            DescriptorResolver.$$$reportNull$$$0(70);
        }
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(71);
        }
        for (KtTypeParameter typeParameter2 : typeAlias.getTypeParameters()) {
            KtTypeReference bound2 = typeParameter2.getExtendsBound();
            if (bound2 == null) continue;
            trace.report(Errors.BOUND_ON_TYPE_ALIAS_PARAMETER_NOT_ALLOWED.on(bound2));
        }
    }

    @NotNull
    public PropertyDescriptor resolveDestructuringDeclarationEntryAsProperty(@NotNull DeclarationDescriptor containingDeclaration, @NotNull LexicalScope scopeForDeclarationResolution, @NotNull LexicalScope scopeForInitializerResolution2, @NotNull KtDestructuringDeclarationEntry entry, @NotNull BindingTrace trace, @NotNull DataFlowInfo dataFlowInfo, @NotNull InferenceSession inferenceSession) {
        if (containingDeclaration == null) {
            DescriptorResolver.$$$reportNull$$$0(72);
        }
        if (scopeForDeclarationResolution == null) {
            DescriptorResolver.$$$reportNull$$$0(73);
        }
        if (scopeForInitializerResolution2 == null) {
            DescriptorResolver.$$$reportNull$$$0(74);
        }
        if (entry == null) {
            DescriptorResolver.$$$reportNull$$$0(75);
        }
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(76);
        }
        if (dataFlowInfo == null) {
            DescriptorResolver.$$$reportNull$$$0(77);
        }
        if (inferenceSession == null) {
            DescriptorResolver.$$$reportNull$$$0(78);
        }
        KtDestructuringDeclaration destructuringDeclaration = (KtDestructuringDeclaration)entry.getParent();
        KtExpression initializer2 = destructuringDeclaration.getInitializer();
        ExpressionTypingContext context = ExpressionTypingContext.newContext(trace, scopeForDeclarationResolution, dataFlowInfo, TypeUtils.NO_EXPECTED_TYPE, this.languageVersionSettings, this.dataFlowValueFactory, inferenceSession);
        ExpressionReceiver receiver = this.createReceiverForDestructuringDeclaration(destructuringDeclaration, context);
        int componentIndex = destructuringDeclaration.getEntries().indexOf(entry);
        KotlinType componentType = this.destructuringDeclarationResolver.resolveInitializer(entry, receiver, initializer2, context, componentIndex);
        return this.resolveAsPropertyDescriptor(containingDeclaration, scopeForDeclarationResolution, scopeForInitializerResolution2, entry, trace, dataFlowInfo, inferenceSession, VariableAsPropertyInfo.Companion.createFromDestructuringDeclarationEntry(componentType));
    }

    private ExpressionReceiver createReceiverForDestructuringDeclaration(@NotNull KtDestructuringDeclaration destructuringDeclaration, @NotNull ExpressionTypingContext context) {
        KtExpression initializer2;
        if (destructuringDeclaration == null) {
            DescriptorResolver.$$$reportNull$$$0(79);
        }
        if (context == null) {
            DescriptorResolver.$$$reportNull$$$0(80);
        }
        if ((initializer2 = destructuringDeclaration.getInitializer()) == null) {
            return null;
        }
        KotlinType initializerType = this.expressionTypingServices.getTypeInfo(initializer2, context).getType();
        if (initializerType == null) {
            return null;
        }
        return ExpressionReceiver.Companion.create(initializer2, initializerType, context.trace.getBindingContext());
    }

    @NotNull
    public PropertyDescriptor resolvePropertyDescriptor(@NotNull DeclarationDescriptor containingDeclaration, @NotNull LexicalScope scopeForDeclarationResolution, @NotNull LexicalScope scopeForInitializerResolution2, @NotNull KtProperty property, @NotNull BindingTrace trace, @NotNull DataFlowInfo dataFlowInfo, @NotNull InferenceSession inferenceSession) {
        if (containingDeclaration == null) {
            DescriptorResolver.$$$reportNull$$$0(81);
        }
        if (scopeForDeclarationResolution == null) {
            DescriptorResolver.$$$reportNull$$$0(82);
        }
        if (scopeForInitializerResolution2 == null) {
            DescriptorResolver.$$$reportNull$$$0(83);
        }
        if (property == null) {
            DescriptorResolver.$$$reportNull$$$0(84);
        }
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(85);
        }
        if (dataFlowInfo == null) {
            DescriptorResolver.$$$reportNull$$$0(86);
        }
        if (inferenceSession == null) {
            DescriptorResolver.$$$reportNull$$$0(87);
        }
        return this.resolveAsPropertyDescriptor(containingDeclaration, scopeForDeclarationResolution, scopeForInitializerResolution2, property, trace, dataFlowInfo, inferenceSession, VariableAsPropertyInfo.Companion.createFromProperty(property));
    }

    @NotNull
    private PropertyDescriptor resolveAsPropertyDescriptor(@NotNull DeclarationDescriptor container, @NotNull LexicalScope scopeForDeclarationResolution, @NotNull LexicalScope scopeForInitializerResolution2, @NotNull KtVariableDeclaration variableDeclaration, @NotNull BindingTrace trace, @NotNull DataFlowInfo dataFlowInfo, @Nullable InferenceSession inferenceSession, @NotNull VariableAsPropertyInfo propertyInfo) {
        KotlinType type2;
        List<Object> typeParameterDescriptors;
        LexicalScope scopeForInitializerResolutionWithTypeParameters;
        LexicalScope scopeForDeclarationResolutionWithTypeParameters;
        if (container == null) {
            DescriptorResolver.$$$reportNull$$$0(88);
        }
        if (scopeForDeclarationResolution == null) {
            DescriptorResolver.$$$reportNull$$$0(89);
        }
        if (scopeForInitializerResolution2 == null) {
            DescriptorResolver.$$$reportNull$$$0(90);
        }
        if (variableDeclaration == null) {
            DescriptorResolver.$$$reportNull$$$0(91);
        }
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(92);
        }
        if (dataFlowInfo == null) {
            DescriptorResolver.$$$reportNull$$$0(93);
        }
        if (propertyInfo == null) {
            DescriptorResolver.$$$reportNull$$$0(94);
        }
        KtModifierList modifierList2 = variableDeclaration.getModifierList();
        boolean isVar = variableDeclaration.isVar();
        DescriptorVisibility visibility2 = ModifiersChecker.resolveVisibilityFromModifiers(variableDeclaration, DescriptorResolver.getDefaultVisibility(variableDeclaration, container));
        Modality modality = container instanceof ClassDescriptor ? ModifiersChecker.resolveMemberModalityFromModifiers(variableDeclaration, DescriptorResolver.getDefaultModality(container, visibility2, propertyInfo.getHasBody()), trace.getBindingContext(), container) : Modality.FINAL;
        Annotations allAnnotations = this.annotationResolver.resolveAnnotationsWithoutArguments(scopeForDeclarationResolution, modifierList2, trace);
        EnumSet<AnnotationUseSiteTarget> targetSet = EnumSet.of(AnnotationUseSiteTarget.PROPERTY, AnnotationUseSiteTarget.PROPERTY_GETTER, AnnotationUseSiteTarget.FIELD);
        if (isVar) {
            targetSet.add(AnnotationUseSiteTarget.PROPERTY_SETTER);
            targetSet.add(AnnotationUseSiteTarget.SETTER_PARAMETER);
        }
        if (variableDeclaration instanceof KtProperty && ((KtProperty)variableDeclaration).hasDelegate()) {
            targetSet.add(AnnotationUseSiteTarget.PROPERTY_DELEGATE_FIELD);
        }
        AnnotationSplitter annotationSplitter = new AnnotationSplitter(this.storageManager, allAnnotations, targetSet);
        CompositeAnnotations propertyAnnotations = new CompositeAnnotations(CollectionsKt.listOf((Object[])new Annotations[]{annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.PROPERTY), annotationSplitter.getOtherAnnotations()}));
        PropertyDescriptorImpl propertyDescriptor = PropertyDescriptorImpl.create(container, propertyAnnotations, modality, visibility2, isVar, KtPsiUtil.safeName(variableDeclaration.getName()), CallableMemberDescriptor.Kind.DECLARATION, KotlinSourceElementKt.toSourceElement(variableDeclaration), modifierList2 != null && modifierList2.hasModifier(KtTokens.LATEINIT_KEYWORD), modifierList2 != null && modifierList2.hasModifier(KtTokens.CONST_KEYWORD), modifierList2 != null && PsiUtilsKt.hasExpectModifier(modifierList2) && container instanceof PackageFragmentDescriptor || container instanceof ClassDescriptor && ((ClassDescriptor)container).isExpect(), modifierList2 != null && PsiUtilsKt.hasActualModifier(modifierList2), modifierList2 != null && modifierList2.hasModifier(KtTokens.EXTERNAL_KEYWORD), propertyInfo.getHasDelegate());
        KotlinType receiverType = null;
        List<KtTypeParameter> typeParameters2 = variableDeclaration.getTypeParameters();
        if (typeParameters2.isEmpty()) {
            scopeForDeclarationResolutionWithTypeParameters = scopeForDeclarationResolution;
            scopeForInitializerResolutionWithTypeParameters = scopeForInitializerResolution2;
            typeParameterDescriptors = Collections.emptyList();
        } else {
            LexicalWritableScope writableScopeForDeclarationResolution = new LexicalWritableScope(scopeForDeclarationResolution, container, false, new TraceBasedLocalRedeclarationChecker(trace, this.overloadChecker), LexicalScopeKind.PROPERTY_HEADER);
            LexicalWritableScope writableScopeForInitializerResolution = new LexicalWritableScope(scopeForInitializerResolution2, container, false, LocalRedeclarationChecker.DO_NOTHING.INSTANCE, LexicalScopeKind.PROPERTY_HEADER);
            typeParameterDescriptors = this.resolveTypeParametersForDescriptor(propertyDescriptor, scopeForDeclarationResolution, typeParameters2, trace);
            for (TypeParameterDescriptor typeParameterDescriptor : typeParameterDescriptors) {
                writableScopeForDeclarationResolution.addClassifierDescriptor(typeParameterDescriptor);
                writableScopeForInitializerResolution.addClassifierDescriptor(typeParameterDescriptor);
            }
            writableScopeForDeclarationResolution.freeze();
            writableScopeForInitializerResolution.freeze();
            this.resolveGenericBounds(variableDeclaration, propertyDescriptor, writableScopeForDeclarationResolution, typeParameterDescriptors, trace);
            scopeForDeclarationResolutionWithTypeParameters = writableScopeForDeclarationResolution;
            scopeForInitializerResolutionWithTypeParameters = writableScopeForInitializerResolution;
        }
        KtTypeReference receiverTypeRef = variableDeclaration.getReceiverTypeReference();
        ReceiverParameterDescriptor receiverDescriptor = null;
        if (receiverTypeRef != null) {
            receiverType = this.typeResolver.resolveType(scopeForDeclarationResolutionWithTypeParameters, receiverTypeRef, trace, true);
            AnnotationSplitter splitter = new AnnotationSplitter(this.storageManager, receiverType.getAnnotations(), EnumSet.of(AnnotationUseSiteTarget.RECEIVER));
            receiverDescriptor = DescriptorFactory.createExtensionReceiverParameterForCallable(propertyDescriptor, receiverType, splitter.getAnnotationsForTarget(AnnotationUseSiteTarget.RECEIVER));
        }
        List<KtContextReceiver> contextReceivers = variableDeclaration.getContextReceivers();
        List<ReceiverParameterDescriptor> contextReceiverDescriptors = IntStream.range(0, contextReceivers.size()).mapToObj(index2 -> {
            KtContextReceiver contextReceiver2 = (KtContextReceiver)contextReceivers.get(index2);
            KtTypeReference typeReference = contextReceiver2.typeReference();
            if (typeReference == null) {
                return null;
            }
            KotlinType type2 = this.typeResolver.resolveType(scopeForDeclarationResolutionWithTypeParameters, typeReference, trace, true);
            AnnotationSplitter splitter = new AnnotationSplitter(this.storageManager, type2.getAnnotations(), EnumSet.of(AnnotationUseSiteTarget.RECEIVER));
            return DescriptorFactory.createContextReceiverParameterForCallable(propertyDescriptor, type2, contextReceiver2.labelNameAsName(), splitter.getAnnotationsForTarget(AnnotationUseSiteTarget.RECEIVER), index2);
        }).collect(Collectors.toList());
        if (this.languageVersionSettings.supportsFeature(LanguageFeature.ContextReceivers)) {
            String receiverName;
            HashMultimap<String, ReceiverParameterDescriptor> hashMultimap = HashMultimap.create();
            if (receiverTypeRef != null && (receiverName = receiverTypeRef.nameForReceiverLabel()) != null) {
                hashMultimap.put(receiverName, receiverDescriptor);
            }
            for (int i = 0; i < contextReceivers.size(); ++i) {
                String contextReceiverName = contextReceivers.get(i).name();
                if (contextReceiverName == null) continue;
                hashMultimap.put(contextReceiverName, (ReceiverParameterDescriptor)contextReceiverDescriptors.get(i));
            }
            trace.record(BindingContext.DESCRIPTOR_TO_CONTEXT_RECEIVER_MAP, propertyDescriptor, hashMultimap);
        }
        LexicalScope lexicalScope = ScopeUtils.makeScopeForPropertyInitializer(scopeForInitializerResolutionWithTypeParameters, propertyDescriptor);
        KotlinType propertyType = propertyInfo.getVariableType();
        KotlinType typeIfKnown = propertyType != null ? propertyType : this.variableTypeAndInitializerResolver.resolveTypeNullable(propertyDescriptor, lexicalScope, variableDeclaration, dataFlowInfo, inferenceSession, trace, false);
        PropertyGetterDescriptorImpl getter2 = this.resolvePropertyGetterDescriptor(scopeForDeclarationResolutionWithTypeParameters, variableDeclaration, propertyDescriptor, annotationSplitter, trace, typeIfKnown, propertyInfo.getPropertyGetter(), propertyInfo.getHasDelegate(), inferenceSession);
        KotlinType kotlinType = type2 = typeIfKnown != null ? typeIfKnown : getter2.getReturnType();
        assert (type2 != null) : "At least getter type must be initialized via resolvePropertyGetterDescriptor";
        this.variableTypeAndInitializerResolver.setConstantForVariableIfNeeded(propertyDescriptor, lexicalScope, variableDeclaration, dataFlowInfo, type2, inferenceSession, trace);
        propertyDescriptor.setType(type2, typeParameterDescriptors, DescriptorUtils.getDispatchReceiverParameterIfNeeded(container), receiverDescriptor, contextReceiverDescriptors);
        PropertySetterDescriptor setter2 = this.resolvePropertySetterDescriptor(scopeForDeclarationResolutionWithTypeParameters, variableDeclaration, propertyDescriptor, annotationSplitter, trace, propertyInfo.getPropertySetter(), propertyInfo.getHasDelegate(), inferenceSession);
        propertyDescriptor.initialize(getter2, setter2, new FieldDescriptorImpl(annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.FIELD), propertyDescriptor), new FieldDescriptorImpl(annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.PROPERTY_DELEGATE_FIELD), propertyDescriptor));
        trace.record(BindingContext.VARIABLE, variableDeclaration, propertyDescriptor);
        PropertyDescriptorImpl propertyDescriptorImpl = propertyDescriptor;
        if (propertyDescriptorImpl == null) {
            DescriptorResolver.$$$reportNull$$$0(95);
        }
        return propertyDescriptorImpl;
    }

    @NotNull
    static KotlinType transformAnonymousTypeIfNeeded(@NotNull DeclarationDescriptorWithVisibility descriptor2, @NotNull KtDeclaration declaration, @NotNull KotlinType type2, @NotNull BindingTrace trace, @NotNull Iterable<DeclarationSignatureAnonymousTypeTransformer> anonymousTypeTransformers, @NotNull LanguageVersionSettings languageVersionSettings2) {
        if (descriptor2 == null) {
            DescriptorResolver.$$$reportNull$$$0(96);
        }
        if (declaration == null) {
            DescriptorResolver.$$$reportNull$$$0(97);
        }
        if (type2 == null) {
            DescriptorResolver.$$$reportNull$$$0(98);
        }
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(99);
        }
        if (anonymousTypeTransformers == null) {
            DescriptorResolver.$$$reportNull$$$0(100);
        }
        if (languageVersionSettings2 == null) {
            DescriptorResolver.$$$reportNull$$$0(101);
        }
        for (DeclarationSignatureAnonymousTypeTransformer transformer2 : anonymousTypeTransformers) {
            KotlinType transformedType = transformer2.transformAnonymousType(descriptor2, type2);
            if (transformedType == null) continue;
            KotlinType kotlinType = transformedType;
            if (kotlinType == null) {
                DescriptorResolver.$$$reportNull$$$0(102);
            }
            return kotlinType;
        }
        ClassifierDescriptor classifier2 = type2.getConstructor().getDeclarationDescriptor();
        if (classifier2 == null || !DescriptorUtils.isAnonymousObject(classifier2) || DescriptorUtils.isLocal(descriptor2)) {
            KotlinType kotlinType = type2;
            if (kotlinType == null) {
                DescriptorResolver.$$$reportNull$$$0(103);
            }
            return kotlinType;
        }
        boolean isPrivate = DescriptorVisibilities.isPrivate(descriptor2.getVisibility());
        boolean isInlineFunction = descriptor2 instanceof SimpleFunctionDescriptor && ((SimpleFunctionDescriptor)descriptor2).isInline();
        boolean isAnonymousReturnTypesInPrivateInlineFunctionsForbidden = languageVersionSettings2.supportsFeature(LanguageFeature.ApproximateAnonymousReturnTypesInPrivateInlineFunctions);
        if (!isPrivate || isInlineFunction && isAnonymousReturnTypesInPrivateInlineFunctionsForbidden) {
            if (type2.getConstructor().getSupertypes().size() == 1) {
                KotlinType approximatingSuperType = type2.getConstructor().getSupertypes().iterator().next();
                MemberScope memberScope2 = type2.getMemberScope();
                KotlinType substitutedSuperType = memberScope2 instanceof SubstitutingScope ? ((SubstitutingScope)memberScope2).substitute(approximatingSuperType) : approximatingSuperType;
                UnwrappedType unwrapped = type2.unwrap();
                boolean lowerNullable = FlexibleTypesKt.lowerIfFlexible(unwrapped).isMarkedNullable();
                boolean upperNullable = FlexibleTypesKt.upperIfFlexible(unwrapped).isMarkedNullable();
                if (languageVersionSettings2.supportsFeature(LanguageFeature.KeepNullabilityWhenApproximatingLocalType)) {
                    if (lowerNullable != upperNullable) {
                        UnwrappedType unwrappedType = KotlinTypeFactory.flexibleType(FlexibleTypesKt.lowerIfFlexible(substitutedSuperType), FlexibleTypesKt.upperIfFlexible(substitutedSuperType).makeNullableAsSpecified(true));
                        if (unwrappedType == null) {
                            DescriptorResolver.$$$reportNull$$$0(104);
                        }
                        return unwrappedType;
                    }
                    KotlinType kotlinType = TypeUtils.makeNullableIfNeeded(substitutedSuperType, upperNullable);
                    if (kotlinType == null) {
                        DescriptorResolver.$$$reportNull$$$0(105);
                    }
                    return kotlinType;
                }
                if (upperNullable) {
                    if (lowerNullable) {
                        trace.report(Errors.APPROXIMATED_LOCAL_TYPE_WILL_BECOME_NULLABLE.on(declaration, substitutedSuperType));
                    } else {
                        trace.report(Errors.APPROXIMATED_LOCAL_TYPE_WILL_BECOME_FLEXIBLE.on(declaration, substitutedSuperType));
                    }
                }
                KotlinType kotlinType = substitutedSuperType;
                if (kotlinType == null) {
                    DescriptorResolver.$$$reportNull$$$0(106);
                }
                return kotlinType;
            }
            trace.report(Errors.AMBIGUOUS_ANONYMOUS_TYPE_INFERRED.on(declaration, type2.getConstructor().getSupertypes()));
        }
        KotlinType kotlinType = type2;
        if (kotlinType == null) {
            DescriptorResolver.$$$reportNull$$$0(107);
        }
        return kotlinType;
    }

    @Nullable
    private PropertySetterDescriptor resolvePropertySetterDescriptor(@NotNull LexicalScope scopeWithTypeParameters, @NotNull KtVariableDeclaration property, @NotNull PropertyDescriptor propertyDescriptor, @NotNull AnnotationSplitter annotationSplitter, @NotNull BindingTrace trace, @Nullable KtPropertyAccessor setter2, boolean hasDelegate, @Nullable InferenceSession inferenceSession) {
        if (scopeWithTypeParameters == null) {
            DescriptorResolver.$$$reportNull$$$0(108);
        }
        if (property == null) {
            DescriptorResolver.$$$reportNull$$$0(109);
        }
        if (propertyDescriptor == null) {
            DescriptorResolver.$$$reportNull$$$0(110);
        }
        if (annotationSplitter == null) {
            DescriptorResolver.$$$reportNull$$$0(111);
        }
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(112);
        }
        PropertySetterDescriptorImpl setterDescriptor = null;
        Annotations setterTargetedAnnotations = annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.PROPERTY_SETTER);
        Annotations parameterTargetedAnnotations = annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.SETTER_PARAMETER);
        if (setter2 != null) {
            KotlinType returnType2;
            CompositeAnnotations annotations2 = new CompositeAnnotations(CollectionsKt.listOf((Object[])new Annotations[]{setterTargetedAnnotations, this.annotationResolver.resolveAnnotationsWithoutArguments(scopeWithTypeParameters, setter2.getModifierList(), trace)}));
            KtParameter parameter2 = setter2.getParameter();
            setterDescriptor = new PropertySetterDescriptorImpl(propertyDescriptor, annotations2, ModifiersChecker.resolveMemberModalityFromModifiers(setter2, propertyDescriptor.getModality(), trace.getBindingContext(), propertyDescriptor.getContainingDeclaration()), ModifiersChecker.resolveVisibilityFromModifiers(setter2, propertyDescriptor.getVisibility()), false, setter2.hasModifier(KtTokens.EXTERNAL_KEYWORD), property.hasModifier(KtTokens.INLINE_KEYWORD) || setter2.hasModifier(KtTokens.INLINE_KEYWORD), CallableMemberDescriptor.Kind.DECLARATION, null, KotlinSourceElementKt.toSourceElement(setter2));
            KtTypeReference returnTypeReference = setter2.getReturnTypeReference();
            if (returnTypeReference != null && !KotlinBuiltIns.isUnit(returnType2 = this.typeResolver.resolveType(scopeWithTypeParameters, returnTypeReference, trace, true))) {
                trace.report(Errors.WRONG_SETTER_RETURN_TYPE.on(returnTypeReference));
            }
            if (parameter2 != null) {
                KotlinType type2;
                KtTypeReference typeReference;
                if (parameter2.hasDefaultValue()) {
                    trace.report(Errors.SETTER_PARAMETER_WITH_DEFAULT_VALUE.on(parameter2.getDefaultValue()));
                }
                if ((typeReference = parameter2.getTypeReference()) == null) {
                    type2 = propertyDescriptor.getType();
                } else {
                    KotlinType inType;
                    type2 = this.typeResolver.resolveType(scopeWithTypeParameters, typeReference, trace, true);
                    if (!TypeUtils.equalTypes(type2, inType = propertyDescriptor.getType())) {
                        trace.report(Errors.WRONG_SETTER_PARAMETER_TYPE.on(typeReference, inType, type2));
                    }
                }
                ValueParameterDescriptorImpl valueParameterDescriptor = this.resolveValueParameterDescriptor(scopeWithTypeParameters, setterDescriptor, parameter2, 0, type2, trace, parameterTargetedAnnotations, inferenceSession);
                setterDescriptor.initialize(valueParameterDescriptor);
            } else {
                setterDescriptor.initializeDefault();
            }
            trace.record(BindingContext.PROPERTY_ACCESSOR, setter2, setterDescriptor);
        } else if (property.isVar()) {
            setterDescriptor = DescriptorFactory.createSetter(propertyDescriptor, setterTargetedAnnotations, parameterTargetedAnnotations, !hasDelegate && setterTargetedAnnotations.isEmpty() && parameterTargetedAnnotations.isEmpty(), false, property.hasModifier(KtTokens.INLINE_KEYWORD), propertyDescriptor.getSource());
        }
        if (!property.isVar() && setter2 != null) {
            trace.report(Errors.VAL_WITH_SETTER.on(setter2));
        }
        return setterDescriptor;
    }

    @NotNull
    private PropertyGetterDescriptorImpl resolvePropertyGetterDescriptor(@NotNull LexicalScope scopeForDeclarationResolution, @NotNull KtVariableDeclaration property, @NotNull PropertyDescriptor propertyDescriptor, @NotNull AnnotationSplitter annotationSplitter, @NotNull BindingTrace trace, @Nullable KotlinType propertyTypeIfKnown, @Nullable KtPropertyAccessor getter2, boolean hasDelegate, @Nullable InferenceSession inferenceSession) {
        KotlinType getterType2;
        PropertyGetterDescriptorImpl getterDescriptor;
        if (scopeForDeclarationResolution == null) {
            DescriptorResolver.$$$reportNull$$$0(113);
        }
        if (property == null) {
            DescriptorResolver.$$$reportNull$$$0(114);
        }
        if (propertyDescriptor == null) {
            DescriptorResolver.$$$reportNull$$$0(115);
        }
        if (annotationSplitter == null) {
            DescriptorResolver.$$$reportNull$$$0(116);
        }
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(117);
        }
        Annotations getterTargetedAnnotations = annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.PROPERTY_GETTER);
        if (getter2 != null) {
            CompositeAnnotations getterAnnotations = new CompositeAnnotations(CollectionsKt.listOf((Object[])new Annotations[]{getterTargetedAnnotations, this.annotationResolver.resolveAnnotationsWithoutArguments(scopeForDeclarationResolution, getter2.getModifierList(), trace)}));
            getterDescriptor = new PropertyGetterDescriptorImpl(propertyDescriptor, getterAnnotations, ModifiersChecker.resolveMemberModalityFromModifiers(getter2, propertyDescriptor.getModality(), trace.getBindingContext(), propertyDescriptor.getContainingDeclaration()), ModifiersChecker.resolveVisibilityFromModifiers(getter2, propertyDescriptor.getVisibility()), false, getter2.hasModifier(KtTokens.EXTERNAL_KEYWORD), property.hasModifier(KtTokens.INLINE_KEYWORD) || getter2.hasModifier(KtTokens.INLINE_KEYWORD), CallableMemberDescriptor.Kind.DECLARATION, null, KotlinSourceElementKt.toSourceElement(getter2));
            getterType2 = this.determineGetterReturnType(scopeForDeclarationResolution, trace, getterDescriptor, getter2, propertyTypeIfKnown, inferenceSession);
            trace.record(BindingContext.PROPERTY_ACCESSOR, getter2, getterDescriptor);
        } else {
            getterDescriptor = DescriptorFactory.createGetter(propertyDescriptor, getterTargetedAnnotations, !hasDelegate && getterTargetedAnnotations.isEmpty(), false, property.hasModifier(KtTokens.INLINE_KEYWORD));
            getterType2 = propertyTypeIfKnown;
        }
        getterDescriptor.initialize(getterType2 != null ? getterType2 : VariableTypeAndInitializerResolver.getTypeForPropertyWithoutReturnType(propertyDescriptor.getName().asString()));
        PropertyGetterDescriptorImpl propertyGetterDescriptorImpl = getterDescriptor;
        if (propertyGetterDescriptorImpl == null) {
            DescriptorResolver.$$$reportNull$$$0(118);
        }
        return propertyGetterDescriptorImpl;
    }

    @Nullable
    private KotlinType determineGetterReturnType(@NotNull LexicalScope scope2, @NotNull BindingTrace trace, @NotNull PropertyGetterDescriptor getterDescriptor, @NotNull KtPropertyAccessor getter2, @Nullable KotlinType propertyTypeIfKnown, @Nullable InferenceSession inferenceSession) {
        KtTypeReference returnTypeReference;
        if (scope2 == null) {
            DescriptorResolver.$$$reportNull$$$0(119);
        }
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(120);
        }
        if (getterDescriptor == null) {
            DescriptorResolver.$$$reportNull$$$0(121);
        }
        if (getter2 == null) {
            DescriptorResolver.$$$reportNull$$$0(122);
        }
        if ((returnTypeReference = getter2.getReturnTypeReference()) != null) {
            KotlinType explicitReturnType = this.typeResolver.resolveType(scope2, returnTypeReference, trace, true);
            if (propertyTypeIfKnown != null && !TypeUtils.equalTypes(explicitReturnType, propertyTypeIfKnown)) {
                trace.report(Errors.WRONG_GETTER_RETURN_TYPE.on(returnTypeReference, propertyTypeIfKnown, explicitReturnType));
            }
            return explicitReturnType;
        }
        KtProperty property = getter2.getProperty();
        if (!property.hasDelegateExpressionOrInitializer() && property.getTypeReference() == null && getter2.hasBody() && !getter2.hasBlockBody()) {
            return this.inferReturnTypeFromExpressionBody(trace, scope2, DataFlowInfoFactory.EMPTY, getter2, getterDescriptor, inferenceSession);
        }
        return propertyTypeIfKnown;
    }

    @NotNull
    KotlinType inferReturnTypeFromExpressionBody(@NotNull BindingTrace trace, @NotNull LexicalScope scope2, @NotNull DataFlowInfo dataFlowInfo, @NotNull KtDeclarationWithBody function2, @NotNull FunctionDescriptor functionDescriptor, @Nullable InferenceSession inferenceSession) {
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(123);
        }
        if (scope2 == null) {
            DescriptorResolver.$$$reportNull$$$0(124);
        }
        if (dataFlowInfo == null) {
            DescriptorResolver.$$$reportNull$$$0(125);
        }
        if (function2 == null) {
            DescriptorResolver.$$$reportNull$$$0(126);
        }
        if (functionDescriptor == null) {
            DescriptorResolver.$$$reportNull$$$0(127);
        }
        KotlinType kotlinType = this.wrappedTypeFactory.createRecursionIntolerantDeferredType(trace, (Function0<? extends KotlinType>)((Function0)() -> {
            PreliminaryDeclarationVisitor.Companion.createForDeclaration(function2, trace, this.languageVersionSettings);
            KotlinType type2 = this.expressionTypingServices.getBodyExpressionType(trace, scope2, dataFlowInfo, function2, functionDescriptor, inferenceSession);
            KotlinType publicType = DescriptorResolver.transformAnonymousTypeIfNeeded(functionDescriptor, function2, type2, trace, this.anonymousTypeTransformers, this.languageVersionSettings);
            UnwrappedType approximatedType = this.typeApproximator.approximateDeclarationType(publicType, false);
            UnwrappedType sanitizedType = this.declarationReturnTypeSanitizer.sanitizeReturnType(approximatedType, this.wrappedTypeFactory, trace, this.languageVersionSettings);
            this.functionsTypingVisitor.checkTypesForReturnStatements(function2, trace, sanitizedType);
            return sanitizedType;
        }));
        if (kotlinType == null) {
            DescriptorResolver.$$$reportNull$$$0(128);
        }
        return kotlinType;
    }

    public PropertyDescriptor resolvePrimaryConstructorParameterToAProperty(@NotNull ClassDescriptor classDescriptor2, @NotNull ValueParameterDescriptor valueParameter2, @NotNull LexicalScope scope2, @NotNull KtParameter parameter2, BindingTrace trace) {
        if (classDescriptor2 == null) {
            DescriptorResolver.$$$reportNull$$$0(129);
        }
        if (valueParameter2 == null) {
            DescriptorResolver.$$$reportNull$$$0(130);
        }
        if (scope2 == null) {
            DescriptorResolver.$$$reportNull$$$0(131);
        }
        if (parameter2 == null) {
            DescriptorResolver.$$$reportNull$$$0(132);
        }
        KotlinType type2 = this.resolveParameterType(scope2, parameter2, trace);
        Name name2 = parameter2.getNameAsSafeName();
        boolean isMutable = parameter2.isMutable();
        KtModifierList modifierList2 = parameter2.getModifierList();
        if (modifierList2 != null && modifierList2.hasModifier(KtTokens.ABSTRACT_KEYWORD)) {
            trace.report(Errors.ABSTRACT_PROPERTY_IN_PRIMARY_CONSTRUCTOR_PARAMETERS.on(parameter2));
        }
        Annotations allAnnotations = this.annotationResolver.resolveAnnotationsWithoutArguments(scope2, parameter2.getModifierList(), trace);
        EnumSet<AnnotationUseSiteTarget> targetSet = EnumSet.of(AnnotationUseSiteTarget.PROPERTY, AnnotationUseSiteTarget.PROPERTY_GETTER, AnnotationUseSiteTarget.FIELD, AnnotationUseSiteTarget.CONSTRUCTOR_PARAMETER, AnnotationUseSiteTarget.PROPERTY_SETTER);
        if (isMutable) {
            targetSet.add(AnnotationUseSiteTarget.PROPERTY_SETTER);
            targetSet.add(AnnotationUseSiteTarget.SETTER_PARAMETER);
        }
        AnnotationSplitter annotationSplitter = new AnnotationSplitter(this.storageManager, allAnnotations, targetSet);
        CompositeAnnotations propertyAnnotations = new CompositeAnnotations(annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.PROPERTY), annotationSplitter.getOtherAnnotations());
        PropertyDescriptorImpl propertyDescriptor = PropertyDescriptorImpl.create(classDescriptor2, propertyAnnotations, ModifiersChecker.resolveMemberModalityFromModifiers(parameter2, Modality.FINAL, trace.getBindingContext(), classDescriptor2), ModifiersChecker.resolveVisibilityFromModifiers(parameter2, DescriptorResolver.getDefaultVisibility(parameter2, classDescriptor2)), isMutable, name2, CallableMemberDescriptor.Kind.DECLARATION, KotlinSourceElementKt.toSourceElement(parameter2), false, false, classDescriptor2.isExpect(), modifierList2 != null && PsiUtilsKt.hasActualModifier(modifierList2), false, false);
        propertyDescriptor.setType(type2, Collections.emptyList(), DescriptorUtils.getDispatchReceiverParameterIfNeeded(classDescriptor2), null, CollectionsKt.emptyList());
        Annotations setterAnnotations = annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.PROPERTY_SETTER);
        CompositeAnnotations getterAnnotations = new CompositeAnnotations(CollectionsKt.listOf((Object)annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.PROPERTY_GETTER)));
        PropertyGetterDescriptorImpl getter2 = DescriptorFactory.createDefaultGetter(propertyDescriptor, getterAnnotations);
        PropertySetterDescriptorImpl setter2 = propertyDescriptor.isVar() ? DescriptorFactory.createDefaultSetter(propertyDescriptor, setterAnnotations, annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.SETTER_PARAMETER)) : null;
        propertyDescriptor.initialize(getter2, setter2, new FieldDescriptorImpl(annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.FIELD), propertyDescriptor), null);
        getter2.initialize(propertyDescriptor.getType());
        trace.record(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter2, propertyDescriptor);
        trace.record(BindingContext.VALUE_PARAMETER_AS_PROPERTY, valueParameter2, propertyDescriptor);
        return propertyDescriptor;
    }

    public static boolean checkHasOuterClassInstance(@NotNull LexicalScope scope2, @NotNull BindingTrace trace, @NotNull PsiElement reportErrorsOn, @NotNull ClassDescriptor target) {
        ClassDescriptor classDescriptor2;
        if (scope2 == null) {
            DescriptorResolver.$$$reportNull$$$0(133);
        }
        if (trace == null) {
            DescriptorResolver.$$$reportNull$$$0(134);
        }
        if (reportErrorsOn == null) {
            DescriptorResolver.$$$reportNull$$$0(135);
        }
        if (target == null) {
            DescriptorResolver.$$$reportNull$$$0(136);
        }
        if (!DescriptorResolver.isInsideOuterClassOrItsSubclass(classDescriptor2 = DescriptorResolver.getContainingClass(scope2), target)) {
            return true;
        }
        while (classDescriptor2 != null) {
            if (DescriptorUtils.isSubclass(classDescriptor2, target)) {
                return true;
            }
            if (DescriptorUtils.isStaticNestedClass(classDescriptor2)) {
                PsiElement onReport = CallResolverUtilKt.reportOnElement(reportErrorsOn);
                trace.report(Errors.INACCESSIBLE_OUTER_CLASS_EXPRESSION.on(onReport, classDescriptor2));
                return false;
            }
            classDescriptor2 = DescriptorUtils.getParentOfType(classDescriptor2, ClassDescriptor.class, true);
        }
        return true;
    }

    private static boolean isInsideOuterClassOrItsSubclass(@Nullable DeclarationDescriptor nested, @NotNull ClassDescriptor outer) {
        if (outer == null) {
            DescriptorResolver.$$$reportNull$$$0(137);
        }
        if (nested == null) {
            return false;
        }
        if (nested instanceof ClassDescriptor && DescriptorUtils.isSubclass((ClassDescriptor)nested, outer)) {
            return true;
        }
        return DescriptorResolver.isInsideOuterClassOrItsSubclass(nested.getContainingDeclaration(), outer);
    }

    @Nullable
    public static ClassDescriptor getContainingClass(@NotNull LexicalScope scope2) {
        if (scope2 == null) {
            DescriptorResolver.$$$reportNull$$$0(138);
        }
        return DescriptorUtils.getParentOfType(scope2.getOwnerDescriptor(), ClassDescriptor.class, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 35: 
            case 40: 
            case 42: 
            case 43: 
            case 46: 
            case 61: 
            case 69: 
            case 95: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 118: 
            case 128: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 35: 
            case 40: 
            case 42: 
            case 43: 
            case 46: 
            case 61: 
            case 69: 
            case 95: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 118: 
            case 128: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationResolver";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builtIns";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeResolver";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supertypeLoopsResolver";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableTypeAndInitializerResolver";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionTypingServices";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overloadChecker";
                break;
            }
            case 8: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageVersionSettings";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionsTypingVisitor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destructuringDeclarationResolver";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiersChecker";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrappedTypeFactory";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "approximator";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationReturnTypeSanitizer";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataFlowValueFactory";
                break;
            }
            case 17: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anonymousTypeTransformers";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalClassPartsProvider";
                break;
            }
            case 19: 
            case 29: 
            case 36: 
            case 56: 
            case 59: 
            case 64: 
            case 66: 
            case 119: 
            case 124: 
            case 131: 
            case 133: 
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 20: 
            case 21: 
            case 44: 
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDescriptor";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 35: 
            case 40: 
            case 42: 
            case 43: 
            case 46: 
            case 61: 
            case 69: 
            case 95: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 118: 
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/resolve/DescriptorResolver";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 26: 
            case 27: 
            case 33: 
            case 38: 
            case 45: 
            case 49: 
            case 51: 
            case 57: 
            case 68: 
            case 71: 
            case 76: 
            case 85: 
            case 92: 
            case 99: 
            case 112: 
            case 117: 
            case 120: 
            case 123: 
            case 134: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
            case 28: 
            case 32: 
            case 63: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 31: 
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueParameter";
                break;
            }
            case 34: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalAnnotations";
                break;
            }
            case 37: 
            case 52: 
            case 60: 
            case 62: 
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 47: 
            case 54: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 48: 
            case 55: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requests";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameter";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "upperBoundType";
                break;
            }
            case 65: 
            case 72: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingDeclaration";
                break;
            }
            case 67: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeAlias";
                break;
            }
            case 73: 
            case 82: 
            case 89: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeForDeclarationResolution";
                break;
            }
            case 74: 
            case 83: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeForInitializerResolution";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 77: 
            case 86: 
            case 93: 
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataFlowInfo";
                break;
            }
            case 78: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inferenceSession";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destructuringDeclaration";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 84: 
            case 109: 
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableDeclaration";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyInfo";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeWithTypeParameters";
                break;
            }
            case 110: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyDescriptor";
                break;
            }
            case 111: 
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationSplitter";
                break;
            }
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getterDescriptor";
                break;
            }
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getter";
                break;
            }
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionDescriptor";
                break;
            }
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reportErrorsOn";
                break;
            }
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/resolve/DescriptorResolver";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSupertype";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveValueParameterDescriptor";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveValueParameterAnnotations";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getVarargParameterType";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndRecordPrimaryConstructorForObject";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLocalVariableDescriptor";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveTypeAliasDescriptor";
                break;
            }
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveAsPropertyDescriptor";
                break;
            }
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                objectArray = objectArray2;
                objectArray2[1] = "transformAnonymousTypeIfNeeded";
                break;
            }
            case 118: {
                objectArray = objectArray2;
                objectArray2[1] = "resolvePropertyGetterDescriptor";
                break;
            }
            case 128: {
                objectArray = objectArray2;
                objectArray2[1] = "inferReturnTypeFromExpressionBody";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "resolveSupertypes";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultSupertype";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 35: 
            case 40: 
            case 42: 
            case 43: 
            case 46: 
            case 61: 
            case 69: 
            case 95: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 118: 
            case 128: {
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "resolveSuperTypeListEntries";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "checkNullableSupertypeAndStripQuestionMarks";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "checkProjectionsInImmediateArguments";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "resolveValueParameterDescriptor";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "resolveValueParameterAnnotations";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getVarargParameterType";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "createAndRecordPrimaryConstructorForObject";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "resolveGenericBounds";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "checkUpperBoundTypes";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "checkConflictingUpperBounds";
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "checkNamesInConstraints";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "checkUpperBoundType";
                break;
            }
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "resolveLocalVariableDescriptor";
                break;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "resolveTypeAliasDescriptor";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "checkNoGenericBoundsOnTypeAliasParameters";
                break;
            }
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "resolveDestructuringDeclarationEntryAsProperty";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "createReceiverForDestructuringDeclaration";
                break;
            }
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "resolvePropertyDescriptor";
                break;
            }
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "resolveAsPropertyDescriptor";
                break;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "transformAnonymousTypeIfNeeded";
                break;
            }
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "resolvePropertySetterDescriptor";
                break;
            }
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "resolvePropertyGetterDescriptor";
                break;
            }
            case 119: 
            case 120: 
            case 121: 
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "determineGetterReturnType";
                break;
            }
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "inferReturnTypeFromExpressionBody";
                break;
            }
            case 129: 
            case 130: 
            case 131: 
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "resolvePrimaryConstructorParameterToAProperty";
                break;
            }
            case 133: 
            case 134: 
            case 135: 
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "checkHasOuterClassInstance";
                break;
            }
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "isInsideOuterClassOrItsSubclass";
                break;
            }
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "getContainingClass";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 35: 
            case 40: 
            case 42: 
            case 43: 
            case 46: 
            case 61: 
            case 69: 
            case 95: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 118: 
            case 128: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static final class UpperBoundCheckRequest {
        public final Name typeParameterName;
        public final KtTypeReference upperBound;
        public final KotlinType upperBoundType;

        UpperBoundCheckRequest(Name typeParameterName, KtTypeReference upperBound, KotlinType upperBoundType) {
            this.typeParameterName = typeParameterName;
            this.upperBound = upperBound;
            this.upperBoundType = upperBoundType;
        }
    }
}

