/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra;

import java.lang.invoke.MethodHandles;
import javax.jms.JMSException;
import javax.resource.ResourceException;
import javax.resource.spi.LocalTransaction;
import org.apache.activemq.artemis.ra.ActiveMQRAManagedConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQRALocalTransaction
implements LocalTransaction {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ActiveMQRAManagedConnection mc;

    public ActiveMQRALocalTransaction(ActiveMQRAManagedConnection mc) {
        logger.trace("constructor({})", (Object)mc);
        this.mc = mc;
    }

    public void begin() throws ResourceException {
        logger.trace("begin()");
    }

    public void commit() throws ResourceException {
        logger.trace("commit()");
        this.mc.lock();
        try {
            if (this.mc.getSession().getTransacted()) {
                this.mc.getSession().commit();
            }
        }
        catch (JMSException e) {
            throw new ResourceException("Could not commit LocalTransaction", (Throwable)e);
        }
        finally {
            this.mc.unlock();
        }
    }

    public void rollback() throws ResourceException {
        logger.trace("rollback()");
        this.mc.lock();
        try {
            if (this.mc.getSession().getTransacted()) {
                this.mc.getSession().rollback();
            }
        }
        catch (JMSException ex) {
            throw new ResourceException("Could not rollback LocalTransaction", (Throwable)ex);
        }
        finally {
            this.mc.unlock();
        }
    }
}

