/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.util;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.qpid.jms.util.StopWatch;
import org.apache.qpid.jms.util.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThreadPoolUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadPoolUtils.class);
    public static final long DEFAULT_SHUTDOWN_AWAIT_TERMINATION = 10000L;

    public static void shutdown(ExecutorService executorService) {
        ThreadPoolUtils.doShutdown(executorService, 0L);
    }

    public static List<Runnable> shutdownNow(ExecutorService executorService) {
        if (executorService == null) {
            return Collections.emptyList();
        }
        List<Runnable> answer = null;
        if (!executorService.isShutdown()) {
            LOG.debug("Forcing shutdown of ExecutorService: {}", (Object)executorService);
            answer = executorService.shutdownNow();
            LOG.trace("Shutdown of ExecutorService: {} is shutdown: {} and terminated: {}.", new Object[]{executorService, executorService.isShutdown(), executorService.isTerminated()});
        }
        if (answer == null) {
            answer = Collections.emptyList();
        }
        return answer;
    }

    public static void shutdownGraceful(ExecutorService executorService) {
        ThreadPoolUtils.doShutdown(executorService, 10000L);
    }

    public static void shutdownGraceful(ExecutorService executorService, long shutdownAwaitTermination) {
        ThreadPoolUtils.doShutdown(executorService, shutdownAwaitTermination);
    }

    private static void doShutdown(ExecutorService executorService, long shutdownAwaitTermination) {
        if (executorService == null) {
            return;
        }
        if (!executorService.isShutdown()) {
            boolean warned = false;
            StopWatch watch = new StopWatch();
            LOG.trace("Shutdown of ExecutorService: {} with await termination: {} millis", (Object)executorService, (Object)shutdownAwaitTermination);
            executorService.shutdown();
            if (shutdownAwaitTermination > 0L) {
                try {
                    if (!ThreadPoolUtils.awaitTermination(executorService, shutdownAwaitTermination)) {
                        warned = true;
                        LOG.warn("Forcing shutdown of ExecutorService: {} due first await termination elapsed.", (Object)executorService);
                        executorService.shutdownNow();
                        if (!ThreadPoolUtils.awaitTermination(executorService, shutdownAwaitTermination)) {
                            LOG.warn("Cannot completely force shutdown of ExecutorService: {} due second await termination elapsed.", (Object)executorService);
                        }
                    }
                }
                catch (InterruptedException e) {
                    warned = true;
                    LOG.warn("Forcing shutdown of ExecutorService: {} due interrupted.", (Object)executorService);
                    executorService.shutdownNow();
                }
            }
            if (warned) {
                LOG.info("Shutdown of ExecutorService: {} is shutdown: {} and terminated: {} took: {}.", new Object[]{executorService, executorService.isShutdown(), executorService.isTerminated(), TimeUtils.printDuration(watch.taken())});
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Shutdown of ExecutorService: {} is shutdown: {} and terminated: {} took: {}.", new Object[]{executorService, executorService.isShutdown(), executorService.isTerminated(), TimeUtils.printDuration(watch.taken())});
            }
        }
    }

    public static boolean awaitTermination(ExecutorService executorService, long shutdownAwaitTermination) throws InterruptedException {
        if (executorService == null) {
            return true;
        }
        StopWatch watch = new StopWatch();
        long interval = Math.min(2000L, shutdownAwaitTermination);
        boolean done = false;
        while (!done && interval > 0L) {
            if (executorService.awaitTermination(interval, TimeUnit.MILLISECONDS)) {
                done = true;
                continue;
            }
            LOG.debug("Waited {} for ExecutorService: {} to terminate...", (Object)TimeUtils.printDuration(watch.taken()), (Object)executorService);
            interval = Math.min(2000L, shutdownAwaitTermination - watch.taken());
        }
        return done;
    }
}

