/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.tenant;

import java.util.Map;
import javax.sql.DataSource;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.tenant.JDBCTenantManager;
import org.wso2.carbon.user.core.tenant.LDAPTenantManager;
import org.wso2.carbon.user.core.tenant.Tenant;

public class HybridLDAPTenantManager
extends JDBCTenantManager {
    private static final Log log = LogFactory.getLog(HybridLDAPTenantManager.class);

    public HybridLDAPTenantManager(OMElement omElement, Map<String, Object> properties) throws Exception {
        super(omElement, properties);
    }

    public HybridLDAPTenantManager(DataSource dataSource, String superTenantDomain) {
        super(dataSource, superTenantDomain);
    }

    @Override
    public void initializeExistingPartitions() {
        try {
            Tenant[] existingTenants = this.getAllTenants();
            LDAPTenantManager ldapTenantManager = this.getLDAPTenantManager();
            for (Tenant tenant : existingTenants) {
                if (tenant.getDomain().equals("carbon.super")) continue;
                ldapTenantManager.addPartitionToTenant(tenant);
            }
        }
        catch (UserStoreException e) {
            log.error((Object)"Cannot get the existing tenants", (Throwable)((Object)e));
        }
    }

    @Override
    public int addTenant(org.wso2.carbon.user.api.Tenant tenant) throws UserStoreException {
        int tenantID = super.addTenant(tenant);
        tenant.setId(tenantID);
        LDAPTenantManager ldapTenantManager = this.getLDAPTenantManager();
        ldapTenantManager.addTenant((Tenant)tenant);
        return tenantID;
    }

    @Override
    public void updateTenant(org.wso2.carbon.user.api.Tenant tenant) throws UserStoreException {
        super.updateTenant(tenant);
        LDAPTenantManager ldapTenantManager = this.getLDAPTenantManager();
        ldapTenantManager.updateTenant((Tenant)tenant);
    }

    @Override
    public void deleteTenant(int tenantId) throws UserStoreException {
        super.deleteTenant(tenantId);
        LDAPTenantManager ldapTenantManager = this.getLDAPTenantManager();
        ldapTenantManager.deleteTenant(tenantId);
    }

    @Override
    public void setBundleContext(BundleContext bundleContext) {
        super.setBundleContext(bundleContext);
    }

    private LDAPTenantManager getLDAPTenantManager() {
        ServiceReference serviceReference = this.bundleContext.getServiceReference(LDAPTenantManager.class.getName());
        return (LDAPTenantManager)this.bundleContext.getService(serviceReference);
    }
}

