/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.saxon.regex.RegularExpression;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.value.NestedIntegerValue;

public class PackageLibrary {
    Map<String, List<StylesheetPackage>> packageMap = new HashMap<String, List<StylesheetPackage>>();

    public void addPackage(String name, StylesheetPackage packagei) {
        List<StylesheetPackage> list = this.packageMap.get(name);
        if (list == null) {
            list = new ArrayList<StylesheetPackage>();
            list.add(packagei);
            this.packageMap.put(name, list);
        } else {
            for (StylesheetPackage p : list) {
                if (!p.getPackageVersion().equals(packagei.getPackageVersion())) continue;
                list.remove(p);
                list.add(packagei);
                return;
            }
            list.add(packagei);
        }
    }

    public StylesheetPackage getPackage(String name, NestedIntegerValue ver) {
        List<StylesheetPackage> list = this.packageMap.get(name);
        for (StylesheetPackage p : list) {
            if (!p.getPackageVersion().equals(ver)) continue;
            return p;
        }
        return null;
    }

    public StylesheetPackage getPackage(String name) {
        NestedIntegerValue latestVersion = null;
        StylesheetPackage latestPackage = null;
        List<StylesheetPackage> list = this.packageMap.get(name);
        if (list == null) {
            return null;
        }
        for (StylesheetPackage p : list) {
            if (latestVersion != null && latestVersion.compareTo(p.getPackageVersion()) != -1) continue;
            latestVersion = p.getPackageVersion();
            latestPackage = p;
        }
        return latestPackage;
    }

    public StylesheetPackage getPackage(String name, RegularExpression versionRegEx) {
        List<StylesheetPackage> list = this.packageMap.get(name);
        if (list != null) {
            for (StylesheetPackage p : list) {
                if (!versionRegEx.matches(p.getPackageVersion().getStringValueCS())) continue;
                return p;
            }
        }
        return null;
    }

    public int size(String name) {
        return this.packageMap.get(name).size();
    }
}

