/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.config;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Aspect;
import org.wso2.carbon.registry.core.config.DataBaseConfiguration;
import org.wso2.carbon.registry.core.config.HandlerConfiguration;
import org.wso2.carbon.registry.core.config.MediaTypeHandlerConfiguration;
import org.wso2.carbon.registry.core.config.Mount;
import org.wso2.carbon.registry.core.config.QueryProcessorConfiguration;
import org.wso2.carbon.registry.core.config.RegistryConfigurationProcessor;
import org.wso2.carbon.registry.core.config.RemoteConfiguration;
import org.wso2.carbon.registry.core.dataaccess.DataAccessManager;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.EmbeddedRegistryService;
import org.wso2.carbon.registry.core.jdbc.Repository;
import org.wso2.carbon.registry.core.jdbc.VersionRepository;
import org.wso2.carbon.registry.core.jdbc.dataaccess.JDBCDataAccessManager;
import org.wso2.carbon.registry.core.jdbc.handlers.CustomEditManager;
import org.wso2.carbon.registry.core.jdbc.handlers.HandlerLifecycleManager;
import org.wso2.carbon.registry.core.jdbc.handlers.HandlerManager;
import org.wso2.carbon.registry.core.jdbc.queries.QueryProcessorManager;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.statistics.StatisticsCollector;
import org.wso2.carbon.registry.core.utils.LogQueue;
import org.wso2.carbon.registry.core.utils.LogWriter;
import org.wso2.carbon.registry.core.utils.UUIDGenerator;
import org.wso2.carbon.user.core.service.RealmService;

public class RegistryContext {
    private static final Log log = LogFactory.getLog(RegistryContext.class);
    private static final List<String> ALLOWED_CLASSES = Arrays.asList(RegistryContext.class.getName(), "org.wso2.carbon.registry.core.ResourceImpl", "org.wso2.carbon.registry.core.jdbc.EmbeddedRegistry", "org.wso2.carbon.registry.core.jdbc.Repository", "org.wso2.carbon.registry.core.jdbc.dao.JDBCLogsDAO", "org.wso2.carbon.registry.core.jdbc.dao.JDBCPathCache");
    private static final String NODE_IDENTIFIER = UUIDGenerator.generateUUID();
    private static volatile List<StatisticsCollector> statisticsCollectors = new LinkedList<StatisticsCollector>();
    private String resourceMediaTypes = null;
    private String collectionMediaTypes = null;
    private String customUIMediaTypes = null;
    private RealmService realmService;
    private RegURLSupplier urlSupplier;
    private DataBaseConfiguration defaultDataBaseConfiguration = null;
    private Map<String, DataBaseConfiguration> dbConfigs = new HashMap<String, DataBaseConfiguration>();
    private HandlerLifecycleManager handlerManager = new HandlerLifecycleManager();
    private CustomEditManager customEditManager = new CustomEditManager();
    private Map aspects = new HashMap();
    private boolean versionOnChange;
    private int maxCache;
    private List<RemoteConfiguration> remoteInstances = new ArrayList<RemoteConfiguration>();
    private List<Mount> mounts = new ArrayList<Mount>();
    private List<QueryProcessorConfiguration> queryProcessors = new ArrayList<QueryProcessorConfiguration>();
    private String profilesPath = "/_system/config/users/";
    private String servicePath = "/_system/governance/trunk/services";
    private LogWriter logWriter = null;
    private boolean enableCache = false;
    private List<String> systemResourcePaths = new ArrayList<String>();
    private List<Pattern> noCachePaths = new ArrayList<Pattern>();
    private static RegistryContext registryContext = null;
    private String registryRoot;
    private boolean readOnly;
    private DataAccessManager dataAccessManager = null;
    private boolean setup = true;
    private boolean clone = false;
    private Repository repository;
    private VersionRepository versionRepository;
    private QueryProcessorManager queryProcessorManager;
    private EmbeddedRegistryService embeddedRegistryService;

    public String getNodeIdentifier() {
        return NODE_IDENTIFIER;
    }

    public String getResourceMediaTypes() {
        return RegistryContext.getBaseInstance().resourceMediaTypes;
    }

    public void setResourceMediaTypes(String resourceMediaTypes) {
        RegistryContext.getBaseInstance().resourceMediaTypes = resourceMediaTypes;
    }

    public String getCollectionMediaTypes() {
        return RegistryContext.getBaseInstance().collectionMediaTypes;
    }

    public void setCollectionMediaTypes(String collectionMediaTypes) {
        RegistryContext.getBaseInstance().collectionMediaTypes = collectionMediaTypes;
    }

    public String getCustomUIMediaTypes() {
        return RegistryContext.getBaseInstance().customUIMediaTypes;
    }

    public void setCustomUIMediaTypes(String customUIMediaTypes) {
        RegistryContext.getBaseInstance().customUIMediaTypes = customUIMediaTypes;
    }

    public boolean isClone() {
        return this.clone;
    }

    public void setClone(boolean clone) {
        this.clone = clone;
    }

    public static RegistryContext getBaseInstance() {
        return registryContext;
    }

    public static RegistryContext getCloneContext() {
        RegistryContext context = new RegistryContext();
        context.setClone(true);
        return context;
    }

    public static void destroy() {
        RegistryContext.setBaseInstance(null);
    }

    public static RegistryContext getBaseInstance(RealmService realmService) {
        return RegistryContext.getBaseInstance(realmService, true);
    }

    public static RegistryContext getBaseInstance(RealmService realmService, boolean populateConfiguration) {
        try {
            if (RegistryContext.getBaseInstance() != null) {
                return RegistryContext.getBaseInstance();
            }
            new RegistryContext(realmService, populateConfiguration);
        }
        catch (RegistryException e) {
            log.error((Object)"Unable to get instance of the registry context", (Throwable)((Object)e));
            return null;
        }
        return RegistryContext.getBaseInstance();
    }

    public static RegistryContext getBaseInstance(InputStream configStream, RealmService realmService) {
        try {
            if (RegistryContext.getBaseInstance() != null) {
                return RegistryContext.getBaseInstance();
            }
            new RegistryContext(configStream, realmService);
        }
        catch (RegistryException e) {
            log.error((Object)"Unable to get instance of the registry context", (Throwable)((Object)e));
            return null;
        }
        return RegistryContext.getBaseInstance();
    }

    @Deprecated
    public static RegistryContext getBaseInstance(InputStream configStream, RegURLSupplier urlSupplier) {
        try {
            if (RegistryContext.getBaseInstance() != null) {
                return RegistryContext.getBaseInstance();
            }
            new RegistryContext(configStream, urlSupplier);
        }
        catch (RegistryException e) {
            log.error((Object)"Unable to get instance of the registry context", (Throwable)((Object)e));
            return null;
        }
        return RegistryContext.getBaseInstance();
    }

    private static synchronized void setBaseInstance(RegistryContext context) {
        registryContext = context;
    }

    public String getRegistryRoot() {
        return this.registryRoot;
    }

    public void setRegistryRoot(String registryRoot) {
        this.registryRoot = registryRoot;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isCacheEnabled() {
        return this.enableCache;
    }

    public void setCacheEnabled(boolean enableCache) {
        this.enableCache = enableCache;
    }

    protected RegistryContext(RealmService realmService, boolean populateConfiguration) throws RegistryException {
        this(null, realmService, populateConfiguration);
    }

    protected RegistryContext(InputStream configStream, RealmService realmService) throws RegistryException {
        this(configStream, realmService, true);
    }

    protected RegistryContext(InputStream configStream, RealmService realmService, boolean populateConfiguration) throws RegistryException {
        RegistryContext.setBaseInstance(this);
        this.realmService = realmService;
        if (populateConfiguration) {
            RegistryConfigurationProcessor.populateRegistryConfig(configStream, this);
        }
    }

    protected RegistryContext(InputStream configStream, RegURLSupplier urlSupplier) throws RegistryException {
        RegistryContext.setBaseInstance(this);
        this.urlSupplier = urlSupplier;
        RegistryConfigurationProcessor.populateRegistryConfig(configStream, this);
    }

    protected RegistryContext() {
        RegistryContext baseContext = RegistryContext.getBaseInstance();
        if (baseContext != null) {
            this.realmService = baseContext.realmService;
            this.urlSupplier = baseContext.urlSupplier;
            this.defaultDataBaseConfiguration = baseContext.defaultDataBaseConfiguration;
            this.dbConfigs = baseContext.dbConfigs;
            this.handlerManager = baseContext.handlerManager;
            this.customEditManager = baseContext.customEditManager;
            this.aspects = baseContext.aspects;
            this.versionOnChange = baseContext.versionOnChange;
            this.maxCache = baseContext.maxCache;
            this.profilesPath = baseContext.profilesPath;
            this.remoteInstances = baseContext.remoteInstances;
            this.mounts = baseContext.mounts;
            this.queryProcessors = baseContext.queryProcessors;
            this.servicePath = baseContext.servicePath;
            this.logWriter = baseContext.logWriter;
            this.systemResourcePaths = baseContext.systemResourcePaths;
            this.noCachePaths = baseContext.noCachePaths;
        }
        this.setup = true;
    }

    public RealmService getRealmService() {
        return this.realmService;
    }

    @Deprecated
    public void setMaxCache(int maxCache) {
        this.maxCache = maxCache;
    }

    @Deprecated
    public int getMaxCache() {
        return this.maxCache;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public VersionRepository getVersionRepository() {
        return this.versionRepository;
    }

    public void setVersionRepository(VersionRepository versionRepository) {
        this.versionRepository = versionRepository;
    }

    public QueryProcessorManager getQueryProcessorManager() {
        return this.queryProcessorManager;
    }

    public void setQueryProcessorManager(QueryProcessorManager queryProcessorManager) {
        this.queryProcessorManager = queryProcessorManager;
    }

    public boolean isVersionOnChange() {
        return this.versionOnChange;
    }

    public void setVersionOnChange(boolean versionOnChange) {
        this.versionOnChange = versionOnChange;
    }

    public boolean isSetup() {
        return this.setup;
    }

    public void setSetup(boolean setup) {
        this.setup = setup;
    }

    public EmbeddedRegistryService getEmbeddedRegistryService() throws RegistryException {
        if (this.embeddedRegistryService == null) {
            try {
                this.embeddedRegistryService = new EmbeddedRegistryService(this);
            }
            catch (RegistryException e) {
                String msg = "Couldn't initialize EmbeddedRegistryService. " + e.getMessage();
                log.error((Object)msg, (Throwable)((Object)e));
                throw new RegistryException(msg, (Throwable)((Object)e));
            }
        }
        return this.embeddedRegistryService;
    }

    public DataBaseConfiguration getDefaultDataBaseConfiguration() {
        return this.defaultDataBaseConfiguration;
    }

    public void setDefaultDataBaseConfiguration(DataBaseConfiguration dataBaseConfiguration) {
        this.defaultDataBaseConfiguration = dataBaseConfiguration;
    }

    public DataBaseConfiguration selectDBConfig(String dbConfigName) {
        DataBaseConfiguration config = this.dbConfigs.get(dbConfigName);
        if (config == null) {
            log.error((Object)("Couldn't find db configuration '" + dbConfigName + "'"));
            return null;
        }
        this.dataAccessManager = new JDBCDataAccessManager(config);
        return config;
    }

    public Iterator<String> getDBConfigNames() {
        return this.dbConfigs.keySet().iterator();
    }

    public DataBaseConfiguration getDBConfig(String dbConfigName) {
        return this.dbConfigs.get(dbConfigName);
    }

    public void addDBConfig(String name, DataBaseConfiguration config) {
        String url = config.getDbUrl();
        if (url != null) {
            config.setDbUrl(url.replace("$basedir$", this.getBasePath()));
        }
        this.dbConfigs.put(name, config);
    }

    public void addAspect(String name, Aspect aspect, int tenantId) {
        HashMap<String, Aspect> tenantAspect = (HashMap<String, Aspect>)this.aspects.get(tenantId);
        if (tenantAspect == null) {
            tenantAspect = new HashMap<String, Aspect>();
        }
        tenantAspect.put(name, aspect);
        this.aspects.put(tenantId, tenantAspect);
    }

    public boolean removeAspect(String name, int tenantId) {
        Map tenantAspect = (Map)this.aspects.get(tenantId);
        if (tenantAspect != null) {
            if (tenantAspect.get(name) == null) {
                return false;
            }
            tenantAspect.remove(name);
            return true;
        }
        return false;
    }

    public Aspect getAspect(String name, int tenantId) {
        Map tenantAspect = (Map)this.aspects.get(tenantId);
        if (tenantAspect != null) {
            return (Aspect)tenantAspect.get(name);
        }
        return null;
    }

    public String[] getAspectNames(int tenantId) {
        Map tenantAspect = (Map)this.aspects.get(tenantId);
        if (tenantAspect != null) {
            Set aspectNames = tenantAspect.keySet();
            return aspectNames.toArray(new String[aspectNames.size()]);
        }
        return null;
    }

    public List getQueryProcessors() {
        return this.queryProcessors;
    }

    public void setQueryProcessors(List<QueryProcessorConfiguration> queryProcessors) {
        this.queryProcessors = queryProcessors;
    }

    public void addQueryProcessor(QueryProcessorConfiguration queryProcessorConfiguration) {
        this.queryProcessors.add(queryProcessorConfiguration);
    }

    public String getBasePath() {
        String basePath = null;
        if (this.urlSupplier != null) {
            basePath = this.urlSupplier.getURL();
        }
        if (basePath == null) {
            basePath = System.getProperty("basedir", "");
        }
        return basePath;
    }

    public DataAccessManager getDataAccessManager() {
        return this.dataAccessManager;
    }

    public void setDataAccessManager(DataAccessManager dataAccessManager) {
        this.dataAccessManager = dataAccessManager;
    }

    public HandlerManager getHandlerManager() {
        return this.handlerManager;
    }

    public HandlerManager getHandlerManager(String lifecyclePhase) {
        return this.handlerManager.getHandlerManagerForPhase(lifecyclePhase);
    }

    public CustomEditManager getCustomEditManager() {
        return this.customEditManager;
    }

    public void setCustomEditManager(CustomEditManager customEditManager) {
        this.customEditManager = customEditManager;
    }

    public List<RemoteConfiguration> getRemoteInstances() {
        return this.remoteInstances;
    }

    public void setRemoteInstances(List<RemoteConfiguration> remoteInstances) {
        this.remoteInstances = remoteInstances;
    }

    public List<Mount> getMounts() {
        return this.mounts;
    }

    public void setMounts(List<Mount> mounts) {
        this.mounts = mounts;
    }

    public void setProfilesPath(String path) {
        this.profilesPath = path;
    }

    public String getProfilesPath() {
        return this.profilesPath;
    }

    public String getServicePath() {
        return this.servicePath;
    }

    public void setServicePath(String servicePath) {
        this.servicePath = servicePath;
    }

    @Deprecated
    public List<HandlerConfiguration> getHandlerConfigurations() {
        throw new UnsupportedOperationException("This method is no longer supported.");
    }

    @Deprecated
    public void setHandlerConfigurations(List<HandlerConfiguration> handlerConfigurations) {
        throw new UnsupportedOperationException("This method is no longer supported.");
    }

    @Deprecated
    public void addHandlerConfiguration(HandlerConfiguration handlerConfiguration) {
        throw new UnsupportedOperationException("This method is no longer supported.");
    }

    @Deprecated
    public List getMediaTypeHandlers() {
        throw new UnsupportedOperationException("This method is no longer supported.");
    }

    @Deprecated
    public void setMediaTypeHandlers(List mediaTypeHandlers) {
        throw new UnsupportedOperationException("This method is no longer supported.");
    }

    @Deprecated
    public void addMediaTypeHandler(MediaTypeHandlerConfiguration mediaTypeHandlerConfiguration) {
        throw new UnsupportedOperationException("This method is no longer supported.");
    }

    @Deprecated
    public List getUrlHandlers() {
        throw new UnsupportedOperationException("This method is no longer supported.");
    }

    @Deprecated
    public void setUrlHandlers(List urlHandlers) {
        throw new UnsupportedOperationException("This method is no longer supported.");
    }

    @Deprecated
    public void addURLHandler(String urlHandler) {
        throw new UnsupportedOperationException("This method is no longer supported.");
    }

    public LogWriter getLogWriter() {
        if (this.logWriter == null) {
            this.logWriter = new LogWriter(new LogQueue(), this.dataAccessManager);
            this.logWriter.start();
        }
        return this.logWriter;
    }

    public void setLogWriter(LogWriter logWriter) {
        this.logWriter = logWriter;
    }

    public boolean isSystemResourcePathRegistered(String absolutePath) {
        return this.systemResourcePaths.contains(CurrentSession.getTenantId() + ":" + absolutePath);
    }

    public void registerSystemResourcePath(String absolutePath) {
        this.systemResourcePaths.add(CurrentSession.getTenantId() + ":" + absolutePath);
    }

    public boolean isNoCachePath(String path) {
        for (Pattern noCachePath : this.noCachePaths) {
            if (!noCachePath.matcher(path).matches()) continue;
            return true;
        }
        return false;
    }

    public void registerNoCachePath(String path) {
        this.noCachePaths.add(Pattern.compile(Pattern.quote(path) + "($|" + "/" + ".*|" + ";" + ".*)"));
    }

    public StatisticsCollector[] getStatisticsCollectors() {
        return statisticsCollectors.isEmpty() ? new StatisticsCollector[]{} : statisticsCollectors.toArray(new StatisticsCollector[statisticsCollectors.size()]);
    }

    public void addStatisticsCollector(StatisticsCollector statisticsCollector) {
        statisticsCollectors.add(statisticsCollector);
    }

    public void removeStatisticsCollector(StatisticsCollector statisticsCollector) {
        statisticsCollectors.remove(statisticsCollector);
    }

    @Deprecated
    public static interface RegURLSupplier {
        public String getURL();
    }
}

