/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.jdbc.dataaccess;

import org.wso2.carbon.registry.core.dao.AssociationDAO;
import org.wso2.carbon.registry.core.dao.CommentsDAO;
import org.wso2.carbon.registry.core.dao.LogsDAO;
import org.wso2.carbon.registry.core.dao.RatingsDAO;
import org.wso2.carbon.registry.core.dao.ResourceDAO;
import org.wso2.carbon.registry.core.dao.ResourceVersionDAO;
import org.wso2.carbon.registry.core.dao.TagsDAO;
import org.wso2.carbon.registry.core.dataaccess.DAOManager;
import org.wso2.carbon.registry.core.jdbc.dao.JDBCAssociationDAO;
import org.wso2.carbon.registry.core.jdbc.dao.JDBCCommentsDAO;
import org.wso2.carbon.registry.core.jdbc.dao.JDBCCommentsVersionDAO;
import org.wso2.carbon.registry.core.jdbc.dao.JDBCLogsDAO;
import org.wso2.carbon.registry.core.jdbc.dao.JDBCRatingsDAO;
import org.wso2.carbon.registry.core.jdbc.dao.JDBCRatingsVersionDAO;
import org.wso2.carbon.registry.core.jdbc.dao.JDBCResourceDAO;
import org.wso2.carbon.registry.core.jdbc.dao.JDBCResourceVersionDAO;
import org.wso2.carbon.registry.core.jdbc.dao.JDBCTagsDAO;
import org.wso2.carbon.registry.core.jdbc.dao.JDBCTagsVersionDAO;

public class JDBCDAOManager
implements DAOManager {
    private AssociationDAO associationDAO;
    private CommentsDAO commentsDAO;
    private CommentsDAO commentsVersionDAO;
    private RatingsDAO ratingsDAO;
    private RatingsDAO ratingsVersionDAO;
    private TagsDAO tagsDAO;
    private TagsDAO tagsVersionDAO;
    private LogsDAO logsDAO;
    private ResourceDAO resourceDAO = new JDBCResourceDAO();
    private ResourceVersionDAO resourceVersionDAO;

    public JDBCDAOManager() {
        this.associationDAO = new JDBCAssociationDAO();
        this.logsDAO = new JDBCLogsDAO();
        this.commentsDAO = new JDBCCommentsDAO(this);
        this.commentsVersionDAO = new JDBCCommentsVersionDAO(this);
        this.ratingsDAO = new JDBCRatingsDAO(this);
        this.ratingsVersionDAO = new JDBCRatingsVersionDAO(this);
        this.tagsDAO = new JDBCTagsDAO(this);
        this.tagsVersionDAO = new JDBCTagsVersionDAO(this);
        this.resourceVersionDAO = new JDBCResourceVersionDAO(this);
    }

    @Override
    public AssociationDAO getAssociationDAO() {
        return this.associationDAO;
    }

    @Override
    public CommentsDAO getCommentsDAO(boolean isVersioned) {
        return isVersioned ? this.commentsVersionDAO : this.commentsDAO;
    }

    @Override
    public RatingsDAO getRatingsDAO(boolean isVersioned) {
        return isVersioned ? this.ratingsVersionDAO : this.ratingsDAO;
    }

    @Override
    public TagsDAO getTagsDAO(boolean isVersioned) {
        return isVersioned ? this.tagsVersionDAO : this.tagsDAO;
    }

    @Override
    public LogsDAO getLogsDAO() {
        return this.logsDAO;
    }

    @Override
    public ResourceDAO getResourceDAO() {
        return this.resourceDAO;
    }

    @Override
    public ResourceVersionDAO getResourceVersionDAO() {
        return this.resourceVersionDAO;
    }
}

