/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.sharing.registry.db.repositories;

import java.util.HashMap;
import java.util.List;
import org.apache.airavata.sharing.registry.db.entities.SharingEntity;
import org.apache.airavata.sharing.registry.db.entities.UserGroupEntity;
import org.apache.airavata.sharing.registry.db.entities.UserGroupPK;
import org.apache.airavata.sharing.registry.db.repositories.AbstractRepository;
import org.apache.airavata.sharing.registry.db.repositories.PermissionTypeRepository;
import org.apache.airavata.sharing.registry.models.GroupCardinality;
import org.apache.airavata.sharing.registry.models.SharingRegistryException;
import org.apache.airavata.sharing.registry.models.UserGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserGroupRepository
extends AbstractRepository<UserGroup, UserGroupEntity, UserGroupPK> {
    private static final Logger logger = LoggerFactory.getLogger(UserGroupRepository.class);

    public UserGroupRepository() {
        super(UserGroup.class, UserGroupEntity.class);
    }

    public List<UserGroup> getAccessibleGroups(String domainId, String entityId, String permissionTypeId) throws SharingRegistryException {
        String query = "SELECT DISTINCT g from " + UserGroupEntity.class.getSimpleName() + " g, " + SharingEntity.class.getSimpleName() + " s";
        query = query + " WHERE ";
        query = query + "g.groupId = s.groupId AND ";
        query = query + "g.domainId = s.domainId AND ";
        query = query + "g.domainId = :domainId AND ";
        query = query + "s.entityId = :entityId AND ";
        query = query + "s.permissionTypeId = :permissionTypeId AND ";
        query = query + "g.groupCardinality = :groupCardinality";
        query = query + " ORDER BY s.createdTime DESC";
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put("domainId", domainId);
        queryParameters.put("entityId", entityId);
        queryParameters.put("permissionTypeId", permissionTypeId);
        queryParameters.put("groupCardinality", GroupCardinality.MULTI_USER.toString());
        return this.select(query, queryParameters, 0, -1);
    }

    public boolean isShared(String domainId, String entityId) throws SharingRegistryException {
        String query = "SELECT DISTINCT g from " + UserGroupEntity.class.getSimpleName() + " g, " + SharingEntity.class.getSimpleName() + " s";
        query = query + " WHERE ";
        query = query + "g.groupId = s.groupId AND ";
        query = query + "g.domainId = s.domainId AND ";
        query = query + "g.domainId = :domainId AND ";
        query = query + "s.entityId = :entityId AND ";
        query = query + "s.permissionTypeId <> :permissionTypeId";
        query = query + " ORDER BY s.createdTime DESC";
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put("domainId", domainId);
        queryParameters.put("entityId", entityId);
        String ownerPermissionTypeIdForDomain = new PermissionTypeRepository().getOwnerPermissionTypeIdForDomain(domainId);
        queryParameters.put("permissionTypeId", ownerPermissionTypeIdForDomain);
        return this.select(query, queryParameters, 0, -1).size() != 0;
    }
}

