/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl;

import com.hazelcast.nio.serialization.ArrayDataSerializableFactory;
import com.hazelcast.nio.serialization.DataSerializableFactory;
import com.hazelcast.nio.serialization.DataSerializerHook;
import com.hazelcast.nio.serialization.FactoryIdHelper;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.Backup;
import com.hazelcast.spi.impl.BackupResponse;
import com.hazelcast.spi.impl.BinaryOperationFactory;
import com.hazelcast.spi.impl.EventServiceImpl;
import com.hazelcast.spi.impl.PartitionIteratingOperation;
import com.hazelcast.spi.impl.ResponseOperation;
import com.hazelcast.spi.impl.SerializableCollection;
import com.hazelcast.util.ConstructorFunction;

public final class SpiDataSerializerHook
implements DataSerializerHook {
    static final int F_ID = FactoryIdHelper.getFactoryId("hazelcast.serialization.ds.spi", -1);
    static final int RESPONSE = 0;
    static final int BACKUP = 1;
    static final int BACKUP_RESPONSE = 2;
    static final int PARTITION_ITERATOR = 3;
    static final int PARTITION_RESPONSE = 4;
    static final int PARALLEL_OPERATION_FACTORY = 5;
    static final int EVENT_PACKET = 6;
    static final int COLLECTION = 7;
    private static final int LEN = 10;

    @Override
    public DataSerializableFactory createFactory() {
        ConstructorFunction[] constructors = new ConstructorFunction[10];
        constructors[0] = new ConstructorFunction<Integer, IdentifiedDataSerializable>(){

            @Override
            public IdentifiedDataSerializable createNew(Integer arg) {
                return new ResponseOperation();
            }
        };
        constructors[1] = new ConstructorFunction<Integer, IdentifiedDataSerializable>(){

            @Override
            public IdentifiedDataSerializable createNew(Integer arg) {
                return new Backup();
            }
        };
        constructors[2] = new ConstructorFunction<Integer, IdentifiedDataSerializable>(){

            @Override
            public IdentifiedDataSerializable createNew(Integer arg) {
                return new BackupResponse();
            }
        };
        constructors[6] = new ConstructorFunction<Integer, IdentifiedDataSerializable>(){

            @Override
            public IdentifiedDataSerializable createNew(Integer arg) {
                return new EventServiceImpl.EventPacket();
            }
        };
        constructors[3] = new ConstructorFunction<Integer, IdentifiedDataSerializable>(){

            @Override
            public IdentifiedDataSerializable createNew(Integer arg) {
                return new PartitionIteratingOperation();
            }
        };
        constructors[4] = new ConstructorFunction<Integer, IdentifiedDataSerializable>(){

            @Override
            public IdentifiedDataSerializable createNew(Integer arg) {
                return new PartitionIteratingOperation.PartitionResponse();
            }
        };
        constructors[5] = new ConstructorFunction<Integer, IdentifiedDataSerializable>(){

            @Override
            public IdentifiedDataSerializable createNew(Integer arg) {
                return new BinaryOperationFactory();
            }
        };
        constructors[7] = new ConstructorFunction<Integer, IdentifiedDataSerializable>(){

            @Override
            public IdentifiedDataSerializable createNew(Integer arg) {
                return new SerializableCollection();
            }
        };
        return new ArrayDataSerializableFactory(constructors);
    }

    @Override
    public int getFactoryId() {
        return F_ID;
    }
}

