/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.samly2.assertion;

import eu.unicore.samly2.assertion.AssertionParser;
import eu.unicore.samly2.attrprofile.ParsedAttribute;
import eu.unicore.samly2.attrprofile.ProfilesManager;
import eu.unicore.samly2.attrprofile.SAMLAttributeProfile;
import eu.unicore.samly2.exceptions.SAMLValidationException;
import java.util.ArrayList;
import java.util.List;
import xmlbeans.org.oasis.saml2.assertion.AssertionDocument;
import xmlbeans.org.oasis.saml2.assertion.AssertionType;
import xmlbeans.org.oasis.saml2.assertion.AttributeStatementType;
import xmlbeans.org.oasis.saml2.assertion.AttributeType;

public class AttributeAssertionParser
extends AssertionParser {
    private static final long serialVersionUID = 1L;
    private ProfilesManager profilesManager = new ProfilesManager();

    protected AttributeAssertionParser() {
    }

    public AttributeAssertionParser(AssertionDocument doc) {
        super(doc);
    }

    public AttributeAssertionParser(AssertionType assertion) {
        super(assertion);
    }

    public void addProfile(SAMLAttributeProfile profile) {
        this.profilesManager.addProfile(profile);
    }

    public ParsedAttribute getAttribute() throws SAMLValidationException {
        List<ParsedAttribute> list = this.getAttributesGeneric();
        if (list.size() == 0) {
            return null;
        }
        if (list.size() > 1) {
            throw new SAMLValidationException("There are " + list.size() + " attributes, expected one.");
        }
        return list.get(0);
    }

    public List<ParsedAttribute> getAttributes() throws SAMLValidationException {
        return this.getAttributesGeneric();
    }

    public ParsedAttribute getAttribute(String name) throws SAMLValidationException {
        for (AttributeStatementType as : this.assertionDoc.getAssertion().getAttributeStatementArray()) {
            for (AttributeType xmlAttr : as.getAttributeArray()) {
                if (!name.equals(xmlAttr.getName())) continue;
                SAMLAttributeProfile profile = this.profilesManager.getBestProfile(xmlAttr);
                return profile.map(xmlAttr);
            }
        }
        return null;
    }

    protected List<ParsedAttribute> getAttributesGeneric() throws SAMLValidationException {
        ArrayList<ParsedAttribute> ret = new ArrayList<ParsedAttribute>();
        for (AttributeStatementType as : this.assertionDoc.getAssertion().getAttributeStatementArray()) {
            this.parseAttributes(ret, as.getAttributeArray());
        }
        return ret;
    }

    protected void parseAttributes(List<ParsedAttribute> target, AttributeType[] xmlAttrs) throws SAMLValidationException {
        for (AttributeType xmlAttr : xmlAttrs) {
            SAMLAttributeProfile profile = this.profilesManager.getBestProfile(xmlAttr);
            target.add(profile.map(xmlAttr));
        }
    }
}

