/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.wsutil;

import eu.emi.security.authn.x509.impl.CertificateUtils;
import eu.emi.security.authn.x509.impl.FormatMode;
import eu.emi.security.authn.x509.impl.X500NameUtils;
import eu.unicore.samly2.SAMLBindings;
import eu.unicore.samly2.exceptions.SAMLValidationException;
import eu.unicore.samly2.trust.SamlTrustChecker;
import eu.unicore.samly2.validators.SSOAuthnAssertionValidator;
import eu.unicore.security.HTTPAuthNTokens;
import eu.unicore.security.SecurityTokens;
import eu.unicore.security.UnicoreSecurityFactory;
import eu.unicore.security.UserAttributeHandler;
import eu.unicore.security.ValidationResult;
import eu.unicore.security.consignor.ConsignorAPI;
import eu.unicore.security.consignor.ConsignorAssertion;
import eu.unicore.security.user.UserAssertion;
import eu.unicore.security.wsutil.CXFUtils;
import eu.unicore.security.wsutil.SecuritySession;
import eu.unicore.security.wsutil.SecuritySessionStore;
import eu.unicore.security.wsutil.SecuritySessionUtils;
import eu.unicore.security.wsutil.SessionIDServerOutHandler;
import eu.unicore.security.wsutil.WSSecHeader;
import eu.unicore.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import org.apache.commons.codec.binary.Base64;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import xmlbeans.org.oasis.saml2.assertion.AssertionDocument;
import xmlbeans.org.oasis.saml2.assertion.AttributeStatementType;
import xmlbeans.org.oasis.saml2.assertion.AttributeType;
import xmlbeans.org.oasis.saml2.assertion.AuthnStatementType;
import xmlbeans.org.oasis.saml2.assertion.NameIDType;
import xmlbeans.org.oasis.saml2.assertion.SubjectLocalityType;
import xmlbeans.org.oasis.saml2.assertion.SubjectType;

public class AuthInHandler
extends AbstractSoapInterceptor {
    protected static final Logger logger = Log.getLogger("unicore.security", AuthInHandler.class);
    public static final String SAML2_NS = "urn:oasis:names:tc:SAML:2.0:assertion";
    public static final String RAW_SAML_ASSERTIONS_KEY = AuthInHandler.class.getName() + ".RAW_SAML_ASSERTIONS";
    private boolean useGatewayAssertions;
    private boolean useHTTPBasic;
    private boolean useSSLData;
    private X509Certificate gatewayC;
    private boolean verifyConsignor;
    private SamlTrustChecker samlAuthnTrustChecker;
    private String samlConsumerName;
    private String samlConsumerEndpointUri;
    private long samlGraceTime;
    private String actor;
    private List<UserAttributeHandler> userAttributeHandlers = new ArrayList<UserAttributeHandler>();
    private final Set<QName> qnameSet = new HashSet<QName>();
    private SecuritySessionStore sessionStore;

    public AuthInHandler(boolean useGatewayAssertions, boolean useSSLData, boolean extractHTTPData, X509Certificate gatewayC, SecuritySessionStore sessionStore) {
        this(useGatewayAssertions, useSSLData, extractHTTPData, gatewayC, null, sessionStore);
    }

    public AuthInHandler(boolean useGatewayAssertions, boolean useSSLData, boolean extractHTTPData, X509Certificate gatewayC, String actor, SecuritySessionStore sessionStore) {
        super("pre-invoke");
        this.qnameSet.add(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security"));
        this.useGatewayAssertions = useGatewayAssertions;
        this.useHTTPBasic = extractHTTPData;
        this.useSSLData = useSSLData;
        this.verifyConsignor = false;
        if (gatewayC != null && useGatewayAssertions) {
            this.gatewayC = gatewayC;
            this.verifyConsignor = true;
        }
        this.actor = actor;
        this.sessionStore = sessionStore;
    }

    public void enableSamlAuthentication(String consumerSamlName, String consumerEndpointUri, SamlTrustChecker samlTrustChecker, long samlValidityGraceTime) {
        this.samlAuthnTrustChecker = samlTrustChecker;
        this.samlConsumerEndpointUri = consumerEndpointUri;
        this.samlConsumerName = consumerSamlName;
        this.samlGraceTime = samlValidityGraceTime;
    }

    public void disableSamlAuthentication() {
        this.samlAuthnTrustChecker = null;
    }

    public void addUserAttributeHandler(UserAttributeHandler uh) {
        this.userAttributeHandlers.add(uh);
    }

    public Set<QName> getUnderstoodHeaders() {
        return this.qnameSet;
    }

    public void handleMessage(SoapMessage ctx) {
        SecurityTokens mainToken;
        String sessionID = SecuritySessionUtils.getSecuritySessionID(ctx);
        if (sessionID == null) {
            mainToken = new SecurityTokens();
            this.process(ctx, mainToken);
        } else {
            SecuritySession session = this.getSession(ctx, sessionID);
            mainToken = session.getTokens();
            mainToken.getContext().put("reused-unicore-security-session", Boolean.TRUE);
            SessionIDServerOutHandler.setSession(session);
            if (logger.isDebugEnabled()) {
                logger.debug("Re-using session " + sessionID + " for <" + session.getUserKey() + ">");
            }
        }
        ctx.put(SecurityTokens.KEY, (Object)mainToken);
    }

    protected SecuritySession getSession(SoapMessage message, String sessionID) {
        SecuritySession session = null;
        session = this.sessionStore.getSession(sessionID);
        if (session == null || session.isExpired()) {
            sessionID = null;
            this.throwFault(432, "No (valid) security session found, please (re-)send full security data!");
        }
        return session;
    }

    protected void process(SoapMessage ctx, SecurityTokens mainToken) {
        HTTPAuthNTokens fromHttp;
        if (this.useHTTPBasic && (fromHttp = this.getHTTPCredentials(ctx)) != null) {
            mainToken.getContext().put(SecurityTokens.CTX_LOGIN_HTTP, fromHttp);
        }
        ConsignorAssertion cAssertion = null;
        Element uAssertion = null;
        Element samlAuthnAssertion = null;
        if (ctx.hasHeaders()) {
            List<Element> assertions = this.extractSAMLAssertions(ctx);
            if (this.useGatewayAssertions) {
                cAssertion = this.getConsignorAssertion(assertions);
            }
            uAssertion = this.getUserAssertion(assertions);
            samlAuthnAssertion = this.getSAMLAuthnAssertion(assertions);
            mainToken.getContext().put(RAW_SAML_ASSERTIONS_KEY, assertions);
        }
        if (this.samlAuthnTrustChecker != null && samlAuthnAssertion != null) {
            this.processSAMLAuthentication(samlAuthnAssertion, cAssertion, mainToken, ctx);
        } else {
            if (samlAuthnAssertion != null) {
                this.throwFault(400, "Got request with SAML Authentication assertions, but this server does not allow for SAML authentication.");
            }
            this.processConsignor(cAssertion, mainToken, ctx);
        }
        if (uAssertion != null) {
            try {
                this.processUser(uAssertion, mainToken);
            }
            catch (IOException i) {
                throw new Fault((Throwable)i);
            }
        }
        mainToken.getContext().put(SecurityTokens.CTX_SCOPE_KEY, "request");
        mainToken.getContext().put("REQUEST.soapAction", this.getSOAPAction(ctx));
    }

    protected List<Element> extractSAMLAssertions(SoapMessage message) {
        List headers = message.getHeaders();
        ArrayList<Element> assertions = new ArrayList<Element>();
        if (headers.size() == 0) {
            logger.debug("No SOAP header");
            return assertions;
        }
        Element wsSecEl = null;
        if (this.actor != null) {
            WSSecHeader utilActor = new WSSecHeader(this.actor, true);
            wsSecEl = utilActor.findWSSecElement(headers);
        }
        if (wsSecEl == null) {
            WSSecHeader utilNoActor = new WSSecHeader(true);
            wsSecEl = utilNoActor.findWSSecElement(headers);
        }
        ArrayList<Element> directAssertions = new ArrayList<Element>();
        for (Header h : headers) {
            if (!SAML2_NS.equals(h.getName().getNamespaceURI()) || !"Assertion".equals(h.getName().getLocalPart())) continue;
            directAssertions.add((Element)h.getObject());
        }
        assertions.addAll(directAssertions);
        if (wsSecEl != null) {
            assertions.addAll(DOMUtils.getChildrenWithName((Element)wsSecEl, (String)SAML2_NS, (String)"Assertion"));
            if (assertions.size() == 0) {
                logger.debug("No assertion found in the wssec:Security element");
            }
        } else {
            logger.debug("No valid WS Security element found in SOAP header");
        }
        return assertions;
    }

    protected void processUser(Element uAssertion, SecurityTokens mainToken) throws IOException {
        logger.debug("Found user assertion in request");
        UserAssertion userA = this.processUserAssertion(uAssertion);
        X509Certificate[] user = this.extractCertPath(userA);
        if (user == null) {
            String userName = userA.getSubjectName();
            mainToken.setUserName(userName);
            if (logger.isDebugEnabled()) {
                logger.debug("Requested USER (retrived as a DN): " + X500NameUtils.getReadableForm((String)userName));
            }
        } else {
            mainToken.setUser(user);
            if (logger.isDebugEnabled()) {
                logger.debug("Requested USER (retrieved as a full certificate): " + CertificateUtils.format((X509Certificate)user[0], (FormatMode)FormatMode.COMPACT_ONE_LINE));
            }
        }
        AttributeStatementType[] attributes = userA.getXMLBean().getAttributeStatementArray();
        if (attributes != null && this.userAttributeHandlers.size() > 0) {
            for (AttributeStatementType attrStatement : attributes) {
                for (AttributeType attr : attrStatement.getAttributeArray()) {
                    String nameFormat = attr.getNameFormat();
                    if ("urn:unicore:subject-role".equals(nameFormat)) continue;
                    String name = attr.getName();
                    XmlObject[] values = attr.getAttributeValueArray();
                    for (UserAttributeHandler h : this.userAttributeHandlers) {
                        h.processUserDefinedAttribute(name, nameFormat, values, mainToken);
                    }
                }
            }
        }
    }

    protected void processSAMLAuthentication(Element samlAuthnAssertion, ConsignorAssertion cAssertion, SecurityTokens mainToken, SoapMessage message) {
        String consignorDn;
        AssertionDocument assertionDoc;
        SSOAuthnAssertionValidator validator = new SSOAuthnAssertionValidator(this.samlConsumerName, this.samlConsumerEndpointUri, null, this.samlGraceTime, this.samlAuthnTrustChecker, null, SAMLBindings.OTHER);
        validator.setLaxInResponseToChecking(true);
        validator.addConsumerSamlNameAlias(this.samlConsumerEndpointUri);
        try {
            assertionDoc = AssertionDocument.Factory.parse(samlAuthnAssertion);
        }
        catch (XmlException e1) {
            Log.logException("SAML authentication assertion received in request can not be parsed", e1, logger);
            this.throwFault(400, "SAML authentication assertion received in request can not be parsed " + e1.toString());
            return;
        }
        try {
            validator.validate(assertionDoc);
        }
        catch (SAMLValidationException e1) {
            logger.warn("SAML authentication assertion received in request is not trusted: " + e1.getMessage());
            this.throwFault(400, "SAML authentication assertion received in request can not be parsed " + e1.getMessage());
        }
        SubjectType subject = assertionDoc.getAssertion().getSubject();
        NameIDType subjectName = subject.getNameID();
        if (subjectName == null) {
            this.throwFault(400, "SAML authentication for UNICORE assertion must have nameID element");
        }
        if (!"urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName".equals(subjectName.getFormat())) {
            this.throwFault(400, "SAML authentication assertion for UNICORE must have subject of urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName format, was: " + subjectName.getFormat());
        }
        if ((consignorDn = subjectName.getStringValue()) == null || consignorDn.isEmpty()) {
            this.throwFault(400, "SAML authenticated user must be non-empty");
        }
        try {
            String readableDn = X500NameUtils.getReadableForm((String)consignorDn);
            logger.debug("Using consignor info from SAML authentication assertion: " + readableDn);
        }
        catch (Exception e) {
            Log.logException("Invalid DN in SAML authn assertion", e, logger);
            this.throwFault(400, "SAML authenticated user identity is not a valid X.500 name: " + e.toString());
        }
        mainToken.setConsignorName(consignorDn);
        this.establishIP(cAssertion, mainToken, message);
    }

    protected void processConsignor(ConsignorAssertion cAssertion, SecurityTokens mainToken, SoapMessage message) {
        if (cAssertion == null && this.useGatewayAssertions) {
            logger.debug("No consignor info in request -> request didn't come through a gateway");
        }
        X509Certificate[] consignor = null;
        String clientIP = null;
        if (cAssertion != null && this.useGatewayAssertions && (consignor = this.processConsignorAssertion(cAssertion)) != null) {
            logger.debug("Using consignor info from Gateway.");
            clientIP = this.extractIPFromConsignorAssertion(cAssertion);
        }
        if (cAssertion == null && this.useSSLData) {
            consignor = this.getSSLCertPath(message);
            clientIP = this.getClientIP(message);
            if (consignor != null) {
                logger.debug("Using consignor info from SSL connection.");
            }
        }
        if (logger.isDebugEnabled() && consignor != null) {
            logger.debug("Consignor: " + X500NameUtils.getReadableForm((X500Principal)consignor[0].getSubjectX500Principal()));
        }
        if (consignor == null) {
            logger.debug("No valid Consignor info received, request is not authenticated.");
        } else {
            mainToken.setConsignor(consignor);
        }
        mainToken.setClientIP(clientIP);
    }

    protected void establishIP(ConsignorAssertion cAssertion, SecurityTokens mainToken, SoapMessage message) {
        String clientIP = null;
        if (cAssertion != null && this.useGatewayAssertions) {
            X509Certificate[] consignor = this.processConsignorAssertion(cAssertion);
            if (consignor != null) {
                logger.debug("Using consignor info from Gateway.");
                clientIP = this.extractIPFromConsignorAssertion(cAssertion);
            }
        } else {
            clientIP = this.getClientIP(message);
        }
        mainToken.setClientIP(clientIP);
    }

    protected X509Certificate[] getSSLCertPath(SoapMessage message) {
        return CXFUtils.getSSLCerts(message);
    }

    protected String getClientIP(SoapMessage message) {
        return CXFUtils.getClientIP(message);
    }

    protected String extractIPFromConsignorAssertion(ConsignorAssertion cAssertion) {
        AuthnStatementType[] authNs = cAssertion.getXMLBean().getAuthnStatementArray();
        if (authNs == null || authNs.length == 0) {
            return null;
        }
        SubjectLocalityType loc = authNs[0].getSubjectLocality();
        if (loc == null) {
            return null;
        }
        return loc.getAddress();
    }

    protected HTTPAuthNTokens getHTTPCredentials(SoapMessage message) {
        HttpServletRequest req = (HttpServletRequest)message.get((Object)"HTTP.REQUEST");
        if (req == null) {
            return null;
        }
        String aa = req.getHeader("Authorization");
        if (aa == null) {
            return null;
        }
        if (aa.length() < 7) {
            logger.warn("Ignoring too short Authorization header element in HTTP request: " + aa);
            return null;
        }
        String encoded = aa.substring(6);
        String decoded = new String(Base64.decodeBase64((byte[])encoded.getBytes()));
        String[] split = decoded.split(":");
        if (split.length > 2) {
            logger.warn("Ignoring malformed Authorization HTTP header element (to many ':' after decode: " + decoded + ")");
            return null;
        }
        if (split.length == 2) {
            return new HTTPAuthNTokens(split[0], split[1]);
        }
        if (split.length == 1) {
            return new HTTPAuthNTokens(split[0], null);
        }
        logger.warn("Ignoring malformed Authorization HTTP header element (empty string after decode)");
        return null;
    }

    protected Element getUserAssertion(List<Element> assertions) {
        for (int i = assertions.size() - 1; i >= 0; --i) {
            Element as;
            Element a = assertions.get(i);
            List ass = DOMUtils.getChildrenWithName((Element)a, (String)SAML2_NS, (String)"AttributeStatement");
            if (ass.size() == 0 || (as = (Element)ass.get(0)) == null) continue;
            List attrs = DOMUtils.getChildrenWithName((Element)as, (String)SAML2_NS, (String)"Attribute");
            for (Element attr : attrs) {
                String a1 = attr.getAttribute("Name");
                String a2 = attr.getAttribute("NameFormat");
                if (StringUtils.isEmpty((String)a1) || StringUtils.isEmpty((String)a2) || !a1.equals("USER") || !a2.equals("urn:unicore:subject-role")) continue;
                assertions.remove(i);
                return a;
            }
        }
        return null;
    }

    protected Element getSAMLAuthnAssertion(List<Element> assertions) {
        Element ret = null;
        for (int i = assertions.size() - 1; i >= 0; --i) {
            Element as;
            Element a = assertions.get(i);
            List ass = DOMUtils.getChildrenWithName((Element)a, (String)SAML2_NS, (String)"AuthnStatement");
            if (ass.size() == 0 || (as = (Element)ass.get(0)) == null) continue;
            if (ret != null) {
                this.throwFault(400, "Multiple SAML authentication assertions received, what is not supported.");
            }
            ret = a;
            assertions.remove(i);
        }
        return ret;
    }

    protected ConsignorAssertion getConsignorAssertion(List<Element> assertions) {
        if (assertions.size() == 0) {
            return null;
        }
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            CXFUtils.writeXml(assertions.get(0), os);
            AssertionDocument aDoc = AssertionDocument.Factory.parse(os.toString());
            ConsignorAssertion ca = new ConsignorAssertion(aDoc);
            assertions.remove(0);
            return ca;
        }
        catch (Exception e) {
            logger.debug("The first assertion is not a valid CONSIGNOR assertion, ignoring: " + e.getMessage());
            return null;
        }
    }

    protected X509Certificate[] processConsignorAssertion(ConsignorAssertion consignorA) {
        X509Certificate[] cert = consignorA.getConsignor();
        if (this.verifyConsignor) {
            if (!consignorA.isSigned()) {
                logger.warn("Consignor assertion is unsigned. Probably gateway is not configured properly to sign consignor assertions. Either fix gateway configuration or turn off signature checking in this server's configuration");
                return null;
            }
            ConsignorAPI engine = UnicoreSecurityFactory.getConsignorAPI();
            ValidationResult res = engine.verifyConsignorToken(consignorA, this.gatewayC);
            if (!res.isValid()) {
                String subject = cert == null || cert.length == 0 ? "null" : X500NameUtils.getReadableForm((X500Principal)cert[0].getSubjectX500Principal());
                logger.warn("Consignor assertion is invalid (probably FAKED): " + res.getInvalidResaon() + ", inserted consignor was: " + subject);
                return null;
            }
            logger.debug("Successfully verified consignor assertion.");
        }
        if (cert == null) {
            logger.debug("Anonymous CONSIGNOR");
        }
        return cert;
    }

    protected UserAssertion processUserAssertion(Element assertion) {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            DOMUtils.writeXml((Node)assertion, (OutputStream)os);
            AssertionDocument aDoc = AssertionDocument.Factory.parse(os.toString());
            UserAssertion userA = new UserAssertion(aDoc);
            return userA;
        }
        catch (Exception e) {
            logger.warn("The USER assertion is invalid, ignoring: " + e.getMessage());
            return null;
        }
    }

    protected X509Certificate[] extractCertPath(UserAssertion userA) {
        X509Certificate[] cert = userA.getSubjectFromConfirmation();
        if (cert == null) {
            logger.debug("USER retrieved, but no certificate is given.");
        }
        return cert;
    }

    protected String getSOAPAction(SoapMessage message) {
        String action = CXFUtils.getAction((Message)message);
        if (logger.isDebugEnabled() && action != null) {
            logger.debug("Setting SOAP action to '" + action + "'");
        }
        return action;
    }

    protected void throwFault(int httpErrorCode, String message) {
        logger.debug("AuthN failed: " + message);
        Fault f = new Fault((Throwable)null);
        f.setStatusCode(httpErrorCode);
        f.setMessage(message);
        throw f;
    }
}

