/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.wsutil.samlclient;

import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.unicore.samly2.assertion.AttributeAssertionParser;
import eu.unicore.samly2.elements.NameID;
import eu.unicore.samly2.elements.SAMLAttribute;
import eu.unicore.samly2.elements.Subject;
import eu.unicore.samly2.exceptions.SAMLResponderException;
import eu.unicore.samly2.exceptions.SAMLValidationException;
import eu.unicore.samly2.proto.AttributeQuery;
import eu.unicore.samly2.trust.PKISamlTrustChecker;
import eu.unicore.samly2.validators.AttributeAssertionResponseValidator;
import eu.unicore.samly2.webservice.SAMLQueryInterface;
import eu.unicore.security.wsutil.samlclient.AbstractSAMLClient;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.xml.ws.soap.SOAPFaultException;
import xmlbeans.org.oasis.saml2.assertion.AssertionDocument;
import xmlbeans.org.oasis.saml2.assertion.NameIDType;
import xmlbeans.org.oasis.saml2.protocol.AttributeQueryDocument;
import xmlbeans.org.oasis.saml2.protocol.AttributeQueryType;
import xmlbeans.org.oasis.saml2.protocol.ResponseDocument;

public class SAMLAttributeQueryClient
extends AbstractSAMLClient {
    private SAMLQueryInterface queryProxy;

    public SAMLAttributeQueryClient(String address, IClientConfiguration clientConfiguration) throws MalformedURLException {
        super(address, clientConfiguration, new PKISamlTrustChecker((X509CertChainValidator)clientConfiguration.getValidator(), true));
        this.queryProxy = this.factory.createPlainWSProxy(SAMLQueryInterface.class, address);
    }

    public AttributeAssertionParser getAssertion(NameID whose, NameID requesterSamlName) throws SAMLValidationException {
        return this.getAssertionGeneric(whose, requesterSamlName, null);
    }

    public AttributeAssertionParser getAssertion(NameID whose, NameID requesterSamlName, SAMLAttribute attribute) throws SAMLValidationException {
        return this.getAssertionGeneric(whose, requesterSamlName, Collections.singleton(attribute));
    }

    public AttributeAssertionParser getAssertion(NameID whose, NameID requesterSamlName, Set<SAMLAttribute> attributes) throws SAMLValidationException {
        return this.getAssertionGeneric(whose, requesterSamlName, attributes);
    }

    protected AttributeAssertionParser getAssertionGeneric(NameID whose, NameID requesterSamlName, Set<SAMLAttribute> attributes) throws SAMLValidationException {
        AttributeQuery attrQuery = this.createQuery(whose, requesterSamlName);
        if (attributes != null && attributes.size() > 0) {
            attrQuery.setAttributes(attributes.toArray(new SAMLAttribute[attributes.size()]));
        }
        return this.performSAMLQuery(attrQuery);
    }

    protected AttributeAssertionParser performSAMLQuery(AttributeQuery attrQuery) throws SAMLValidationException {
        ResponseDocument xmlRespDoc;
        try {
            xmlRespDoc = this.queryProxy.attributeQuery((AttributeQueryDocument)attrQuery.getXMLBeanDoc());
        }
        catch (SOAPFaultException e) {
            throw new SAMLResponderException("SAML service invocation failed: " + e.getMessage(), (Throwable)e);
        }
        AttributeAssertionResponseValidator validator = new AttributeAssertionResponseValidator(null, null, null, 180000L, this.trustChecker, ((AttributeQueryType)attrQuery.getXMLBean()).getSubject().getNameID());
        validator.validate(xmlRespDoc);
        List<AssertionDocument> assertions = validator.getAttributeAssertions();
        if (assertions.size() == 0) {
            return null;
        }
        if (assertions.size() > 1) {
            throw new SAMLValidationException("More than one assertion was returned. It is OK,however this implementation supports only responses with a single assertion.");
        }
        AssertionDocument assertion = assertions.get(0);
        return new AttributeAssertionParser(assertion);
    }

    protected AttributeQuery createQuery(NameID whose, NameID requesterSamlName) throws SAMLValidationException {
        NameIDType subjectN = whose.getXBean();
        Subject subject = new Subject(subjectN.getStringValue(), subjectN.getFormat());
        if (requesterSamlName == null) {
            requesterSamlName = this.getLocalIssuer();
        }
        if (requesterSamlName == null) {
            throw new SAMLValidationException("No SAML issuer was given and it is not possible to generate one as local credential is missing.");
        }
        return new AttributeQuery(requesterSamlName.getXBean(), subject.getXBean());
    }
}

