/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.impl.watcher;

import org.apache.airavata.gfac.core.GFacException;
import org.apache.airavata.gfac.core.context.ProcessContext;
import org.apache.airavata.gfac.core.watcher.CancelRequestWatcher;
import org.apache.airavata.gfac.impl.Factory;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.CuratorWatcher;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CancelRequestWatcherImpl
implements CancelRequestWatcher {
    private static final Logger log = LoggerFactory.getLogger(CancelRequestWatcherImpl.class);
    private final String processId;
    private final String experimentId;
    private final int max_retry = 3;

    public CancelRequestWatcherImpl(String experimentId, String processId) {
        this.experimentId = experimentId;
        this.processId = processId;
    }

    public void process(WatchedEvent watchedEvent) throws Exception {
        String path = watchedEvent.getPath();
        Watcher.Event.EventType type = watchedEvent.getType();
        CuratorFramework curatorClient = Factory.getCuratorClient();
        log.info("cancel watcher triggered process id {}.", (Object)this.processId);
        switch (type) {
            case NodeDataChanged: {
                byte[] bytes = (byte[])curatorClient.getData().forPath(path);
                String action = new String(bytes);
                if (action.equalsIgnoreCase("CANCEL_REQUEST")) {
                    this.cancelProcess(0);
                    break;
                }
                ((BackgroundPathable)curatorClient.getData().usingWatcher((CuratorWatcher)this)).forPath(path);
                break;
            }
            case NodeDeleted: {
                log.info("expId: {}, cancel watcher trigger for process {} with event type {}", new Object[]{this.experimentId, this.processId, type.name()});
                break;
            }
            case NodeCreated: 
            case NodeChildrenChanged: 
            case None: {
                log.info("expId: {}, Cancel watcher trigger for process {} with event type {}", new Object[]{this.experimentId, this.processId, type.name()});
                if (path == null) break;
                ((BackgroundPathable)curatorClient.getData().usingWatcher((CuratorWatcher)this)).forPath(path);
                break;
            }
            default: {
                log.info("expId: {}, Cancel watcher trigger for process {} with event type {}", new Object[]{this.experimentId, this.processId, type.name()});
                if (path == null) break;
                ((BackgroundPathable)curatorClient.getData().usingWatcher((CuratorWatcher)this)).forPath(path);
            }
        }
    }

    private void cancelProcess(int retryAttempt) throws GFacException {
        ProcessContext processContext = Factory.getGfacContext().getProcess(this.processId);
        if (processContext != null) {
            processContext.setCancel(true);
            log.info("expId {}, processId : {}, Cancelling process", (Object)this.experimentId, (Object)this.processId);
            Factory.getGFacEngine().cancelProcess(processContext);
        } else if (retryAttempt < 3) {
            log.info("expId: {}, Cancel request came for processId {} but couldn't find process context. retry in {} s ", new Object[]{this.experimentId, this.processId, retryAttempt * 3});
            try {
                Thread.sleep(retryAttempt++ * 3000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.cancelProcess(retryAttempt);
        } else {
            log.info("expId: {}, Cancel request came for processId {} but couldn't find process context.", (Object)this.experimentId, (Object)this.processId);
        }
    }
}

