/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.monitor.email.parser;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Message;
import javax.mail.MessagingException;
import org.apache.airavata.common.exception.AiravataException;
import org.apache.airavata.gfac.core.monitor.EmailParser;
import org.apache.airavata.gfac.core.monitor.JobStatusResult;
import org.apache.airavata.model.status.JobState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UGEEmailParser
implements EmailParser {
    private static final Logger log = LoggerFactory.getLogger(UGEEmailParser.class);
    private static final String REGEX = "[\\w]*[ ]*(?<jobId>[\\d]*)[ ]*\\((?<jobName>[a-zA-Z0-9]*)\\)[ ]*(?<status>[a-zA-Z]*)";
    public static final String STARTED = "Started";
    public static final String COMPLETE = "Complete";
    public static final String FAILED = "Failed";
    public static final String KILLED = "Killed";
    private static final String REGEX_EXIT_STATUS = "Exit Status[ ]*=[ ]*(?<exitStatus>[\\d]+)";
    public static final String ABORTED = "Aborted";

    public JobStatusResult parseEmail(Message message) throws MessagingException, AiravataException {
        JobStatusResult jobStatusResult = new JobStatusResult();
        this.parseContent(message, jobStatusResult);
        return jobStatusResult;
    }

    private void parseContent(Message message, JobStatusResult jobStatusResult) throws MessagingException, AiravataException {
        String subject = message.getSubject();
        subject = subject.replace("Set in error state", FAILED);
        Pattern pattern = Pattern.compile(REGEX);
        Matcher matcher = pattern.matcher(subject);
        try {
            if (matcher.find()) {
                jobStatusResult.setJobId(matcher.group("jobId"));
                jobStatusResult.setJobName(matcher.group("jobName"));
                String content = (String)message.getContent();
                jobStatusResult.setState(this.getJobState(matcher.group("status"), content));
            } else {
                log.error("[EJM]: No matched found for subject => \n" + subject);
            }
        }
        catch (IOException e) {
            throw new AiravataException("[EJM]: Error while reading content of the email message");
        }
    }

    private JobState getJobState(String status, String content) {
        switch (status) {
            case "Started": {
                return JobState.ACTIVE;
            }
            case "Complete": {
                int exitStatus = this.getExitStatus(content);
                if (exitStatus == 0) {
                    return JobState.COMPLETE;
                }
                log.info("[EJM]: Job returns with Exit Status = " + exitStatus + "  , Marked as Failed");
                return JobState.FAILED;
            }
            case "Failed": {
                return JobState.FAILED;
            }
            case "Aborted": {
                return JobState.CANCELED;
            }
        }
        return JobState.UNKNOWN;
    }

    private int getExitStatus(String content) {
        String group;
        Pattern statusPattern = Pattern.compile(REGEX_EXIT_STATUS);
        Matcher statusMatcher = statusPattern.matcher(content);
        if (statusMatcher.find() && (group = statusMatcher.group("exitStatus")) != null && !group.trim().isEmpty()) {
            return Integer.valueOf(group.trim());
        }
        return -1;
    }
}

