/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.utils.CarbonUtils;

public class AuthenticatorsConfiguration {
    private static Log log = LogFactory.getLog(AuthenticatorsConfiguration.class);
    private static final String AUTHENTICATORS_FILE_NAME = "authenticators.xml";
    private static final String ELEM_AUTHENTICATOR = "Authenticator";
    private static final String ELEM_PRIORITY = "Priority";
    private static final String ELEM_CONFIG = "Config";
    private static final String ELEM_PARAMETER = "Parameter";
    private static final String ELEM_SKIP_AUTHENTICATION = "SkipAuthentication";
    private static final String ELEM_SKIP_SESSION_VALIDATION = "SkipSessionValidation";
    private static final String ELEM_URL_CONTAINS = "UrlContains";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_DISABLED = "disabled";
    private static AuthenticatorsConfiguration instance = new AuthenticatorsConfiguration();
    private Map<String, AuthenticatorConfig> authenticatorConfigMap = new Hashtable<String, AuthenticatorConfig>();

    public static AuthenticatorsConfiguration getInstance() {
        return instance;
    }

    private AuthenticatorsConfiguration() {
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        String authenticatorsFilePath = CarbonUtils.getCarbonConfigDirPath() + File.separator + "security" + File.separator + AUTHENTICATORS_FILE_NAME;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(new File(authenticatorsFilePath));
            OMElement documentElement = new StAXOMBuilder((InputStream)fileInputStream).getDocumentElement();
            Iterator authenticatorElements = documentElement.getChildrenWithLocalName(ELEM_AUTHENTICATOR);
            while (authenticatorElements.hasNext()) {
                AuthenticatorConfig authenticatorConfig = this.processAuthenticatorElement((OMElement)authenticatorElements.next());
                if (authenticatorConfig == null) continue;
                this.authenticatorConfigMap.put(authenticatorConfig.getName(), authenticatorConfig);
            }
        }
        catch (FileNotFoundException e) {
            log.error((Object)"authenticators.xml file is not available. Carbon Server is starting with thedefault authenticators");
        }
        catch (XMLStreamException e) {
            log.error((Object)"Error reading the authenticators.xml. Carbon Server is starting with the defaultauthenticators.");
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException e) {
                log.warn((Object)"Unable to close the file input stream created for authenticators.xml");
            }
        }
    }

    private AuthenticatorConfig processAuthenticatorElement(OMElement authenticatorElem) {
        OMElement urlElement;
        Iterator paramIterator;
        OMElement configElement;
        OMAttribute nameAttr = authenticatorElem.getAttribute(new QName(ATTR_NAME));
        if (nameAttr == null) {
            log.warn((Object)"Each Authenticator Configuration should have a unique name attribute. +This Authenticator will not be registered.");
            return null;
        }
        String authenticatorName = nameAttr.getAttributeValue();
        boolean disabled = false;
        if (authenticatorElem.getAttribute(new QName(ATTR_DISABLED)) != null) {
            disabled = Boolean.parseBoolean(authenticatorElem.getAttribute(new QName(ATTR_DISABLED)).getAttributeValue());
        }
        int priority = 0;
        Iterator priorityElemItr = authenticatorElem.getChildrenWithLocalName(ELEM_PRIORITY);
        while (priorityElemItr.hasNext()) {
            priority = Integer.parseInt(((OMElement)priorityElemItr.next()).getText());
        }
        Hashtable<String, String> parameterMap = new Hashtable<String, String>();
        Iterator configElemItr = authenticatorElem.getChildrenWithLocalName(ELEM_CONFIG);
        while (configElemItr.hasNext()) {
            OMElement configElement2 = (OMElement)configElemItr.next();
            Iterator paramIterator2 = configElement2.getChildrenWithLocalName(ELEM_PARAMETER);
            while (paramIterator2.hasNext()) {
                OMElement paramElem = (OMElement)paramIterator2.next();
                OMAttribute paramNameAttr = paramElem.getAttribute(new QName(ATTR_NAME));
                if (paramNameAttr == null) {
                    log.warn((Object)"An Authenticator Parameter should have a name attribute. Skipping the parameter.");
                    continue;
                }
                parameterMap.put(paramNameAttr.getAttributeValue(), paramElem.getText());
            }
        }
        AuthenticatorConfig authenticatorConfig = new AuthenticatorConfig(authenticatorName, priority, disabled, parameterMap);
        Iterator configElemItr2 = authenticatorElem.getChildrenWithLocalName(ELEM_SKIP_AUTHENTICATION);
        while (configElemItr2.hasNext()) {
            configElement = (OMElement)configElemItr2.next();
            paramIterator = configElement.getChildrenWithLocalName(ELEM_URL_CONTAINS);
            while (paramIterator.hasNext()) {
                urlElement = (OMElement)paramIterator.next();
                if (urlElement.getText() == null || urlElement.getText().isEmpty()) continue;
                authenticatorConfig.addAuthenticationSkippingUrl(urlElement.getText().trim());
            }
        }
        configElemItr2 = authenticatorElem.getChildrenWithLocalName(ELEM_SKIP_SESSION_VALIDATION);
        while (configElemItr2.hasNext()) {
            configElement = (OMElement)configElemItr2.next();
            paramIterator = configElement.getChildrenWithLocalName(ELEM_URL_CONTAINS);
            while (paramIterator.hasNext()) {
                urlElement = (OMElement)paramIterator.next();
                if (urlElement.getText() == null || urlElement.getText().isEmpty()) continue;
                authenticatorConfig.addSessionValidationSkippingUrl(urlElement.getText().trim());
            }
        }
        return authenticatorConfig;
    }

    public AuthenticatorConfig getAuthenticatorConfig(String authenticatorName) {
        return this.authenticatorConfigMap.get(authenticatorName);
    }

    public static class AuthenticatorConfig {
        private String name;
        private int priority;
        private boolean disabled;
        private Map<String, String> parameters = new Hashtable<String, String>();
        private List<String> authenticationSkippingUrls = new ArrayList<String>();
        private List<String> sessionValidationSkippingUrls = new ArrayList<String>();

        private AuthenticatorConfig(String name, int priority, boolean disabled, Map<String, String> params) {
            this.name = name;
            this.priority = priority;
            this.disabled = disabled;
            this.parameters = params;
        }

        public String getName() {
            return this.name;
        }

        public int getPriority() {
            return this.priority;
        }

        public boolean isDisabled() {
            return this.disabled;
        }

        public Map<String, String> getParameters() {
            return this.parameters;
        }

        public void addAuthenticationSkippingUrl(String url) {
            this.authenticationSkippingUrls.add(url);
        }

        public void addSessionValidationSkippingUrl(String url) {
            this.sessionValidationSkippingUrls.add(url);
        }

        public List<String> getAuthenticationSkippingUrls() {
            return Collections.unmodifiableList(this.authenticationSkippingUrls);
        }

        public List<String> getSessionValidationSkippingUrls() {
            return Collections.unmodifiableList(this.sessionValidationSkippingUrls);
        }
    }
}

