/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.util.json.JSONWriter;
import java.nio.ByteBuffer;
import java.util.Map;

public class AttributeValueJsonMarshaller {
    private static AttributeValueJsonMarshaller instance;

    public void marshall(AttributeValue attributeValue, JSONWriter jsonWriter) {
        if (attributeValue == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            ListWithAutoConstructFlag lList;
            ListWithAutoConstructFlag bSList;
            ListWithAutoConstructFlag nSList;
            ListWithAutoConstructFlag sSList;
            jsonWriter.object();
            if (attributeValue.getS() != null) {
                jsonWriter.key("S").value((Object)attributeValue.getS());
            }
            if (attributeValue.getN() != null) {
                jsonWriter.key("N").value((Object)attributeValue.getN());
            }
            if (attributeValue.getB() != null) {
                jsonWriter.key("B").value(attributeValue.getB());
            }
            if (!((sSList = (ListWithAutoConstructFlag)attributeValue.getSS()) == null || sSList.isAutoConstruct() && sSList.isEmpty())) {
                jsonWriter.key("SS");
                jsonWriter.array();
                for (String sSListValue : sSList) {
                    if (sSListValue == null) continue;
                    jsonWriter.value((Object)sSListValue);
                }
                jsonWriter.endArray();
            }
            if (!((nSList = (ListWithAutoConstructFlag)attributeValue.getNS()) == null || nSList.isAutoConstruct() && nSList.isEmpty())) {
                jsonWriter.key("NS");
                jsonWriter.array();
                for (String nSListValue : nSList) {
                    if (nSListValue == null) continue;
                    jsonWriter.value((Object)nSListValue);
                }
                jsonWriter.endArray();
            }
            if (!((bSList = (ListWithAutoConstructFlag)attributeValue.getBS()) == null || bSList.isAutoConstruct() && bSList.isEmpty())) {
                jsonWriter.key("BS");
                jsonWriter.array();
                for (ByteBuffer bSListValue : bSList) {
                    if (bSListValue == null) continue;
                    jsonWriter.value(bSListValue);
                }
                jsonWriter.endArray();
            }
            if (attributeValue.getM() != null) {
                jsonWriter.key("M");
                jsonWriter.object();
                for (Map.Entry<String, AttributeValue> mListValue : attributeValue.getM().entrySet()) {
                    if (mListValue.getValue() == null) continue;
                    jsonWriter.key(mListValue.getKey());
                    AttributeValueJsonMarshaller.getInstance().marshall(mListValue.getValue(), jsonWriter);
                }
                jsonWriter.endObject();
            }
            if (!((lList = (ListWithAutoConstructFlag)attributeValue.getL()) == null || lList.isAutoConstruct() && lList.isEmpty())) {
                jsonWriter.key("L");
                jsonWriter.array();
                for (AttributeValue lListValue : lList) {
                    if (lListValue == null) continue;
                    AttributeValueJsonMarshaller.getInstance().marshall(lListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (attributeValue.isNULL() != null) {
                jsonWriter.key("NULL").value((Object)attributeValue.isNULL());
            }
            if (attributeValue.isBOOL() != null) {
                jsonWriter.key("BOOL").value((Object)attributeValue.isBOOL());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static AttributeValueJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new AttributeValueJsonMarshaller();
        }
        return instance;
    }
}

