/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.app.catalog.resources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.registry.core.app.catalog.model.AppOutput_PK;
import org.apache.airavata.registry.core.app.catalog.model.ApplicationIntOutput;
import org.apache.airavata.registry.core.app.catalog.model.ApplicationInterface;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatAbstractResource;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatalogResource;
import org.apache.airavata.registry.core.app.catalog.resources.AppInterfaceResource;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogJPAUtils;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogQueryGenerator;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogResourceType;
import org.apache.airavata.registry.cpi.AppCatalogException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationOutputResource
extends AppCatAbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationOutputResource.class);
    private String interfaceID;
    private String outputKey;
    private String outputVal;
    private String dataType;
    private boolean isRequired;
    private boolean dataMovement;
    private String dataNameLocation;
    private boolean requiredToCMD;
    private String searchQuery;
    private String appArgument;
    private boolean outputStreaming;
    private AppInterfaceResource appInterfaceResource;

    @Override
    public void remove(Object identifier) throws AppCatalogException {
        if (!(identifier instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new AppCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)identifier;
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("ApplicationIntOutput", new Object[0][]);
            generator.setParameter("interfaceID", ids.get("interfaceID"));
            if (ids.get("outputKey") != null) {
                generator.setParameter("outputKey", ids.get("outputKey"));
            }
            Query q = generator.deleteQuery(em);
            q.executeUpdate();
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public AppCatalogResource get(Object identifier) throws AppCatalogException {
        if (!(identifier instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new AppCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)identifier;
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("ApplicationIntOutput", new Object[0][]);
            generator.setParameter("interfaceID", ids.get("interfaceID"));
            generator.setParameter("outputKey", ids.get("outputKey"));
            Query q = generator.selectQuery(em);
            ApplicationIntOutput applicationOutput = (ApplicationIntOutput)q.getSingleResult();
            ApplicationOutputResource applicationOutputResource = (ApplicationOutputResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.APPLICATION_OUTPUT, applicationOutput);
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            ApplicationOutputResource applicationOutputResource2 = applicationOutputResource;
            return applicationOutputResource2;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public List<AppCatalogResource> get(String fieldName, Object value) throws AppCatalogException {
        ArrayList<AppCatalogResource> appInputResources = new ArrayList<AppCatalogResource>();
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("ApplicationIntOutput", new Object[0][]);
            if (fieldName.equals("interfaceID")) {
                generator.setParameter("interfaceID", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        ApplicationIntOutput applicationOutput = (ApplicationIntOutput)result;
                        ApplicationOutputResource applicationOutputResource = (ApplicationOutputResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.APPLICATION_OUTPUT, applicationOutput);
                        appInputResources.add(applicationOutputResource);
                    }
                }
            } else if (fieldName.equals("outputKey")) {
                generator.setParameter("outputKey", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        ApplicationIntOutput applicationOutput = (ApplicationIntOutput)result;
                        ApplicationOutputResource applicationOutputResource = (ApplicationOutputResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.APPLICATION_OUTPUT, applicationOutput);
                        appInputResources.add(applicationOutputResource);
                    }
                }
            } else if (fieldName.equals("dataType")) {
                generator.setParameter("dataType", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        ApplicationIntOutput applicationOutput = (ApplicationIntOutput)result;
                        ApplicationOutputResource applicationOutputResource = (ApplicationOutputResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.APPLICATION_OUTPUT, applicationOutput);
                        appInputResources.add(applicationOutputResource);
                    }
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for App Output Resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for App Output Resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return appInputResources;
    }

    @Override
    public List<AppCatalogResource> getAll() throws AppCatalogException {
        return null;
    }

    @Override
    public List<String> getAllIds() throws AppCatalogException {
        return null;
    }

    @Override
    public List<String> getIds(String fieldName, Object value) throws AppCatalogException {
        ArrayList<String> appOutputResourceIDs = new ArrayList<String>();
        EntityManager em = null;
        try {
            ApplicationIntOutput applicationOutput;
            List results;
            Query q;
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("ApplicationIntOutput", new Object[0][]);
            if (fieldName.equals("interfaceID")) {
                generator.setParameter("interfaceID", value);
                q = generator.selectQuery(em);
                results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        applicationOutput = (ApplicationIntOutput)result;
                        appOutputResourceIDs.add(applicationOutput.getInterfaceID());
                    }
                }
            }
            if (fieldName.equals("outputKey")) {
                generator.setParameter("outputKey", value);
                q = generator.selectQuery(em);
                results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        applicationOutput = (ApplicationIntOutput)result;
                        appOutputResourceIDs.add(applicationOutput.getInterfaceID());
                    }
                }
            } else if (fieldName.equals("dataType")) {
                generator.setParameter("dataType", value);
                q = generator.selectQuery(em);
                results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        applicationOutput = (ApplicationIntOutput)result;
                        appOutputResourceIDs.add(applicationOutput.getInterfaceID());
                    }
                }
            } else {
                em.getTransaction().commit();
                em.close();
                logger.error("Unsupported field name for App Output resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for App Output Resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return appOutputResourceIDs;
    }

    @Override
    public void save() throws AppCatalogException {
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            ApplicationIntOutput existingApplicationOutput = (ApplicationIntOutput)em.find(ApplicationIntOutput.class, (Object)new AppOutput_PK(this.interfaceID, this.outputKey));
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            ApplicationIntOutput applicationOutput = existingApplicationOutput == null ? new ApplicationIntOutput() : existingApplicationOutput;
            ApplicationInterface applicationInterface = (ApplicationInterface)em.find(ApplicationInterface.class, (Object)this.interfaceID);
            applicationOutput.setApplicationInterface(applicationInterface);
            applicationOutput.setInterfaceID(applicationInterface.getInterfaceID());
            applicationOutput.setDataType(this.dataType);
            applicationOutput.setOutputKey(this.outputKey);
            applicationOutput.setOutputVal(this.outputVal);
            applicationOutput.setRequired(this.isRequired);
            applicationOutput.setRequiredToCMD(this.requiredToCMD);
            applicationOutput.setDataMovement(this.dataMovement);
            applicationOutput.setDataNameLocation(this.dataNameLocation);
            applicationOutput.setSearchQuery(this.searchQuery);
            applicationOutput.setApplicationArgument(this.appArgument);
            applicationOutput.setOutputStreaming(this.outputStreaming);
            em.merge((Object)applicationOutput);
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public boolean isExists(Object identifier) throws AppCatalogException {
        if (!(identifier instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new AppCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)identifier;
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            ApplicationIntOutput applicationOutput = (ApplicationIntOutput)em.find(ApplicationIntOutput.class, (Object)new AppOutput_PK((String)ids.get("interfaceID"), (String)ids.get("outputKey")));
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            boolean bl = applicationOutput != null;
            return bl;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public String getInterfaceID() {
        return this.interfaceID;
    }

    public void setInterfaceID(String interfaceID) {
        this.interfaceID = interfaceID;
    }

    public String getOutputKey() {
        return this.outputKey;
    }

    public void setOutputKey(String outputKey) {
        this.outputKey = outputKey;
    }

    public String getOutputVal() {
        return this.outputVal;
    }

    public void setOutputVal(String outputVal) {
        this.outputVal = outputVal;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public AppInterfaceResource getAppInterfaceResource() {
        return this.appInterfaceResource;
    }

    public void setAppInterfaceResource(AppInterfaceResource appInterfaceResource) {
        this.appInterfaceResource = appInterfaceResource;
    }

    public boolean getRequired() {
        return this.isRequired;
    }

    public void setRequired(boolean required) {
        this.isRequired = required;
    }

    public boolean isDataMovement() {
        return this.dataMovement;
    }

    public void setDataMovement(boolean dataMovement) {
        this.dataMovement = dataMovement;
    }

    public String getDataNameLocation() {
        return this.dataNameLocation;
    }

    public void setDataNameLocation(String dataNameLocation) {
        this.dataNameLocation = dataNameLocation;
    }

    public boolean getRequiredToCMD() {
        return this.requiredToCMD;
    }

    public void setRequiredToCMD(boolean requiredToCMD) {
        this.requiredToCMD = requiredToCMD;
    }

    public String getSearchQuery() {
        return this.searchQuery;
    }

    public void setSearchQuery(String searchQuery) {
        this.searchQuery = searchQuery;
    }

    public String getAppArgument() {
        return this.appArgument;
    }

    public void setAppArgument(String appArgument) {
        this.appArgument = appArgument;
    }

    public boolean isOutputStreaming() {
        return this.outputStreaming;
    }

    public void setOutputStreaming(boolean outputStreaming) {
        this.outputStreaming = outputStreaming;
    }
}

