/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.app.catalog.resources;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.AiravataUtils;
import org.apache.airavata.registry.core.app.catalog.model.ComputeResource;
import org.apache.airavata.registry.core.app.catalog.model.DataMovementInterface;
import org.apache.airavata.registry.core.app.catalog.model.DataMovementInterface_PK;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatAbstractResource;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatalogResource;
import org.apache.airavata.registry.core.app.catalog.resources.ComputeResourceResource;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogJPAUtils;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogQueryGenerator;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogResourceType;
import org.apache.airavata.registry.cpi.AppCatalogException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataMovementInterfaceResource
extends AppCatAbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(DataMovementInterfaceResource.class);
    private String computeResourceId;
    private ComputeResourceResource computeHostResource;
    private String dataMovementProtocol;
    private String dataMovementInterfaceId;
    private int priorityOrder;
    private Timestamp createdTime;
    private Timestamp updatedTime;

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(Timestamp createdTime) {
        this.createdTime = createdTime;
    }

    public Timestamp getUpdatedTime() {
        return this.updatedTime;
    }

    public void setUpdatedTime(Timestamp updatedTime) {
        this.updatedTime = updatedTime;
    }

    @Override
    public void remove(Object identifier) throws AppCatalogException {
        if (!(identifier instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new AppCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)identifier;
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("DataMovementInterface", new Object[0][]);
            generator.setParameter("computeResourceId", ids.get("computeResourceId"));
            generator.setParameter("dataMovementInterfaceId", ids.get("dataMovementInterfaceId"));
            Query q = generator.deleteQuery(em);
            q.executeUpdate();
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public AppCatalogResource get(Object identifier) throws AppCatalogException {
        if (!(identifier instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new AppCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)identifier;
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("DataMovementInterface", new Object[0][]);
            generator.setParameter("computeResourceId", ids.get("computeResourceId"));
            generator.setParameter("dataMovementInterfaceId", ids.get("dataMovementInterfaceId"));
            Query q = generator.selectQuery(em);
            DataMovementInterface dataMovementInterface = (DataMovementInterface)q.getSingleResult();
            DataMovementInterfaceResource dataMovementInterfaceResource = (DataMovementInterfaceResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.DATA_MOVEMENT_INTERFACE, dataMovementInterface);
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            DataMovementInterfaceResource dataMovementInterfaceResource2 = dataMovementInterfaceResource;
            return dataMovementInterfaceResource2;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public List<AppCatalogResource> get(String fieldName, Object value) throws AppCatalogException {
        ArrayList<AppCatalogResource> dataMovementInterfaceResources = new ArrayList<AppCatalogResource>();
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("DataMovementInterface", new Object[0][]);
            if (fieldName.equals("computeResourceId") || fieldName.equals("dataMovementProtocol") || fieldName.equals("dataMovementInterfaceId") || fieldName.equals("priorityOrder")) {
                generator.setParameter(fieldName, value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                for (Object result : results) {
                    DataMovementInterface dataMovementInterface = (DataMovementInterface)result;
                    DataMovementInterfaceResource dataMovementInterfaceResource = (DataMovementInterfaceResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.DATA_MOVEMENT_INTERFACE, dataMovementInterface);
                    dataMovementInterfaceResources.add(dataMovementInterfaceResource);
                }
            } else {
                em.getTransaction().commit();
                em.close();
                logger.error("Unsupported field name for Data Movement Interface Resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for Data Movement Interface Resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return dataMovementInterfaceResources;
    }

    @Override
    public List<AppCatalogResource> getAll() throws AppCatalogException {
        return null;
    }

    @Override
    public List<String> getAllIds() throws AppCatalogException {
        return null;
    }

    @Override
    public List<String> getIds(String fieldName, Object value) throws AppCatalogException {
        ArrayList<String> dataMovementInterfaceResourceIDs = new ArrayList<String>();
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("DataMovementInterface", new Object[0][]);
            if (fieldName.equals("computeResourceId") || fieldName.equals("dataMovementProtocol") || fieldName.equals("dataMovementInterfaceId") || fieldName.equals("priorityOrder")) {
                generator.setParameter(fieldName, value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                for (Object result : results) {
                    DataMovementInterface dataMovementInterface = (DataMovementInterface)result;
                    DataMovementInterfaceResource dataMovementInterfaceResource = (DataMovementInterfaceResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.DATA_MOVEMENT_INTERFACE, dataMovementInterface);
                    dataMovementInterfaceResourceIDs.add(dataMovementInterfaceResource.getComputeResourceId());
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for Data Movement Interface Resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for Data Movement Interface Resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return dataMovementInterfaceResourceIDs;
    }

    @Override
    public void save() throws AppCatalogException {
        EntityManager em = null;
        try {
            DataMovementInterface dataMovementInterface;
            em = AppCatalogJPAUtils.getEntityManager();
            DataMovementInterface existingDataMovementInterface = (DataMovementInterface)em.find(DataMovementInterface.class, (Object)new DataMovementInterface_PK(this.computeResourceId, this.dataMovementInterfaceId));
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            if (existingDataMovementInterface == null) {
                dataMovementInterface = new DataMovementInterface();
                dataMovementInterface.setCreationTime(AiravataUtils.getCurrentTimestamp());
            } else {
                dataMovementInterface = existingDataMovementInterface;
                dataMovementInterface.setUpdateTime(AiravataUtils.getCurrentTimestamp());
            }
            dataMovementInterface.setComputeResourceId(this.getComputeResourceId());
            ComputeResource computeResource = (ComputeResource)em.find(ComputeResource.class, (Object)this.getComputeResourceId());
            dataMovementInterface.setComputeResource(computeResource);
            dataMovementInterface.setDataMovementProtocol(this.getDataMovementProtocol());
            dataMovementInterface.setDataMovementInterfaceId(this.getDataMovementInterfaceId());
            dataMovementInterface.setPriorityOrder(this.getPriorityOrder());
            if (existingDataMovementInterface == null) {
                em.persist((Object)dataMovementInterface);
            } else {
                em.merge((Object)dataMovementInterface);
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public boolean isExists(Object identifier) throws AppCatalogException {
        if (!(identifier instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new AppCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)identifier;
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            DataMovementInterface dataMovementInterface = (DataMovementInterface)em.find(DataMovementInterface.class, (Object)new DataMovementInterface_PK((String)ids.get("computeResourceId"), (String)ids.get("dataMovementInterfaceId")));
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            boolean bl = dataMovementInterface != null;
            return bl;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public String getComputeResourceId() {
        return this.computeResourceId;
    }

    public ComputeResourceResource getComputeHostResource() {
        return this.computeHostResource;
    }

    public String getDataMovementProtocol() {
        return this.dataMovementProtocol;
    }

    public String getDataMovementInterfaceId() {
        return this.dataMovementInterfaceId;
    }

    public int getPriorityOrder() {
        return this.priorityOrder;
    }

    public void setComputeResourceId(String computeResourceId) {
        this.computeResourceId = computeResourceId;
    }

    public void setComputeHostResource(ComputeResourceResource computeHostResource) {
        this.computeHostResource = computeHostResource;
    }

    public void setDataMovementProtocol(String dataMovementProtocol) {
        this.dataMovementProtocol = dataMovementProtocol;
    }

    public void setDataMovementInterfaceId(String dataMovementInterfaceId) {
        this.dataMovementInterfaceId = dataMovementInterfaceId;
    }

    public void setPriorityOrder(int priorityOrder) {
        this.priorityOrder = priorityOrder;
    }
}

