/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.replica.catalog.model;

import java.sql.Timestamp;
import java.util.Collection;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.apache.airavata.registry.core.replica.catalog.model.DataProduct;
import org.apache.airavata.registry.core.replica.catalog.model.DataReplicaMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Table(name="DATA_REPLICA_LOCATION")
public class DataReplicaLocation {
    private static final Logger logger = LoggerFactory.getLogger(DataReplicaLocation.class);
    private String replicaId;
    private String productUri;
    private String replicaName;
    private String replicaDescription;
    private String storageResourceId;
    private String filePath;
    private String replicaLocationCategory;
    private String replicaPersistentType;
    private Timestamp creationTime;
    private Timestamp lastModifiedTime;
    private Timestamp validUntilTime;
    private DataProduct dataProduct;
    private Collection<DataReplicaMetaData> dataReplicaMetaData;

    @Id
    @Column(name="REPLICA_ID")
    public String getReplicaId() {
        return this.replicaId;
    }

    public void setReplicaId(String replicaId) {
        this.replicaId = replicaId;
    }

    @Column(name="PRODUCT_URI")
    public String getProductUri() {
        return this.productUri;
    }

    public void setProductUri(String productUri) {
        this.productUri = productUri;
    }

    @Column(name="REPLICA_NAME")
    public String getReplicaName() {
        return this.replicaName;
    }

    public void setReplicaName(String replicaName) {
        this.replicaName = replicaName;
    }

    @Column(name="REPLICA_DESCRIPTION")
    public String getReplicaDescription() {
        return this.replicaDescription;
    }

    public void setReplicaDescription(String replicaDescription) {
        this.replicaDescription = replicaDescription;
    }

    @Column(name="STORAGE_RESOURCE_ID")
    public String getStorageResourceId() {
        return this.storageResourceId;
    }

    public void setStorageResourceId(String storageResourceId) {
        this.storageResourceId = storageResourceId;
    }

    @Column(name="FILE_PATH")
    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    @Column(name="CREATION_TIME")
    public Timestamp getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Timestamp creationTime) {
        this.creationTime = creationTime;
    }

    @Column(name="LAST_MODIFIED_TIME")
    public Timestamp getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public void setLastModifiedTime(Timestamp lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    @Column(name="VALID_UNTIL_TIME")
    public Timestamp getValidUntilTime() {
        return this.validUntilTime;
    }

    public void setValidUntilTime(Timestamp validUntilTime) {
        this.validUntilTime = validUntilTime;
    }

    @Column(name="REPLICA_LOCATION_CATEGORY")
    public String getReplicaLocationCategory() {
        return this.replicaLocationCategory;
    }

    public void setReplicaLocationCategory(String replicaLocationCategory) {
        this.replicaLocationCategory = replicaLocationCategory;
    }

    @Column(name="REPLICA_PERSISTENT_TYPE")
    public String getReplicaPersistentType() {
        return this.replicaPersistentType;
    }

    public void setReplicaPersistentType(String replicaPersistentType) {
        this.replicaPersistentType = replicaPersistentType;
    }

    @ManyToOne
    @JoinColumn(name="PRODUCT_URI", referencedColumnName="PRODUCT_URI")
    public DataProduct getDataProduct() {
        return this.dataProduct;
    }

    public void setDataProduct(DataProduct dataProduct) {
        this.dataProduct = dataProduct;
    }

    @OneToMany(mappedBy="dataReplicaLocation", cascade={CascadeType.ALL})
    public Collection<DataReplicaMetaData> getDataReplicaMetaData() {
        return this.dataReplicaMetaData;
    }

    public void setDataReplicaMetaData(Collection<DataReplicaMetaData> dataReplicaMetaData) {
        this.dataReplicaMetaData = dataReplicaMetaData;
    }
}

