/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.credential.store.server;

import java.net.InetSocketAddress;
import org.apache.airavata.common.utils.IServer;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.credential.store.cpi.CredentialStoreService;
import org.apache.airavata.credential.store.server.CredentialStoreServerHandler;
import org.apache.thrift.TProcessor;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CredentialStoreServer
implements IServer {
    private static final Logger logger = LoggerFactory.getLogger(CredentialStoreServer.class);
    private static final String SERVER_NAME = "Credential Store Server";
    private static final String SERVER_VERSION = "1.0";
    private IServer.ServerStatus status;
    private TServer server;

    public CredentialStoreServer() {
        this.setStatus(IServer.ServerStatus.STOPPED);
    }

    public String getName() {
        return SERVER_NAME;
    }

    public String getVersion() {
        return SERVER_VERSION;
    }

    public void start() throws Exception {
        try {
            TServerSocket serverTransport;
            this.setStatus(IServer.ServerStatus.STARTING);
            final int serverPort = Integer.parseInt(ServerSettings.getCredentialStoreServerPort());
            String serverHost = ServerSettings.getCredentialStoreServerHost();
            CredentialStoreService.Processor processor = new CredentialStoreService.Processor((CredentialStoreService.Iface)new CredentialStoreServerHandler());
            if (serverHost == null) {
                serverTransport = new TServerSocket(serverPort);
            } else {
                InetSocketAddress inetSocketAddress = new InetSocketAddress(serverHost, serverPort);
                serverTransport = new TServerSocket(inetSocketAddress);
            }
            TThreadPoolServer.Args options = new TThreadPoolServer.Args((TServerTransport)serverTransport);
            options.minWorkerThreads = 30;
            this.server = new TThreadPoolServer((TThreadPoolServer.Args)options.processor((TProcessor)processor));
            new Thread(){

                @Override
                public void run() {
                    CredentialStoreServer.this.server.serve();
                    CredentialStoreServer.this.setStatus(IServer.ServerStatus.STOPPED);
                    logger.info("Credential store Server Stopped.");
                }
            }.start();
            new Thread(){

                @Override
                public void run() {
                    while (!CredentialStoreServer.this.server.isServing()) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                            break;
                        }
                    }
                    if (CredentialStoreServer.this.server.isServing()) {
                        CredentialStoreServer.this.setStatus(IServer.ServerStatus.STARTED);
                        logger.info("Starting Credential store Server on Port " + serverPort);
                        logger.info("Listening to Credential store clients ....");
                    }
                }
            }.start();
        }
        catch (TTransportException e) {
            this.setStatus(IServer.ServerStatus.FAILED);
            throw new Exception("Error while starting the credential store service", e);
        }
    }

    public static void main(String[] args) {
        try {
            new CredentialStoreServer().start();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void stop() throws Exception {
        if (this.server != null && this.server.isServing()) {
            this.setStatus(IServer.ServerStatus.STOPING);
            this.server.stop();
        }
    }

    public void restart() throws Exception {
        this.stop();
        this.start();
    }

    public void configure() throws Exception {
    }

    public IServer.ServerStatus getStatus() throws Exception {
        return this.status;
    }

    private void setStatus(IServer.ServerStatus stat) {
        this.status = stat;
        this.status.updateTime();
    }

    public TServer getServer() {
        return this.server;
    }

    public void setServer(TServer server) {
        this.server = server;
    }
}

