/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.id;

import java.io.Serializable;
import java.net.InetAddress;
import org.compass.core.id.IdentifierGenerator;

public class UUIDGenerator
implements IdentifierGenerator {
    private static final int IP;
    private static short counter;
    private static final int JVM;
    private String sep = "";

    private static int toInt(byte[] bytes) {
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            result = (result << 8) - -128 + bytes[i];
        }
        return result;
    }

    protected int getJVM() {
        return JVM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected short getCount() {
        Class<UUIDGenerator> clazz = UUIDGenerator.class;
        synchronized (UUIDGenerator.class) {
            if (counter < 0) {
                counter = 0;
            }
            short s = counter;
            counter = (short)(s + 1);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return s;
        }
    }

    protected int getIP() {
        return IP;
    }

    protected short getHiTime() {
        return (short)(System.currentTimeMillis() >>> 32);
    }

    protected int getLoTime() {
        return (int)System.currentTimeMillis();
    }

    protected String format(int intval) {
        String formatted = Integer.toHexString(intval);
        StringBuffer buf = new StringBuffer("00000000");
        buf.replace(8 - formatted.length(), 8, formatted);
        return buf.toString();
    }

    protected String format(short shortval) {
        String formatted = Integer.toHexString(shortval);
        StringBuffer buf = new StringBuffer("0000");
        buf.replace(4 - formatted.length(), 4, formatted);
        return buf.toString();
    }

    public Serializable generate() {
        return new StringBuffer(36).append(this.format(this.getIP())).append(this.sep).append(this.format(this.getJVM())).append(this.sep).append(this.format(this.getHiTime())).append(this.sep).append(this.format(this.getLoTime())).append(this.sep).append(this.format(this.getCount())).toString();
    }

    static {
        int ipadd;
        try {
            ipadd = UUIDGenerator.toInt(InetAddress.getLocalHost().getAddress());
        }
        catch (Exception e) {
            ipadd = 0;
        }
        IP = ipadd;
        counter = 0;
        JVM = (int)(System.currentTimeMillis() >>> 8);
    }
}

