/*
 * Decompiled with CFR 0.152.
 */
package org.compass.needle.terracotta;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.store.Lock;
import org.compass.needle.terracotta.TerracottaLockFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TerracottaLock
extends Lock {
    private String lockName;
    private final ConcurrentHashMap<String, Object> locks;

    public TerracottaLock(ConcurrentHashMap<String, Object> locks, String lockName) {
        this.locks = locks;
        this.lockName = lockName;
    }

    @Override
    public boolean obtain() throws IOException {
        return this.locks.putIfAbsent(this.lockName, TerracottaLockFactory.MARK) == null;
    }

    @Override
    public void release() {
        this.locks.remove(this.lockName);
    }

    @Override
    public boolean isLocked() {
        return this.locks.containsKey(this.lockName);
    }

    public String toString() {
        return "TerracottaLock: " + this.lockName;
    }
}

