/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.opsworks.model.UpdateInstanceRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class UpdateInstanceRequestMarshaller
implements Marshaller<Request<UpdateInstanceRequest>, UpdateInstanceRequest> {
    public Request<UpdateInstanceRequest> marshall(UpdateInstanceRequest updateInstanceRequest) {
        if (updateInstanceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateInstanceRequest, "AWSOpsWorks");
        String target = "OpsWorks_20130218.UpdateInstance";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag layerIdsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (updateInstanceRequest.getInstanceId() != null) {
                jsonWriter.key("InstanceId").value((Object)updateInstanceRequest.getInstanceId());
            }
            if (!((layerIdsList = (ListWithAutoConstructFlag)updateInstanceRequest.getLayerIds()) == null || layerIdsList.isAutoConstruct() && layerIdsList.isEmpty())) {
                jsonWriter.key("LayerIds");
                jsonWriter.array();
                for (String layerIdsListValue : layerIdsList) {
                    if (layerIdsListValue == null) continue;
                    jsonWriter.value((Object)layerIdsListValue);
                }
                jsonWriter.endArray();
            }
            if (updateInstanceRequest.getInstanceType() != null) {
                jsonWriter.key("InstanceType").value((Object)updateInstanceRequest.getInstanceType());
            }
            if (updateInstanceRequest.getAutoScalingType() != null) {
                jsonWriter.key("AutoScalingType").value((Object)updateInstanceRequest.getAutoScalingType());
            }
            if (updateInstanceRequest.getHostname() != null) {
                jsonWriter.key("Hostname").value((Object)updateInstanceRequest.getHostname());
            }
            if (updateInstanceRequest.getOs() != null) {
                jsonWriter.key("Os").value((Object)updateInstanceRequest.getOs());
            }
            if (updateInstanceRequest.getAmiId() != null) {
                jsonWriter.key("AmiId").value((Object)updateInstanceRequest.getAmiId());
            }
            if (updateInstanceRequest.getSshKeyName() != null) {
                jsonWriter.key("SshKeyName").value((Object)updateInstanceRequest.getSshKeyName());
            }
            if (updateInstanceRequest.getArchitecture() != null) {
                jsonWriter.key("Architecture").value((Object)updateInstanceRequest.getArchitecture());
            }
            if (updateInstanceRequest.isInstallUpdatesOnBoot() != null) {
                jsonWriter.key("InstallUpdatesOnBoot").value((Object)updateInstanceRequest.isInstallUpdatesOnBoot());
            }
            if (updateInstanceRequest.isEbsOptimized() != null) {
                jsonWriter.key("EbsOptimized").value((Object)updateInstanceRequest.isEbsOptimized());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

