/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.common.utils;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.airavata.common.utils.DBUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseTestCases {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseTestCases.class);
    protected static String hostAddress = "localhost";
    protected static int port = 20000;
    protected static String userName = "admin";
    protected static String password = "admin";
    protected static String driver = "org.apache.derby.jdbc.ClientDriver";

    public static String getHostAddress() {
        return hostAddress;
    }

    public static int getPort() {
        return port;
    }

    public static String getUserName() {
        return userName;
    }

    public static String getPassword() {
        return password;
    }

    public static String getDriver() {
        return driver;
    }

    public static String getJDBCUrl() {
        return "jdbc:derby://" + DatabaseTestCases.getHostAddress() + ":" + DatabaseTestCases.getPort() + "/experiment_catalog;create=true;user=" + DatabaseTestCases.getUserName() + ";password=" + DatabaseTestCases.getPassword();
    }

    public static void waitTillServerStarts() {
        DBUtil dbUtil = null;
        try {
            dbUtil = new DBUtil(DatabaseTestCases.getJDBCUrl(), DatabaseTestCases.getUserName(), DatabaseTestCases.getPassword(), DatabaseTestCases.getDriver());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Connection connection = null;
        try {
            if (dbUtil != null) {
                connection = dbUtil.getConnection();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        while (connection == null) {
            try {
                Thread.sleep(1000L);
                try {
                    if (dbUtil == null) continue;
                    connection = dbUtil.getConnection();
                }
                catch (SQLException sQLException) {
                }
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static void executeSQL(String sql) throws Exception {
        DBUtil dbUtil = new DBUtil(DatabaseTestCases.getJDBCUrl(), DatabaseTestCases.getUserName(), DatabaseTestCases.getPassword(), DatabaseTestCases.getDriver());
        dbUtil.executeSQL(sql);
    }

    public DBUtil getDbUtil() throws Exception {
        return new DBUtil(DatabaseTestCases.getJDBCUrl(), DatabaseTestCases.getUserName(), DatabaseTestCases.getPassword(), DatabaseTestCases.getDriver());
    }

    public Connection getConnection() throws Exception {
        DBUtil dbUtil = this.getDbUtil();
        Connection connection = dbUtil.getConnection();
        connection.setAutoCommit(true);
        return connection;
    }
}

