/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jax.rs.shiro.authc.impl;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import javax.ws.rs.core.Feature;
import org.apache.aries.component.dsl.OSGi;
import org.apache.aries.component.dsl.OSGiResult;
import org.apache.aries.component.dsl.Utils;
import org.apache.aries.jax.rs.shiro.authc.impl.ShiroAuthenticationFeatureProvider;
import org.apache.shiro.realm.Realm;
import org.osgi.annotation.bundle.Header;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Header(name="Bundle-Activator", value="${@class}")
public class ShiroAuthenticationActivator
implements BundleActivator {
    private static final Logger _LOG = LoggerFactory.getLogger(ShiroAuthenticationActivator.class);
    private OSGiResult registration;

    public void start(BundleContext context) throws Exception {
        _LOG.debug("Starting the Shiro JAX-RS Authentication Feature");
        this.registration = OSGi.coalesce((OSGi[])new OSGi[]{OSGi.configuration((String)"org.apache.aries.jax.rs.shiro.authentication"), OSGi.just(() -> {
            _LOG.debug("Using the default configuration for the Shiro JAX-RS Authentication Feature");
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("service.pid", "org.apache.aries.jax.rs.shiro.authentication");
            return properties;
        })}).map(this::filter).flatMap(this::setupRealms).run(context);
    }

    Map<String, Object> filter(Dictionary<String, ?> props) {
        Hashtable<String, Object> serviceProps = new Hashtable<String, Object>();
        Enumeration<String> keys = props.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (key.startsWith(".")) continue;
            serviceProps.put(key, props.get(key));
        }
        serviceProps.put("osgi.jaxrs.extension", Boolean.TRUE);
        serviceProps.putIfAbsent("osgi.jaxrs.name", "aries.shiro.authc");
        _LOG.debug("Shiro JAX-RS Authentication Feature service properties are: {}", serviceProps);
        return serviceProps;
    }

    OSGi<?> setupRealms(Map<String, Object> properties) {
        OSGi realms;
        Object filter = properties.get("realms.target");
        if (filter == null) {
            _LOG.debug("The Shiro JAX-RS Authentication Feature is accepting all realms");
            realms = Utils.accumulate((OSGi)OSGi.service((OSGi)OSGi.serviceReferences(Realm.class)));
        } else {
            _LOG.debug("The Shiro JAX-RS Authentication Feature is filtering realms using the filter {}", filter);
            realms = Utils.accumulate((OSGi)OSGi.service((OSGi)OSGi.serviceReferences(Realm.class, (String)String.valueOf(filter))));
        }
        return realms.map(ShiroAuthenticationFeatureProvider::new).flatMap(f -> OSGi.register(Feature.class, (ServiceFactory)f, (Map)properties).effects(x -> {}, x -> f.close()));
    }

    public void stop(BundleContext context) throws Exception {
        _LOG.debug("Stopping the Shiro JAX-RS Authentication Feature");
        this.registration.close();
    }
}

