/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jndi;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.spi.DirObjectFactory;
import javax.naming.spi.DirectoryManager;
import javax.naming.spi.NamingManager;
import javax.naming.spi.ObjectFactory;
import javax.naming.spi.ObjectFactoryBuilder;
import org.apache.aries.jndi.DirObjectFactoryHelper;
import org.apache.aries.jndi.Utils;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiObjectFactoryBuilder
implements ObjectFactoryBuilder,
ObjectFactory,
DirObjectFactory {
    private BundleContext defaultContext;

    public OSGiObjectFactoryBuilder(BundleContext ctx) {
        this.defaultContext = ctx;
    }

    @Override
    public ObjectFactory createObjectFactory(Object obj, Hashtable<?, ?> environment) throws NamingException {
        return this;
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        BundleContext callerContext = this.getCallerBundleContext(environment);
        if (callerContext == null) {
            return obj;
        }
        DirObjectFactoryHelper helper = new DirObjectFactoryHelper(this.defaultContext, callerContext);
        return helper.getObjectInstance(obj, name, nameCtx, environment);
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment, Attributes attrs) throws Exception {
        BundleContext callerContext = this.getCallerBundleContext(environment);
        if (callerContext == null) {
            return obj;
        }
        DirObjectFactoryHelper helper = new DirObjectFactoryHelper(this.defaultContext, callerContext);
        return helper.getObjectInstance(obj, name, nameCtx, environment, attrs);
    }

    private BundleContext getCallerBundleContext(Hashtable<?, ?> environment) throws NamingException {
        BundleContext context = Utils.getBundleContext(environment, NamingManager.class);
        if (context == null) {
            context = Utils.getBundleContext(environment, DirectoryManager.class);
        }
        return context;
    }
}

