/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.equinox.region.RegionFilterBuilder;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.resource.Requirement;

public class RegionUpdater {
    public static final int MAX_ATTEMPTS_DEFAULT = 10;
    private final RegionDigraph digraph;
    private final Region head;
    private final Region tail;

    public RegionUpdater(Region tail, Region head) {
        if (tail == null) {
            throw new NullPointerException("Missing required parameter: tail");
        }
        if (head == null) {
            throw new NullPointerException("Missing required parameter: head");
        }
        this.tail = tail;
        this.head = head;
        this.digraph = tail.getRegionDigraph();
    }

    public void addRequirements(Collection<? extends Requirement> requirements) throws BundleException, InvalidSyntaxException {
        for (int i = 0; i < 10; ++i) {
            RegionDigraph copy = this.copyDigraph();
            Region tail = this.copyTail(copy);
            Region head = this.copyHead(copy);
            Set<Long> bundleIds = this.copyBundleIds(tail);
            Map<String, RegionFilterBuilder> heads = this.copyHeadRegions(tail, copy);
            Map<String, RegionFilterBuilder> tails = this.copyTailRegions(tail, copy);
            copy.removeRegion(tail);
            tail = copy.createRegion(tail.getName());
            this.addBundleIds(bundleIds, tail);
            this.addRequirements(requirements, heads.get(head.getName()));
            this.addHeadRegions(heads, tail, copy);
            this.addTailRegions(tails, tail, copy);
            try {
                this.digraph.replace(copy);
                break;
            }
            catch (BundleException e) {
                if (i < 10) continue;
                throw e;
            }
        }
    }

    private void addBundleIds(Set<Long> ids, Region region) throws BundleException {
        for (Long id : ids) {
            region.addBundle(id.longValue());
        }
    }

    private void addHeadRegions(Map<String, RegionFilterBuilder> heads, Region tail, RegionDigraph digraph) throws BundleException {
        for (Map.Entry<String, RegionFilterBuilder> entry : heads.entrySet()) {
            tail.connectRegion(digraph.getRegion(entry.getKey()), entry.getValue().build());
        }
    }

    private void addTailRegions(Map<String, RegionFilterBuilder> tails, Region head, RegionDigraph digraph) throws BundleException {
        for (Map.Entry<String, RegionFilterBuilder> entry : tails.entrySet()) {
            digraph.getRegion(entry.getKey()).connectRegion(head, entry.getValue().build());
        }
    }

    private void addRequirements(Collection<? extends Requirement> requirements, RegionFilterBuilder builder) throws InvalidSyntaxException {
        for (Requirement requirement : requirements) {
            String filter;
            String namespace = requirement.getNamespace();
            if ("osgi.service".equals(namespace)) {
                namespace = "org.eclipse.equinox.allow.service";
            }
            if ((filter = (String)requirement.getDirectives().get("filter")) == null) {
                builder.allowAll(namespace);
                continue;
            }
            builder.allow(namespace, filter);
        }
    }

    private Set<Long> copyBundleIds(Region region) {
        return region.getBundleIds();
    }

    private RegionDigraph copyDigraph() throws BundleException {
        return this.digraph.copy();
    }

    private Region copyHead(RegionDigraph digraph) {
        return digraph.getRegion(this.head.getName());
    }

    private Map<String, RegionFilterBuilder> copyHeadRegions(Region tail, RegionDigraph digraph) throws InvalidSyntaxException {
        HashMap<String, RegionFilterBuilder> result = new HashMap<String, RegionFilterBuilder>();
        for (RegionDigraph.FilteredRegion edge : tail.getEdges()) {
            result.put(edge.getRegion().getName(), this.createRegionFilterBuilder(edge.getFilter().getSharingPolicy(), digraph));
        }
        return result;
    }

    private Region copyTail(RegionDigraph digraph) {
        return digraph.getRegion(this.tail.getName());
    }

    private Map<String, RegionFilterBuilder> copyTailRegions(Region tail, RegionDigraph digraph) throws InvalidSyntaxException {
        HashMap<String, RegionFilterBuilder> result = new HashMap<String, RegionFilterBuilder>();
        for (Region head : digraph.getRegions()) {
            if (head.equals(tail)) continue;
            for (RegionDigraph.FilteredRegion edge : head.getEdges()) {
                if (!edge.getRegion().equals(tail)) continue;
                result.put(head.getName(), this.createRegionFilterBuilder(edge.getFilter().getSharingPolicy(), digraph));
            }
        }
        return result;
    }

    private RegionFilterBuilder createRegionFilterBuilder(Map<String, Collection<String>> sharingPolicy, RegionDigraph digraph) throws InvalidSyntaxException {
        RegionFilterBuilder result = digraph.createRegionFilterBuilder();
        for (Map.Entry<String, Collection<String>> entry : sharingPolicy.entrySet()) {
            for (String filter : entry.getValue()) {
                result.allow(entry.getKey(), filter);
            }
        }
        return result;
    }
}

