/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.archive;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.aries.subsystem.core.archive.AttributeFactory;
import org.apache.aries.subsystem.core.archive.DirectiveFactory;
import org.apache.aries.subsystem.core.archive.Parameter;

public class ParameterFactory {
    public static final String QUOTED_STRING = "\"((?:[^\"\r\n\u0000]|\\\\\"|\\\\\\\\)*)\"";
    public static final String ARGUMENT = "((?:[0-9]|[A-Za-z]|_|-|\\.)+)|\"((?:[^\"\r\n\u0000]|\\\\\"|\\\\\\\\)*)\"";
    private static final String REGEX = "((?:[0-9]|[A-Za-z]|_|-|\\.)+)(\\:?=)(?:((?:[0-9]|[A-Za-z]|_|-|\\.)+)|\"((?:[^\"\r\n\u0000]|\\\\\"|\\\\\\\\)*)\")";
    private static final Pattern PATTERN = Pattern.compile("((?:[0-9]|[A-Za-z]|_|-|\\.)+)(\\:?=)(?:((?:[0-9]|[A-Za-z]|_|-|\\.)+)|\"((?:[^\"\r\n\u0000]|\\\\\"|\\\\\\\\)*)\")");

    public static Parameter create(String parameter) {
        Matcher matcher = PATTERN.matcher(parameter);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid parameter: " + parameter);
        }
        String name = matcher.group(1);
        String symbol = matcher.group(2);
        String value = matcher.group(3);
        if (value == null) {
            value = matcher.group(4);
        }
        if (symbol.equals("=")) {
            return AttributeFactory.createAttribute(name, value);
        }
        return DirectiveFactory.createDirective(name, value);
    }
}

