/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.archive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.aries.subsystem.core.archive.Attribute;
import org.apache.aries.subsystem.core.archive.ClauseTokenizer;
import org.apache.aries.subsystem.core.archive.Directive;
import org.apache.aries.subsystem.core.archive.Parameter;
import org.apache.aries.subsystem.core.archive.ParameterFactory;
import org.apache.aries.subsystem.core.archive.RequireBundleRequirement;
import org.apache.aries.subsystem.core.archive.RequirementHeader;
import org.apache.aries.subsystem.core.archive.ResolutionDirective;
import org.apache.aries.subsystem.core.archive.VisibilityDirective;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class RequireBundleHeader
implements RequirementHeader<Clause> {
    public static final String NAME = "Require-Bundle";
    private final Set<Clause> clauses;

    private static Collection<Clause> processHeader(String header) {
        HashSet<Clause> clauses = new HashSet<Clause>();
        for (String clause : new ClauseTokenizer(header).getClauses()) {
            clauses.add(new Clause(clause));
        }
        return clauses;
    }

    public RequireBundleHeader(Collection<Clause> clauses) {
        if (clauses.isEmpty()) {
            throw new IllegalArgumentException("A Require-Bundle header must have at least one clause");
        }
        this.clauses = new HashSet<Clause>(clauses);
    }

    public RequireBundleHeader(String value) {
        this(RequireBundleHeader.processHeader(value));
    }

    @Override
    public Collection<Clause> getClauses() {
        return Collections.unmodifiableSet(this.clauses);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getValue() {
        return this.toString();
    }

    @Override
    public List<RequireBundleRequirement> toRequirements(Resource resource) {
        ArrayList<RequireBundleRequirement> requirements = new ArrayList<RequireBundleRequirement>(this.clauses.size());
        for (Clause clause : this.clauses) {
            requirements.add(clause.toRequirement(resource));
        }
        return requirements;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Clause clause : this.getClauses()) {
            builder.append(clause).append(',');
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }

    public static class Clause
    implements org.apache.aries.subsystem.core.archive.Clause {
        public static final String ATTRIBUTE_BUNDLEVERSION = "bundle-version";
        public static final String DIRECTIVE_RESOLUTION = "resolution";
        public static final String DIRECTIVE_VISIBILITY = "visibility";
        private static final Pattern PATTERN_SYMBOLICNAME = Pattern.compile("((?:[0-9]|[A-Za-z]|_|-)+(?:\\.(?:[0-9]|[A-Za-z]|_|-)+)*)(?=;|\\z)");
        private static final Pattern PATTERN_PARAMETER = Pattern.compile("((?:(?:[0-9]|[A-Za-z]|_|-|\\.)+:=(?:(?:[0-9]|[A-Za-z]|_|-|\\.)+|\"(?:[^\\\\\"\r\n\u0000]|\\\\\"|\\\\\\\\)*\"))|(?:(?:[0-9]|[A-Za-z]|_|-|\\.)+=(?:(?:[0-9]|[A-Za-z]|_|-|\\.)+|\"(?:[^\\\\\"\r\n\u0000]|\\\\\"|\\\\\\\\)*\")))(?=;|\\z)");
        private final String path;
        private final Map<String, Parameter> parameters = new HashMap<String, Parameter>();
        private static final String REGEX = "\\((osgi.wiring.bundle)(=)([^\\)]+)\\)";
        private static final Pattern PATTERN = Pattern.compile("\\((osgi.wiring.bundle)(=)([^\\)]+)\\)");

        private static void fillInDefaults(Map<String, Parameter> parameters) {
            Parameter parameter = parameters.get(DIRECTIVE_VISIBILITY);
            if (parameter == null) {
                parameters.put(DIRECTIVE_VISIBILITY, VisibilityDirective.PRIVATE);
            }
            if ((parameter = parameters.get(DIRECTIVE_RESOLUTION)) == null) {
                parameters.put(DIRECTIVE_RESOLUTION, ResolutionDirective.MANDATORY);
            }
        }

        public Clause(String clause) {
            Matcher matcher = PATTERN_SYMBOLICNAME.matcher(clause);
            if (!matcher.find()) {
                throw new IllegalArgumentException("Missing bundle description path: " + clause);
            }
            this.path = matcher.group();
            matcher.usePattern(PATTERN_PARAMETER);
            while (matcher.find()) {
                Parameter parameter = ParameterFactory.create(matcher.group());
                this.parameters.put(parameter.getName(), parameter);
            }
            Clause.fillInDefaults(this.parameters);
        }

        public Clause(Requirement requirement) {
            if (!"osgi.wiring.bundle".equals(requirement.getNamespace())) {
                throw new IllegalArgumentException("Requirement must be in the 'osgi.wiring.bundle' namespace");
            }
            String filter = (String)requirement.getDirectives().get("filter");
            String path = null;
            Matcher matcher = PATTERN.matcher(filter);
            while (matcher.find()) {
                String name = matcher.group(1);
                String operator = matcher.group(2);
                String value = matcher.group(3);
                if ("osgi.wiring.bundle".equals(name)) {
                    path = value;
                    continue;
                }
                if (!ATTRIBUTE_BUNDLEVERSION.equals(name)) continue;
            }
            if (path == null) {
                throw new IllegalArgumentException("Missing filter key: osgi.wiring.bundle");
            }
            this.path = path;
        }

        @Override
        public Attribute getAttribute(String name) {
            Parameter result = this.parameters.get(name);
            if (result instanceof Attribute) {
                return (Attribute)result;
            }
            return null;
        }

        @Override
        public Collection<Attribute> getAttributes() {
            ArrayList<Attribute> attributes = new ArrayList<Attribute>(this.parameters.size());
            for (Parameter parameter : this.parameters.values()) {
                if (!(parameter instanceof Attribute)) continue;
                attributes.add((Attribute)parameter);
            }
            attributes.trimToSize();
            return attributes;
        }

        @Override
        public Directive getDirective(String name) {
            Parameter result = this.parameters.get(name);
            if (result instanceof Directive) {
                return (Directive)result;
            }
            return null;
        }

        @Override
        public Collection<Directive> getDirectives() {
            ArrayList<Directive> directives = new ArrayList<Directive>(this.parameters.size());
            for (Parameter parameter : this.parameters.values()) {
                if (!(parameter instanceof Directive)) continue;
                directives.add((Directive)parameter);
            }
            directives.trimToSize();
            return directives;
        }

        @Override
        public Parameter getParameter(String name) {
            return this.parameters.get(name);
        }

        @Override
        public Collection<Parameter> getParameters() {
            return Collections.unmodifiableCollection(this.parameters.values());
        }

        @Override
        public String getPath() {
            return this.path;
        }

        public String getSymbolicName() {
            return this.path;
        }

        public RequireBundleRequirement toRequirement(Resource resource) {
            return new RequireBundleRequirement(this, resource);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder().append(this.getPath());
            for (Parameter parameter : this.getParameters()) {
                builder.append(';').append(parameter);
            }
            return builder.toString();
        }
    }
}

