/*
 * Decompiled with CFR 0.152.
 */
package org.tranql.connector.jdbc;

import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Set;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.InvalidPropertyException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.security.auth.Subject;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.tranql.connector.CredentialExtractor;
import org.tranql.connector.ExceptionSorter;
import org.tranql.connector.ManagedConnectionHandle;
import org.tranql.connector.UserPasswordManagedConnectionFactory;
import org.tranql.connector.jdbc.AutocommitSpecCompliant;
import org.tranql.connector.jdbc.ManagedXAConnection;
import org.tranql.connector.jdbc.TranqlDataSource;

public abstract class AbstractXADataSourceMCF<T extends XADataSource>
implements UserPasswordManagedConnectionFactory,
AutocommitSpecCompliant {
    private static final long serialVersionUID = -1531351804704240389L;
    protected final T xaDataSource;
    protected final ExceptionSorter exceptionSorter;
    private int transactionIsolationLevel = -1;
    protected PrintWriter log;

    protected AbstractXADataSourceMCF(T xaDataSource, ExceptionSorter exceptionSorter) {
        this.xaDataSource = xaDataSource;
        this.exceptionSorter = exceptionSorter;
    }

    public Object createConnectionFactory() throws ResourceException {
        throw new NotSupportedException("ConnectionManager is required");
    }

    public Object createConnectionFactory(ConnectionManager connectionManager) throws ResourceException {
        return new TranqlDataSource(this, connectionManager);
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        CredentialExtractor credentialExtractor = new CredentialExtractor(subject, connectionRequestInfo, this);
        XAConnection sqlConnection = this.getPhysicalConnection(credentialExtractor);
        try {
            return new ManagedXAConnection(this, sqlConnection, credentialExtractor, this.exceptionSorter);
        }
        catch (SQLException e) {
            throw new ResourceAdapterInternalException("Could not set up ManagedXAConnection", (Throwable)e);
        }
    }

    protected XAConnection getPhysicalConnection(CredentialExtractor credentialExtractor) throws ResourceException {
        try {
            return this.xaDataSource.getXAConnection(credentialExtractor.getUserName(), credentialExtractor.getPassword());
        }
        catch (SQLException e) {
            throw new ResourceAdapterInternalException("Unable to obtain physical connection to " + this.xaDataSource, (Throwable)e);
        }
    }

    public ManagedConnection matchManagedConnections(Set set, Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        for (Object o : set) {
            ManagedConnectionHandle mc;
            if (!(o instanceof ManagedConnectionHandle) || !(mc = (ManagedConnectionHandle)o).matches(this, subject, connectionRequestInfo)) continue;
            return mc;
        }
        return null;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        try {
            return this.xaDataSource.getLogWriter();
        }
        catch (SQLException e) {
            throw new ResourceAdapterInternalException(e.getMessage(), (Throwable)e);
        }
    }

    public void setLogWriter(PrintWriter log) throws ResourceException {
        try {
            this.xaDataSource.setLogWriter(log);
        }
        catch (SQLException e) {
            throw new ResourceAdapterInternalException(e.getMessage(), (Throwable)e);
        }
    }

    public Integer getLoginTimeout() {
        int timeout;
        try {
            timeout = this.xaDataSource.getLoginTimeout();
        }
        catch (SQLException e) {
            timeout = 0;
        }
        return timeout;
    }

    public void setLoginTimeout(Integer timeout) throws ResourceException {
        try {
            this.xaDataSource.setLoginTimeout(timeout);
        }
        catch (SQLException e) {
            throw new InvalidPropertyException(e.getMessage());
        }
    }

    @Override
    public Boolean isCommitBeforeAutocommit() {
        return Boolean.FALSE;
    }

    public int getTransactionIsolationLevel() {
        return this.transactionIsolationLevel;
    }

    public void setTransactionIsolationLevel(int transactionIsolationLevel) {
        this.transactionIsolationLevel = transactionIsolationLevel;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AbstractXADataSourceMCF) {
            AbstractXADataSourceMCF other = (AbstractXADataSourceMCF)obj;
            return this.xaDataSource.equals(other.xaDataSource);
        }
        return false;
    }

    public int hashCode() {
        return this.xaDataSource.hashCode();
    }

    public String toString() {
        return "AbstractXADataSourceMCF[" + this.xaDataSource + "]";
    }
}

