/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.comparisons;

import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ADouble;
import org.apache.asterix.om.base.AMutableDouble;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.functions.IFunctionTypeInferer;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.comparisons.AbstractComparisonDescriptor;
import org.apache.asterix.runtime.evaluators.comparisons.AbstractIfEqualsEvaluator;
import org.apache.asterix.runtime.functions.FunctionTypeInferers;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;

@MissingNullInOutFunction
public class NanIfEqualsDescriptor
extends AbstractComparisonDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new NanIfEqualsDescriptor();
        }

        public IFunctionTypeInferer createFunctionTypeInferer() {
            return FunctionTypeInferers.SET_ARGUMENTS_TYPE;
        }
    };

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.NAN_IF;
    }

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(IEvaluatorContext ctx) throws HyracksDataException {
                return new AbstractIfEqualsEvaluator(args[0], NanIfEqualsDescriptor.this.leftType, args[1], NanIfEqualsDescriptor.this.rightType, ctx, NanIfEqualsDescriptor.this.sourceLoc){
                    final AMutableDouble equalsResult;
                    final ISerializerDeserializer<ADouble> doubleSerde;
                    {
                        this.equalsResult = new AMutableDouble(Double.NaN);
                        this.doubleSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADOUBLE);
                    }

                    @Override
                    protected void writeEqualsResult() throws HyracksDataException {
                        this.doubleSerde.serialize((Object)this.equalsResult, this.out);
                    }
                };
            }
        };
    }
}

