/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.binary;

import java.io.IOException;
import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.evaluators.functions.binary.AbstractBinaryScalarEvaluator;
import org.apache.asterix.runtime.exceptions.UnsupportedItemTypeException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.ByteArrayPointable;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.util.bytes.Base64Printer;
import org.apache.hyracks.util.bytes.HexPrinter;
import org.apache.hyracks.util.string.UTF8StringWriter;

@MissingNullInOutFunction
public class PrintBinaryDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    private static final UTF8StringPointable HEX_FORMAT = UTF8StringPointable.generateUTF8Pointable((String)"hex");
    private static final UTF8StringPointable BASE64_FORMAT = UTF8StringPointable.generateUTF8Pointable((String)"base64");
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new PrintBinaryDescriptor();
        }
    };
    public static final ATypeTag[] EXPECTED_INPUT_TAGS = new ATypeTag[]{ATypeTag.BINARY, ATypeTag.STRING};

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.PRINT_BINARY;
    }

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(IEvaluatorContext ctx) throws HyracksDataException {
                return new AbstractBinaryScalarEvaluator(ctx, args, PrintBinaryDescriptor.this.getIdentifier(), PrintBinaryDescriptor.this.sourceLoc){
                    private StringBuilder stringBuilder;
                    private final ByteArrayPointable byteArrayPtr;
                    private final UTF8StringPointable formatPointable;
                    private final UTF8StringWriter writer;
                    {
                        this.stringBuilder = new StringBuilder();
                        this.byteArrayPtr = new ByteArrayPointable();
                        this.formatPointable = new UTF8StringPointable();
                        this.writer = new UTF8StringWriter();
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        this.resultStorage.reset();
                        this.evaluators[0].evaluate(tuple, this.pointables[0]);
                        this.evaluators[1].evaluate(tuple, this.pointables[1]);
                        if (PointableHelper.checkAndSetMissingOrNull(result, this.pointables[0], this.pointables[1])) {
                            return;
                        }
                        try {
                            ATypeTag arg0Tag = ATypeTag.VALUE_TYPE_MAPPING[this.pointables[0].getByteArray()[this.pointables[0].getStartOffset()]];
                            ATypeTag arg1Tag = ATypeTag.VALUE_TYPE_MAPPING[this.pointables[1].getByteArray()[this.pointables[1].getStartOffset()]];
                            this.checkTypeMachingThrowsIfNot(EXPECTED_INPUT_TAGS, arg0Tag, arg1Tag);
                            this.byteArrayPtr.set(this.pointables[0].getByteArray(), this.pointables[0].getStartOffset() + 1, this.pointables[0].getLength());
                            this.formatPointable.set(this.pointables[1].getByteArray(), this.pointables[1].getStartOffset() + 1, this.pointables[1].getLength());
                            int lengthBinary = this.byteArrayPtr.getContentLength();
                            this.stringBuilder.setLength(0);
                            if (HEX_FORMAT.ignoreCaseCompareTo(this.formatPointable) == 0) {
                                HexPrinter.printHexString((byte[])this.byteArrayPtr.getByteArray(), (int)this.byteArrayPtr.getContentStartOffset(), (int)lengthBinary, (Appendable)this.stringBuilder);
                            } else if (BASE64_FORMAT.ignoreCaseCompareTo(this.formatPointable) == 0) {
                                Base64Printer.printBase64Binary((byte[])this.byteArrayPtr.getByteArray(), (int)this.byteArrayPtr.getContentStartOffset(), (int)lengthBinary, (Appendable)this.stringBuilder);
                            } else {
                                throw new UnsupportedItemTypeException(this.sourceLoc, PrintBinaryDescriptor.this.getIdentifier(), arg1Tag.serialize());
                            }
                            this.dataOutput.writeByte(ATypeTag.SERIALIZED_STRING_TYPE_TAG);
                            this.writer.writeUTF8((CharSequence)this.stringBuilder.toString(), this.dataOutput);
                        }
                        catch (IOException e) {
                            throw HyracksDataException.create((Throwable)e);
                        }
                        result.set((IValueReference)this.resultStorage);
                    }
                };
            }
        };
    }
}

