/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.records;

import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.asterix.dataflow.data.nontagged.serde.ARecordSerializerDeserializer;
import org.apache.asterix.formats.nontagged.BinaryComparatorFactoryProvider;
import org.apache.asterix.formats.nontagged.BinaryHashFunctionFactoryProvider;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMissing;
import org.apache.asterix.om.base.ANull;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.runtime.RuntimeRecordTypeInfo;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.asterix.om.utils.RecordUtil;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryHashFunction;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.data.std.util.ByteArrayAccessibleOutputStream;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class FieldAccessNestedEvalFactory
implements IScalarEvaluatorFactory {
    private static final long serialVersionUID = 1L;
    private final IScalarEvaluatorFactory recordEvalFactory;
    private final ARecordType recordType;
    private final List<String> fieldPath;
    private final SourceLocation sourceLoc;

    public FieldAccessNestedEvalFactory(IScalarEvaluatorFactory recordEvalFactory, ARecordType recordType, List<String> fldName, SourceLocation sourceLoc) {
        this.recordEvalFactory = recordEvalFactory;
        this.recordType = recordType;
        this.fieldPath = fldName;
        this.sourceLoc = sourceLoc;
    }

    public IScalarEvaluator createScalarEvaluator(final IEvaluatorContext ctx) throws HyracksDataException {
        return new IScalarEvaluator(){
            private final IBinaryHashFunction fieldNameHashFunction = BinaryHashFunctionFactoryProvider.UTF8STRING_POINTABLE_INSTANCE.createBinaryHashFunction();
            private final IBinaryComparator fieldNameComparator = BinaryComparatorFactoryProvider.UTF8STRING_POINTABLE_INSTANCE.createBinaryComparator();
            private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
            private final DataOutput out = this.resultStorage.getDataOutput();
            private final ByteArrayAccessibleOutputStream subRecordTmpStream = new ByteArrayAccessibleOutputStream();
            private final IPointable inputArg0 = new VoidPointable();
            private final IScalarEvaluator eval0 = FieldAccessNestedEvalFactory.access$000(FieldAccessNestedEvalFactory.this).createScalarEvaluator(ctx);
            private final IPointable[] fieldPointables = new VoidPointable[FieldAccessNestedEvalFactory.access$100(FieldAccessNestedEvalFactory.this).size()];
            private final RuntimeRecordTypeInfo[] recTypeInfos = new RuntimeRecordTypeInfo[FieldAccessNestedEvalFactory.access$100(FieldAccessNestedEvalFactory.this).size()];
            private final ISerializerDeserializer<ANull> nullSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ANULL);
            private final ISerializerDeserializer<AMissing> missingSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AMISSING);
            {
                this.generateFieldsPointables();
                for (int index = 0; index < FieldAccessNestedEvalFactory.this.fieldPath.size(); ++index) {
                    this.recTypeInfos[index] = new RuntimeRecordTypeInfo();
                }
            }

            private void generateFieldsPointables() throws HyracksDataException {
                for (int i = 0; i < FieldAccessNestedEvalFactory.this.fieldPath.size(); ++i) {
                    ArrayBackedValueStorage storage = new ArrayBackedValueStorage();
                    DataOutput out = storage.getDataOutput();
                    AString as = new AString((String)FieldAccessNestedEvalFactory.this.fieldPath.get(i));
                    SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)as.getType()).serialize((Object)as, out);
                    this.fieldPointables[i] = new VoidPointable();
                    this.fieldPointables[i].set((IValueReference)storage);
                }
            }

            public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                try {
                    int pathIndex;
                    int offset;
                    this.resultStorage.reset();
                    this.eval0.evaluate(tuple, this.inputArg0);
                    if (PointableHelper.checkAndSetMissingOrNull(result, this.inputArg0)) {
                        return;
                    }
                    byte[] serRecord = this.inputArg0.getByteArray();
                    int start = offset = this.inputArg0.getStartOffset();
                    int len = this.inputArg0.getLength();
                    if (serRecord[start] != ATypeTag.SERIALIZED_RECORD_TYPE_TAG) {
                        throw new TypeMismatchException(FieldAccessNestedEvalFactory.this.sourceLoc, serRecord[start], ATypeTag.SERIALIZED_RECORD_TYPE_TAG);
                    }
                    int subFieldIndex = -1;
                    int subFieldOffset = -1;
                    int subFieldLength = -1;
                    int nullBitmapSize = -1;
                    ARecordType subType = FieldAccessNestedEvalFactory.this.recordType;
                    this.recTypeInfos[0].reset(FieldAccessNestedEvalFactory.this.recordType);
                    ATypeTag subTypeTag = ATypeTag.MISSING;
                    boolean openField = false;
                    for (pathIndex = 0; pathIndex < this.fieldPointables.length; ++pathIndex) {
                        if (subType.getTypeTag().equals((Object)ATypeTag.UNION)) {
                            byte serializedTypeTag = (subType = ((AUnionType)subType).getActualType()).getTypeTag().serialize();
                            if (serializedTypeTag != ATypeTag.SERIALIZED_RECORD_TYPE_TAG) {
                                throw new TypeMismatchException(FieldAccessNestedEvalFactory.this.sourceLoc, serializedTypeTag, ATypeTag.SERIALIZED_RECORD_TYPE_TAG);
                            }
                            if (subType.getTypeTag() == ATypeTag.OBJECT) {
                                this.recTypeInfos[pathIndex].reset(subType);
                            }
                        }
                        if ((subFieldIndex = this.recTypeInfos[pathIndex].getFieldIndex(this.fieldPointables[pathIndex].getByteArray(), this.fieldPointables[pathIndex].getStartOffset() + 1, this.fieldPointables[pathIndex].getLength() - 1)) == -1) break;
                        nullBitmapSize = RecordUtil.computeNullBitmapSize((ARecordType)subType);
                        subFieldOffset = ARecordSerializerDeserializer.getFieldOffsetById((byte[])serRecord, (int)start, (int)subFieldIndex, (int)nullBitmapSize, (boolean)subType.isOpen());
                        if (subFieldOffset == 0) {
                            this.nullSerde.serialize((Object)ANull.NULL, this.out);
                            result.set((IValueReference)this.resultStorage);
                            return;
                        }
                        if (subFieldOffset < 0) {
                            this.missingSerde.serialize((Object)AMissing.MISSING, this.out);
                            result.set((IValueReference)this.resultStorage);
                            return;
                        }
                        if ((subType = subType.getFieldTypes()[subFieldIndex]).getTypeTag() == ATypeTag.OBJECT && pathIndex + 1 < this.fieldPointables.length) {
                            this.recTypeInfos[pathIndex + 1].reset(subType);
                        }
                        if (subType.getTypeTag().equals((Object)ATypeTag.UNION)) {
                            subTypeTag = ((AUnionType)subType).getActualType().getTypeTag();
                            subFieldLength = NonTaggedFormatUtil.getFieldValueLength((byte[])serRecord, (int)subFieldOffset, (ATypeTag)subTypeTag, (boolean)false);
                        } else {
                            subTypeTag = subType.getTypeTag();
                            subFieldLength = NonTaggedFormatUtil.getFieldValueLength((byte[])serRecord, (int)subFieldOffset, (ATypeTag)subTypeTag, (boolean)false);
                        }
                        if (pathIndex < this.fieldPointables.length - 1) {
                            this.subRecordTmpStream.reset();
                            this.subRecordTmpStream.write((int)subTypeTag.serialize());
                            this.subRecordTmpStream.write(serRecord, subFieldOffset, subFieldLength);
                            serRecord = this.subRecordTmpStream.getByteArray();
                            start = 0;
                        }
                        if (pathIndex >= this.fieldPointables.length - 1 || serRecord[start] == ATypeTag.SERIALIZED_RECORD_TYPE_TAG) continue;
                        throw new TypeMismatchException(FieldAccessNestedEvalFactory.this.sourceLoc, serRecord[start], ATypeTag.SERIALIZED_RECORD_TYPE_TAG);
                    }
                    while (pathIndex < this.fieldPointables.length) {
                        openField = true;
                        subFieldOffset = ARecordSerializerDeserializer.getFieldOffsetByName((byte[])serRecord, (int)start, (int)len, (byte[])this.fieldPointables[pathIndex].getByteArray(), (int)this.fieldPointables[pathIndex].getStartOffset(), (IBinaryHashFunction)this.fieldNameHashFunction, (IBinaryComparator)this.fieldNameComparator);
                        if (subFieldOffset < 0) {
                            this.out.writeByte(ATypeTag.SERIALIZED_MISSING_TYPE_TAG);
                            result.set((IValueReference)this.resultStorage);
                            return;
                        }
                        subTypeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(serRecord[subFieldOffset]);
                        subFieldLength = NonTaggedFormatUtil.getFieldValueLength((byte[])serRecord, (int)subFieldOffset, (ATypeTag)subTypeTag, (boolean)true) + 1;
                        if (pathIndex < this.fieldPointables.length - 1) {
                            start = subFieldOffset;
                            len = subFieldLength;
                            if (serRecord[start] == ATypeTag.SERIALIZED_MISSING_TYPE_TAG) {
                                this.missingSerde.serialize((Object)AMissing.MISSING, this.out);
                                result.set((IValueReference)this.resultStorage);
                                return;
                            }
                            if (serRecord[start] != ATypeTag.SERIALIZED_RECORD_TYPE_TAG) {
                                throw new TypeMismatchException(FieldAccessNestedEvalFactory.this.sourceLoc, serRecord[start], ATypeTag.SERIALIZED_RECORD_TYPE_TAG);
                            }
                        }
                        ++pathIndex;
                    }
                    if (openField) {
                        result.set(serRecord, subFieldOffset, subFieldLength);
                    } else {
                        this.out.writeByte(subTypeTag.serialize());
                        this.out.write(serRecord, subFieldOffset, subFieldLength);
                        result.set((IValueReference)this.resultStorage);
                    }
                }
                catch (IOException e) {
                    throw HyracksDataException.create((Throwable)e);
                }
            }
        };
    }

    static /* synthetic */ IScalarEvaluatorFactory access$000(FieldAccessNestedEvalFactory x0) {
        return x0.recordEvalFactory;
    }
}

