/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.common.comm.io;

import java.nio.ByteBuffer;
import org.apache.hyracks.api.comm.FrameHelper;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameAppender;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.util.IntSerDeUtils;
import org.apache.hyracks.util.trace.ITracer;

public class AbstractFrameAppender
implements IFrameAppender {
    protected IFrame frame;
    protected byte[] array;
    protected int tupleCount;
    protected int tupleDataEndOffset;

    public void reset(IFrame frame, boolean clear) throws HyracksDataException {
        this.frame = frame;
        if (clear) {
            this.frame.reset();
        }
        this.reset(this.getBuffer(), clear);
    }

    protected boolean hasEnoughSpace(int fieldCount, int tupleLength) {
        return this.tupleDataEndOffset + FrameHelper.calcRequiredSpace((int)fieldCount, (int)tupleLength) + this.tupleCount * 4 <= FrameHelper.getTupleCountOffset((int)this.frame.getFrameSize());
    }

    protected void reset(ByteBuffer buffer, boolean clear) {
        this.array = buffer.array();
        if (clear) {
            IntSerDeUtils.putInt((byte[])this.array, (int)FrameHelper.getTupleCountOffset((int)this.frame.getFrameSize()), (int)0);
            this.tupleCount = 0;
            this.tupleDataEndOffset = 5;
        } else {
            this.tupleCount = IntSerDeUtils.getInt((byte[])this.array, (int)FrameHelper.getTupleCountOffset((int)this.frame.getFrameSize()));
            this.tupleDataEndOffset = this.tupleCount == 0 ? 5 : IntSerDeUtils.getInt((byte[])this.array, (int)(FrameHelper.getTupleCountOffset((int)this.frame.getFrameSize()) - this.tupleCount * 4));
        }
    }

    public int getTupleCount() {
        return this.tupleCount;
    }

    public ByteBuffer getBuffer() {
        return this.frame.getBuffer();
    }

    public void write(IFrameWriter outWriter, boolean clearFrame) throws HyracksDataException {
        this.failIfInterrupted();
        this.getBuffer().clear();
        outWriter.nextFrame(this.getBuffer());
        if (clearFrame) {
            this.frame.reset();
            this.reset(this.getBuffer(), true);
        }
    }

    protected boolean canHoldNewTuple(int fieldCount, int dataLength) throws HyracksDataException {
        if (this.hasEnoughSpace(fieldCount, dataLength)) {
            return true;
        }
        if (this.tupleCount == 0) {
            this.frame.ensureFrameSize(FrameHelper.calcAlignedFrameSizeToStore((int)fieldCount, (int)dataLength, (int)this.frame.getMinSize()));
            this.reset(this.frame.getBuffer(), true);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(IFrameWriter writer, ITracer tracer, String name, long traceCategory, String args) throws HyracksDataException {
        long tid = tracer.durationB(name, traceCategory, args);
        try {
            this.flush(writer);
        }
        finally {
            tracer.durationE(tid, traceCategory, args);
        }
    }

    protected void failIfInterrupted() throws HyracksDataException {
        if (Thread.currentThread().isInterrupted()) {
            throw HyracksDataException.create((Throwable)new InterruptedException());
        }
    }
}

