/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.common.data.partition.range;

import java.io.Serializable;
import java.util.Arrays;

public class RangeMap
implements Serializable {
    private static final long serialVersionUID = -7523433293419648234L;
    private final int fields;
    private final byte[] bytes;
    private final int[] endOffsets;

    public RangeMap(int numFields, byte[] bytes, int[] endOffsets) {
        this.fields = numFields;
        this.bytes = bytes;
        this.endOffsets = endOffsets;
    }

    public int getSplitCount() {
        return this.endOffsets.length / this.fields;
    }

    public byte[] getByteArray() {
        return this.bytes;
    }

    public int getTag(int fieldIndex, int splitIndex) {
        return this.getSplitValueTag(this.getSplitValueIndex(fieldIndex, splitIndex));
    }

    public int getStartOffset(int fieldIndex, int splitIndex) {
        return this.getSplitValueStart(this.getSplitValueIndex(fieldIndex, splitIndex));
    }

    public int getLength(int fieldIndex, int splitIndex) {
        return this.getSplitValueLength(this.getSplitValueIndex(fieldIndex, splitIndex));
    }

    private int getSplitValueIndex(int fieldIndex, int splitIndex) {
        return splitIndex * this.fields + fieldIndex;
    }

    private int getSplitValueTag(int splitValueIndex) {
        return this.bytes[this.getSplitValueStart(splitValueIndex)];
    }

    private int getSplitValueStart(int splitValueIndex) {
        int start = 0;
        if (splitValueIndex != 0) {
            start = this.endOffsets[splitValueIndex - 1];
        }
        return start;
    }

    private int getSplitValueLength(int splitValueIndex) {
        int length = this.endOffsets[splitValueIndex];
        if (splitValueIndex != 0) {
            length -= this.endOffsets[splitValueIndex - 1];
        }
        return length;
    }

    public int hashCode() {
        return this.fields + Arrays.hashCode(this.bytes) + Arrays.hashCode(this.endOffsets);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RangeMap)) {
            return false;
        }
        RangeMap other = (RangeMap)object;
        return this.fields == other.fields && Arrays.equals(this.endOffsets, other.endOffsets) && Arrays.equals(this.bytes, other.bytes);
    }

    public String toString() {
        return "{SPLIT:" + this.getSplitCount() + '}';
    }
}

