/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.transactions;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.CRC32;
import org.apache.asterix.common.context.PrimaryIndexOperationTracker;
import org.apache.asterix.common.transactions.ILogMarkerCallback;
import org.apache.asterix.common.transactions.ILogRecord;
import org.apache.asterix.common.transactions.ILogRequester;
import org.apache.asterix.common.transactions.ITransactionContext;
import org.apache.asterix.common.transactions.LogSource;
import org.apache.asterix.common.transactions.LogType;
import org.apache.asterix.common.transactions.PrimaryKeyTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleReference;
import org.apache.hyracks.storage.am.common.tuples.SimpleTupleReferenceV0;
import org.apache.hyracks.storage.am.common.tuples.SimpleTupleWriter;

public class LogRecord
implements ILogRecord {
    private int version = 1;
    private byte logSource = 0;
    private byte logType;
    private long txnId;
    private int datasetId;
    private int pKHashValue;
    private int pKValueSize;
    private ITupleReference pKValue;
    private long resourceId;
    private int resourcePartition;
    private int logSize;
    private int newValueFieldCount;
    private byte newOp;
    private int newValueSize;
    private ITupleReference newValue;
    private int oldValueSize;
    private ITupleReference oldValue;
    private int oldValueFieldCount;
    private long checksum;
    private long prevMarkerLSN;
    private ByteBuffer marker;
    private long flushingComponentMinId;
    private long flushingComponentMaxId;
    private final ILogMarkerCallback callback;
    private int pKFieldCnt;
    private ITransactionContext txnCtx;
    private volatile long LSN;
    private final AtomicBoolean isFlushed;
    private final PrimaryKeyTupleReference readPKValue;
    private final ITreeIndexTupleReference readNewValue;
    private final ITreeIndexTupleReference readOldValue;
    private ITreeIndexTupleReference readNewValueV0;
    private ITreeIndexTupleReference readOldValueV0;
    private final CRC32 checksumGen;
    private int[] pKFields;
    private PrimaryIndexOperationTracker opTracker;
    private final AtomicBoolean replicated;
    private boolean replicate = false;
    private ILogRequester requester;

    public LogRecord(ILogMarkerCallback callback) {
        this.callback = callback;
        this.isFlushed = new AtomicBoolean(false);
        this.replicated = new AtomicBoolean(false);
        this.readPKValue = new PrimaryKeyTupleReference();
        this.readNewValue = SimpleTupleWriter.INSTANCE.createTupleReference();
        this.readOldValue = SimpleTupleWriter.INSTANCE.createTupleReference();
        this.checksumGen = new CRC32();
    }

    public LogRecord() {
        this(null);
    }

    private void doWriteLogRecord(ByteBuffer buffer) {
        buffer.put((byte)(this.version << 2 | this.logSource & 0xFF));
        buffer.put(this.logType);
        buffer.putLong(this.txnId);
        switch (this.logType) {
            case 2: {
                this.writeEntityResource(buffer);
                this.writeEntityValue(buffer);
                break;
            }
            case 0: {
                this.writeEntityResource(buffer);
                this.writeEntityValue(buffer);
                buffer.putLong(this.resourceId);
                buffer.putInt(this.logSize);
                buffer.putInt(this.newValueFieldCount);
                buffer.put(this.newOp);
                buffer.putInt(this.newValueSize);
                this.writeTuple(buffer, this.newValue, this.newValueSize);
                if (this.oldValueSize <= 0) break;
                buffer.putInt(this.oldValueSize);
                buffer.putInt(this.oldValueFieldCount);
                this.writeTuple(buffer, this.oldValue, this.oldValueSize);
                break;
            }
            case 7: {
                this.writeEntityResource(buffer);
                buffer.putLong(this.resourceId);
                buffer.putInt(this.logSize);
                buffer.putInt(this.newValueFieldCount);
                buffer.put(this.newOp);
                buffer.putInt(this.newValueSize);
                this.writeTuple(buffer, this.newValue, this.newValueSize);
                break;
            }
            case 4: {
                buffer.putInt(this.datasetId);
                buffer.putInt(this.resourcePartition);
                buffer.putLong(this.flushingComponentMinId);
                buffer.putLong(this.flushingComponentMaxId);
                break;
            }
            case 8: {
                buffer.putInt(this.datasetId);
                buffer.putInt(this.resourcePartition);
                this.callback.before(buffer);
                buffer.putInt(this.logSize);
                buffer.put(this.marker);
                break;
            }
        }
    }

    private void writeEntityValue(ByteBuffer buffer) {
        buffer.putInt(this.pKHashValue);
        if (this.pKValueSize <= 0) {
            throw new IllegalStateException("Primary Key Size is less than or equal to 0");
        }
        buffer.putInt(this.pKValueSize);
        this.writePKValue(buffer);
    }

    private void writeEntityResource(ByteBuffer buffer) {
        buffer.putInt(this.resourcePartition);
        buffer.putInt(this.datasetId);
    }

    @Override
    public void writeLogRecord(ByteBuffer buffer) {
        int beginOffset = buffer.position();
        this.doWriteLogRecord(buffer);
        this.checksum = this.generateChecksum(buffer, beginOffset, this.logSize - 8);
        buffer.putLong(this.checksum);
    }

    @Override
    public void writeRemoteLogRecord(ByteBuffer buffer) {
        this.doWriteLogRecord(buffer);
        if (this.logType == 4) {
            buffer.putLong(this.LSN);
        }
    }

    private void writePKValue(ByteBuffer buffer) {
        if (this.logSource == 0) {
            for (int i = 0; i < this.pKFieldCnt; ++i) {
                buffer.put(this.pKValue.getFieldData(0), this.pKValue.getFieldStart(this.pKFields[i]), this.pKValue.getFieldLength(this.pKFields[i]));
            }
        } else {
            buffer.put(this.pKValue.getFieldData(0), 0, this.pKValueSize);
        }
    }

    private void writeTuple(ByteBuffer buffer, ITupleReference tuple, int size) {
        SimpleTupleWriter.INSTANCE.writeTuple(tuple, buffer.array(), buffer.position());
        buffer.position(buffer.position() + size);
    }

    private long generateChecksum(ByteBuffer buffer, int offset, int len) {
        this.checksumGen.reset();
        this.checksumGen.update(buffer.array(), offset, len);
        return this.checksumGen.getValue();
    }

    @Override
    public ILogRecord.RecordReadStatus readLogRecord(ByteBuffer buffer) {
        int beginOffset = buffer.position();
        ILogRecord.RecordReadStatus status = this.doReadLogRecord(buffer);
        if (status != ILogRecord.RecordReadStatus.OK) {
            buffer.position(beginOffset);
            return status;
        }
        if (buffer.remaining() < 8) {
            buffer.position(beginOffset);
            return ILogRecord.RecordReadStatus.TRUNCATED;
        }
        this.checksum = buffer.getLong();
        if (this.checksum != this.generateChecksum(buffer, beginOffset, this.logSize - 8)) {
            return ILogRecord.RecordReadStatus.BAD_CHKSUM;
        }
        return ILogRecord.RecordReadStatus.OK;
    }

    private ILogRecord.RecordReadStatus doReadLogRecord(ByteBuffer buffer) {
        ITreeIndexTupleReference readNew;
        ITreeIndexTupleReference readOld;
        if (buffer.remaining() < 10) {
            return ILogRecord.RecordReadStatus.TRUNCATED;
        }
        byte logSourceVersion = buffer.get();
        this.logSource = (byte)(logSourceVersion & 3);
        this.version = (byte)((logSourceVersion & 0xFF) >> 2);
        if (this.version == 0) {
            if (this.readOldValueV0 == null) {
                this.readOldValueV0 = new SimpleTupleReferenceV0();
                this.readNewValueV0 = new SimpleTupleReferenceV0();
            }
            readOld = this.readOldValueV0;
            readNew = this.readNewValueV0;
        } else {
            readOld = this.readOldValue;
            readNew = this.readNewValue;
        }
        this.logType = buffer.get();
        this.txnId = buffer.getLong();
        switch (this.logType) {
            case 4: {
                if (buffer.remaining() < 24) {
                    return ILogRecord.RecordReadStatus.TRUNCATED;
                }
                this.datasetId = buffer.getInt();
                this.resourcePartition = buffer.getInt();
                this.flushingComponentMinId = buffer.getLong();
                this.flushingComponentMaxId = buffer.getLong();
                this.resourceId = 0L;
                this.computeAndSetLogSize();
                break;
            }
            case 6: 
            case 9: {
                this.computeAndSetLogSize();
                break;
            }
            case 1: 
            case 3: {
                this.datasetId = -1;
                this.pKHashValue = -1;
                this.computeAndSetLogSize();
                break;
            }
            case 2: {
                if (this.readEntityResource(buffer) && this.readEntityValue(buffer)) {
                    this.computeAndSetLogSize();
                    break;
                }
                return ILogRecord.RecordReadStatus.TRUNCATED;
            }
            case 0: {
                if (this.readEntityResource(buffer) && this.readEntityValue(buffer)) {
                    return this.readUpdateInfo(buffer, readNew, readOld);
                }
                return ILogRecord.RecordReadStatus.TRUNCATED;
            }
            case 8: {
                if (buffer.remaining() < 20) {
                    return ILogRecord.RecordReadStatus.TRUNCATED;
                }
                this.datasetId = buffer.getInt();
                this.resourcePartition = buffer.getInt();
                this.prevMarkerLSN = buffer.getLong();
                this.logSize = buffer.getInt();
                int lenRemaining = this.logSize - 38;
                if (buffer.remaining() < lenRemaining) {
                    return ILogRecord.RecordReadStatus.TRUNCATED;
                }
                if (this.marker == null || this.marker.capacity() < lenRemaining) {
                    this.marker = ByteBuffer.allocate(lenRemaining + 2);
                }
                this.marker.clear();
                buffer.get(this.marker.array(), 0, lenRemaining);
                this.marker.position(lenRemaining);
                this.marker.flip();
                break;
            }
            case 7: {
                if (this.readEntityResource(buffer)) {
                    return this.readUpdateInfo(buffer, readNew, readOld);
                }
                return ILogRecord.RecordReadStatus.TRUNCATED;
            }
        }
        return ILogRecord.RecordReadStatus.OK;
    }

    private boolean readEntityValue(ByteBuffer buffer) {
        if (buffer.remaining() < 8) {
            return false;
        }
        this.pKHashValue = buffer.getInt();
        this.pKValueSize = buffer.getInt();
        if (buffer.remaining() < this.pKValueSize) {
            return false;
        }
        if (this.pKValueSize <= 0) {
            throw new IllegalStateException("Primary Key Size is less than or equal to 0");
        }
        this.pKValue = this.readPKValue(buffer);
        return true;
    }

    private boolean readEntityResource(ByteBuffer buffer) {
        if (buffer.remaining() < 8) {
            return false;
        }
        this.resourcePartition = buffer.getInt();
        this.datasetId = buffer.getInt();
        return true;
    }

    private ILogRecord.RecordReadStatus readUpdateInfo(ByteBuffer buffer, ITreeIndexTupleReference newRead, ITreeIndexTupleReference oldRead) {
        if (buffer.remaining() < 21) {
            return ILogRecord.RecordReadStatus.TRUNCATED;
        }
        this.resourceId = buffer.getLong();
        this.logSize = buffer.getInt();
        this.newValueFieldCount = buffer.getInt();
        this.newOp = buffer.get();
        this.newValueSize = buffer.getInt();
        if (buffer.remaining() < this.newValueSize) {
            if (this.logSize > buffer.capacity()) {
                return ILogRecord.RecordReadStatus.LARGE_RECORD;
            }
            return ILogRecord.RecordReadStatus.TRUNCATED;
        }
        this.newValue = LogRecord.readTuple(buffer, newRead, this.newValueFieldCount, this.newValueSize);
        if (this.logSize > this.getUpdateLogSizeWithoutOldValue()) {
            if (buffer.remaining() < 4) {
                return ILogRecord.RecordReadStatus.TRUNCATED;
            }
            this.oldValueSize = buffer.getInt();
            if (buffer.remaining() < 4) {
                return ILogRecord.RecordReadStatus.TRUNCATED;
            }
            this.oldValueFieldCount = buffer.getInt();
            if (buffer.remaining() < this.oldValueSize) {
                return ILogRecord.RecordReadStatus.TRUNCATED;
            }
            this.oldValue = LogRecord.readTuple(buffer, oldRead, this.oldValueFieldCount, this.oldValueSize);
        } else {
            this.oldValueSize = 0;
            this.oldValue = null;
        }
        return ILogRecord.RecordReadStatus.OK;
    }

    @Override
    public void readRemoteLog(ByteBuffer buffer) {
        this.doReadLogRecord(buffer);
        if (this.logType == 4) {
            this.LSN = buffer.getLong();
        }
    }

    private ITupleReference readPKValue(ByteBuffer buffer) {
        if (buffer.position() + this.pKValueSize > buffer.limit()) {
            throw new BufferUnderflowException();
        }
        this.readPKValue.reset(buffer.array(), buffer.position(), this.pKValueSize);
        buffer.position(buffer.position() + this.pKValueSize);
        return this.readPKValue;
    }

    private static ITupleReference readTuple(ByteBuffer srcBuffer, ITreeIndexTupleReference destTuple, int fieldCnt, int size) {
        if (srcBuffer.position() + size > srcBuffer.limit()) {
            throw new BufferUnderflowException();
        }
        destTuple.setFieldCount(fieldCnt);
        destTuple.resetByTupleOffset(srcBuffer.array(), srcBuffer.position());
        srcBuffer.position(srcBuffer.position() + size);
        return destTuple;
    }

    @Override
    public void computeAndSetPKValueSize() {
        this.pKValueSize = 0;
        for (int i = 0; i < this.pKFieldCnt; ++i) {
            this.pKValueSize += this.pKValue.getFieldLength(this.pKFields[i]);
        }
    }

    private void setUpdateLogSize() {
        this.logSize = this.getUpdateLogSizeWithoutOldValue();
        if (this.oldValueSize > 0) {
            this.logSize += 8 + this.oldValueSize;
        }
    }

    private int getFilterLogSize() {
        return 47 + this.newValueSize;
    }

    private int getUpdateLogSizeWithoutOldValue() {
        return 55 + this.pKValueSize + this.newValueSize;
    }

    @Override
    public void computeAndSetLogSize() {
        switch (this.logType) {
            case 0: {
                this.setUpdateLogSize();
                break;
            }
            case 1: 
            case 3: {
                this.logSize = 18;
                break;
            }
            case 2: {
                this.logSize = 34 + this.pKValueSize;
                break;
            }
            case 4: {
                this.logSize = 42;
                break;
            }
            case 6: 
            case 9: {
                this.logSize = 18;
                break;
            }
            case 7: {
                this.logSize = this.getFilterLogSize();
                break;
            }
            case 8: {
                this.setMarkerLogSize();
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported Log Type");
            }
        }
    }

    private void setMarkerLogSize() {
        this.logSize = 38 + this.marker.remaining();
    }

    @Override
    public String getLogRecordForDisplay() {
        StringBuilder builder = new StringBuilder();
        builder.append(" Source : ").append(LogSource.toString(this.logSource));
        builder.append(" LSN : ").append(this.LSN);
        builder.append(" LogType : ").append(LogType.toString(this.logType));
        builder.append(" LogSize : ").append(this.logSize);
        builder.append(" TxnId : ").append(this.txnId);
        if (this.logType == 2 || this.logType == 0) {
            builder.append(" DatasetId : ").append(this.datasetId);
            builder.append(" ResourcePartition : ").append(this.resourcePartition);
            builder.append(" PKHashValue : ").append(this.pKHashValue);
            builder.append(" PKFieldCnt : ").append(this.pKFieldCnt);
            builder.append(" PKSize: ").append(this.pKValueSize);
        }
        if (this.logType == 0) {
            builder.append(" ResourceId : ").append(this.resourceId);
        }
        builder.append(" Version : ").append(this.version);
        return builder.toString();
    }

    @Override
    public ITransactionContext getTxnCtx() {
        return this.txnCtx;
    }

    @Override
    public void setTxnCtx(ITransactionContext txnCtx) {
        this.txnCtx = txnCtx;
    }

    @Override
    public boolean isFlushed() {
        return this.isFlushed.get();
    }

    @Override
    public void isFlushed(boolean isFlushed) {
        this.isFlushed.set(isFlushed);
    }

    @Override
    public byte getLogType() {
        return this.logType;
    }

    @Override
    public void setLogType(byte logType) {
        this.logType = logType;
    }

    @Override
    public long getTxnId() {
        return this.txnId;
    }

    @Override
    public void setTxnId(long txnId) {
        this.txnId = txnId;
    }

    @Override
    public int getDatasetId() {
        return this.datasetId;
    }

    @Override
    public void setDatasetId(int datasetId) {
        this.datasetId = datasetId;
    }

    @Override
    public int getPKHashValue() {
        return this.pKHashValue;
    }

    @Override
    public void setPKHashValue(int pKHashValue) {
        this.pKHashValue = pKHashValue;
    }

    @Override
    public long getResourceId() {
        return this.resourceId;
    }

    @Override
    public void setResourceId(long resourceId) {
        this.resourceId = resourceId;
    }

    @Override
    public int getLogSize() {
        return this.logSize;
    }

    @Override
    public int getRemoteLogSize() {
        int remoteLogSize = this.logSize;
        if (this.logType == 4) {
            remoteLogSize += 8;
        }
        return remoteLogSize -= 8;
    }

    @Override
    public void setLogSize(int logSize) {
        this.logSize = logSize;
    }

    @Override
    public byte getNewOp() {
        return this.newOp;
    }

    @Override
    public void setNewOp(byte newOp) {
        this.newOp = newOp;
    }

    @Override
    public void setNewValueSize(int newValueSize) {
        this.newValueSize = newValueSize;
    }

    @Override
    public ITupleReference getNewValue() {
        return this.newValue;
    }

    @Override
    public void setNewValue(ITupleReference newValue) {
        this.newValue = newValue;
        this.newValueFieldCount = newValue.getFieldCount();
    }

    @Override
    public long getChecksum() {
        return this.checksum;
    }

    @Override
    public void setChecksum(long checksum) {
        this.checksum = checksum;
    }

    @Override
    public long getLSN() {
        return this.LSN;
    }

    @Override
    public void setLSN(long LSN) {
        this.LSN = LSN;
    }

    @Override
    public int getPKValueSize() {
        return this.pKValueSize;
    }

    @Override
    public ITupleReference getPKValue() {
        return this.pKValue;
    }

    @Override
    public void setPKFields(int[] primaryKeyFields) {
        this.pKFields = primaryKeyFields;
        this.pKFieldCnt = this.pKFields.length;
    }

    @Override
    public void setPKValue(ITupleReference pKValue) {
        this.pKValue = pKValue;
    }

    public PrimaryIndexOperationTracker getOpTracker() {
        return this.opTracker;
    }

    @Override
    public void setLogSource(byte logSource) {
        if (logSource < 0) {
            throw new IllegalArgumentException("logSource underflow: " + logSource);
        }
        if (logSource > 3) {
            throw new IllegalArgumentException("logSource overflow: " + logSource);
        }
        this.logSource = logSource;
    }

    @Override
    public byte getLogSource() {
        return this.logSource;
    }

    public void setPKFieldCnt(int pKFieldCnt) {
        this.pKFieldCnt = pKFieldCnt;
    }

    public void setOpTracker(PrimaryIndexOperationTracker opTracker) {
        this.opTracker = opTracker;
    }

    @Override
    public int getResourcePartition() {
        return this.resourcePartition;
    }

    @Override
    public void setResourcePartition(int resourcePartition) {
        this.resourcePartition = resourcePartition;
    }

    @Override
    public void setReplicated(boolean replicated) {
        this.replicated.set(replicated);
    }

    @Override
    public boolean isReplicated() {
        return this.replicated.get();
    }

    @Override
    public ITupleReference getOldValue() {
        return this.oldValue;
    }

    @Override
    public void setOldValue(ITupleReference oldValue) {
        this.oldValue = oldValue;
        this.oldValueFieldCount = oldValue.getFieldCount();
    }

    @Override
    public void setOldValueSize(int oldValueSize) {
        this.oldValueSize = oldValueSize;
    }

    public void setMarker(ByteBuffer marker) {
        this.marker = marker;
    }

    @Override
    public boolean isMarker() {
        return this.logType == 8;
    }

    @Override
    public void logAppended(long lsn) {
        this.callback.after(lsn);
    }

    @Override
    public long getPreviousMarkerLSN() {
        return this.prevMarkerLSN;
    }

    @Override
    public ByteBuffer getMarker() {
        return this.marker;
    }

    @Override
    public void setReplicate(boolean replicate) {
        this.replicate = replicate;
    }

    @Override
    public boolean isReplicate() {
        return this.replicate;
    }

    public ILogRequester getRequester() {
        return this.requester;
    }

    public void setRequester(ILogRequester requester) {
        this.requester = requester;
    }

    @Override
    public long getFlushingComponentMinId() {
        return this.flushingComponentMinId;
    }

    @Override
    public void setFlushingComponentMinId(long flushingComponentMinId) {
        this.flushingComponentMinId = flushingComponentMinId;
    }

    @Override
    public long getFlushingComponentMaxId() {
        return this.flushingComponentMaxId;
    }

    @Override
    public void setFlushingComponentMaxId(long flushingComponentMaxId) {
        this.flushingComponentMaxId = flushingComponentMaxId;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(int version) {
        if (version < 0) {
            throw new IllegalArgumentException("version underflow: " + version);
        }
        if (version > 62) {
            throw new IllegalArgumentException("version overflow: " + version);
        }
        this.version = (byte)version;
    }
}

