/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.function;

import com.teradata.tpcds.Results;
import com.teradata.tpcds.Session;
import com.teradata.tpcds.Table;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.asterix.app.function.FunctionReader;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.external.api.IRawRecord;
import org.apache.asterix.external.input.record.CharArrayRecord;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class TPCDSDataGeneratorReader
extends FunctionReader {
    private final FunctionIdentifier functionIdentifier;
    private static final String TABLE_NAME_FIELD_NAME = "table_name";
    private static final int PARENT_VALUES_INDEX = 0;
    private static final int CHILD_VALUES_INDEX = 1;
    private final List<Table> selectedTables;
    private final StringBuilder builder = new StringBuilder();
    private final List<Iterator<List<List<String>>>> tableIterators = new ArrayList<Iterator<List<List<String>>>>();
    private Table currentTable;
    private final int tableCount;
    private int currentTableIndex;
    private String childRow = null;
    private boolean getFromParent = true;
    private final boolean generateAllTables;

    TPCDSDataGeneratorReader(String tableName, double scalingFactor, int parallelism, int partitionNumber, FunctionIdentifier functionIdentifier) throws HyracksDataException {
        this.functionIdentifier = functionIdentifier;
        Session session = Session.getDefaultSession().withScale(scalingFactor).withParallelism(parallelism).withChunkNumber(partitionNumber + 1);
        this.generateAllTables = tableName == null;
        this.selectedTables = this.getTableFromStringTableName(tableName);
        this.currentTableIndex = 0;
        this.tableCount = this.selectedTables.size();
        this.currentTable = this.selectedTables.get(this.currentTableIndex);
        for (Table table : this.selectedTables) {
            Results result = Results.constructResults((Table)table, (Session)session);
            this.tableIterators.add(result.iterator());
        }
    }

    private List<Table> getTableFromStringTableName(String tableName) throws HyracksDataException {
        if (this.generateAllTables) {
            return Table.getBaseTables().stream().filter(table -> !table.equals((Object)Table.DBGEN_VERSION) && !table.isChild()).collect(Collectors.toList());
        }
        List<Table> matchedTables = Table.getBaseTables().stream().filter(table -> tableName.equalsIgnoreCase(table.getName())).collect(Collectors.toList());
        if (matchedTables.isEmpty()) {
            throw new RuntimeDataException(42, new Serializable[]{this.getFunctionIdentifier().getName(), tableName});
        }
        return matchedTables;
    }

    private FunctionIdentifier getFunctionIdentifier() {
        return this.functionIdentifier;
    }

    public boolean hasNext() {
        if (this.generateAllTables && this.childRow != null) {
            this.getFromParent = false;
            return true;
        }
        if (this.tableIterators.get(this.currentTableIndex).hasNext()) {
            return true;
        }
        if (this.currentTableIndex == this.tableCount - 1) {
            return false;
        }
        ++this.currentTableIndex;
        this.currentTable = this.selectedTables.get(this.currentTableIndex);
        return this.hasNext();
    }

    public IRawRecord<char[]> next() throws IOException, InterruptedException {
        CharArrayRecord record = new CharArrayRecord();
        if (this.getFromParent) {
            record.append(this.formatRecord(this.tableIterators.get(this.currentTableIndex).next()).toCharArray());
        } else {
            record.append(this.childRow.toCharArray());
            this.childRow = null;
            this.getFromParent = true;
        }
        record.endRecord();
        return record;
    }

    private String formatRecord(List<List<String>> values) {
        this.builder.setLength(0);
        this.constructRecord(values.get(0), this.currentTable);
        String parentRow = this.builder.toString();
        if (this.generateAllTables && values.size() > 1) {
            this.builder.setLength(0);
            this.constructRecord(values.get(1), this.currentTable.getChild());
            this.childRow = this.builder.toString();
        }
        return parentRow;
    }

    private void constructRecord(List<String> values, Table table) {
        this.builder.append("{\"").append(TABLE_NAME_FIELD_NAME).append("\":\"").append(table.getName()).append("\"");
        block4: for (int counter = 0; counter < values.size(); ++counter) {
            if (values.get(counter) == null) {
                this.builder.append(",\"");
                this.builder.append(table.getColumns()[counter].getName());
                this.builder.append("\":");
                this.builder.append(values.get(counter));
                continue;
            }
            String fieldName = table.getColumns()[counter].getName();
            String stringValue = values.get(counter);
            switch (table.getColumns()[counter].getType().getBase()) {
                case INTEGER: {
                    this.builder.append(",\"").append(fieldName).append("\":").append(Integer.valueOf(stringValue));
                    continue block4;
                }
                case DECIMAL: {
                    this.builder.append(",\"").append(fieldName).append("\":").append(Double.valueOf(stringValue));
                    continue block4;
                }
                default: {
                    this.builder.append(",\"").append(fieldName).append("\":\"").append(stringValue).append("\"");
                }
            }
        }
        this.builder.append("}");
    }
}

