/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.expression;

import java.util.List;
import java.util.Objects;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.lang.common.base.AbstractExpression;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;

public class CallExpr
extends AbstractExpression {
    private FunctionSignature functionSignature;
    private List<Expression> exprList;
    private Expression aggFilterExpr;

    public CallExpr(FunctionSignature functionSignature, List<Expression> exprList) {
        this(functionSignature, exprList, null);
    }

    public CallExpr(FunctionSignature functionSignature, List<Expression> exprList, Expression aggFilterExpr) {
        this.functionSignature = functionSignature;
        this.exprList = exprList;
        this.aggFilterExpr = aggFilterExpr;
    }

    public FunctionSignature getFunctionSignature() {
        return this.functionSignature;
    }

    public List<Expression> getExprList() {
        return this.exprList;
    }

    public boolean hasAggregateFilterExpr() {
        return this.aggFilterExpr != null;
    }

    public Expression getAggregateFilterExpr() {
        return this.aggFilterExpr;
    }

    @Override
    public Expression.Kind getKind() {
        return Expression.Kind.CALL_EXPRESSION;
    }

    public void setFunctionSignature(FunctionSignature functionSignature) {
        this.functionSignature = functionSignature;
    }

    public void setExprList(List<Expression> exprList) {
        this.exprList = exprList;
    }

    public void setAggregateFilterExpr(Expression aggFilterExpr) {
        this.aggFilterExpr = aggFilterExpr;
    }

    @Override
    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return visitor.visit(this, arg);
    }

    public String toString() {
        return "call " + this.functionSignature;
    }

    public int hashCode() {
        return Objects.hash(this.exprList, this.aggFilterExpr, this.functionSignature);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CallExpr)) {
            return false;
        }
        CallExpr target = (CallExpr)object;
        return Objects.equals(this.exprList, target.exprList) && Objects.equals(this.aggFilterExpr, target.aggFilterExpr) && Objects.equals(this.functionSignature, target.functionSignature);
    }
}

