/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.rewrites;

import java.util.HashMap;
import java.util.Map;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.hyracks.algebricks.core.algebra.base.Counter;
import org.apache.hyracks.api.exceptions.IWarningCollector;

public final class LangRewritingContext {
    private final IWarningCollector warningCollector;
    private Counter varCounter;
    private int systemVarCounter = 1;
    private Map<Integer, VarIdentifier> oldVarIdToNewVarId = new HashMap<Integer, VarIdentifier>();

    public LangRewritingContext(int varCounter, IWarningCollector warningCollector) {
        this.varCounter = new Counter(varCounter);
        this.warningCollector = warningCollector;
    }

    public Counter getVarCounter() {
        return this.varCounter;
    }

    public VarIdentifier mapOldId(Integer oldId, String varValue) {
        int n = this.increaseAndGetCtr();
        VarIdentifier newVar = new VarIdentifier(varValue);
        newVar.setId(n);
        this.oldVarIdToNewVarId.put(oldId, newVar);
        return newVar;
    }

    public VarIdentifier getRewrittenVar(Integer oldId) {
        return this.oldVarIdToNewVarId.get(oldId);
    }

    public VarIdentifier newVariable() {
        int id = this.increaseAndGetCtr();
        return new VarIdentifier("#" + this.systemVarCounter++, id);
    }

    private int increaseAndGetCtr() {
        this.varCounter.inc();
        return this.varCounter.get();
    }

    public IWarningCollector getWarningCollector() {
        return this.warningCollector;
    }
}

