/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.dataflow;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameTupleAppender;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IMissingWriter;
import org.apache.hyracks.api.dataflow.value.IMissingWriterFactory;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.util.GrowableArray;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryInputUnaryOutputOperatorNodePushable;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.IBinaryTokenizer;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.IToken;

public class BinaryTokenizerOperatorNodePushable
extends AbstractUnaryInputUnaryOutputOperatorNodePushable {
    private final IHyracksTaskContext ctx;
    private final IBinaryTokenizer tokenizer;
    private final int docField;
    private final int[] keyFields;
    private final boolean addNumTokensKey;
    private final boolean writeKeyFieldsFirst;
    private final RecordDescriptor inputRecDesc;
    private final RecordDescriptor outputRecDesc;
    private final boolean writeMissing;
    private final IMissingWriter missingWriter;
    private final FrameTupleReference tuple = new FrameTupleReference();
    private FrameTupleAccessor accessor;
    private ArrayTupleBuilder builder;
    private GrowableArray builderData;
    private FrameTupleAppender appender;

    public BinaryTokenizerOperatorNodePushable(IHyracksTaskContext ctx, RecordDescriptor inputRecDesc, RecordDescriptor outputRecDesc, IBinaryTokenizer tokenizer, int docField, int[] keyFields, boolean addNumTokensKey, boolean writeKeyFieldsFirst, boolean writeMissing, IMissingWriterFactory missingWriterFactory) {
        this.ctx = ctx;
        this.tokenizer = tokenizer;
        this.docField = docField;
        this.keyFields = keyFields;
        this.addNumTokensKey = addNumTokensKey;
        this.inputRecDesc = inputRecDesc;
        this.outputRecDesc = outputRecDesc;
        this.writeKeyFieldsFirst = writeKeyFieldsFirst;
        this.writeMissing = writeMissing;
        this.missingWriter = missingWriterFactory.createMissingWriter();
    }

    public void open() throws HyracksDataException {
        this.writer.open();
        this.accessor = new FrameTupleAccessor(this.inputRecDesc);
        this.builder = new ArrayTupleBuilder(this.outputRecDesc.getFieldCount());
        this.builderData = this.builder.getFieldData();
        this.appender = new FrameTupleAppender((IFrame)new VSizeFrame((IHyracksFrameMgrContext)this.ctx), true);
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.accessor.reset(buffer);
        int tupleCount = this.accessor.getTupleCount();
        for (int i = 0; i < tupleCount; ++i) {
            this.tuple.reset((IFrameTupleAccessor)this.accessor, i);
            short numTokens = 0;
            if (!this.isDocFieldMissing((ITupleReference)this.tuple)) {
                this.tokenizer.reset(this.tuple.getFieldData(this.docField), this.tuple.getFieldStart(this.docField), this.tuple.getFieldLength(this.docField));
                if (this.addNumTokensKey) {
                    numTokens = this.tokenizer.getTokensCount();
                }
                while (this.tokenizer.hasNext()) {
                    this.tokenizer.next();
                    IToken token = this.tokenizer.getToken();
                    this.writeTuple(token, numTokens, i);
                }
                continue;
            }
            if (!this.writeMissing) continue;
            this.writeTuple(null, 0, i);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void writeTuple(IToken token, int numTokens, int fieldIdx) throws HyracksDataException {
        this.builder.reset();
        if (!this.writeKeyFieldsFirst) {
            try {
                if (token != null) {
                    token.serializeToken(this.builderData);
                    this.builder.addFieldEndOffset();
                } else {
                    this.missingWriter.writeMissing(this.builder.getDataOutput());
                    this.builder.addFieldEndOffset();
                }
                if (this.addNumTokensKey) {
                    this.builder.getDataOutput().writeShort(numTokens);
                    this.builder.addFieldEndOffset();
                }
            }
            catch (IOException e) {
                throw HyracksDataException.create((Throwable)e);
            }
            for (k = 0; k < this.keyFields.length; ++k) {
                this.builder.addField((IFrameTupleAccessor)this.accessor, fieldIdx, this.keyFields[k]);
            }
        } else {
            for (k = 0; k < this.keyFields.length; ++k) {
                this.builder.addField((IFrameTupleAccessor)this.accessor, fieldIdx, this.keyFields[k]);
            }
            try {
                if (token != null) {
                    token.serializeToken(this.builderData);
                    this.builder.addFieldEndOffset();
                } else {
                    this.missingWriter.writeMissing(this.builder.getDataOutput());
                    this.builder.addFieldEndOffset();
                }
                if (!this.addNumTokensKey) ** GOTO lbl36
                this.builder.getDataOutput().writeShort(numTokens);
                this.builder.addFieldEndOffset();
            }
            catch (IOException e) {
                throw HyracksDataException.create((Throwable)e);
            }
        }
lbl36:
        // 3 sources

        FrameUtils.appendToWriter((IFrameWriter)this.writer, (IFrameTupleAppender)this.appender, (int[])this.builder.getFieldEndOffsets(), (byte[])this.builder.getByteArray(), (int)0, (int)this.builder.getSize());
    }

    public void close() throws HyracksDataException {
        try {
            this.appender.write(this.writer, true);
        }
        finally {
            this.writer.close();
        }
    }

    public void fail() throws HyracksDataException {
        this.writer.fail();
    }

    public void flush() throws HyracksDataException {
        this.appender.flush(this.writer);
    }

    private boolean isDocFieldMissing(ITupleReference tuple) {
        return tuple.getFieldLength(this.docField) <= 1;
    }
}

