/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.work;

import java.util.List;
import org.apache.hyracks.api.dataflow.TaskAttemptId;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.result.IResultPartitionManager;
import org.apache.hyracks.api.util.ExceptionUtils;
import org.apache.hyracks.control.common.work.AbstractWork;
import org.apache.hyracks.control.nc.NodeControllerService;
import org.apache.hyracks.control.nc.Task;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NotifyTaskFailureWork
extends AbstractWork {
    private static final Logger LOGGER = LogManager.getLogger();
    private final NodeControllerService ncs;
    private final Task task;
    private final JobId jobId;
    private final TaskAttemptId taskId;
    private final List<Exception> exceptions;

    public NotifyTaskFailureWork(NodeControllerService ncs, Task task, List<Exception> exceptions, JobId jobId, TaskAttemptId taskId) {
        this.ncs = ncs;
        this.task = task;
        this.exceptions = exceptions;
        this.jobId = jobId;
        this.taskId = taskId;
    }

    public void run() {
        Exception ex = this.exceptions.get(0);
        LOGGER.log(ExceptionUtils.causedByInterrupt((Throwable)ex) ? Level.DEBUG : Level.WARN, "task " + this.taskId + " has failed", (Throwable)ex);
        try {
            IResultPartitionManager resultPartitionManager = this.ncs.getResultPartitionManager();
            if (resultPartitionManager != null) {
                resultPartitionManager.abortReader(this.jobId);
            }
            this.ncs.getClusterController(this.jobId.getCcId()).notifyTaskFailure(this.jobId, this.taskId, this.ncs.getId(), this.exceptions);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Failure reporting task failure to cluster controller", (Throwable)e);
        }
        if (this.task != null) {
            this.task.getJoblet().removeTask(this.task);
        }
    }

    public String toString() {
        return this.getName() + ": [" + this.ncs.getId() + "[" + this.jobId + ":" + this.taskId + "]";
    }
}

