/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.lock;

import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.asterix.common.exceptions.MetadataException;
import org.apache.asterix.common.metadata.IMetadataLock;
import org.apache.asterix.metadata.lock.MetadataLockKey;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.util.InvokeUtil;

public class DatasetLock
implements IMetadataLock {
    private final MetadataLockKey key;
    private final ReentrantReadWriteLock lock;
    private final ReentrantReadWriteLock upgradeLock;
    private final ReentrantReadWriteLock modifyLock;
    private final MutableInt indexBuildCounter;
    private final MutableInt dsModifyCounter;

    public DatasetLock(MetadataLockKey key) {
        this.key = key;
        this.lock = new ReentrantReadWriteLock(true);
        this.upgradeLock = new ReentrantReadWriteLock(true);
        this.modifyLock = new ReentrantReadWriteLock(true);
        this.indexBuildCounter = new MutableInt(0);
        this.dsModifyCounter = new MutableInt(0);
    }

    private void readLock() {
        this.lock.readLock().lock();
    }

    private void readUnlock() {
        this.lock.readLock().unlock();
    }

    private void writeLock() {
        this.lock.writeLock().lock();
    }

    private void writeUnlock() {
        this.lock.writeLock().unlock();
    }

    private void upgradeReadLock() {
        this.upgradeLock.readLock().lock();
    }

    private void modifyReadLock() {
        this.modifyLock.readLock().lock();
        this.incrementModifyCounter();
    }

    private void incrementModifyCounter() {
        InvokeUtil.doUninterruptibly(() -> {
            MutableInt mutableInt = this.indexBuildCounter;
            synchronized (mutableInt) {
                while (this.indexBuildCounter.getValue() > 0) {
                    this.indexBuildCounter.wait();
                }
                MutableInt mutableInt2 = this.dsModifyCounter;
                synchronized (mutableInt2) {
                    this.dsModifyCounter.increment();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementModifyCounter() {
        MutableInt mutableInt = this.indexBuildCounter;
        synchronized (mutableInt) {
            MutableInt mutableInt2 = this.dsModifyCounter;
            synchronized (mutableInt2) {
                if (this.dsModifyCounter.decrementAndGet() == 0) {
                    this.indexBuildCounter.notifyAll();
                }
            }
        }
    }

    private void modifyReadUnlock() {
        this.decrementModifyCounter();
        this.modifyLock.readLock().unlock();
    }

    private void upgradeReadUnlock() {
        this.upgradeLock.readLock().unlock();
    }

    private void upgradeWriteUnlock() {
        this.upgradeLock.writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildIndexLock() {
        MutableInt mutableInt = this.indexBuildCounter;
        synchronized (mutableInt) {
            if (this.indexBuildCounter.getValue() > 0) {
                this.indexBuildCounter.increment();
            } else {
                InvokeUtil.doUninterruptibly(() -> {
                    while (true) {
                        MutableInt mutableInt = this.dsModifyCounter;
                        synchronized (mutableInt) {
                            if (this.dsModifyCounter.getValue() == 0) {
                                this.indexBuildCounter.increment();
                                return;
                            }
                        }
                        this.indexBuildCounter.wait();
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildIndexUnlock() {
        MutableInt mutableInt = this.indexBuildCounter;
        synchronized (mutableInt) {
            if (this.indexBuildCounter.decrementAndGet() == 0) {
                this.indexBuildCounter.notifyAll();
            }
        }
    }

    private void modifyWriteLock() {
        this.modifyLock.writeLock().lock();
        this.incrementModifyCounter();
    }

    private void modifyExclusiveWriteUnlock() {
        this.decrementModifyCounter();
        this.modifyLock.writeLock().unlock();
    }

    public void upgrade(IMetadataLock.Mode from, IMetadataLock.Mode to) throws AlgebricksException {
        if (from != IMetadataLock.Mode.EXCLUSIVE_MODIFY || to != IMetadataLock.Mode.UPGRADED_WRITE) {
            throw new MetadataException(1045, new Serializable[]{from, to});
        }
        this.upgradeLock.writeLock().lock();
    }

    public void downgrade(IMetadataLock.Mode from, IMetadataLock.Mode to) throws AlgebricksException {
        if (from != IMetadataLock.Mode.UPGRADED_WRITE || to != IMetadataLock.Mode.EXCLUSIVE_MODIFY) {
            throw new MetadataException(1046, new Serializable[]{from, to});
        }
        this.upgradeLock.writeLock().unlock();
    }

    public void lock(IMetadataLock.Mode mode) {
        switch (mode) {
            case INDEX_BUILD: {
                this.readLock();
                this.buildIndexLock();
                break;
            }
            case MODIFY: {
                this.readLock();
                this.modifyReadLock();
                break;
            }
            case EXCLUSIVE_MODIFY: {
                this.readLock();
                this.modifyWriteLock();
                break;
            }
            case WRITE: {
                this.writeLock();
                break;
            }
            case READ: {
                this.readLock();
                this.upgradeReadLock();
                break;
            }
            default: {
                throw new IllegalStateException("locking mode " + mode + " is not supported");
            }
        }
    }

    public void unlock(IMetadataLock.Mode mode) {
        switch (mode) {
            case INDEX_BUILD: {
                this.buildIndexUnlock();
                this.readUnlock();
                break;
            }
            case MODIFY: {
                this.modifyReadUnlock();
                this.readUnlock();
                break;
            }
            case EXCLUSIVE_MODIFY: {
                this.modifyExclusiveWriteUnlock();
                this.readUnlock();
                break;
            }
            case WRITE: {
                this.writeUnlock();
                break;
            }
            case READ: {
                this.upgradeReadUnlock();
                this.readUnlock();
                break;
            }
            case UPGRADED_WRITE: {
                this.upgradeWriteUnlock();
                this.modifyExclusiveWriteUnlock();
                this.readUnlock();
                break;
            }
            default: {
                throw new IllegalStateException("unlocking mode " + mode + " is not supported");
            }
        }
    }

    public MetadataLockKey getKey() {
        return this.key;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof DatasetLock)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        return Objects.equals(this.key, ((DatasetLock)o).key);
    }

    public String toString() {
        return String.valueOf(this.key);
    }
}

