/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.http.server;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.server.utils.HttpUtil;

public class BaseRequest
implements IServletRequest {
    protected final FullHttpRequest request;
    protected final Map<String, List<String>> parameters;
    protected final InetSocketAddress remoteAddress;
    protected final HttpScheme scheme;
    protected final InetSocketAddress localAddress;

    public static IServletRequest create(ChannelHandlerContext ctx, FullHttpRequest request, HttpScheme scheme) {
        QueryStringDecoder decoder = new QueryStringDecoder(request.uri());
        Map param = decoder.parameters();
        InetSocketAddress remoteAddress = (InetSocketAddress)ctx.channel().remoteAddress();
        InetSocketAddress localAddress = (InetSocketAddress)ctx.channel().localAddress();
        return new BaseRequest(request, localAddress, remoteAddress, param, scheme);
    }

    protected BaseRequest(FullHttpRequest request, InetSocketAddress localAddress, InetSocketAddress remoteAddress, Map<String, List<String>> parameters, HttpScheme scheme) {
        this.request = request;
        this.localAddress = localAddress;
        this.remoteAddress = remoteAddress;
        this.parameters = parameters;
        this.scheme = scheme;
    }

    @Override
    public FullHttpRequest getHttpRequest() {
        return this.request;
    }

    @Override
    public String getParameter(CharSequence name) {
        return HttpUtil.getParameter(this.parameters, name);
    }

    @Override
    public List<String> getParameterValues(CharSequence name) {
        List<String> values = this.parameters.get(String.valueOf(name));
        return values != null ? Collections.unmodifiableList(values) : null;
    }

    @Override
    public Set<String> getParameterNames() {
        return Collections.unmodifiableSet(this.parameters.keySet());
    }

    @Override
    public Map<String, String> getParameters() {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        for (String name : this.parameters.keySet()) {
            paramMap.put(name, HttpUtil.getParameter(this.parameters, name));
        }
        return Collections.unmodifiableMap(paramMap);
    }

    @Override
    public String getHeader(CharSequence name) {
        return this.request.headers().get(name);
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public HttpScheme getScheme() {
        return this.scheme;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this.localAddress;
    }
}

