/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.dataflow.data.nontagged.comparators;

import java.io.IOException;
import org.apache.asterix.dataflow.data.common.ListAccessorUtil;
import org.apache.asterix.dataflow.data.common.TaggedValueReference;
import org.apache.asterix.dataflow.data.nontagged.comparators.ACirclePartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.ADurationPartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.AGeometryPartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.AIntervalAscPartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.ALinePartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.APoint3DPartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.APointPartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.APolygonPartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.ARectanglePartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.AUUIDPartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.ComparatorUtil;
import org.apache.asterix.dataflow.data.nontagged.serde.ADateSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ADateTimeSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ADayTimeDurationSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ATimeSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AYearMonthDurationSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.SerializerDeserializerUtil;
import org.apache.asterix.om.pointables.nonvisitor.RecordField;
import org.apache.asterix.om.pointables.nonvisitor.SortedRecord;
import org.apache.asterix.om.typecomputer.impl.TypeComputeUtils;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.om.util.container.ListObjectPool;
import org.apache.asterix.om.util.container.ObjectFactories;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.accessors.RawBinaryComparatorFactory;
import org.apache.hyracks.data.std.primitive.BooleanPointable;
import org.apache.hyracks.data.std.primitive.ByteArrayPointable;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;

abstract class AbstractAGenericBinaryComparator
implements IBinaryComparator {
    protected final IAType leftType;
    protected final IAType rightType;
    private final ListObjectPool<SortedRecord, ARecordType> recordPool = new ListObjectPool<SortedRecord, ARecordType>(ObjectFactories.RECORD_FACTORY);
    private final ListObjectPool<TaggedValueReference, Void> taggedValueAllocator = new ListObjectPool<TaggedValueReference, Void>(ObjectFactories.VALUE_FACTORY);

    AbstractAGenericBinaryComparator(IAType leftType, IAType rightType) {
        this.leftType = leftType;
        this.rightType = rightType;
    }

    protected final int compare(IAType leftType, TaggedValueReference leftValue, IAType rightType, TaggedValueReference rightValue) throws HyracksDataException {
        ATypeTag tag1 = leftValue.getTag();
        ATypeTag tag2 = rightValue.getTag();
        if (tag1 == null || tag2 == null) {
            throw new IllegalStateException("Could not recognize the type of data.");
        }
        if (tag1 == ATypeTag.MISSING) {
            return tag2 == ATypeTag.MISSING ? 0 : -1;
        }
        if (tag2 == ATypeTag.MISSING) {
            return 1;
        }
        if (tag1 == ATypeTag.NULL) {
            return tag2 == ATypeTag.NULL ? 0 : -1;
        }
        if (tag2 == ATypeTag.NULL) {
            return 1;
        }
        byte[] b1 = leftValue.getByteArray();
        int s1 = leftValue.getStartOffset();
        int l1 = leftValue.getLength();
        byte[] b2 = rightValue.getByteArray();
        int s2 = rightValue.getStartOffset();
        int l2 = rightValue.getLength();
        if (ATypeHierarchy.isCompatible(tag1, tag2) && ATypeHierarchy.getTypeDomain(tag1) == ATypeHierarchy.Domain.NUMERIC) {
            return ComparatorUtil.compareNumbers(tag1, b1, s1, tag2, b2, s2);
        }
        if (tag1 != tag2) {
            return Byte.compare(tag1.serialize(), tag2.serialize());
        }
        switch (tag1) {
            case STRING: {
                return UTF8StringPointable.compare((byte[])b1, (int)s1, (int)l1, (byte[])b2, (int)s2, (int)l2);
            }
            case UUID: {
                return AUUIDPartialBinaryComparatorFactory.compare(b1, s1, l1, b2, s2, l2);
            }
            case BOOLEAN: {
                return BooleanPointable.compare((byte[])b1, (int)s1, (int)l1, (byte[])b2, (int)s2, (int)l2);
            }
            case TIME: {
                return Integer.compare(ATimeSerializerDeserializer.getChronon(b1, s1), ATimeSerializerDeserializer.getChronon(b2, s2));
            }
            case DATE: {
                return Integer.compare(ADateSerializerDeserializer.getChronon(b1, s1), ADateSerializerDeserializer.getChronon(b2, s2));
            }
            case YEARMONTHDURATION: {
                return Integer.compare(AYearMonthDurationSerializerDeserializer.getYearMonth(b1, s1), AYearMonthDurationSerializerDeserializer.getYearMonth(b2, s2));
            }
            case DATETIME: {
                return Long.compare(ADateTimeSerializerDeserializer.getChronon(b1, s1), ADateTimeSerializerDeserializer.getChronon(b2, s2));
            }
            case DAYTIMEDURATION: {
                return Long.compare(ADayTimeDurationSerializerDeserializer.getDayTime(b1, s1), ADayTimeDurationSerializerDeserializer.getDayTime(b2, s2));
            }
            case RECTANGLE: {
                return ARectanglePartialBinaryComparatorFactory.compare(b1, s1, l1, b2, s2, l2);
            }
            case CIRCLE: {
                return ACirclePartialBinaryComparatorFactory.compare(b1, s1, l1, b2, s2, l2);
            }
            case POINT: {
                return APointPartialBinaryComparatorFactory.compare(b1, s1, l1, b2, s2, l2);
            }
            case POINT3D: {
                return APoint3DPartialBinaryComparatorFactory.compare(b1, s1, l1, b2, s2, l2);
            }
            case LINE: {
                return ALinePartialBinaryComparatorFactory.compare(b1, s1, l1, b2, s2, l2);
            }
            case POLYGON: {
                return APolygonPartialBinaryComparatorFactory.compare(b1, s1, l1, b2, s2, l2);
            }
            case GEOMETRY: {
                return AGeometryPartialBinaryComparatorFactory.compare(b1, s1, l1, b2, s2, l2);
            }
            case DURATION: {
                return ADurationPartialBinaryComparatorFactory.compare(b1, s1, l1, b2, s2, l2);
            }
            case INTERVAL: {
                return this.compareInterval(b1, s1, l1, b2, s2, l2);
            }
            case BINARY: {
                return ByteArrayPointable.compare((byte[])b1, (int)s1, (int)l1, (byte[])b2, (int)s2, (int)l2);
            }
            case ARRAY: {
                return this.compareArrays(leftType, leftValue, rightType, rightValue);
            }
            case OBJECT: {
                return this.compareRecords(leftType, b1, s1, rightType, b2, s2);
            }
        }
        return RawBinaryComparatorFactory.compare((byte[])b1, (int)s1, (int)l1, (byte[])b2, (int)s2, (int)l2);
    }

    protected int compareInterval(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
        return AIntervalAscPartialBinaryComparatorFactory.compare(b1, s1, l1, b2, s2, l2);
    }

    private int compareArrays(IAType leftArrayType, TaggedValueReference leftArray, IAType rightArrayType, TaggedValueReference rightArray) throws HyracksDataException {
        int leftNumItems = SerializerDeserializerUtil.getNumberOfItemsNonTagged(leftArray);
        int rightNumItems = SerializerDeserializerUtil.getNumberOfItemsNonTagged(rightArray);
        IAType leftItemType = ((AbstractCollectionType)TypeComputeUtils.getActualTypeOrOpen(leftArrayType, ATypeTag.ARRAY)).getItemType();
        IAType rightItemType = ((AbstractCollectionType)TypeComputeUtils.getActualTypeOrOpen(rightArrayType, ATypeTag.ARRAY)).getItemType();
        ATypeTag leftArrayItemTag = leftItemType.getTypeTag();
        ATypeTag rightArrayItemTag = rightItemType.getTypeTag();
        TaggedValueReference leftItem = this.taggedValueAllocator.allocate(null);
        TaggedValueReference rightItem = this.taggedValueAllocator.allocate(null);
        boolean leftItemHasTag = leftArrayItemTag == ATypeTag.ANY;
        boolean rightItemHasTag = rightArrayItemTag == ATypeTag.ANY;
        try {
            int i;
            for (i = 0; i < leftNumItems && i < rightNumItems; ++i) {
                ListAccessorUtil.getItemFromList(leftArray, i, leftItem, leftArrayItemTag, leftItemHasTag);
                ListAccessorUtil.getItemFromList(rightArray, i, rightItem, rightArrayItemTag, rightItemHasTag);
                int result = this.compare(leftItemType, leftItem, rightItemType, rightItem);
                if (result == 0) continue;
                int n = result;
                return n;
            }
            i = Integer.compare(leftNumItems, rightNumItems);
            return i;
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
        finally {
            this.taggedValueAllocator.free(rightItem);
            this.taggedValueAllocator.free(leftItem);
        }
    }

    private int compareRecords(IAType leftType, byte[] b1, int s1, IAType rightType, byte[] b2, int s2) throws HyracksDataException {
        ARecordType leftRecordType = (ARecordType)TypeComputeUtils.getActualTypeOrOpen(leftType, ATypeTag.OBJECT);
        ARecordType rightRecordType = (ARecordType)TypeComputeUtils.getActualTypeOrOpen(rightType, ATypeTag.OBJECT);
        SortedRecord leftRecord = this.recordPool.allocate(leftRecordType);
        SortedRecord rightRecord = this.recordPool.allocate(rightRecordType);
        TaggedValueReference leftFieldValue = this.taggedValueAllocator.allocate(null);
        TaggedValueReference rightFieldValue = this.taggedValueAllocator.allocate(null);
        try {
            leftRecord.resetNonTagged(b1, s1);
            rightRecord.resetNonTagged(b2, s2);
            while (!leftRecord.isEmpty() && !rightRecord.isEmpty()) {
                RecordField rightField;
                RecordField leftField = leftRecord.poll();
                int result = RecordField.FIELD_NAME_COMP.compare(leftField, rightField = rightRecord.poll());
                if (result != 0) {
                    int n = result;
                    return n;
                }
                leftRecord.getFieldValue(leftField, leftFieldValue);
                rightRecord.getFieldValue(rightField, rightFieldValue);
                result = this.compare(leftRecord.getFieldType(leftField), leftFieldValue, rightRecord.getFieldType(rightField), rightFieldValue);
                if (result == 0) continue;
                int n = result;
                return n;
            }
            int n = Integer.compare(leftRecord.size(), rightRecord.size());
            return n;
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
        finally {
            this.recordPool.free(rightRecord);
            this.recordPool.free(leftRecord);
            this.taggedValueAllocator.free(rightFieldValue);
            this.taggedValueAllocator.free(leftFieldValue);
        }
    }
}

