/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.aql.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.aql.visitor.AQLFormatPrintVisitor;
import org.apache.asterix.lang.aql.visitor.AQLToSQLPPPrintVisitor;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.base.Statement;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;

public class AQLFormatPrintUtil {
    public static void print(ILangExpression expr, PrintWriter output) throws CompilationException {
        AQLFormatPrintVisitor visitor = new AQLFormatPrintVisitor(output);
        expr.accept((ILangVisitor)visitor, (Object)0);
    }

    public static void print(List<Statement> exprs, PrintWriter output) throws CompilationException {
        AQLFormatPrintVisitor visitor = new AQLFormatPrintVisitor(output);
        for (Statement expr : exprs) {
            expr.accept((ILangVisitor)visitor, (Object)0);
        }
    }

    public static String toString(ILangExpression expr) throws CompilationException {
        ArrayList<ILangExpression> exprs = new ArrayList<ILangExpression>();
        exprs.add(expr);
        return AQLFormatPrintUtil.toString(exprs);
    }

    public static String toString(List<ILangExpression> exprs) throws CompilationException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintWriter output = new PrintWriter(bos);
        AQLFormatPrintVisitor visitor = new AQLFormatPrintVisitor(output);
        for (ILangExpression expr : exprs) {
            expr.accept((ILangVisitor)visitor, (Object)0);
        }
        output.close();
        return bos.toString();
    }

    public static String toSQLPPString(List<Statement> exprs) throws CompilationException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintWriter output = new PrintWriter(bos);
        AQLToSQLPPPrintVisitor visitor = new AQLToSQLPPPrintVisitor(output);
        for (Statement expr : exprs) {
            expr.accept((ILangVisitor)visitor, (Object)0);
        }
        output.close();
        return bos.toString();
    }
}

