/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.utils.ConstantExpressionUtil;
import org.apache.asterix.runtime.evaluators.functions.FullTextContainsDescriptor;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionReferenceTransform;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class FullTextContainsParameterCheckRule
implements IAlgebraicRewriteRule {
    protected FullTextContainsExpressionVisitor ftcontainsExprVisitor = new FullTextContainsExpressionVisitor();

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)opRef.getValue())) {
            return false;
        }
        if (this.checkParameter(opRef, context)) {
            OperatorPropertiesUtil.typeOpRec(opRef, (IOptimizationContext)context);
            return true;
        }
        return false;
    }

    private boolean checkParameter(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        boolean modified = op.acceptExpressionTransform((ILogicalExpressionReferenceTransform)this.ftcontainsExprVisitor);
        if (modified) {
            context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op);
        }
        return modified;
    }

    protected class FullTextContainsExpressionVisitor
    implements ILogicalExpressionReferenceTransform {
        private static final int LAST_EXPRESSION_POS_BEFORE_OPTION = 1;
        private static final int FULLTEXT_QUERY_WITHOUT_OPTION_NO_OF_ARGUMENTS = 2;
        private static final int FULLTEXT_QUERY_WITH_OPTION_NO_OF_ARGUMENTS = 3;

        public boolean transform(Mutable<ILogicalExpression> exprRef) throws AlgebricksException {
            ILogicalExpression e = (ILogicalExpression)exprRef.getValue();
            switch (e.getExpressionTag()) {
                case FUNCTION_CALL: {
                    return this.transformFunctionCallExpression((AbstractFunctionCallExpression)e);
                }
            }
            return false;
        }

        private boolean transformFunctionCallExpression(AbstractFunctionCallExpression fce) throws AlgebricksException {
            boolean modified = false;
            FunctionIdentifier fi = fce.getFunctionIdentifier();
            if (fi != BuiltinFunctions.FULLTEXT_CONTAINS && fi != BuiltinFunctions.FULLTEXT_CONTAINS_WO_OPTION) {
                for (Mutable arg : fce.getArguments()) {
                    if (!this.transform((Mutable<ILogicalExpression>)arg)) continue;
                    modified = true;
                }
            } else {
                modified = this.checkParameterForFuncExpr(fce, fi);
            }
            return modified;
        }

        private boolean checkParameterForFuncExpr(AbstractFunctionCallExpression funcExpr, FunctionIdentifier fi) throws AlgebricksException {
            int numberOfCorrectArguments = 0;
            String functionName = "";
            if (fi == BuiltinFunctions.FULLTEXT_CONTAINS) {
                numberOfCorrectArguments = 3;
                functionName = BuiltinFunctions.FULLTEXT_CONTAINS.getName();
            } else if (fi == BuiltinFunctions.FULLTEXT_CONTAINS_WO_OPTION) {
                numberOfCorrectArguments = 2;
                functionName = BuiltinFunctions.FULLTEXT_CONTAINS_WO_OPTION.getName();
            }
            if (numberOfCorrectArguments > 0) {
                List oldExprs = funcExpr.getArguments();
                ArrayList<Mutable<ILogicalExpression>> newExprs = new ArrayList<Mutable<ILogicalExpression>>();
                if (oldExprs.size() != numberOfCorrectArguments) {
                    throw CompilationException.create((int)1008, (SourceLocation)funcExpr.getSourceLocation(), (Serializable[])new Serializable[]{fi.getName(), Integer.valueOf(oldExprs.size())});
                }
                for (int i = 0; i <= 1; ++i) {
                    newExprs.add((Mutable<ILogicalExpression>)new MutableObject(((Mutable)oldExprs.get(i)).getValue()));
                }
                this.checkFirstAndSecondParamter(oldExprs, functionName);
                if (numberOfCorrectArguments == 3) {
                    this.checkValueForThirdParameter((Mutable<ILogicalExpression>)((Mutable)oldExprs.get(2)), newExprs, functionName);
                } else {
                    this.setDefaultValueForThirdParameter(newExprs);
                }
                funcExpr.getArguments().clear();
                funcExpr.getArguments().addAll(newExprs);
                return true;
            }
            return false;
        }

        private void checkFirstAndSecondParamter(List<Mutable<ILogicalExpression>> exprs, String functionName) throws AlgebricksException {
            ILogicalExpression firstExpr = (ILogicalExpression)exprs.get(0).getValue();
            if (firstExpr.getExpressionTag() == LogicalExpressionTag.CONSTANT && ConstantExpressionUtil.getConstantIaObjectType((ILogicalExpression)firstExpr) != ATypeTag.STRING) {
                throw CompilationException.create((int)4, (SourceLocation)firstExpr.getSourceLocation(), (Serializable[])new Serializable[]{functionName, ConstantExpressionUtil.getConstantIaObjectType((ILogicalExpression)firstExpr)});
            }
            ILogicalExpression secondExpr = (ILogicalExpression)exprs.get(1).getValue();
            if (secondExpr.getExpressionTag() == LogicalExpressionTag.CONSTANT) {
                ATypeTag exprTypeTag = ConstantExpressionUtil.getConstantIaObjectType((ILogicalExpression)secondExpr);
                switch (exprTypeTag) {
                    case STRING: 
                    case MULTISET: 
                    case ARRAY: {
                        break;
                    }
                    default: {
                        throw CompilationException.create((int)4, (SourceLocation)secondExpr.getSourceLocation(), (Serializable[])new Serializable[]{functionName, exprTypeTag});
                    }
                }
            }
        }

        private void checkValueForThirdParameter(Mutable<ILogicalExpression> expr, List<Mutable<ILogicalExpression>> newArgs, String functionName) throws AlgebricksException {
            AbstractFunctionCallExpression openRecConsExpr = (AbstractFunctionCallExpression)expr.getValue();
            FunctionIdentifier openRecConsFi = openRecConsExpr.getFunctionIdentifier();
            if (openRecConsFi != BuiltinFunctions.OPEN_RECORD_CONSTRUCTOR && openRecConsFi != BuiltinFunctions.CLOSED_RECORD_CONSTRUCTOR) {
                throw CompilationException.create((int)4, (SourceLocation)openRecConsExpr.getSourceLocation(), (Serializable[])new Serializable[]{functionName, openRecConsFi});
            }
            if (openRecConsExpr.getArguments().size() > FullTextContainsDescriptor.getParamTypeMap().size() * 2) {
                throw CompilationException.create((int)1056, (SourceLocation)openRecConsExpr.getSourceLocation(), (Serializable[])new Serializable[]{functionName});
            }
            for (int i = 0; i < openRecConsExpr.getArguments().size(); i += 2) {
                ILogicalExpression optionExpr = (ILogicalExpression)((Mutable)openRecConsExpr.getArguments().get(i)).getValue();
                ILogicalExpression optionExprVal = (ILogicalExpression)((Mutable)openRecConsExpr.getArguments().get(i + 1)).getValue();
                String option = ConstantExpressionUtil.getStringConstant((ILogicalExpression)optionExpr);
                if (optionExpr.getExpressionTag() != LogicalExpressionTag.CONSTANT || option == null) {
                    throw CompilationException.create((int)4, (SourceLocation)optionExpr.getSourceLocation(), (Serializable[])new Serializable[]{functionName, optionExpr.getExpressionTag()});
                }
                option = option.toLowerCase();
                if (!FullTextContainsDescriptor.getParamTypeMap().containsKey(option)) {
                    throw CompilationException.create((int)4, (SourceLocation)optionExprVal.getSourceLocation(), (Serializable[])new Serializable[]{functionName, option});
                }
                String optionTypeStringVal = null;
                if (optionExprVal.getExpressionTag() == LogicalExpressionTag.CONSTANT) {
                    switch ((ATypeTag)FullTextContainsDescriptor.getParamTypeMap().get(option)) {
                        case STRING: {
                            optionTypeStringVal = ConstantExpressionUtil.getStringConstant((ILogicalExpression)optionExprVal);
                            if (optionTypeStringVal == null) {
                                throw CompilationException.create((int)4, (SourceLocation)optionExprVal.getSourceLocation(), (Serializable[])new Serializable[]{functionName, option});
                            }
                            optionTypeStringVal = optionTypeStringVal.toLowerCase();
                            break;
                        }
                        default: {
                            throw CompilationException.create((int)4, (SourceLocation)optionExprVal.getSourceLocation(), (Serializable[])new Serializable[]{functionName, option});
                        }
                    }
                    switch (option) {
                        case "mode": {
                            this.checkSearchModeOption(optionTypeStringVal, functionName, optionExprVal.getSourceLocation());
                            break;
                        }
                        default: {
                            throw CompilationException.create((int)4, (SourceLocation)optionExprVal.getSourceLocation(), (Serializable[])new Serializable[]{functionName, option});
                        }
                    }
                }
                newArgs.add((Mutable<ILogicalExpression>)new MutableObject((Object)optionExpr));
                newArgs.add((Mutable<ILogicalExpression>)new MutableObject((Object)optionExprVal));
            }
        }

        private void checkSearchModeOption(String optionVal, String functionName, SourceLocation sourceLoc) throws AlgebricksException {
            if (optionVal.equals("all") || optionVal.equals("any")) {
                return;
            }
            throw CompilationException.create((int)4, (SourceLocation)sourceLoc, (Serializable[])new Serializable[]{functionName, optionVal});
        }

        void setDefaultValueForThirdParameter(List<Mutable<ILogicalExpression>> newArgs) throws AlgebricksException {
            ConstantExpression searchModeOptionExpr = new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AString("mode")));
            ConstantExpression searchModeValExpr = new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AString("all")));
            newArgs.add((Mutable<ILogicalExpression>)new MutableObject((Object)searchModeOptionExpr));
            newArgs.add((Mutable<ILogicalExpression>)new MutableObject((Object)searchModeValExpr));
        }
    }
}

